// DoppelList.java

import javax.swing.*;
import javax.swing.event.*;

class DoppelList extends JPanel {
    DoppelList() {
        String[] os = {
            "HP-UX", "JavaOS", "Linux", "MVS", 
            "OS X", "Solaris", "Windows XP"
        };
        final JList lList = new JList(), rList = new JList();
        lList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        rList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        add(lList);
        add(rList);
        final DefaultListModel lModel = new DefaultListModel(),
            rModel = new DefaultListModel();
        for (int i = 0; i < os.length; i++)
            lModel.add(0, os[i]);
        lList.setModel(lModel);
        rList.setModel(rModel);
        lList.addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                if (!lList.isSelectionEmpty()) {
                    int i = lList.getMinSelectionIndex();
                    Object obj = lModel.remove(i);
                    rModel.add(0, obj);
                }
            }
        });
        rList.addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                if (!rList.isSelectionEmpty()) {
                    int i = rList.getMinSelectionIndex();
                    Object obj = rModel.remove(i);
                    lModel.add(0, obj);
                }
            }
        });
    }
    public static void main(String[] args) {
        JFrame f = new JFrame("Doppelliste");
        f.getContentPane().add(new DoppelList());
        f.setSize(200, 220);
        f.setVisible(true);
    }
}
