// ButtonDoppelList.java

import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

public class ButtonDoppelList extends JPanel {
    public ButtonDoppelList(String[] daten) {
        JList lList = new JList();
        JList rList = new JList();
        JButton lBut = new JButton(new ImageIcon("left.gif")),
        rBut = new JButton(new ImageIcon("right.gif"));
        addList(lList, rList, rBut, daten);
        add(lBut); 
        add(rBut);
        addList(rList, lList, lBut, new String[] { });
    }
    void addList(final JList von, final JList nach, final JButton but, String[] daten) {
        von.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        add(von);
        final DefaultListModel model = new DefaultListModel();
        for (int i = 0; i < daten.length; i++)
            model.add(0, daten[i]);
        von.setModel(model);
        but.setEnabled(false);
        von.addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                but.setEnabled(!von.isSelectionEmpty());
            }
        });
        but.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Object obj = model.get(von.getMinSelectionIndex());
                ((DefaultListModel)nach.getModel()).add(0, obj);
                model.remove(model.indexOf(obj));
                but.setEnabled(false);
            }
        });
    }
    public static void main(String[] args) {
        String[] os = {
            "HP-UX", "JavaOS", "Linux", "MVS", 
            "OS X", "Solaris", "Windows XP"
        };
        JFrame f = new JFrame("Doppelliste mit Buttons");
        f.getContentPane().add(new ButtonDoppelList(os));
        f.setSize(300, 200);
        f.setVisible(true);
    }
}
