// Stepper.java

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

public class Stepper extends Box {
    JTextField view;
    JButton plus, minus;
    int wert, min, max, betrag = 1;    
    public Stepper(int start, int min, int max) {
        super(BoxLayout.X_AXIS);
        wert = start; 
        this.min = min; 
        this.max = max;
        view = new JTextField((int)Math.ceil(Math.log(max)/Math.log(10)) + 1);
        view.setHorizontalAlignment(JTextField.RIGHT);
        view.setText(String.valueOf(start));
        view.setEditable(false);
        Box butBox = new Box(BoxLayout.Y_AXIS);
        plus = new JButton("+"); 
        plus.setMargin(new Insets(0,0,0,0));
        Font smallFont = new Font(plus.getFont().getName(), plus.getFont().getStyle(), plus.getFont().getSize()/2);
        plus.setFont(smallFont);
        minus = new JButton("-"); 
        minus.setMargin(new Insets(0,0,0,0));
        minus.setFont(smallFont);
        butBox.add(plus); 
        butBox.add(minus);
        add(view);
        add(butBox);
        final ActionListener lis = new ActionListener() {
            public void actionPerformed(ActionEvent ev) {
                if (ev.getActionCommand() == "+")
                    diff(+betrag);
                else if (ev.getActionCommand() == "-")
                    diff(-betrag);
            }
        };
        plus.addActionListener(lis);
        minus.addActionListener(lis);
    }
    public void diff(int betrag) {
        if ((wert + betrag < min) || (wert + betrag > max))
            return;
        wert += betrag;
        view.setText(String.valueOf(wert));
    }
    public static void main(String[] args) {
        JFrame f = new JFrame("Stepper");
        f.getContentPane().add(new Stepper(12, 1, 100));
        f.pack();
        f.setVisible(true);
    }
}
