// PunktePanel.java

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;

class PunktePanel extends JPanel {
    private Collection punkte = new HashSet();
    PunktePanel() {
        setBackground(Color.yellow);
        setForeground(Color.green);
        addMouseListener(new MouseAdapter() {
            public void mousePressed(MouseEvent e) {
                punkte.add(e.getPoint());
                repaint();
            }
        });
    }
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        for (Iterator it = punkte.iterator(); it.hasNext(); ) {
            Point p = (Point)it.next();
            g.fillOval(p.x - 5, p.y - 5, 10, 10);
        }
    }
    public static void main(String[] args) {
        JFrame f = new JFrame("Punkte-Panel");
        f.getContentPane().add(new PunktePanel());
        f.setSize(400, 300);
        f.setVisible(true);
    }
}
