// DivNullTest.java

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class DivNullTest extends JApplet {
    private JLabel text1, text2;
    private JTextField ein1, ein2;
    private int zaehler, nenner;
    private double resultat;
    public void init() {
        Container c = getContentPane();
        c.setLayout(new GridLayout(2, 2));
        c.add(text1 = new JLabel("Zhler eingeben"));
        c.add(ein1 = new JTextField(10));
        c.add(text2 = new JLabel("Nenner eingeben, dann Return"));
        c.add(ein2 = new JTextField(10));
        ein2.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                zaehler = Integer.parseInt(ein1.getText());
                ein1.setText("");
                nenner = Integer.parseInt(ein2.getText());
                ein2.setText("");
                try {
                    resultat = div(zaehler, nenner);
                    showStatus(zaehler + "/" + nenner + " = " + resultat);
                } catch(DivNullException ex) { 
                    showStatus(ex.getMessage());
                }
            }
        });        
    }
    double div(int i, int j) throws DivNullException {
        if (j == 0)
            throw new DivNullException();
        return (double)i/j;
    }
    class DivNullException extends ArithmeticException {
        DivNullException() {
            super("Versuch der Division durch Null");
        }
    }
}
