// DumpTool.java

import java.io.*;

class DumpTool {
    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("Starten mittels java DumpTool <Dateiname>");
            return;
        }
        final int BREITE = 16;
        DataInputStream in = new DataInputStream(new FileInputStream(args[0]));
        StringBuffer buf = new StringBuffer();
        int i, c = 0;
        while ((i = in.read()) != -1) {
            c++;
            if (i <= 15)
                System.out.print('0');
            System.out.print(Integer.toHexString(i));
            if (i >= 32 && i <127)
                buf.append((char)i);
            else
                buf.append('.');
            if (c == BREITE) {
                System.out.println("\t" + buf);
                c = 0; 
                buf = new StringBuffer();
            }
        }
        int l = buf.length();
        if (l > 0) {
            for (int k = 0; k < BREITE - l; k++) {
                System.out.print("00"); 
                buf.append('.');
            }
            System.out.println("\t" + buf);
        }
    }
}
