// ByteDiff.java

import java.io.*;

class ByteDiff {
    public static void main(String[] args) {
	if (args.length < 2) {
	    System.err.println("Aufruf mittels java ByteDiff <Datei1> <Datei2>");
	    return;
	}
	int ch1 = 0, ch2 = 0;
	System.out.println("Pos.\tDatei1\tDatei2");
	try {
	    FileInputStream in1 = new FileInputStream(args[0]),
		in2 = new FileInputStream(args[1]);
	    long pos = 0;
	    while (((ch1 = in1.read()) != -1) && ((ch2 = in2.read()) != -1)) {
		if (ch1 != ch2)
		    System.out.println(pos + "\t" + ((int)ch1) + "\t" +  ((int)ch2));
		    pos++;
	    }
	    if (ch1 != -1 && in1.available() > 0)
		System.out.println(args[0] + " hat zustzlich " + in1.available() + " Bytes am Ende");
	    if (ch2 != -1 && in2.available() > 0)
		System.out.println(args[1] + " hat zustzlich " + in2.available() + " Bytes am Ende");
	} catch (IOException ex) {
	    System.err.println("Fehler beim Lesen.");
	    ex.printStackTrace();
	}
    }
}
