// TextAnzeige.java

import java.io.*;
import javax.swing.*;

class TextAnzeige {
    public static void main(String[] args) throws IOException {
	// 1. parse Commandline-Parameter:
	String encoding = null;
	String file = null;
	for (int i = 0; i < args.length; i++) {
	    if (args[i].equalsIgnoreCase("-encoding") && (args.length > i+1)) {
		encoding = args[i+1];
		i++;
	    } else 
		file = args[i];
	}
	if (file == null) {
	    System.out.println("Aufruf mittels java TextAnzeige [-encoding <encoding>] <Textdatei>");
	    return;
	}

	// 2. Lese Datei:
	StringWriter out = new StringWriter();
	Reader in;
	if (encoding == null)
	    in = new FileReader(file); // verwendet VM-Standard-Codierung.
	    // oder auch:   
	    // in = new InputStreamReader(new FileInputStream(file));
	else
	    in = new InputStreamReader(new FileInputStream(file), encoding);
	Kopierer.kopiere(in, out);
	
	// 3. GUI:
	JFrame f = new JFrame("TextAnzeige (" + file + ")");
	f.getContentPane().add(new JTextArea(out.toString(), 40, 40));
	f.pack();
	f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	f.setVisible(true);
    }
}
