// IntVektorEinAusgabe.java

import java.io.*;
import java.nio.*;
import java.nio.channels.*;

class IntVektorEinAusgabe {
    static final int INT_GROESSE = 4;
    ByteBuffer buf = ByteBuffer.allocateDirect(INT_GROESSE * 100);
    IntBuffer bufInt = buf.asIntBuffer();    

    public void speichern(String filename, int[] daten, int laenge) {
	try {
	    FileChannel out = new FileOutputStream(new File(filename)).getChannel();
	    int pufferGroesse = bufInt.capacity();
	    int durchlaeufe = (int) Math.ceil(laenge * 1.0 / pufferGroesse);
	    for (int i = 0; i < durchlaeufe; i++) {
		bufInt.clear();
		buf.clear();
		bufInt.put(daten, i*pufferGroesse, (i+1 < durchlaeufe? pufferGroesse : laenge - i*pufferGroesse));
		buf.limit(INT_GROESSE * bufInt.position());
		out.write(buf);
	    }
	    out.close();
	} catch (IOException ex) {
	    System.out.println("Fehler beim Schreiben auf " + filename);
	    ex.printStackTrace();
	}
    }
    public int laden(String filename, int[] daten, int laenge) {
	try {
	    FileChannel in = new FileInputStream(new File(filename)).getChannel();
	    bufInt.clear();
	    buf.clear();
	    int anzBytes;
	    while ((anzBytes = in.read(buf)) != -1) {
		int anzDurchlauf = anzBytes / INT_GROESSE;
		bufInt.limit(anzDurchlauf);
		bufInt.get(daten, laenge, anzDurchlauf);
		laenge += anzDurchlauf;
		bufInt.clear();
		buf.clear();
	    }
	    in.close();
	} catch (IOException ex) {
	    System.out.println("Fehler beim Schreiben auf " + filename);
	    ex.printStackTrace();
	}
	return laenge;
    }


    public int laden_OLD(String filename, int[] daten, int laenge) {
	try {
	    File file = new File(filename);
	    FileChannel in = new FileInputStream(file).getChannel();
	    int pufferGroesse = bufInt.capacity();
	    int anzFile = (int) (file.length() / INT_GROESSE);
	    int durchlaeufe = (int) Math.ceil(anzFile * 1.0 / pufferGroesse);
	    for (int i = 0; i < durchlaeufe; i++) {
		bufInt.clear();
		buf.clear();
		in.read(buf);
		int anzDurchlauf = buf.position() / INT_GROESSE;
		bufInt.limit(anzDurchlauf);
		bufInt.get(daten, laenge, anzDurchlauf);
		laenge += anzDurchlauf;
	    }
	    in.close();
	} catch (IOException ex) {
	    System.out.println("Fehler beim Schreiben auf " + filename);
	    ex.printStackTrace();
	}
	return laenge;
    }
}
