// PunktePanel.java

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class PunktePanel extends JPanel {
    private static final int MAX_ANZ = 10000;
    private static final int PUNKT_GROESSE = 10;
    private static String FILENAME = "punkte.dat";
    private int anz = 0;
    private int[] punkte = new int[MAX_ANZ * 2];
    private IntVektorEinAusgabe einaus = new IntVektorEinAusgabe();
    PunktePanel() {
	setLayout(new BorderLayout());
        setBackground(Color.yellow);
        setForeground(Color.green);
        addMouseListener(new MouseAdapter() {
            public void mousePressed(MouseEvent e) {
                if (anz < MAX_ANZ) {
                    punkte[anz*2] = e.getX();
                    punkte[anz*2+1] = e.getY();
		    anz++;
                    repaint();
                }
            }
        });
	JToolBar tools = new JToolBar();

	JButton loeschen = new JButton("lschen");
	loeschen.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    anz = 0;
		    repaint();
		}
	    });
	tools.add(loeschen);

	JButton speichern = new JButton("speichern");
	speichern.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    einaus.speichern(FILENAME, punkte, anz);
		}
	    });
	tools.add(speichern);

	JButton laden = new JButton("laden");
	laden.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    anz = einaus.laden(FILENAME, punkte, anz);
		    repaint();
		}
	    });
	tools.add(laden);

	add(tools, BorderLayout.NORTH);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        for (int i = 0; i < anz; i++) 
            g.fillOval(punkte[2*i] - PUNKT_GROESSE/2, punkte[2*i+1] - PUNKT_GROESSE/2, 
		       PUNKT_GROESSE, PUNKT_GROESSE);
    }
    public static void main(String[] args) {
        JFrame f = new JFrame("Punkte-Panel");
        f.getContentPane().add(new PunktePanel());
        f.setSize(400, 300);
	f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.setVisible(true);
    }
}
