// DateiVerketter2.java

import java.io.*;
import java.nio.*;
import java.nio.channels.*;

class DateiVerketter2 {
    public static void main(String[] args) {
	if (args.length < 2) {
	    System.out.println("Aufruf mittels java DateiVerketter2 <Quelldatei1> [<Quelldatei2> [...]] <Zieldatei>");
	    return;
	}
	File[] f = new File[args.length];
	for (int i = 0; i < args.length; i++) {
	    f[i] = new File(args[i]);
	    if (i+1 < args.length && (! f[i].exists() || ! f[i].canRead())) {
		System.out.println("Ich kann Quelldatei " + f[i] + " nicht lesen.");
		return;
	    }
	}

	try {
	    FileChannel out = new FileOutputStream(f[f.length - 1]).getChannel();
	    for (int i = 0; i < args.length-1; i++) {
		FileChannel in = new FileInputStream(f[i]).getChannel();
		long pos = 0, len = f[i].length(), transfer;
		do 
		    pos += in.transferTo(pos, len-pos, out);
		while (pos < len);
		in.close();
	    }
	    out.close();
	} catch (IOException ex) {
	    System.out.println("Beim Verketten ist ein Fehler aufgetreten.");
	    ex.printStackTrace();
	}
    }
}
