// Kasse.java

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

class Kasse {
    private int anzahl = 0;
    private DefaultListModel warteschlange;
    private JTextField kas;
    private String text;
    static final int MAX = 40;
    private boolean fin = false;
    private Runnable anRunner = new Runnable() {
        public void run() {
            warteschlange.add(warteschlange.size(), text);
        }
    },
    abRunner = new Runnable() {
        public void run() {
            warteschlange.remove(0);
        }
    },
    endRunner = new Runnable() {
        public void run() {
            kas.setText(text);
        }
    };
    Kasse(String text) {
        final JFrame f = new JFrame(text);
        JPanel pan = new JPanel();
        pan.add(new JLabel("Bedient wird ", JLabel.RIGHT));
        pan.add(kas = new JTextField(10));
        kas.setEditable(false);
        Container c = f.getContentPane();
        c.add(new JLabel("Warteliste", JLabel.CENTER), BorderLayout.NORTH);
        c.add(new JScrollPane(new JList(warteschlange = 
            new DefaultListModel())), BorderLayout.CENTER);
        c.add(pan, BorderLayout.SOUTH);
	f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.setSize(300, 300);
        f.setVisible(true);
    }
    synchronized void ankunft() {
        text = "  Kunde " + ++anzahl;
        try {
            SwingUtilities.invokeAndWait(anRunner);
        } catch (Exception ign) { }
        notify();
    }
    synchronized String abfertigung() throws FinEx {
        while (warteschlange.size() == 0) {
            if (fin)
                throw new FinEx();
            try {
                wait();
            } catch (InterruptedException ign) { }
        }
        text = (String)warteschlange.get(0);
        SwingUtilities.invokeLater(abRunner);
        return text;
    }
    void kassieren(String s) {
        text = s;
        SwingUtilities.invokeLater(endRunner);
    }
    synchronized void ende() {
        fin = true;
        notify();
    }
    static class FinEx extends Exception { }
}            
