// AlleThreads.java

import java.awt.event.*;
import java.io.*;
import javax.swing.*;

class AlleThreads extends JPanel {
    private JTextArea text;
    AlleThreads() {
        add(text = new JTextArea(15, 60));
    }
    private void startListe() {
        StringWriter strout = new StringWriter();
        liste(new PrintWriter(strout));
        text.setText(strout.toString());
    }
    private static void thrStatus(PrintWriter out, Thread t, String tabs) {
        if (t == null)
            return;
        out.println(tabs + "Thread: " + t.getName() + " Prioritt: " + t.getPriority()
            + " Lebend: " + t.isAlive() + " Dmon: " + t.isDaemon());
    } 
    private static void grStatus(PrintWriter out, ThreadGroup g, String tabs) {
        if (g == null)
            return;
        int thrAnz = g.activeCount(), grAnz = g.activeGroupCount();
        Thread[] threads = new Thread[thrAnz];
        ThreadGroup[] groups = new ThreadGroup[grAnz];
        g.enumerate(threads, false);
        g.enumerate(groups, false);
        out.println(tabs + "Gruppe: " + g.getName() + " Max.-Prioritt: " 
            + g.getMaxPriority() + " Dmon: " + g.isDaemon());
        for (int i = 0; i < thrAnz; i++)
            thrStatus(out, threads[i], tabs + "    ");
        for (int i = 0; i < grAnz; i++)
            grStatus(out, groups[i], tabs + "    ");
    } 
    private static void liste(PrintWriter out) {
        ThreadGroup akt, wurzel, parent;
        wurzel = akt = Thread.currentThread().getThreadGroup();
        parent = wurzel.getParent();
        while (parent != null) {
            wurzel = parent;
            parent = parent.getParent();
        }
        grStatus(out, wurzel, "");
    }
    public static void main(String[] args) {
        AlleThreads at = new AlleThreads();
        JFrame f = new JFrame("Alle Threads");
	f.getContentPane().add(at);
        f.pack();
	f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	f.setVisible(true);
        at.startListe();
    }
}
