// FileHandler.java

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;

class FileHandler extends JPanel {
    private JDesktopPane desk;
    private JInternalFrame fr;
    private JTextArea text;
    FileHandler() {
        setLayout(new BorderLayout());
        Box sel = Box.createHorizontalBox();
        JButton obut = new JButton(new ImageIcon("open.gif")), 
            sbut = new JButton(new ImageIcon("save.gif"));
        obut.setToolTipText("ffnen");
        sbut.setToolTipText("Speichern");
        sel.add(obut); 
        sel.add(sbut); 
        add(sel, BorderLayout.NORTH);
        desk = new JDesktopPane();
        add(desk);
        fr = new JInternalFrame("", true, true, true, true); 
        text = new JTextArea(10, 40);
        text.setLineWrap(true);
        fr.getContentPane().add(new JScrollPane(text));
        fr.pack();
        fr.setVisible(true);
        desk.add(fr);
        obut.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ev) {
                JFileChooser dialog = new JFileChooser();
                int auswahl = dialog.showOpenDialog(FileHandler.this);
                if (auswahl == JFileChooser.APPROVE_OPTION) {
                    File datei = dialog.getSelectedFile();
                    try {
                        fr.setTitle(datei.toString());
                        text.read(new FileReader(datei), null);
                    } catch (IOException ex) {
                        JOptionPane.showMessageDialog(FileHandler.this, "Datei " + datei + " nicht gefunden.");
                    }
                }
            }
        });
        sbut.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ev) {
                JFileChooser dialog = new JFileChooser();
                int auswahl = dialog.showSaveDialog(FileHandler.this);
                if (auswahl == JFileChooser.APPROVE_OPTION) {
                    File datei = dialog.getSelectedFile();
                    try {
                        fr.setTitle(datei.toString());
                        text.write(new FileWriter(datei));
                    } catch (IOException ex) {
                        JOptionPane.showMessageDialog(FileHandler.this, "Datei " + datei + " nicht gefunden.");
                    }
                }
            }
        });
    }
    public static void main(String[] args) {
        JFrame f = new JFrame("File-Handler");
        f.getContentPane().add(new FileHandler());
        f.setSize(500, 400);
        f.setVisible(true);
    }
}
