// TableColSelect.java

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;

class TableColSelect extends JPanel  {
    TableColSelect(Object[][] daten, Object[] name) {
        setLayout(new BorderLayout());
        final Icon[] icons = new Icon[daten.length];
        for (int i = 1; i < daten.length; i++)
            icons[i] = new ImageIcon(daten[0][i] + ".gif");
        final Icon def = new ImageIcon("grey.gif");
        final JTable table = new JTable(daten, name);
        table.setPreferredScrollableViewportSize(new Dimension(350, 100));
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setRowSelectionAllowed(false);
        table.setColumnSelectionAllowed(true);
        add(new JScrollPane(table), BorderLayout.CENTER);
        final JLabel bild = new JLabel(def);
        add(bild, BorderLayout.SOUTH);
        ListSelectionModel sel = table.getColumnModel().getSelectionModel();
        sel.addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                int spalte = table.getSelectedColumn();
                if (spalte > 0) 
                    bild.setIcon(icons[spalte]);
                else
                    bild.setIcon(def);
            }
        });
    }
    public static void main(String[] args) {
        Object[] name = { "Sprache", "rot", "gr\n", "blau" };
        Object[][] daten = { 
            { "English", "red", "green", "blue" },
            { "Espa\u00f1ol", "rojo", "verde", "azul" },
            { "Fran\u00e7ais", "rouge", "vert", "bleue" },
            { "Italiano", "rosso", "verde", "azzurro" }
        };
        JFrame f = new JFrame("Tabelle mit Icon (Spalten-Version)");
        f.getContentPane().add(new TableColSelect(daten, name));
        f.pack();
        f.setVisible(true);
    }
}
