// RemoveColumn.java

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;

class RemoveColumn extends JPanel {
    RemoveColumn(Object[][] daten, Object[] name) {
        setLayout(new BorderLayout());
        final ExtDefaultTableModel model = new ExtDefaultTableModel(daten, name);
        final JTable table = new JTable(model);
        table.setPreferredScrollableViewportSize(new Dimension(550, 60));
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setRowSelectionAllowed(false);
        table.setColumnSelectionAllowed(true);
        add(new JScrollPane(table), BorderLayout.CENTER);
        JButton eBut = new JButton("Entfernen"), aBut = new JButton("Anzeigen");
        JPanel pan = new JPanel();
        pan.add(eBut);
        pan.add(aBut);
        eBut.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                int spalte = table.getSelectedColumn();
                if (spalte > -1)
                    model.removeColumn(spalte);
            }
        });
        aBut.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < table.getRowCount(); i++) {
                    for (int j = 0; j < table.getColumnCount(); j++) 
                        System.out.print(table.getValueAt(i, j) + "\t");
                    System.out.println();
                }
                System.out.println();
            }
        });
        add(pan, BorderLayout.SOUTH);
    }
    public static void main(String[] args) {
        Object[] name = { "English", "Espa\u00f1ol", "Fran\u00e7ais", "Italiano", "T\rk" };
        Object[][] daten = { 
            { "red", "rojo", "rouge", "rosso", "k\u0131rm\u0131z\u0131" },
            { "green", "verde", "vert", "verde", "ye\u015fil" },
            { "blue", "azul", "bleue", "azzurro", "mavi" }
        };
        JFrame f = new JFrame("Reduzierbare Tabelle");
        f.getContentPane().add(new RemoveColumn(daten, name));
        f.pack();
        f.setVisible(true);
    }
}
