// TastenTable.java

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;

class TastenTable extends JPanel {
    TastenTable(Object[][] daten, Object[] name) {
        setLayout(new BorderLayout());
        final DefaultTableModel model = new DefaultTableModel(daten, name);
        final JTable table = new JTable(model);
        table.setPreferredScrollableViewportSize(new Dimension(550, 100));
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        add(new JScrollPane(table), BorderLayout.CENTER);
        ActionListener eLis = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                int zeile = table.getSelectedRow();
                if (zeile > -1) 
                    model.insertRow(zeile, new Object[] { "", "", null });
            }
        },
            aLis = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < table.getRowCount(); i++) {
                    for (int j = 0; j < table.getColumnCount(); j++) 
                        System.out.print(table.getValueAt(i, j) + "\t");
                    System.out.println();
                }
                System.out.println();
            }
        };
        KeyStroke eKey = KeyStroke.getKeyStroke("control E"),
            aKey = KeyStroke.getKeyStroke("control A");
        table.registerKeyboardAction(eLis, eKey, JTable.WHEN_FOCUSED);
        table.registerKeyboardAction(aLis, aKey, JTable.WHEN_FOCUSED);
    }
    public static void main(String[] args) {
        Object[] name = { "Name", "Erfindung", "geboren" };
        Object[][] daten =  {
            { "C. Babbage", "The Analytical Engine", new Integer(1792) },
            { "N. Chomsky", "Die Chomsky-Grammatiken", new Integer(1928) },
            { "G.W. Leibniz", "Das Dualsystem", new Integer(1646) },
            { "A.M. Turing", "Die Turing-Maschine", new Integer(1912) },
            { "K. Zuse", "Der 1. Relaisrechner Z1", new Integer(1910) }
        };
        JFrame f = new JFrame("Erweiterbare Tabelle");
        f.getContentPane().add(new TastenTable(daten, name));
        f.pack();
        f.setVisible(true);
    }
}
