// StatusBrowser.java

import java.awt.*;
import java.io.*;
import javax.swing.*;
import javax.swing.event.*;

class StatusBrowser extends JPanel {
    private JEditorPane inhalt;
    StatusBrowser(String seite) {
        setLayout(new BorderLayout());
        inhalt = new JEditorPane();
        inhalt.setEditable(false);
        inhalt.setSize(500, 500);
        add(new JScrollPane(inhalt), BorderLayout.CENTER);
        final JTextField status = new JTextField(50);
        status.setEditable(false);
        add(status, BorderLayout.SOUTH);
        inhalt.addHyperlinkListener(new HyperlinkListener() {
            public void hyperlinkUpdate(HyperlinkEvent e) {
		if (e.getEventType() == HyperlinkEvent.EventType.ENTERED)
		    status.setText(e.getURL().toString());
		else if (e.getEventType() == HyperlinkEvent.EventType.EXITED)
		    status.setText("");
                else if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED)
                    setPage(e.getURL().toString());
            }
        });
        setPage(seite);
    }
    void setPage(String seite) {
        try {
            inhalt.setPage(seite);
        } catch (IOException e) {
            inhalt.setText("Fehler beim Laden der Seite.");
        }
    }
    public static void main(String[] args) {
        String url = (args.length > 0) ? args[0] : "http://java.sun.com/";
        JFrame f = new JFrame("StatusBrowser");
        f.getContentPane().add(new StatusBrowser(url));
        f.setSize(650, 650);
        f.setVisible(true);
    }
}


