// AdressBrowser.java

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.event.*;

class AdressBrowser extends JPanel {
    private JEditorPane inhalt;
    private JTextField adresse;
    AdressBrowser(String seite) {
        setLayout(new BorderLayout());
        inhalt = new JEditorPane();
        inhalt.setEditable(false);
        inhalt.setSize(500, 500);
        add(new JScrollPane(inhalt), BorderLayout.CENTER);
        JPanel pan = new JPanel();
        JLabel lab = new JLabel("Adresse: ", JLabel.RIGHT);
        adresse = new JTextField(50);
        final JTextField status = new JTextField(50);
        pan.add(lab);
        pan.add(adresse);
        add(pan, BorderLayout.NORTH);
        status.setEditable(false);
        add(status, BorderLayout.SOUTH);
        inhalt.addHyperlinkListener(new HyperlinkListener() {
            public void hyperlinkUpdate(HyperlinkEvent e) {
		if (e.getEventType() == HyperlinkEvent.EventType.ENTERED)
		    status.setText(e.getURL().toString());
		else if (e.getEventType() == HyperlinkEvent.EventType.EXITED)
		    status.setText("");
                else if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED)
                    setPage(e.getURL().toString());
            }
        });
        adresse.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                setPage(adresse.getText());
            }
        });
        setPage(seite);
    }
    void setPage(String seite) {
        adresse.setText(seite);
        try {
            inhalt.setPage(seite);
        } catch (IOException e) {
            inhalt.setText("Fehler beim Laden der Seite.");
        }
    }
    public static void main(String[] args) {
        String url = (args.length > 0) ? args[0] : "http://java.sun.com/";
        JFrame f = new JFrame("AdressBrowser");
        f.getContentPane().add(new AdressBrowser(url));
        f.setSize(650, 650);
        f.setVisible(true);
    }
}


