// ChatRoomServerMultithreaded.java

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.*;
import java.nio.ByteBuffer;
import java.nio.channels.*;
import java.nio.charset.Charset;

class ChatRoomServerMultithreaded {
    private Collection clients;
    private int nr;
    private Charset charset = Charset.forName("ISO-8859-1");
    ChatRoomServerMultithreaded(int port) {
        clients = new HashSet();
        nr = 0;
        try {
            ServerSocketChannel server = ServerSocketChannel.open();
	    server.socket().bind(new InetSocketAddress(port));
            System.out.println("Server wartet auf Port " + port + ".");
            while (true) {
                ChatRoomVerbindung verb = 
                    new ChatRoomVerbindung(server.accept());
                clients.add(verb);
                new Thread(verb).start();
            }
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
    private void versende(ByteBuffer buf) {
        for (Iterator c = clients.iterator(); c.hasNext(); ) {
	    while (buf.hasRemaining()) 
		((ChatRoomVerbindung)(c.next())).sende(buf);
	    buf.flip();
	}
    }
    public static void main(String[] args) {
        if (args.length == 1)
            new ChatRoomServerMultithreaded(Integer.parseInt(args[0]));
        else
            System.out.println("Starten mittels java ChatRoomServerMultithreaded <portnr>");
    }
    private class ChatRoomVerbindung implements Runnable {
	SocketChannel sock;
        String name;
	ByteBuffer buf;
	int pos0;
        ChatRoomVerbindung(SocketChannel sock) throws IOException {
            this.sock = sock;
            name = "Client-" + (++nr);
	    buf = ByteBuffer.allocate(1000);
	    buf.put(charset.encode(name + ": "));
	    pos0 = buf.position();
        }
	public void sende(ByteBuffer buf) {
	    try {
		sock.write(buf);
	    } catch (IOException ex) {}
	}
        public void run() {
            try {
                while (sock.read(buf) != -1) {
		    buf.flip();
		    versende(buf);
		    buf.clear().position(pos0);
		}
            } catch (IOException ioe) {
            }
        }
    }
}
