// DateVerbindung.java

import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;

class DateVerbindung implements Runnable {
    private SocketChannel sock;
    private DateFormat form = 
        DateFormat.getDateTimeInstance(DateFormat.FULL, DateFormat.FULL);
    private Date jetzt;
    private Charset charset = Charset.forName("ISO-8859-1");

    DateVerbindung(SocketChannel sock) {
        this.sock = sock; 
    }

    private void zeige(String meldung) {
        System.out.println("[" + sock.socket().getRemoteSocketAddress()
			   + ": " + meldung + "]");
    }

    public void run() {
        try {
            zeige("neue Verbindung");
            jetzt = new Date();
	    ByteBuffer buf = ByteBuffer.allocate(1000);
	    buf.put(charset.encode(form.format(jetzt)));
	    buf.flip();
	    while (buf.hasRemaining())
		sock.write(buf);
            sock.close();
            zeige("Verbindung getrennt");
        } catch (IOException ex) { } 
    }
}
