// TCPIPClient.java

import java.io.IOException;
import java.net.*;
import java.nio.*;
import java.nio.channels.*;
import java.nio.charset.Charset;

class TCPIPClient {
    WritableByteChannel out = Channels.newChannel(System.out);
    ReadableByteChannel in = Channels.newChannel(System.in);
    Charset charset = Charset.forName("ISO-8859-1");
    ByteBuffer buffer = ByteBuffer.allocateDirect(1000);

    TCPIPClient(String hostname, int port) throws IOException {
        try {
	    SocketChannel soc = SocketChannel.open(new InetSocketAddress(hostname, port));
	    soc.configureBlocking(false);
	    System.out.println("Client gebunden an lokalen Port: " + soc.socket().getLocalPort());
	    String eingabe = "";
            while (! eingabe.startsWith("ende")) {
		kopiere(soc, out);
		out.write(charset.encode(CharBuffer.wrap("> ")));
		eingabe = kopiere(in, soc);
		try { Thread.sleep(500); } catch (InterruptedException ex) {}
            }
	    soc.close();
        } catch (UnknownHostException ux) {
            System.out.println(hostname + " ist dem DNS nicht bekannt.");
	}
    }
    public String kopiere(ReadableByteChannel quelle, WritableByteChannel senke) throws IOException {
	buffer.clear();
	quelle.read(buffer);
	buffer.flip();
	while (buffer.hasRemaining())
	    senke.write(buffer);
	buffer.flip();
	return charset.decode(buffer).toString();
    }
    public static void main(String[] args) throws IOException {
        if (args.length == 2) 
            new TCPIPClient(args[0], Integer.parseInt(args[1]));
        else
            System.out.println("Starten mittels java TCPIPClient1c <hostname> <portnr>");
    }
}
