// SMTPClient.java

import java.net.*;
import java.io.*;
import java.nio.channels.*;

class SMTPClient {
    SMTPClient(String hostname, int port) {
        try {
            SocketChannel sock = SocketChannel.open(new InetSocketAddress(hostname, port));
            System.out.println("Client gebunden an lokalen Port: " + sock.socket().getLocalSocketAddress());
            BufferedReader sockin = new BufferedReader(new 
                InputStreamReader(Channels.newInputStream(sock)));
            BufferedWriter sockout = new BufferedWriter(new 
                OutputStreamWriter(Channels.newOutputStream(sock)));
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            String zeile;
            antwort(sockin);
            while (!(zeile = in.readLine()).startsWith("ende")) {
		sockout.write(zeile); sockout.newLine(); sockout.flush();
		antwort(sockin);
            }
            sock.close();
        } catch (UnknownHostException ux) {
            System.out.println(hostname + " ist dem DNS nicht bekannt.");
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
    private void antwort(BufferedReader sockin) throws IOException {
        String zeile;
        while (((zeile = sockin.readLine()) != null) && zeile.charAt(3) != ' ')
            System.out.println(zeile);
        if (zeile != null)
            System.out.println(zeile);
        System.out.print("> "); 
    }
    public static void main(String[] args) {
        if (args.length == 2) 
            new SMTPClient(args[0], Integer.parseInt(args[1]));
        else
            System.out.println("Starten mittels java SMTPClient <hostname> <portnr>");
    }
}
