// EchoServer.java

import java.io.IOException;
import java.net.*;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;


class EchoServer {
    static final int MAX_VERB = 10000;
    EchoServer(int port) {
        try {
            DatagramChannel sock = DatagramChannel.open();
	    sock.socket().bind(new InetSocketAddress(port));
            boolean iter = true;
	    ByteBuffer buf = ByteBuffer.allocate(1024);
            for (int i = 0; i < MAX_VERB; i++) {
                SocketAddress sender = sock.receive(buf);
		buf.flip();
		sock.send(buf, sender);
		buf.clear();
            }
            sock.close();
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
    public static void main(String args[]) {
        if (args.length == 1)
            new EchoServer(Integer.parseInt(args[0])); 
        else
            System.out.println("Starten mittels java EchoServer <port>");
    }
}
