// EchoTester.java

import java.net.*;
import java.nio.*;
import java.nio.channels.*;

class EchoTester implements Runnable {
    private int MAX_VERB = 100;
    private InetSocketAddress empfaenger;
    private DatagramChannel sock;
    private int gesendet, empfangen;

    EchoTester(String hostname, int port) throws Exception {
        empfaenger = new InetSocketAddress(hostname, port);
	sock = DatagramChannel.open();
        new Thread(new Sender()).start();
        new Thread(new Empfaenger()).start();
    }

    public void run() {
        while (true) {
            try { 
		Thread.sleep(10000);
	    } catch (InterruptedException ex) {}
            System.out.println("Gesendet: " + gesendet + " und empfangen: " + empfangen);
        }
    }

    private class Sender implements Runnable {
        public void run() {
	    ByteBuffer buf = ByteBuffer.allocate(1024);
            try {
		for (int i = 0; i < MAX_VERB; i++) {
		    buf.putInt(i);
		    buf.flip();
		    sock.send(buf, empfaenger);
		    buf.clear();
		    gesendet++;
		    try { 
			Thread.sleep(2000);
		    } catch (InterruptedException ex) {}
		}
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private class Empfaenger implements Runnable {
        public void run() {
	    ByteBuffer buf = ByteBuffer.allocate(1024);
            try {
                for (int i = 0; i < MAX_VERB; i++) {
                    sock.receive(buf);
		    buf.clear();
                    empfangen++;
                }
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
    public static void main(String[] args) throws Exception {
        if (args.length == 2) 
            new Thread(new EchoTester(args[0], Integer.parseInt(args[1]))).start();
        else
            System.out.println("Starten mittels java EchoTester <hostname> <portnr>");
    }
}
