// AnfrageApplet.java

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import javax.swing.*;

public class AnfrageApplet extends JApplet {
    private JTextField name, ergebnis;
    private JRadioButton erfBut, datBut;

    public void init() {
        Container c = getContentPane();
        c.setLayout(new GridLayout(3, 1));
        JPanel p = new JPanel();
        p.add(new JLabel("Name: ", JLabel.RIGHT));
        p.add(name = new JTextField(30));
        c.add(p);
        p = new JPanel();
        p.add(new JLabel("Anfrage: ", JLabel.RIGHT));
        ButtonGroup anfrage = new ButtonGroup();
        p.add(erfBut = new JRadioButton("Erfindung", true));
        p.add(datBut = new JRadioButton("Daten"));
        anfrage.add(erfBut);        
        anfrage.add(datBut);        
        JButton sende = new JButton("abschicken");
        p.add(sende);
        c.add(p);
        p = new JPanel();
        p.add(ergebnis = new JTextField(55));
        c.add(p);
        ergebnis.setEditable(false);
        sende.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (erfBut.isSelected())
                    stelleAnfrage(name.getText(), erfBut.getText());
                else
                    stelleAnfrage(name.getText(), datBut.getText());
            }
        });
    }
   void stelleAnfrage(String name, String anfrage) {
        try {
	    URL u = new URL("http://localhost:8000/anfrage/AnfrageServlet");
//
//            oder
//              URL u = new URL(getCodeBase(), "AnfrageServlet");
//
            URLConnection uc = u.openConnection(); 
            uc.setDoOutput(true);
            Writer urlout = new OutputStreamWriter(uc.getOutputStream());
            urlout.write("Name=" + URLEncoder.encode(name, "ISO-8859-1") 
                + "&Anfrage=" + URLEncoder.encode(anfrage, "ISO-8859-1")); 
            urlout.close();
            BufferedReader urlin = 
                new BufferedReader(new InputStreamReader(uc.getInputStream()));
            StringBuffer buf = new StringBuffer();
            String zeile;
            while ((zeile = urlin.readLine()) != null)
                buf.append(zeile);
            String seite = buf.toString();
            int index1 = seite.indexOf("</h1>") + 5, 
                index2 = seite.indexOf("</body>");
            String antwort = seite.substring(index1, index2);
            ergebnis.setText(antwort);
        } catch (IOException ex) {
            ergebnis.setText("[FEHLER in der bertragung.]");
	    ex.printStackTrace();
        }
    }
}
