// ZaehlerClient.java

import java.awt.BorderLayout;
import java.awt.event.*;
import javax.swing.*;
import java.net.*;
import java.io.*;
import java.nio.channels.*;

class ZaehlerClient extends JPanel {
    private ZaehlerGUI zaehlerGUI;
    private JButton sende;
    private SocketAddress serverAdresse;
    ZaehlerClient(String hostname, int port) {
	serverAdresse = new InetSocketAddress(hostname, port);
	setLayout(new BorderLayout());
	add(zaehlerGUI = new ZaehlerGUI());
        add(sende = new JButton("Sende"), BorderLayout.SOUTH);
	sende.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    sende();
		}});
    }
    public void sende() {
	try {
	    SocketChannel sock = SocketChannel.open(serverAdresse);
	    
	    System.out.println("Client gebunden an lokalen Port: " + sock.socket().getLocalSocketAddress());
	    ObjectOutputStream sockout = 
		new ObjectOutputStream(Channels.newOutputStream(sock));
	    ObjectInputStream sockin = 
		new ObjectInputStream(Channels.newInputStream(sock));
	    sockout.writeObject(zaehlerGUI.getZaehler());
	    zaehlerGUI.setZaehler((Zaehler)sockin.readObject());
	    sock.close();
	    // System.out.println("sende zaehler");
	} catch (IOException ex) {
	    ex.printStackTrace();
	} catch (ClassNotFoundException ex) {
	    ex.printStackTrace();
	}
    }
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Starten mittels java ZaehlerClient <hostname> <portnr>");
	    return;
	}
	JFrame f = new JFrame("ZhlerClient");
	f.getContentPane().add(new ZaehlerClient(args[0], Integer.parseInt(args[1])));
	f.pack();
	f.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
	f.setVisible(true);
    }
}
