// ZaehlerServer.java

import java.io.*;
import java.net.*;
import java.nio.channels.*;

class ZaehlerServer {
    ZaehlerServer(int port) {
        try {
            final int MAX_VERB = 100;
            ServerSocketChannel server = ServerSocketChannel.open();
	    server.socket().bind(new InetSocketAddress(port));
            System.out.println("[Server wartet auf Port " + port + "]");
            for (int i = 0; i < MAX_VERB; i++) {
                SocketChannel sock = server.accept();
                System.out.println("[Verbindung zu " + sock.socket().getRemoteSocketAddress() + "]");
                ObjectInputStream sockin = 
                    new ObjectInputStream(Channels.newInputStream(sock));
                ObjectOutputStream sockout = 
                    new ObjectOutputStream(Channels.newOutputStream(sock));
                Zaehler z = (Zaehler)sockin.readObject();
                z.wert(-z.wert());
                sockout.writeObject(z);
                sock.close();
                System.out.println("[Verbindung getrennt]");
            }
            server.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    public static void main(String[] args) {
        if (args.length == 1) 
            new ZaehlerServer(Integer.parseInt(args[0]));
        else
            System.out.println("Starten mittels java ZaehlerServer <portnr>");
    }
}
