// VersandhausClient.java

import java.awt.*;
import java.awt.event.*;
import java.rmi.*;
import javax.swing.*;

public class VersandhausClient extends JPanel implements ActionListener {
    private JTextField alt;
    private JTextArea resultat;
    private JCheckBox mann, frau;
    private JList hobbies;
    private Versandhaus vers;
    public VersandhausClient() {
	setLayout(new BorderLayout());
        JPanel p = new JPanel();
        p.add(new JLabel("Alter:", JLabel.RIGHT));
        p.add(alt = new JTextField(5));
        ButtonGroup cbg = new ButtonGroup();
        p.add(mann = new JCheckBox("Mnnlich", false));
        cbg.add(mann);
        p.add(frau = new JCheckBox("Weiblich", true));
        cbg.add(frau);
        add(p, BorderLayout.NORTH);
        p = new JPanel();
	p.add(new JLabel("Hobbies:"));
        hobbies = new JList( new String[]{ "Haushalt", "Kosmetik", "Garten", "Computer", "Sport" });
        p.add(new JScrollPane(hobbies));
        JButton fertig = new JButton("bertragen");
        p.add(fertig);
        fertig.addActionListener(this);
        add(p, BorderLayout.CENTER);
        p = new JPanel();
        p.add(new JLabel("Resultat:"));
        p.add(new JScrollPane(resultat = new JTextArea(4, 40)));
        add(p, BorderLayout.SOUTH);
        System.setSecurityManager(new RMISecurityManager());
        String url = "rmi:///";
        try {
            vers = (Versandhaus)Naming.lookup("versandhaus");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    public void actionPerformed(ActionEvent evt) {
        String arg = evt.getActionCommand();
        if (arg.equals("bertragen")) {
            Object[] vals = hobbies.getSelectedValues();
            int n = vals.length;
            String[] hobs = new String[n];
            for (int i = 0; i < n; i++)
                hobs[i] = (String)vals[i];
            Kunde k = new Kunde(Integer.parseInt(alt.getText()),
                (mann.isSelected() ? Produkt.MANN : 0)          
                +  (frau.isSelected() ? Produkt.FRAU : 0), hobs);
            String t = k + "\n";
            try {
                java.util.List result = vers.suche(k);
                for (int i = 0; i < result.size(); i++) {
                    Produkt p = (Produkt)result.get(i);
                    t += p.beschreibung() + "\n";
                }
            } catch (Exception e) {
               e.printStackTrace();
            }
            resultat.setText(t);
       }
    }
    public static void main(String[] args) {
        if (System.getSecurityManager() == null)
            System.setSecurityManager(new RMISecurityManager());
        JFrame f = new JFrame("Versandhausclient");
	f.getContentPane().add(new VersandhausClient());
        f.pack();
	f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	f.setVisible(true);
    }
}
