/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.dialogs;

import com.zerog.ia.download.dialogs.GUIDialog;
import com.zerog.ia.download.dialogs.ProgressBar;
import com.zerog.ia.download.shared.DownloadContext;
import com.zerog.ia.download.utility.AppletResourceBundle;
import com.zerog.ia.download.utility.Gestalt;
import com.zerog.ia.download.utility.GridBagUtilImpl;
import com.zerog.ia.download.utility.IObservable;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.util.Observer;

public class ProgressDialog
extends GUIDialog
implements Runnable {
    public static final String CHECKDISKSPACE_TITLE = ".CheckDiskSpace.Title";
    public static final String DOWNLOAD_TITLE = ".Download.Title";
    public static final String START_INSTALLER_TITLE = ".StartInstaller.Title";
    public static final String CHECKDISKSPACE_HEADING = ".CheckDiskSpace.Heading";
    public static final String DOWNLOAD_HEADING = ".Download.Heading";
    public static final String START_INSTALLER_HEADING = ".StartInstaller.Heading";
    public static final String CHECKDISKSPACE_LABEL = ".CheckDiskSpace.Label";
    public static final String DOWNLOAD_LABEL = ".Download.Label";
    public static final String START_INSTALLER_LABEL = ".StartInstaller.Label";
    public static final int MODE_START_INSTALLER = 0;
    public static final int MODE_DOWNLOAD = 1;
    public static final int MODE_CHECKDISKSPACE = 2;
    private int currentMode = 2;
    private ProgressBar progressBar = null;
    protected GridBagLayout gbl = null;
    protected Button actionButton = new Button("               ");
    protected Label informUserOfActionLabel = new Label();
    protected Label locationOfActionLabel = new Label();
    protected Label fileDestinationLabel = new Label();
    IObservable observable = new IObservable();
    static Class class$com$zerog$ia$download$WebInstallerApplet;
    static Class class$com$zerog$ia$download$dialogs$ProgressDialog;

    public ProgressDialog(DownloadContext downloadContext) {
        super(downloadContext.getParentFrame(), "", false);
        this.build();
    }

    public boolean handleEvent(Event e) {
        super.handleEvent(e);
        if (e.id == 1001 && e.target == this.actionButton) {
            if (this.currentMode != 0) {
                this.observable.setChanged(true);
                this.observable.notifyObservers();
                ((Component)this).setVisible(false);
                this.hide();
            } else {
                ((Component)this).setVisible(false);
                this.hide();
            }
        }
        return true;
    }

    private void build() {
        this.gbl = new GridBagLayout();
        this.setLayout(this.gbl);
        Font standardFont = new Font("Dialog", 0, 12);
        Font appleFont = new Font("SanSerif", 0, 10);
        if (Gestalt.getVMVendor().equals(Gestalt.APPLE_VM)) {
            this.informUserOfActionLabel.setFont(appleFont);
            this.locationOfActionLabel.setFont(appleFont);
            this.fileDestinationLabel.setFont(appleFont);
            this.actionButton.setFont(standardFont);
        } else {
            this.informUserOfActionLabel.setFont(standardFont);
            this.locationOfActionLabel.setFont(standardFont);
            this.fileDestinationLabel.setFont(standardFont);
            this.actionButton.setFont(standardFont);
        }
        GridBagUtilImpl.setLayoutManager(this.gbl);
        GridBagUtilImpl.add(this, this.informUserOfActionLabel, 0, 0, 0, 1, 2, new Insets(0, 0, 10, 0), 17, 0.0, 0.0);
        this.progressBar = new ProgressBar();
        GridBagUtilImpl.add(this, this.progressBar, 0, 1, 5, 2);
        this.setPercentDone(0);
        GridBagUtilImpl.add(this, this.locationOfActionLabel, 0, 4, 0, 1, 2, new Insets(4, 0, 0, 0), 17, 0.0, 0.0);
        GridBagUtilImpl.add(this, this.fileDestinationLabel, 0, 5, 0, 1, 2, 17, 0.0, 0.0);
        GridBagUtilImpl.add(this, this.actionButton, 4, 6, 1, 1, 0, new Insets(15, 0, 0, 0), 13);
    }

    public void setProgressDialogText(int mode, String productName, String fileDestinationText) {
        String dialogTitle = null;
        String buttonText = null;
        String actionText = null;
        String locationText = null;
        switch (mode) {
            case 0: {
                System.err.println("Mode: Start Installer");
                dialogTitle = AppletResourceBundle.getLocalizedString(this, START_INSTALLER_TITLE);
                buttonText = AppletResourceBundle.getLocalizedString(class$com$zerog$ia$download$WebInstallerApplet == null ? (class$com$zerog$ia$download$WebInstallerApplet = ProgressDialog.class$("com.zerog.ia.download.WebInstallerApplet")) : class$com$zerog$ia$download$WebInstallerApplet, ".Button.OK");
                actionText = AppletResourceBundle.getLocalizedString(this, START_INSTALLER_HEADING);
                locationText = AppletResourceBundle.getLocalizedString(this, START_INSTALLER_LABEL);
                this.actionButton.setVisible(false);
                this.progressBar.setVisible(false);
                break;
            }
            case 1: {
                System.err.println("Mode: Downloading Installer");
                dialogTitle = AppletResourceBundle.getLocalizedString(this, DOWNLOAD_TITLE);
                buttonText = AppletResourceBundle.getLocalizedString(class$com$zerog$ia$download$WebInstallerApplet == null ? (class$com$zerog$ia$download$WebInstallerApplet = ProgressDialog.class$("com.zerog.ia.download.WebInstallerApplet")) : class$com$zerog$ia$download$WebInstallerApplet, ".Button.Cancel");
                actionText = AppletResourceBundle.getLocalizedString(this, DOWNLOAD_HEADING);
                if (productName != null) {
                    actionText = String.valueOf(String.valueOf(actionText)).concat(String.valueOf(String.valueOf(" ".concat(String.valueOf(String.valueOf(productName))))));
                }
                locationText = AppletResourceBundle.getLocalizedString(this, DOWNLOAD_LABEL);
                break;
            }
            case 2: {
                System.err.println("Mode: Checking Disk Space");
                dialogTitle = AppletResourceBundle.getLocalizedString(this, CHECKDISKSPACE_TITLE);
                buttonText = AppletResourceBundle.getLocalizedString(class$com$zerog$ia$download$WebInstallerApplet == null ? (class$com$zerog$ia$download$WebInstallerApplet = ProgressDialog.class$("com.zerog.ia.download.WebInstallerApplet")) : class$com$zerog$ia$download$WebInstallerApplet, ".Button.Cancel");
                actionText = AppletResourceBundle.getLocalizedString(this, CHECKDISKSPACE_HEADING);
                locationText = AppletResourceBundle.getLocalizedString(this, CHECKDISKSPACE_LABEL);
            }
        }
        this.currentMode = mode;
        this.setTitle(dialogTitle);
        this.actionButton.setLabel(buttonText);
        this.informUserOfActionLabel.setText(actionText);
        this.locationOfActionLabel.setText(locationText);
        this.fileDestinationLabel.setText(fileDestinationText);
        if (this.currentMode == 2) {
            this.pack();
            this.center();
        }
        this.repaint();
    }

    public void setPercentDone(int percentDone) {
        this.progressBar.setPercentDone(percentDone);
    }

    public void run() {
    }

    public void paint(Graphics g) {
        super.paint(g);
        int height = this.locationOfActionLabel.location().y - 2;
        int height2 = this.fileDestinationLabel.location().y + this.fileDestinationLabel.size().height + 2;
        int right = 10;
        int left = this.locationOfActionLabel.location().x;
        g.setColor(Color.gray);
        g.drawLine(left, height, this.size().width - right, height);
        g.drawLine(left, height2, this.size().width - right, height2);
        g.setColor(Color.white);
        g.drawLine(left + 1, height + 1, this.size().width - right + 1, height + 1);
        g.drawLine(left + 1, height2 + 1, this.size().width - right + 1, height2 + 1);
    }

    public void addObserver(Observer obs) {
        this.observable.addObserver(obs);
    }

    public void deleteObserver(Observer obs) {
        this.observable.deleteObserver(obs);
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        CHECKDISKSPACE_TITLE = CHECKDISKSPACE_TITLE;
        DOWNLOAD_TITLE = DOWNLOAD_TITLE;
        START_INSTALLER_TITLE = START_INSTALLER_TITLE;
        CHECKDISKSPACE_HEADING = CHECKDISKSPACE_HEADING;
        DOWNLOAD_HEADING = DOWNLOAD_HEADING;
        START_INSTALLER_HEADING = START_INSTALLER_HEADING;
        CHECKDISKSPACE_LABEL = CHECKDISKSPACE_LABEL;
        DOWNLOAD_LABEL = DOWNLOAD_LABEL;
        START_INSTALLER_LABEL = START_INSTALLER_LABEL;
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$dialogs$ProgressDialog == null ? (class$com$zerog$ia$download$dialogs$ProgressDialog = ProgressDialog.class$("com.zerog.ia.download.dialogs.ProgressDialog")) : class$com$zerog$ia$download$dialogs$ProgressDialog, CHECKDISKSPACE_TITLE, "Checking Space on Local Disk");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$dialogs$ProgressDialog == null ? (class$com$zerog$ia$download$dialogs$ProgressDialog = ProgressDialog.class$("com.zerog.ia.download.dialogs.ProgressDialog")) : class$com$zerog$ia$download$dialogs$ProgressDialog, CHECKDISKSPACE_HEADING, "Checking disk space...");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$dialogs$ProgressDialog == null ? (class$com$zerog$ia$download$dialogs$ProgressDialog = ProgressDialog.class$("com.zerog.ia.download.dialogs.ProgressDialog")) : class$com$zerog$ia$download$dialogs$ProgressDialog, CHECKDISKSPACE_LABEL, "Disk location:");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$dialogs$ProgressDialog == null ? (class$com$zerog$ia$download$dialogs$ProgressDialog = ProgressDialog.class$("com.zerog.ia.download.dialogs.ProgressDialog")) : class$com$zerog$ia$download$dialogs$ProgressDialog, DOWNLOAD_TITLE, "Download Progress");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$dialogs$ProgressDialog == null ? (class$com$zerog$ia$download$dialogs$ProgressDialog = ProgressDialog.class$("com.zerog.ia.download.dialogs.ProgressDialog")) : class$com$zerog$ia$download$dialogs$ProgressDialog, DOWNLOAD_HEADING, "Downloading");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$dialogs$ProgressDialog == null ? (class$com$zerog$ia$download$dialogs$ProgressDialog = ProgressDialog.class$("com.zerog.ia.download.dialogs.ProgressDialog")) : class$com$zerog$ia$download$dialogs$ProgressDialog, DOWNLOAD_LABEL, "Saving installer to location:");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$dialogs$ProgressDialog == null ? (class$com$zerog$ia$download$dialogs$ProgressDialog = ProgressDialog.class$("com.zerog.ia.download.dialogs.ProgressDialog")) : class$com$zerog$ia$download$dialogs$ProgressDialog, START_INSTALLER_TITLE, "Starting Installer");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$dialogs$ProgressDialog == null ? (class$com$zerog$ia$download$dialogs$ProgressDialog = ProgressDialog.class$("com.zerog.ia.download.dialogs.ProgressDialog")) : class$com$zerog$ia$download$dialogs$ProgressDialog, START_INSTALLER_HEADING, "Launching installer. This may take a few moments...");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$dialogs$ProgressDialog == null ? (class$com$zerog$ia$download$dialogs$ProgressDialog = ProgressDialog.class$("com.zerog.ia.download.dialogs.ProgressDialog")) : class$com$zerog$ia$download$dialogs$ProgressDialog, START_INSTALLER_LABEL, "Installer location:");
        MODE_START_INSTALLER = 0;
        MODE_DOWNLOAD = 1;
        MODE_CHECKDISKSPACE = 2;
    }
}

