/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.downloaders.macexecutils;

import com.zerog.ia.download.downloaders.macexecutils.MacJDirectChooser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MacHFSOutStrm {
    private File file;
    private String path;
    public static final int PART_DATA = 0;
    public static final int PART_RESOURCE = 1;
    public static final int PART_FINDER = 2;
    private OutputStream rfos = null;
    private OutputStream fios = null;
    private boolean rfClosed = true;
    private boolean fiClosed = true;
    protected FileOutputStream composedFOS;

    public MacHFSOutStrm(File xfile) throws IOException {
        this.composedFOS = new FileOutputStream(xfile.getPath());
        this.path = xfile.getPath();
        this.file = xfile;
    }

    public MacHFSOutStrm(String path) throws IOException {
        this(new File(path));
    }

    public int getPartCount() {
        return 3;
    }

    public void close() throws IOException {
        this.composedFOS.close();
        if (!this.rfClosed) {
            if (this.rfos != null) {
                this.rfos.close();
            }
            this.rfClosed = true;
        }
        if (!this.fiClosed) {
            if (this.fios != null) {
                this.fios.close();
            }
            this.fiClosed = true;
        }
    }

    public void write(int part, byte[] b, int off, int len) throws IOException {
        switch (part) {
            case 0: {
                this.writeDF(b, off, len);
                break;
            }
            case 1: {
                this.writeRF(b, off, len);
                break;
            }
            case 2: {
                this.writeFI(b, off, len);
                break;
            }
            default: {
                throw new IOException(String.valueOf(String.valueOf(new StringBuffer("OutputStream for ").append(this.path).append(" does not have a part: ").append(part))));
            }
        }
    }

    private void writeFI(byte[] b, int off, int len) throws IOException {
        if (this.fios == null) {
            this.fios = (OutputStream)MacJDirectChooser.makeInstance("com.zerog.ia.download.downloaders.macexecutils.MacInfoFileOutStrm", new Object[]{this.file});
            this.fiClosed = false;
        }
        this.fios.write(b, off, len);
    }

    private void writeRF(byte[] b, int off, int len) throws IOException {
        if (this.rfos == null) {
            this.rfos = (OutputStream)MacJDirectChooser.makeInstance("com.zerog.ia.download.downloaders.macexecutils.MacRSRCFileOutStrm", new Object[]{this.file});
            this.rfClosed = false;
        }
        this.rfos.write(b, off, len);
    }

    private void writeDF(byte[] b, int off, int len) throws IOException {
        this.composedFOS.write(b, off, len);
    }

    static {
        PART_DATA = 0;
        PART_RESOURCE = 1;
        PART_FINDER = 2;
    }
}

