/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.downloaders.macexecutils;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.util.BitSet;

public class MacURLEncoder {
    static BitSet dontNeedEncoding;
    static final int caseDiff = 32;

    private MacURLEncoder() {
    }

    public static String encode(String s) {
        int maxBytesPerChar = 10;
        ByteArrayOutputStream out = new ByteArrayOutputStream(s.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        OutputStreamWriter writer = new OutputStreamWriter(buf);
        for (int i = 0; i < s.length(); ++i) {
            int c = s.charAt(i);
            if (dontNeedEncoding.get(c)) {
                if (c == 32) {
                    c = 43;
                }
                out.write(c);
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (Exception e) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.toByteArray();
            for (int j = 0; j < ba.length; ++j) {
                out.write(37);
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.write(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.write(ch);
            }
            buf.reset();
        }
        return out.toString();
    }

    static {
        int i;
        caseDiff = 32;
        dontNeedEncoding = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            dontNeedEncoding.set(i);
        }
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
        dontNeedEncoding.set(47);
    }
}

