/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.outputListeners;

import com.zerog.ia.download.downloaders.FileDownloader;
import com.zerog.ia.download.outputListeners.DownloadListener;

public class TimeoutListener
extends Thread
implements DownloadListener {
    long lastHeardFromTime;
    long timeoutLength;
    long bytesInFileDownloaded;
    boolean stopWaiting = false;
    FileDownloader download;

    public TimeoutListener(FileDownloader _download, long _timeoutLength) {
        this.download = _download;
        this.timeoutLength = _timeoutLength;
        this.start();
    }

    public void run() {
        this.lastHeardFromTime = -1L;
        while (this.lastHeardFromTime == (long)-1) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        while (!this.stopWaiting) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() - this.lastHeardFromTime <= this.timeoutLength) continue;
            this.download.cancelDownload();
            if (this.bytesInFileDownloaded > (long)0) {
                this.download.notifySetFriendlyErrorMessage(String.valueOf(String.valueOf(new StringBuffer("The download has not progressed in over ").append(this.timeoutLength / (long)1000).append(" seconds.  It is possible your network connection has terminated or the server the installer was coming from has gone down."))));
            } else {
                this.download.notifySetFriendlyErrorMessage("No data has been retrieved from the server.  It is likely that the server's MIME types are misconfigured.  Please notify the server administrator.");
            }
            this.download.notifyErrorOccured(new Exception());
            this.stopWaiting = true;
        }
    }

    public void downloadStarted(String _fileName) {
        this.lastHeardFromTime = System.currentTimeMillis();
    }

    public void downloadCompleted() {
        this.stopWaiting = true;
    }

    public void downloadCancelled() {
        this.stopWaiting = true;
    }

    public void setTotalNumberOfBytesInFile(long _totalBytesInFile) {
    }

    public void setBytesInFileDownloaded(long _bytesDownloaded) {
        this.bytesInFileDownloaded = _bytesDownloaded;
        this.lastHeardFromTime = System.currentTimeMillis();
    }

    public void errorOccured() {
        this.stopWaiting = true;
    }
}

