/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.utility.nativelib.unix;

import com.zerog.ia.download.utility.ZGProcess;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Environment {
    private static Environment env = null;
    private static Hashtable variableTable = new Hashtable();

    private Environment() throws IOException {
        this.makeVariableTable(this.getEnvironmentVariables());
    }

    public static Environment getInstance() throws IOException {
        if (env == null) {
            env = new Environment();
        }
        return env;
    }

    public String getValue(String variable) {
        try {
            String string = variableTable.get(variable).toString();
            return string;
        }
        catch (Exception e) {
            String string = "";
            return string;
        }
    }

    private void makeVariableTable(String env) {
        StringTokenizer lines = new StringTokenizer(env, "\n");
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            StringTokenizer setting = new StringTokenizer(line, "=");
            String lhs = setting.nextToken();
            String rhs = "";
            if (setting.hasMoreTokens()) {
                rhs = setting.nextToken();
            }
            variableTable.put(lhs, rhs);
            if (!lhs.equalsIgnoreCase("PATH")) continue;
            break;
        }
    }

    private String getEnvironmentVariables() throws IOException {
        int emptyLines = 0;
        ZGProcess p = new ZGProcess("/bin/sh -c set");
        String buffer = "";
        StringBuffer output = new StringBuffer();
        if (p == null) {
            System.err.println("ZGProcess p = null");
            return null;
        }
        buffer = p.getLine();
        while (buffer != null) {
            if (!buffer.trim().equals("")) {
                output.append(String.valueOf(String.valueOf(buffer)).concat("\n"));
            } else if (++emptyLines > 15) break;
            if (buffer.startsWith("PATH")) break;
            buffer = p.getLine();
        }
        return output.toString();
    }
}

