/*
 * Copyright (c) 2001 living systems(R) AG, Germany. All rights reserved.
 * Original Author: Christoph Kluge
 *
 * $Modtime:   Jul 02 2001 11:36:30  $
 */

package com.ls.demo.capabilities;

import java.util.Map;
import java.util.List;
import java.util.HashMap;
import java.util.Iterator;

import com.ls.service.log.ILogger;

import com.ls.logiccontrol.capabilities.LogicCapabilities;
import com.ls.logiccontrol.LogicException;
import com.ls.logiccontrol.LogicConfigurationException;

import	com.ls.util.xml.XMLFragment;

import	javax.swing.JFrame;
import	javax.swing.JOptionPane;


/**
 * The gui capabilities is able to popup message or confirm boxes.
 *
 * @author  Last modified by $Author:   CKluge  $
 * @version $Revision:   1.6  $
 */
public class Behavior extends LogicCapabilities {
	/** The name of the class used for the logging */
	public static final String CLASS_NAME 	= "Behavior";	


	/** 
     * Basic empty Constructor 
     */
    public Behavior()
	{
		
	}


	/** 
     * Configuration of the capabilities which allows to setup the look&feel of the message box.
	 *
     * @param configuration The configuration of the capabilities (usually a XMLFragment)
	 * @throws LogicConfigurationException If the capabilities could not be configured
     */

    public void configure(Map configuration) throws LogicConfigurationException 
	{
		super.configure(configuration);
		
		if (configuration == null) {
			return;
		}

		Iterator configurationIterator = ((XMLFragment)configuration).getChildren().iterator();

		while (configurationIterator.hasNext()) {
			XMLFragment configurationTag=(XMLFragment)configurationIterator.next();
			String tagName = configurationTag.getRootName();
		}
	}
	
	/**
	 *	Action 1
	*/
	public void actionOne(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		JOptionPane.showMessageDialog(null, "This is action 1", "MessageDialog", JOptionPane.INFORMATION_MESSAGE); 		
	}	
	
	/**
	 *	Action 2
	*/
	public void actionTwo(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		JOptionPane.showMessageDialog(null, "This is action 2", "MessageDialog", JOptionPane.INFORMATION_MESSAGE); 		
	}	
	
	/**
	 *	Action 3
	*/
	public void actionThree(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		JOptionPane.showMessageDialog(null, "This is action 3", "MessageDialog", JOptionPane.INFORMATION_MESSAGE); 		
	}	
	
	/**
	 *	Sets any environment variable to a given value.
	 *
	 *	@lsparam varname
	 *	@lsparam varvalue
	*/
	public void actionSetEnv(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME 	= "actionSetEnv";	
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "logicEnvironment"+logicEnvironment);
		
		String varname = (String) logicEnvironment.get("varname");
		String varvalue = (String) logicEnvironment.get("varvalue");
		logicEnvironment.put(varname, varvalue);					
		iLogger.log(CLASS_NAME, ILogger.TRACE5, METHOD_NAME, "set "+varname+" to "+varvalue);
	}	
	
	/**
	 *	Logs variable 'varname'.
	 *
	 *	@lsparam varname
	*/
	public void actionLogEnv(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME 	= "actionLogEnv";	
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "logicEnvironment"+logicEnvironment);
		
		String varname = (String) logicEnvironment.get("varname");
		iLogger.log(CLASS_NAME, ILogger.TRACE5, METHOD_NAME, varname+"='"+logicEnvironment.get(varname)+"'");
	}	
	
	/**
	 *	Checks, if level 9 is reached.
	*/
	public double perceptionLevelReached(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{	
		String	METHOD_NAME = "perceptionLevelReached";	
		double returnValue = FALSE;
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "LogicEnvironment"+logicEnvironment);
			
		String	level = (String) logicEnvironment.get("level");
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "level="+level );
		if ((level != null) && (level.equals("9")) ) 
		{
			returnValue = TRUE;
		}
		
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "returnValue "+returnValue );
		return returnValue;				
	}	
	
	/**
	 *	Checks, if level 1 is reached.
	*/
	public double perceptionLevel1(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{	
		String	METHOD_NAME = "perceptionLevel1";	
		double returnValue = FALSE;
			
		String	level = (String) logicEnvironment.get("level");
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "level="+level );
		if ((level != null) && (level.compareTo("0")>=0)) 
		{
			returnValue = TRUE;
		}
		
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "returnValue "+returnValue );
		return returnValue;				
	}	
	
	/**
	 *	Checks, if level 2 is reached.
	*/
	public double perceptionLevel2(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{	
		String	METHOD_NAME = "perceptionLevel2";	
		double returnValue = FALSE;
			
		String	level = (String) logicEnvironment.get("level");
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "level="+level );
		if ((level != null) && (level.compareTo("2")>=0)) 
		{
			returnValue = TRUE;
		}
		
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "returnValue "+returnValue );
		return returnValue;				
	}	
	
	/**
	 *	Checks, if level 3 is reached.
	*/
	public double perceptionLevel3(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{	
		String	METHOD_NAME = "perceptionLevel3";	
		double returnValue = FALSE;
			
		String	level = (String) logicEnvironment.get("level");
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "level="+level );
		if ((level != null) && (level.compareTo("3")>=0)) 
		{
			returnValue = TRUE;
		}
		
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "returnValue "+returnValue );
		return returnValue;				
	}	


	/**
	 * PopsUp a message box with the message passed in the message argument of 
	 * the action tag.
	 *
	 *	@lsparam message
	 *
	 * @param	logicEnvironment 			The environment in which the action takes place or on which 
	 										the condition / perception is based.
	 * @throws	IllegalArgumentException	If an argument was missing which is needed by this action
	 * @throws	LogicException				If message box could not be displayed
	 */    	
	public void actionShowMessageDialog(Map logicEnvironment) 
    	throws LogicException, IllegalArgumentException
	{
		boolean ok = true;		

		Object messageObject = logicEnvironment.get("message");
		if (messageObject != null) {
		 	if((messageObject  instanceof String) && (logicEnvironment.containsKey(messageObject ))) {
				messageObject  = logicEnvironment.get(messageObject );
			}
		} else {		
			messageObject = new String("Default Message");
		}

		JOptionPane.showMessageDialog(null, messageObject.toString(), "MessageDialog", JOptionPane.INFORMATION_MESSAGE); 		
	}


	/**
	 * Performs the condition and returns with a truthvalue which tells how true 
	 * the condition is. The default implementation does nothing.
	 *
	 *	@lsparam message
	 *
	 *
	 * @param	logicEnvironment 			The environment in which the action takes place or on which 
	 * 										the condition / perception is based.
	 * @return	The truth value of the perception
	 * @throws	IllegalArgumentException	If an argument was missing which is needed by this perception
	 * @throws	LogicException				If no descission could be made based on the validation
	 */    	
	
	public double perceptionShowConfirmDialog(Map logicEnvironment)
    	throws LogicException, IllegalArgumentException
	{
		double ok=FALSE;

		Object messageObject = logicEnvironment.get("message");
		if (messageObject != null) {
		 	if((messageObject  instanceof String) && (logicEnvironment.containsKey(messageObject ))) {
				messageObject  = logicEnvironment.get(messageObject );
			}
		} else {		
			messageObject = new String("Default Message");
		}
			
		int result = JOptionPane.showConfirmDialog(null, messageObject.toString(), "ConfirmDialog", JOptionPane.YES_NO_OPTION);

		if(result == JOptionPane.YES_OPTION) {
			ok=TRUE;
		}

		return(ok);
	}
}
