/*
 * Copyright (c) year living systems (R) AG, Germany.
 * All rights reserved.
 * Original Author: Andreas Amann
 *
 * $Date:   Sep 03 2001 11:04:10  $
 */
 
package com.ls.demo.capabilities;

import com.ls.logiccontrol.capabilities.LogicCapabilities;
import com.ls.service.log.ILogger;

import java.util.Hashtable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import java.lang.Long;

import com.ls.service.log.ILogger;

import com.ls.logiccontrol.ILogicEngine;

import com.ls.logiccontrol.LogicConfigurationException;

import com.ls.lars.communication.*;
import com.ls.lars.communication.GroupMessage;
import com.ls.TimeoutException;


/** 
 * 
 * @author  Last modified by $Author:   CDannegger  $
 * @version $Revision:   1.18  $
 */
public class Transport extends LogicCapabilities implements Constants
{
	/** constant for name of this class */
	static private final String CLASS_NAME 		= "Transport";
	/** value to be returned by the perception */
	static private final double TRUE			= 1.0; 	
	/** value to be returned by the perception */
	static private final double FALSE			= 0.0; 	
	/** maximal number of nodes to be looked through on one step */
	static private final int MAX_NODES			= 5;
	
	static private final String BEAN_KEY_PREFIX	= "TB_KEY_";
/*
	KEY's
*/	
	/** key used to map freight status */
	static private final String FREIGHT				= BEAN_KEY_PREFIX + "freight";
	/** key used to map drive status */
	static private final String DRIVE				= BEAN_KEY_PREFIX + "drive";
	/** key used to map drive status */
	static private final String TRUCK_SPEED			= BEAN_KEY_PREFIX + "truck_speed";
	/** key used to map drive status */
	static private final String TRUCK_DISTANCE_TO_NODE = BEAN_KEY_PREFIX + "distance_to_next_node";
	/** key used to map truck status */
	static private final String TRUCK_STATUS		= BEAN_KEY_PREFIX + "truck";
	/** key used to map position status */
	static private final String POSITION			= BEAN_KEY_PREFIX + "position";
	/** key used to map factory list */
	static private final String FACTORY_LIST		= BEAN_KEY_PREFIX + "factory_list";
	/** key used to store the freight id which the truck has to transport to the store */
	static private final String FREIGHT_NO_TO_CARRY = BEAN_KEY_PREFIX + "freightNoToCarry";
	/** key used to map node */
	static private final String NODE				= BEAN_KEY_PREFIX + "node";
	/** key used to map distance */
	static private final String NODE_1				= BEAN_KEY_PREFIX + "node_1";
	/** key used to map distance */
	static private final String NODE_2				= BEAN_KEY_PREFIX + "node_2";
	/** key used to map distance */
	static private final String NODE_3				= BEAN_KEY_PREFIX + "node_3";
	/** key used to map distance */
	static private final String NODE_4				= BEAN_KEY_PREFIX + "node_4";
	/** key used to map distance */
	static private final String NODE_5				= BEAN_KEY_PREFIX + "node_5";
	/** key used to map current factory name */
	static private final String CURRENT_FACTORY		= BEAN_KEY_PREFIX + "current_factory";
	static private final String CURRENT_FACTORY_NODE= BEAN_KEY_PREFIX + "current_factory_node";
	/** key used the store node id the truck has to deliver his freight */
	static private final String STORE_TO_DRIVE		= BEAN_KEY_PREFIX + "store_to_drive";
	static private final String STORE_TO_DRIVE_ID	= BEAN_KEY_PREFIX + "store_to_drive_nodeId";
	/** key used to map destination name */
	static private final String DESTINATION			= BEAN_KEY_PREFIX + "destination";
	/** key used to map positiontype: node, factory or store */
	static private final String POSITION_TYPE		= BEAN_KEY_PREFIX + "position_type";

	/** key used to map coordinates */
	static private final String X_COORDINATE 		= BEAN_KEY_PREFIX + "x_cor";
	static private final String Y_COORDINATE 		= BEAN_KEY_PREFIX + "y_cor";
	static private final String MY_ROAD				= BEAN_KEY_PREFIX + "my_road";
	
	static private final String TRUCK_DRIVING		= BEAN_KEY_PREFIX + "truck_driving";

	/** key used to store the truck Id (is configuration parameter) */
	static private final String TRUCK_ID			= "truckID";
	
/*
	values
*/	
	/** value for the truck status */
	static private final String TRUCK_IS_DRIVING = "is_driving";
	/** value for the truck status */
	static private final String READY			= "ready";
	/** value for the freight status */
	static private final String DELIVER			= "deliver";
	/** value for the freight status */
	static private final String BOOKED			= "booked";
	/** value for the freight status */
	static private final String LOADED			= "loaded";
	/** value for the drive status */
	static private final String FAST			= "fast";
	/** value for the drive status */
	static private final String SLOW			= "slow";
	/** value for the truck status */
	static private final String FULL			= "full";
	/** value for the truck status */
	static private final String EMPTY			= "empty";
	/** value for the position status */
	static private final String FACTORY_NODE	= "factoryNode";
	/** value for the position status */
	static private final String STORE_NODE		= "storeNode";
	
/*
	truck internal subjects
*/	
	static private final String SUBJECT_SEND_ROAD_INFO	= "get_road_info"; 
	
	/** value used for decision whether a truck is fast or not */
	static private final int	M_ILIMITIFFASTORNOT	= 60;
	
	static private final int	SLEEP_TIME_AFTER_ALL_FACTORIES_HAVE_NOTHING_TO_TRANSPORT = 2500;
	
	static private /*final*/long	m_lTimeWhenTheRoadInfoIsOutdatedInMilliSecs = 40000;	// secs
	
	static private final int	m_iSynTimeOutInMilliSec	= 10000;
	
	static private final String RADIUS_FOR_NEARBY_TRUCKS	= "150";
	
	/** value used during distance fuzzy value calculation */
	static private final double MINIMAL_SPEED	 	= 0.0; 
	/** value used during distance fuzzy value calculation */
	static private final double MAXIMAL_SPEED	 	= 100.0; 
	
	/** array keeping names of all factoris */
	private ArrayList m_vecFactories 	= new ArrayList();
	private ArrayList m_vecStores	 	= new ArrayList();
	/** array keeping names for the next nodes */
	private String[] m_aNodesName 		= new String[MAX_NODES];
	/** array keeping distances for the next nodes */
	private double[] m_aNodesDistance 	= new double[MAX_NODES];
	/** array keeping speeds for the next nodes */
	private double[] m_aNodesSpeed 		= new double[MAX_NODES];
	
	/** array keeping speed on the roads => key values is the roadId */
	private HashMap m_InfoHashMapForAllKnownRoads = new HashMap();	
	
	//******************************** Goals ***************************************
	
	/**
	 * @param workflowModel represents logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionDeliverFreight(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionDeliverFreight";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);

	    String freightStatus = (String)workflowModel.get(FREIGHT);
	    if ((freightStatus != null) && (freightStatus.equals(DELIVER))) {
	    	returnValue = TRUE;
//??AA??   	workflowModel.remove(FREIGHT);
        }
		iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionOthersDriveFast(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionOthersDriveFast";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
        
		iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionDriveFast(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionDriveFast";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
        String truckSpeed = (String)workflowModel.get(TRUCK_SPEED);
        
        if (truckSpeed != null)
        {
			double mySpeed = Double.parseDouble(truckSpeed);
			
			returnValue = mySpeed / MAXIMAL_SPEED;
			
			if (returnValue > 0.7)
			{
				returnValue = TRUE;
			}
	    }
        
		iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	    
	}	// perceptionDriveFast -------------------------------------------
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionDriveCheap(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionDriveCheap";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
        String truckDistance = (String)workflowModel.get(TRUCK_DISTANCE_TO_NODE);
        
        if (truckDistance != null)
        {
			double myDistance = Double.parseDouble(truckDistance);
			
			returnValue = myDistance;		
	    }
        
		iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}	// perceptionDriveCheap ------------------------------------------
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionReady(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionReady";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
        String driveStatus = (String)workflowModel.get(STATUS);
	    if ((driveStatus != null) && (driveStatus.equals(READY))) {
	    	returnValue = TRUE;
	    }
        
		iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	//********************************** Perceptions *****************************************
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionNewRoadInfo(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionNewRoadInfo";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);

	    String knowRoad = (String) workflowModel.get(MY_ROAD);
	    if (knowRoad != null) {
	    	returnValue = TRUE;
        }
        
		iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionHaveFactoryList(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionHaveFactoryList";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
	    
		if (workflowModel.get(FACTORY_LIST) != null) {
	    	returnValue = TRUE;
	    }
	    
        iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionFreightBooked(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionFreightBooked";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		String freightStatus = (String)workflowModel.get(FREIGHT);
		if ((freightStatus != null) && (freightStatus.equals(BOOKED))) {
	    	returnValue = TRUE;
	    }
        
        iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionFreightLoaded(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionFreightBooked";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		String freightStatus = (String)workflowModel.get(FREIGHT);
		if ((freightStatus != null) && (freightStatus.equals(LOADED))) {
	    	returnValue = TRUE;
	    }
        
        iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionKnowDestination(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionKnowDestination";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		if (workflowModel.get(DESTINATION) != null) {
	    	returnValue = TRUE;
	    }
        
        iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionTruckFull(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionTruckFull";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		String truckStatus = (String)workflowModel.get(TRUCK_STATUS);
		if ((truckStatus != null) && (truckStatus.equals(FULL))) {
	    	returnValue = TRUE;
	    }
	    
        iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionAtFactory(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionAtFactory";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		String positionType = (String)workflowModel.get(POSITION_TYPE);
		if ((positionType != null) && (positionType.equals(FACTORY_NODE))) {
	    	returnValue = TRUE;
	    }
        
        iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionAtStore(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionAtStore";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		String positionType = (String)workflowModel.get(POSITION_TYPE);
		if ((positionType != null) && (positionType.equals(STORE_NODE))) {
	    	returnValue = TRUE;
	    }
        
        iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionKnowNode(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionKnowNode";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		if (workflowModel.get(NODE) != null) {
	    	returnValue = TRUE;
	    }
        
        iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionHaveNodes(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionHaveNodes";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		if (workflowModel.get(NODE_1) != null) {
	    	returnValue = TRUE;
	    } else if (workflowModel.get(NODE_2) != null) {
	    	returnValue = TRUE;
	    } else if (workflowModel.get(NODE_3) != null) {
	    	returnValue = TRUE;
	    } else if (workflowModel.get(NODE_4) != null) {
	    	returnValue = TRUE;
	    } else if (workflowModel.get(NODE_5) != null) {
	    	returnValue = TRUE;
	    }
        
        iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionKnowNode1(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionKnowNode1";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		if (workflowModel.get(NODE_1) != null) {
	    	returnValue = TRUE;
	    }
        
        iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionKnowNode2(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionKnowNode2";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		if (workflowModel.get(NODE_2) != null) {
	    	returnValue = TRUE;
	    }
        
        iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionKnowNode3(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionKnowNode3";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		if (workflowModel.get(NODE_3) != null) {
	    	returnValue = TRUE;
	    }
        
        iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionKnowNode4(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionKnowNode4";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		if (workflowModel.get(NODE_4) != null) {
	    	returnValue = TRUE;
	    }
        
        iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionKnowNode5(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionKnowNode5";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		if (workflowModel.get(NODE_5) != null) {
	    	returnValue = TRUE;
	    }
        
        iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionAtNode(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionAtNode";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		String position = (String)workflowModel.get(POSITION);
		String node 	= (String)workflowModel.get(NODE);
		
		if ((position != null) && (position.equals(node))) {
			
//??AA??	workflowModel.remove(TRUCK_SPEED);
	    	returnValue = TRUE;
	    }
        
        iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionDriving(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionDriving";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		String driving = (String)workflowModel.get(TRUCK_DRIVING);
		
		if ((driving != null) && (driving.equals(TRUCK_IS_DRIVING))) {
			
	    	returnValue = TRUE;
	    }
        
        iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionGoalIsStore(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionGoalIsStore";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		String task 	= (String)workflowModel.get(TRUCK_TASK);
		if ((task != null) && (task.equals(DRIVING_TO_STORE))) {
	    	returnValue = TRUE;
	    }
        
        iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionGoalIsFactory(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionGoalIsFactory";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		String task	= (String)workflowModel.get(TRUCK_TASK);
		if ((task != null) && (task.equals(DRIVING_TO_FACTORY))) {
	    	returnValue = TRUE;
	    }
        
        iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionAtDestination(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionAtDestination";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		String position 	= (String)workflowModel.get(POSITION);
		String destination 	= (String)workflowModel.get(DESTINATION);
		if ((position != null) && (position.equals(destination))) {
	    	returnValue = TRUE;
	    }
        
        iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
/*
	IS SHORT METHOD's
*/	
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionNode1IsNear(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionNode1IsNear";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
        returnValue = m_aNodesDistance[0];
        
		iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue : " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionNode2IsNear(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionNode2IsNear";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);

        returnValue = m_aNodesDistance[1];

        iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue : " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionNode3IsNear(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionNode3IsNear";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
        returnValue = m_aNodesDistance[2];
        
        iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue : " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionNode4IsNear(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionNode4IsNear";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
	    
        returnValue = m_aNodesDistance[3];
        
        iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue : " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionNode5IsNear(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionNode5IsNear";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
	    
        returnValue = m_aNodesDistance[4];
        
        iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue : " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
/*
	Is Fast Method's
*/	
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionNode1IsFast(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionNode1IsFast";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		returnValue = m_aNodesSpeed[0];
        
		iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionNode2IsFast(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionNode2IsFast";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		returnValue = m_aNodesSpeed[1];
        
        iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionNode3IsFast(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionNode3IsFast";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		returnValue = m_aNodesSpeed[2];
        
		iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionNode4IsFast(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionNode4IsFast";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		returnValue = m_aNodesSpeed[3];
        
		iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionNode5IsFast(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionNode5IsFast";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		returnValue = m_aNodesSpeed[4];
        
		iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}

/*
	Node Info is New Methods
*/	
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionNode1InfoIsNew(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionNode1InfoIsNew";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		Random randomTime = new Random();
		returnValue = randomTime.nextDouble();
		
		returnValue = TRUE;
		
		iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionNode2InfoIsNew(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionNode2InfoIsNew";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		Random randomTime = new Random();
		returnValue = randomTime.nextDouble();
		
		returnValue = TRUE;
		
		iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionNode3InfoIsNew(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionNode3InfoIsNew";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		Random randomTime = new Random();
		returnValue = randomTime.nextDouble();
		
		returnValue = TRUE;
		
		iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionNode4InfoIsNew(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionNode4InfoIsNew";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		Random randomTime = new Random();
		returnValue = randomTime.nextDouble();
		
		returnValue = TRUE;
				
		iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	/**
	 * @param workflowModel represens logical environment
	 * @return TRUE if the mapping exists
	 */
	public double perceptionNode5InfoIsNew(Map workflowModel) 
	{
		double returnValue = FALSE;		
		String METHOD_NAME = "perceptionNode5InfoIsNew";
	    iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
	    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
        
		Random randomTime = new Random();
		returnValue = randomTime.nextDouble();
		
		returnValue = TRUE;
		
		iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue: " + returnValue);
	    iLogger.log("", ILogger.TRACE3, "", "");

	    return returnValue;
	}
	
	//*********************************** Actions *********************************************
	
	/**
	 * @param workflowModel represents logical environment
	 */
	public void actionGetFactoryList(Map workflowModel)
	{
		String METHOD_NAME = "actionGetFactoryList";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);

		// if the position is not set => get it from the configuration paramter
		if (workflowModel.get(POSITION) == null)
		{
			Object	obj = workflowModel.get(SUBJECT_INITIAL_POSITION);
			if (obj != null)
			{
				iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "setting initial postion to " + obj.toString() );
				workflowModel.put(POSITION, obj);
			}
			else
			{	// no parameter set => setConfiguration workflow not called
				iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "no initial postion => 'initial_position' " + 
																				"key in the environment is null !!!");
				return;
			}
		}
		try 
		{	// set current position and destination as parameters to get the next nodes		
			HashMap		content = new HashMap ();
			content.put("currentNodeID", workflowModel.get(POSITION) );
			
			// get the info from the AgentInfo
			Message message = new SingleMessage(SUBJECT_GET_FACTORY_LIST, AGENT_INFO, content);
			
			message.setReplyWith(CLASS_NAME+System.currentTimeMillis());
		
			if (null == iCommunication)
			{
				iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "iCommunication is null");
				return;
			}
			Message replyMessage = iCommunication.sendSynchronousRequest(message, m_iSynTimeOutInMilliSec);
			if (replyMessage != null)
			{
				Object		replyObj = (Object) replyMessage.getContent();		

				if (replyObj instanceof ArrayList)
				{
					m_vecFactories = (ArrayList) replyMessage.getContent();
					
					if (m_vecFactories != null)
					{
						ArrayList	factoriesList = new ArrayList();
						String	factoryName = null;
						
						iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "=======================================");	
						iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "= Factory List from NodeId " + 
																					workflowModel.get(POSITION) + " =");	
						iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "=======================================");	
						for (int i = 0; i < m_vecFactories.size(); i++)
						{
							factoryName = (String) m_vecFactories.get(i);
							iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "Factory : " + i + " =>" + 
																										factoryName);
							factoriesList.add(factoryName);
						}
						iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "=======================================");	
		
						workflowModel.put(FACTORY_LIST, factoriesList);
					}
					else
					{
						iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "can't get factory info from the reply " +
																							"msg : " + replyMessage);
					}
				}
				else
				{
					iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "wrong MsgDataType => no ArrayList  :-(");
				}
			}
			else
			{
				iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "replyMessage is null");
			}
			iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "" + m_vecFactories);
		}
		catch(TimeoutException te) 
		{
			iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "TimeoutException : " + te.toString() );
		}
	}	// actionGetFactoryList ------------------------------------------
	
	/**
	 * @param workflowModel represens logical environment
	 */
	public void actionGetNextNodes(Map workflowModel)
	{
		String METHOD_NAME = "actionGetNextNodes";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);

		// set current position and destination as parameters to get the next nodes		
		HashMap		content = new HashMap ();
		content.put("positionNodeID", workflowModel.get(POSITION) );
		content.put("destinationNodeID", workflowModel.get(DESTINATION) );

		iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "content : " + content);
		
		// get the info from the AgentInfo
		Message message = new SingleMessage(SUBJECT_GET_NEXT_NODE, AGENT_INFO, content);
		message.setReplyWith(CLASS_NAME+System.currentTimeMillis());
		
		try 
		{
			Message 	replyMessage	= iCommunication.sendSynchronousRequest(message, m_iSynTimeOutInMilliSec);
			Object		replyObj		= (Object) replyMessage.getContent();
			
			iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "ClassName : " + replyObj.toString() );
	
			if (replyObj instanceof HashMap)
			{
				HashMap	replyMap = (HashMap) replyMessage.getContent();
				iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "Msg-Content is a HashMap :-)");
			
				
				iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "replyList : " + replyMap);
				
				Iterator it = replyMap.keySet().iterator();
				
				int	iCounter = 0;
				
				double	dMaxDistance = 1;
				double	dMinDistance = 100000.0;
				
				String[] aRoadIds = new String[MAX_NODES];
		
				while ( (it.hasNext()) && (iCounter < MAX_NODES) ) 
				{
					String	keyValue	= (String) it.next();
					HashMap nodeHash	= (HashMap) replyMap.get(keyValue);
	
					m_aNodesName [iCounter]		= (String) nodeHash.get("nodeID");
					Double	dValue1				= (Double) nodeHash.get("distance");
					String	roadId				= (String) nodeHash.get("roadID");
					m_aNodesDistance [iCounter]	= dValue1.doubleValue();
					aRoadIds [iCounter]			= roadId;
					
					if (m_aNodesName[iCounter].equals("-1") )
					{
						iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "NodeID is  -1 !!!!!!!!!!");
					}
					if (m_aNodesDistance [iCounter] >= dMaxDistance)
					{
						dMaxDistance = m_aNodesDistance [iCounter];
					}
					if (m_aNodesDistance [iCounter] <= dMinDistance)
					{
						dMinDistance = m_aNodesDistance [iCounter];
					}
					
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "--------------------------");
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "NodeID   : " + m_aNodesName [iCounter]);
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "distance : " + m_aNodesDistance [iCounter]);
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "roadId   : " + aRoadIds [iCounter]);
					
					iCounter++;
				}
				iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "--------------------------");
				// converting absolut distances to relativ distances 
				double	dMaxValueForMaxDistances = 0.45;	// truth value for the biggest distance value
				for (int i = 0; (i < MAX_NODES) && (i < iCounter); i++)
				{
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "Distance (abs.) " + m_aNodesDistance [i]);
					// ---------------------------------------------------
					m_aNodesDistance [i] = m_aNodesDistance [i] * ( (dMaxValueForMaxDistances - 1.0)  / dMaxDistance);
					m_aNodesDistance [i] += 1.0;
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "Distance (rel.) " + m_aNodesDistance [i]);
					//----------------------------------------------------
					// setting the speed on the road to the next node
					//----------------------------------------------------
					HashMap hm = (HashMap) m_InfoHashMapForAllKnownRoads.get(aRoadIds [i]);
					
					if (null == hm)
					{	// we have no speed information about this very road => assume the highest velocity...
						m_aNodesSpeed [i] = 1.0;
					}
					else
					{	// we have speed information about this very road => calculate truth value
						String	strSpeed = (String) hm.get("speed");
						String	strDate  = (String) hm.get("date");
						
						double	dSpeed = Double.parseDouble(strSpeed);
						long	lTime  = Long.parseLong(strDate);
						
						long	actualTime = System.currentTimeMillis();
						
						long	ageOfTheInfo = actualTime - lTime;
						
						if (ageOfTheInfo > m_lTimeWhenTheRoadInfoIsOutdatedInMilliSecs)
						{	// infos is too old, we don't use it
							iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "removing the infos about this road"+ 
																  " => outdated : infs is " + ageOfTheInfo + " ms old");
							m_InfoHashMapForAllKnownRoads.remove(aRoadIds [i]);
							
							m_aNodesSpeed [i] = 1.0;
						}
						else
						{
							m_aNodesSpeed [i] = dSpeed / MAXIMAL_SPEED;
							iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "we have informations (speed & date)" +
																						" about the road to this node");
							iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "elapsed time    " + 
																								  ageOfTheInfo + " ms");
							iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "Velocity (abs.) " + dSpeed );
						}
					}
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "Velocity (rel.) " + m_aNodesSpeed [i]);
					//----------------------------------------------------
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "--------------------------");
				}
			}
			else
			{
				iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "Datatype is wrong => no HashMap !!!! :-(");
			}
		}
		catch(TimeoutException te) 
		{
			iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "TimeoutException : " + te.toString() );
		}
		
		// setting all known nodes
		
		if ( (m_aNodesName[0] != null) && (m_aNodesName[0].length() != 0) ) {
			workflowModel.put(NODE_1, m_aNodesName[0]);
		}
		if ( (m_aNodesName[1] != null) && (m_aNodesName[1].length() != 0) ) {
			workflowModel.put(NODE_2, m_aNodesName[1]);
		}
		if ( (m_aNodesName[2] != null) && (m_aNodesName[2].length() != 0) ) {
			workflowModel.put(NODE_3, m_aNodesName[2]);
		}
		if ( (m_aNodesName[3] != null) && (m_aNodesName[3].length() != 0) ) {
			workflowModel.put(NODE_4, m_aNodesName[3]);
		}
		if ( (m_aNodesName[4] != null) && (m_aNodesName[4].length() != 0) ) {
			workflowModel.put(NODE_5, m_aNodesName[4]);
		}
		
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, m_aNodesName);
				
	}	// actionGetNextNodes --------------------------------------------

	/**
	 * @param workflowModel represens logical environment
	 */
	public void actionGetNextFactory(Map workflowModel)
	{
		String METHOD_NAME = "actionGetNextFactory";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
		
		// get the list from the environment -----------------------------
		ArrayList factories = (ArrayList)workflowModel.get(FACTORY_LIST);
		// if not known return anyway or no factories in the list
		if (factories == null) return;
		if (factories.size() == 0) {

			try {
				iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "sleep......");
				Thread.sleep(SLEEP_TIME_AFTER_ALL_FACTORIES_HAVE_NOTHING_TO_TRANSPORT);
				iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "up and running again......");
			}
			catch (InterruptedException ie) {}
			
			String		factoryName = null;
			for (int i = 0; i < m_vecFactories.size(); i++)
			{
				factoryName = (String) m_vecFactories.get(i);
				factories.add(factoryName);
			}
			workflowModel.put(FACTORY_LIST, factories);
			// workflowModel.remove(FACTORY_LIST);
		}
		// put the first factory to current factory
		workflowModel.put(CURRENT_FACTORY, (String)factories.get(0));
		// remove the 'putted' factory from the list, so next time another factory is put to the current factory
		factories.remove(0);
		// if we ran thru all factories, remove the list and set it to null 
		if (factories.size() == 0) {
			factories = null;
		}
		// log the 'next' factory
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, (String)workflowModel.get(CURRENT_FACTORY));		
	}
	
	/**
	 * @param workflowModel represens logical environment
	 */
	public void actionTransportRequest(Map workflowModel)
	{
		String METHOD_NAME = "actionTransportRequest";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
		
		boolean booked = false;
		
		String 	strCurrentFactory = null;
		try 
		{
			strCurrentFactory = (String) workflowModel.get(CURRENT_FACTORY);
			//------------------------------------------------------------
			// asking the factory for something to transport 
			//------------------------------------------------------------
			Message message = new SingleMessage(SUBJECT_TRANSPORT_REQUEST_TO_FACTORY, strCurrentFactory, null);
			
			message.setReplyWith(CLASS_NAME+System.currentTimeMillis());
		
			if (null == iCommunication)
			{
				iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "iCommunication is null");
				return;
			}
			Message replyMessage = iCommunication.sendSynchronousRequest(message, m_iSynTimeOutInMilliSec);
			if (replyMessage != null)
			{
				iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "reply msg : " + replyMessage);
						
				Object	replyObj = (Object) replyMessage.getContent();
				
				if (replyObj instanceof HashMap)
				{
					HashMap returnHashMap = (HashMap) replyObj;

					iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "returnHashMap : " + returnHashMap);
					
					if (returnHashMap != null)
					{
						String	strNodeId 	 = (String) returnHashMap.get("nodeID");
						String	strFreightNo = (String) returnHashMap.get("freightNoForTruck");

						if (null == strNodeId)
						{
							iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "strNodeId is null");
						}
						if (null == strFreightNo)
						{
							iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "strFreightNo is null");
						}
						
						if (!strFreightNo.equals("-1") )	// positiv answer
						{
							iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "[" + strCurrentFactory + 
																	"] finally we have something to transport..");
							
							iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "strNodeId : " + strNodeId);
							workflowModel.put(CURRENT_FACTORY_NODE, strNodeId);
	
							iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "we have to pick up FreightNo : " + 
																		strFreightNo + " from " + strCurrentFactory);
																			
							iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "returnHashMap => " + returnHashMap);
							
							workflowModel.put(FREIGHT, BOOKED);
							booked = true;
																			
							workflowModel.put(FREIGHT_NO_TO_CARRY, strFreightNo);
							
							workflowModel.put(TRUCK_TASK, DRIVING_TO_FACTORY);
						
							// new 28/08/2001 22:53	
							workflowModel.remove(FACTORY_LIST);
						}
						else
						{	// negativ answer
							iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "[" + strCurrentFactory + 
																						"] has nothing to transport");
						}
						
						//----------------------------------------------------------------
						// send transport request info to all the viewers (for visualization)
						//----------------------------------------------------------------
						HashMap	hm = new HashMap ();
						hm.put("truckID", 	workflowModel.get(TRUCK_ID) );
						hm.put("factoryNodeID", strNodeId);
						iCommunication.sendMessage(new GroupMessage(SUBJECT_TRUCK_REQUEST_TO_FACTORY, 
																	AGENT_VIEWERS, 
																	hm) 
												   );
						//----------------------------------------------------------------
					}// if (returnHashMap != null)
				}
				else
				{
					iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "Datatype is wrong => no HashMap !!!! :-(");
				}
			}
		}
		catch(TimeoutException te) 
		{
			iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "Timeout => [" + strCurrentFactory + 
																						"] has nothing to transport");
		}
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "is booked : " + booked);		
		
	}	// actionTransportRequest ----------------------------------------

	/**
	 * @param workflowModel represens logical environment
	 */
	public void actionDriveToFactory(Map workflowModel)
	{
		String METHOD_NAME = "actionDriveToFactory";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
		
		// maybe we have to set a node as destination and not the factory(agent) name ??AA??
		Object obj = workflowModel.get(CURRENT_FACTORY_NODE);
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "obj : " + obj);
		if (obj != null)
		{
			workflowModel.put(DESTINATION, obj);
			iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, (String)workflowModel.get(DESTINATION));		
		}
	}

	/**
	 * @param workflowModel represens logical environment
	 */
	public void actionDriveToStore(Map workflowModel)
	{
		String METHOD_NAME = "actionDriveToStore";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);

		workflowModel.put(TRUCK_TASK, DRIVING_TO_STORE);
		
		workflowModel.put(DESTINATION, workflowModel.get(STORE_TO_DRIVE_ID) );

		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, (String)workflowModel.get(DESTINATION));		
	
		return;
	}

	/**
	 * @param workflowModel represens logical environment
	 */
	public void actionInformFactory(Map workflowModel)
	{
		String METHOD_NAME = "actionInformFactory";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
		
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "================> L O A D <================");
		
		try 
		{
			String strCurrentFactory = (String) workflowModel.get(CURRENT_FACTORY);
			String strFreightNo		 = (String) workflowModel.get(FREIGHT_NO_TO_CARRY);
			
			iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "strCurrentFactory : " + strCurrentFactory);
			iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "strFreightNo      : " + strFreightNo);
			
			// get the name ot the store which ordered this freight !!!!
			Message message = new SingleMessage(SUBJECT_ARRIVE_AT_FACTORY, strCurrentFactory, strFreightNo);
			
			message.setReplyWith(CLASS_NAME+System.currentTimeMillis());
		
			Message 	replyMessage	= iCommunication.sendSynchronousRequest(message, m_iSynTimeOutInMilliSec);
			String		AgentStore		= (String) replyMessage.getContent();

			iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "AgentStore : " + AgentStore);
			
			// get the nodeId from the store 
			Message messageToInfo = new SingleMessage(SUBJECT_GET_NODE_ID_FROM_OBJECT, AGENT_INFO, AgentStore);
			
			messageToInfo.setReplyWith(CLASS_NAME+System.currentTimeMillis());
		
			Message 	replyMessageFromInfo	= iCommunication.sendSynchronousRequest(messageToInfo, 
																					    m_iSynTimeOutInMilliSec);
			String		storeNodeId				= (String) replyMessageFromInfo.getContent();

			iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "loaded freightNo : " + strFreightNo + 
																" for " + AgentStore + " with nodeID : " + storeNodeId);


			//workflowModel.remove(FREIGHT);	// ??AA??
			workflowModel.put(FREIGHT, LOADED);

			workflowModel.put(TRUCK_STATUS, FULL);
			workflowModel.remove(DESTINATION);

			workflowModel.put(STORE_TO_DRIVE, AgentStore);

			workflowModel.put(STORE_TO_DRIVE_ID, storeNodeId);
/*
	moved to the next two lines to the method driveToStore 
*/			
			//workflowModel.put(DESTINATION, storeNodeId);
			//workflowModel.put(TRUCK_TASK, DRIVING_TO_STORE);
		}
		catch(TimeoutException te) 
		{
			iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "TimeoutException : " + te.toString() );
		}
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "");		
	}	// actionInformFactory -------------------------------------------

	/**
	 * @param workflowModel represens logical environment
	 */
	public void actionUnloadFreight(Map workflowModel)
	{
		String METHOD_NAME = "actionUnloadFreight";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
		
		String	strCurrentStore = (String) workflowModel.get(STORE_TO_DRIVE);

		iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "===============================================");
		iLogger.log(CLASS_NAME, ILogger.INFO,   METHOD_NAME, "================> U N L O A D <================");
		iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "===============================================");
		
		iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "strCurrentStore : " + strCurrentStore);
		
		// get the info from the AgentInfo
		Message message = new SingleMessage(SUBJECT_ARRIVE_AT_STORE, strCurrentStore, null);
		
		iCommunication.sendMessage(message);
		
		workflowModel.put(FREIGHT, DELIVER);
		workflowModel.put(TRUCK_STATUS, EMPTY);
		workflowModel.remove(FACTORY_LIST);

		// send unload info the viewer's (client application)		
		HashMap	hm = new HashMap ();
		
		hm.put("truckID", workflowModel.get(TRUCK_ID) );
		hm.put("nodeID",  workflowModel.get(DESTINATION) );
		
		iCommunication.sendMessage(new GroupMessage(SUBJECT_TRUCK_UNLOAD_INFO, AGENT_VIEWERS, hm) );
		
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "freight was delivered");		
		
	}	// actionUnloadFreight -------------------------------------------

	/**
	 * @param workflowModel represens logical environment
	 */
	public void actionDriveToNode(Map workflowModel)
	{
		String METHOD_NAME = "actionDriveToNode";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);

		HashMap	sendHashMap = new HashMap ();
		
		String	startNode = (String) workflowModel.get(POSITION);
		String	endNode   = (String) workflowModel.get(NODE);
		
		if (!startNode.equals(endNode) )
		{
			workflowModel.put(TRUCK_DRIVING, TRUCK_IS_DRIVING);
			
			sendHashMap.put("startNodeID", 		workflowModel.get(POSITION) );
			sendHashMap.put("endNodeID",   		workflowModel.get(NODE) );
			sendHashMap.put("finalDestination", workflowModel.get(DESTINATION) );
			sendHashMap.put("truckID",     		workflowModel.get(TRUCK_ID) );
	
			String	truckStatus 	= (String) workflowModel.get(TRUCK_STATUS);
			String	strIsEmptyValue = "true";
			
			if ( (truckStatus != null) && (truckStatus.equals(EMPTY)) )
			{
				strIsEmptyValue = "true";
			}
			if ( (truckStatus != null) && (truckStatus.equals(FULL)) )
			{
				strIsEmptyValue = "false";
			}
			
			sendHashMap.put("isEmpty", strIsEmptyValue );
			
			iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "sendHash : " + sendHashMap);		
			
			// send the information that we are on the road agein :-)
			Message message = new SingleMessage(SUBJECT_DRIVE_TO_NODE, AGENT_DRIVE_SIMULATION, sendHashMap);
			
			iCommunication.sendMessage(message);		
		}
		else
		{
			iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "start and end node are the same => just too fast");		
		}
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "end");		
	}	// actionDriveToNode ---------------------------------------------
	
	/**
	 * @param workflowModel represens logical environment
	 */
	public void actionGetInfoFromDrivingSimulator(Map workflowModel)
	{
		String METHOD_NAME = "actionGetInfoFromDrivingSimulator";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);

		SingleMessage	message = (SingleMessage) workflowModel.get(ILogicEngine.REQUEST_MESSAGE_KEY);
		
		if (message.getContent() != null) 
		{
			Object returnObj = (Object) message.getContent();
			
			if (returnObj instanceof HashMap)
			{
				HashMap	infoMap = (HashMap) returnObj;
				if (infoMap != null)
				{
					String	corX = (String) infoMap.get("X");
					String	corY = (String) infoMap.get("Y");
					
					String	truckId = (String) infoMap.get("ID");
					String	speed	= (String) infoMap.get("speed");
					String	roadId  = (String) infoMap.get("roadID");
					String	nodID   = (String) infoMap.get("nodID");
					
					double dValue = Double.parseDouble(speed);
					dValue *= MAXIMAL_SPEED;
					String	absSpeed = "" + dValue;
					
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "=======================================");	
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "===== Info from Driving Simulator =====");	
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "=======================================");	
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "x       : " + corX);	
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "y       : " + corY);	
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "truckId : " + truckId);	
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "speed   : " + absSpeed);	
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "roadId  : " + roadId);	
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "nodID   : " + nodID);	
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "=======================================");
					
					workflowModel.put(X_COORDINATE, corX);
					workflowModel.put(Y_COORDINATE, corY);
					workflowModel.put(MY_ROAD,      roadId);
					workflowModel.put(TRUCK_SPEED,  absSpeed);
					
					//----------------------------------------------------					
					// store the information about the road --------------
					//----------------------------------------------------					
					HashMap	hmRoad = new HashMap ();
					hmRoad.put("speed", absSpeed);
					hmRoad.put("date", "" + System.currentTimeMillis() );
					m_InfoHashMapForAllKnownRoads.put(roadId, hmRoad);
					
					if (!nodID.equals("-1") )
					{	// we arrived at the node => setting position to node => postion == node
						// atNode perception should be fulfilled....
						iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "arrived at node ===============> " + nodID);
						Object obj = workflowModel.get(NODE);																						
						if (obj != null)
						{
							workflowModel.put(POSITION, workflowModel.get(NODE));
							workflowModel.put(POSITION_TYPE, NODE);
							
							// we don't drive anymore !!!!!
							workflowModel.remove(TRUCK_DRIVING);
						}
					}
				}	//----------------------------------------------------
			}
			else
			{
				iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "wrong data type => no HashMap !!!");	
			}
		}
		else
		{
			iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "Message Content is null !!!!");	
		}
	}	// actionGetInfoFromDrivingSimulator -----------------------------
	
	/**
	 * @param workflowModel represens logical environment
	 */
	public void actionInformNearByTrucks(Map workflowModel)
	{
		String METHOD_NAME = "actionInformNearByTrucks";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
		//----------------------------------------------------
		// inform the nearby trucks 
		//----------------------------------------------------
		String myRoadId = (String) workflowModel.get(MY_ROAD);

		if (myRoadId != null)
		{
			HashMap	sendHash = new HashMap ();
			
			sendHash.put("x", workflowModel.get(X_COORDINATE) );
			sendHash.put("y", workflowModel.get(Y_COORDINATE) );
			sendHash.put(TRUCK_ID, workflowModel.get(TRUCK_ID) );
			sendHash.put("radius", RADIUS_FOR_NEARBY_TRUCKS);
	
			iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "roadID : " + myRoadId + " sendHash : " + sendHash);
			
			Message message = new SingleMessage(SUBJECT_GET_NEAR_TRUCK_LIST, AGENT_INFO, sendHash);
			
			message.setReplyWith(CLASS_NAME+System.currentTimeMillis());
	
			try
			{	
				Message replyMessage = iCommunication.sendSynchronousRequest(message, m_iSynTimeOutInMilliSec);
	
				Object returnObj = (Object) replyMessage.getContent();
				if (returnObj != null)
				{
					HashMap myRoadInfo = (HashMap) m_InfoHashMapForAllKnownRoads.get(myRoadId);
					
					if (myRoadInfo != null)
					{
						HashMap roadInfoForTruck = new HashMap ();
						
						roadInfoForTruck.put("roadID", myRoadId);
						roadInfoForTruck.put("speed",  myRoadInfo.get("speed") );
						roadInfoForTruck.put("date",   myRoadInfo.get("date") );
					
						if (returnObj instanceof ArrayList)
						{
							ArrayList	listOfTrucks = (ArrayList) returnObj;
							iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "=================================");	
							iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "road info => " + roadInfoForTruck);	
							
							// for loop thru all trucks....
				        	for (int i = 0; i < listOfTrucks.size(); i++) {
							
								String	truckAgentName = (String) listOfTrucks.get(i);
								iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "send road info to " 
																									 + truckAgentName);	
								Message messageToTruck = new SingleMessage(SUBJECT_SEND_ROAD_INFO, 
																		   truckAgentName, 
																		   roadInfoForTruck);
								iCommunication.sendMessage(messageToTruck);


								HashMap	hm = new HashMap ();
								hm.put("truckID", 	workflowModel.get(TRUCK_ID) );
								hm.put("truckReceiverName", truckAgentName);
								iCommunication.sendMessage(new GroupMessage(SUBJECT_INFORM_TRUCK_ABOUT_SPEED, 
																			AGENT_VIEWERS, 
																			hm) 
														   );
				        	}        	
							iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "=================================");	
						}
						else
						{
							iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "wrong datatype => expecting" + 
																										  " ArrayList");	
						}
					}
					else
					{
						iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "myRoadInfo is null for roadId : " + 
																											 myRoadId);	
					}
				}
				else
				{
					iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "reply Msg is null");	
				}
			}
			catch(TimeoutException te) 
			{
				iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "TimeoutException : " + te.toString() );
			}
			// we informed the other trucks with this information => remove the id
			workflowModel.remove(MY_ROAD);
		}
		else
		{
			iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "myRoadId is null");	
		}
	}	// actionGetInfoFromDrivingSimulator -----------------------------
	
	/**
	 * @param workflowModel represens logical environment
	 * processes incoming new road information
	 */
	public void actionGetRoadInfo(Map workflowModel)
	{
		String METHOD_NAME = "actionGetRoadInfo";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);

		SingleMessage	message = (SingleMessage) workflowModel.get(ILogicEngine.REQUEST_MESSAGE_KEY);
		
		if (message.getContent() != null) 
		{
			Object returnObj = (Object) message.getContent();
			
			if (returnObj instanceof HashMap)
			{
				HashMap	infoMap = (HashMap) returnObj;
				if (infoMap != null)
				{
					String	speed	= (String) infoMap.get("speed");
					String	roadId  = (String) infoMap.get("roadID");
					String	date    = (String) infoMap.get("date");
					
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "=======================================");	
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "got road info from " + message.getSender() );	
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "=======================================");	
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "roadId  : " + roadId);	
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "speed   : " + speed);	
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "date    : " + date);	
					iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "=======================================");	
					
					HashMap hmRoad = new HashMap ();
					
					hmRoad.put("speed", speed);
					hmRoad.put("date",  date);

					// store the information about this road 					
					m_InfoHashMapForAllKnownRoads.put(roadId, hmRoad);
					
				}	//----------------------------------------------------
			}
			else
			{
				iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "wrong data type => no HashMap !!!");	
			}
		}
		else
		{
			iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "Message Content is null !!!!");	
		}
	}	// actionGetRoadInfo ---------------------------------------------
	
	/**
	 * @param workflowModel represents logical environment
	 * @lsparam seconds
	 */
	public void actionSetRoadOutdatedTime(Map workflowModel)
	{
		String METHOD_NAME = "actionSetRoadOutdatedTime";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
		
		Object content = workflowModel.get("seconds");
		if (content != null) {
			
			if (content instanceof String)
			{
				String	strTime = (String) content;
				long	lTime   = Long.parseLong(strTime);
				m_lTimeWhenTheRoadInfoIsOutdatedInMilliSecs = lTime * 1000;	// from sec => millisecs
				iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "changed the RemberingTime to : " + 
												m_lTimeWhenTheRoadInfoIsOutdatedInMilliSecs + " ms <<<<<<<<<<<<<<<<<");	
			}
			else
			{
				iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "key [seconds] is not a String Object !!!!");	
			}
		}
		else
		{
			iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "key [seconds] is null !!!!");	
		}
	}	// setRoadOutdatedTime -------------------------------------------

	/**
	 * @param workflowModel represens logical environment
	 */
	public void actionClearNode(Map workflowModel)
	{
		String METHOD_NAME = "actionClearNode";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);

		Object	obj = workflowModel.get(NODE);
		
		if (obj != null)
		{
			workflowModel.put(POSITION,  obj);
		}
		workflowModel.remove(NODE);
		
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, (String)workflowModel.get(NODE));		
	}
	
/*
	C H O O S I N G - R O A D 
*/	
	
	/**
	 * @param workflowModel represens logical environment
	 */
	public void actionChoose1(Map workflowModel)
	{
		String METHOD_NAME = "actionChoose1";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);

		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, ">>>>>>>>>>>>>>>>>>>>>>>>>>>");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "Env. : " + workflowModel);
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "<<<<<<<<<<<<<<<<<<<<<<<<<<<");
		
		workflowModel.put(NODE, workflowModel.get(NODE_1));
		
		workflowModel.put(TRUCK_DISTANCE_TO_NODE, new Double(m_aNodesDistance[0]).toString() );
		//workflowModel.put(DRIVE, FAST);
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "Node Id =====================> " + 
																					(String)workflowModel.get(NODE));		
	}

	/**
	 * @param workflowModel represens logical environment
	 */
	public void actionChoose2(Map workflowModel)
	{
		String METHOD_NAME = "actionChoose2";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);

		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, ">>>>>>>>>>>>>>>>>>>>>>>>>>>");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "Env. : " + workflowModel);
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "<<<<<<<<<<<<<<<<<<<<<<<<<<<");
		
		workflowModel.put(NODE, workflowModel.get(NODE_2));
		
		workflowModel.put(TRUCK_DISTANCE_TO_NODE, new Double(m_aNodesDistance[1]).toString() );
		
		//workflowModel.put(DRIVE, FAST);
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "Node Id =====================> " + 
																					(String)workflowModel.get(NODE));		
	}

	/**
	 * @param workflowModel represens logical environment
	 */
	public void actionChoose3(Map workflowModel)
	{
		String METHOD_NAME = "actionChoose3";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);

		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, ">>>>>>>>>>>>>>>>>>>>>>>>>>>");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "Env. : " + workflowModel);
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "<<<<<<<<<<<<<<<<<<<<<<<<<<<");
		
		workflowModel.put(NODE, workflowModel.get(NODE_3));
		
		workflowModel.put(TRUCK_DISTANCE_TO_NODE, new Double(m_aNodesDistance[2]).toString() );
		
		//workflowModel.put(DRIVE, FAST);
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "Node Id =====================> " + 
																					(String)workflowModel.get(NODE));		
	}
	
	/**
	 * @param workflowModel represens logical environment
	 */
	public void actionChoose4(Map workflowModel)
	{
		String METHOD_NAME = "actionChoose4";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);

		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, ">>>>>>>>>>>>>>>>>>>>>>>>>>>");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "Env. : " + workflowModel);
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "<<<<<<<<<<<<<<<<<<<<<<<<<<<");
		
		workflowModel.put(NODE, workflowModel.get(NODE_4));
		
		workflowModel.put(TRUCK_DISTANCE_TO_NODE, new Double(m_aNodesDistance[3]).toString() );
		
		//workflowModel.put(DRIVE, FAST);
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "Node Id =====================> " + 
																					(String)workflowModel.get(NODE));		
	}
	
	/**
	 * @param workflowModel represens logical environment
	 */
	public void actionChoose5(Map workflowModel)
	{
		String METHOD_NAME = "actionChoose5";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);

		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, ">>>>>>>>>>>>>>>>>>>>>>>>>>>");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "Env. : " + workflowModel);
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "<<<<<<<<<<<<<<<<<<<<<<<<<<<");
		
		workflowModel.put(NODE, workflowModel.get(NODE_5));
		
		workflowModel.put(TRUCK_DISTANCE_TO_NODE, new Double(m_aNodesDistance[4]).toString() );
		
		//workflowModel.put(DRIVE, FAST);
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "Node Id =====================> " + 
																					(String)workflowModel.get(NODE));		
	}

	/**
	 * @param workflowModel represens logical environment
	 */
	public void actionRemoveNodes(Map workflowModel)
	{
		String METHOD_NAME = "actionRemoveNodes";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
		
		workflowModel.remove(NODE_1);
		workflowModel.remove(NODE_2);
		workflowModel.remove(NODE_3);
		workflowModel.remove(NODE_4);
		workflowModel.remove(NODE_5);

		for (int i = 0; i < MAX_NODES; i++) {

			m_aNodesName     [i] = null;
			m_aNodesSpeed    [i] = 0.0;		// 31/08/2001 AA
			m_aNodesDistance [i] = 0.0;		// 31/08/2001 AA
		}
		
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "");		
	}

	/**
	 * @param workflowModel represens logical environment
	 */
	public void actionUpdateTypeToFactory(Map workflowModel)
	{
		String METHOD_NAME = "actionUpdateTypeToFactory";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
		
		workflowModel.put(POSITION_TYPE, FACTORY_NODE);
		
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, (String)workflowModel.get(POSITION_TYPE));		
	}
	
	/**
	 * @param workflowModel represens logical environment
	 */
	public void actionUpdateTypeToStore(Map workflowModel)
	{
		String METHOD_NAME = "actionUpdateTypeToStore";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);
		
		workflowModel.put(POSITION_TYPE, STORE_NODE);
		
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, (String)workflowModel.get(POSITION_TYPE));		
	}
	
	/**
	 * @param workflowModel represens logical environment
	 */
	public void actionResetEnvironment(Map workflowModel)
	{
		String METHOD_NAME = "actionResetEnvironment";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "workflowModel: " + workflowModel);

		// save the important information from the environment		
		String position = (String)workflowModel.get(POSITION);
		String truckId  = (String)workflowModel.get(TRUCK_ID);
		String lastRoad = (String)workflowModel.get(MY_ROAD);
		String x 		= (String)workflowModel.get(X_COORDINATE);
		String y 		= (String)workflowModel.get(Y_COORDINATE);
		
		workflowModel.clear();
		
		// reset the important values
		workflowModel.put(POSITION, position);
		workflowModel.put(TRUCK_ID, truckId);
		workflowModel.put(MY_ROAD,  lastRoad);
		workflowModel.put(X_COORDINATE, x);
		workflowModel.put(Y_COORDINATE, y);
	}

	//********************** Additional methods **********************************************

	/**
	 * @return CLASS_NAME value
	 */
	public String getClassName() {
		return CLASS_NAME;
	}
	
	/**
	 * Method used to calculate fuzzy value on the basis of given absolute one.
	 * @param value Absolute value.
	 * @param minValue minimal value for the calculation
	 * @param maxValue maximal value for the calculation
	 * @return  fuzzy value which corresponds to the parsed value if 0.0 corresponds to
	 *			minValue and 1.0 corresponds to the maxValue
	 */
	private double mapValue(double value, double minValue, double maxValue)
	{
		if (maxValue < minValue) {
			throw new RuntimeException("maxValue " + maxValue + " is less then minValue " + minValue);
		}
		if (value <= minValue) {
			return FALSE;
		}
		if (value >= maxValue) {
			return TRUE;
		}
		return (value - minValue)/(maxValue - minValue);
	}
	
	/**
	 * Calculates the truth value of the passed property by linearly interpolating between 
	 * falseValue and trueValue.
	 * If falseValue is less than or equal trueValue, all values less than falseValue are 
	 * considered to be false, all values
	 * greater than trueValue are considered to be true and all values in between are linearly 
	 * interpolated.
	 * If falseValue is greater than trueValue, all values greater than falseValue are considered 
	 * to be false, all values
	 * less than trueValue are considered to be true and all values in between are linearly 
	 * interpolated.
	 *
	 * @param   property    the source property for which the fuzzy truth value has to be calculated
	 * @param   falseValue  the value up to which the property is considered to be false
	 * @param   trueValue   the value down to which the property is considered to be true
	 * @return              the fuzzy truth value of the property as value in [0..1]
	 */
	protected double getLinearFuzzyValue(double property, double falseValue, double trueValue)
	{
		// do not really know where to put this constant
		final double    D_ZERO_P    = 0.000001;

		if (falseValue < trueValue - D_ZERO_P) {
		    // low values are false, big values true
			if (property < falseValue)
				return 0.0;
			else if (property > trueValue)
				return 1.0;
			else
				return (property - falseValue) / (trueValue - falseValue);

		} else if (falseValue > trueValue + D_ZERO_P) {
		    // low values are true, big values false
			if (property < trueValue)
				return 1.0;
			else if (property > falseValue)
				return 0.0;
			else
				return (falseValue - property) / (falseValue - trueValue);

		} else {
		    // true and false value are (almost) the same
			if (property < falseValue)
				return 0.0;
			else
				return 1.0;
		}
	}	// getLinearFuzzyValue -------------------------------------------
	
}	// closing class bracket ---------------------------------------------
