/*
 * The Apache Software License, Version 1.1
 *
 *
 * Copyright (c) 2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Axis" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package samples.jaxrpc;

import org.apache.axis.encoding.XMLType; // This should probably be javax.xml.rpc.encoding.XMLType if we're told that class is approved (ie., it gets into the spec rather than just in the RI).
import org.apache.axis.utils.Options;

import javax.xml.rpc.Call;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceFactory;

import javax.xml.namespace.QName;

/**
 * This version of GetInfo is a near-duplicate of the GetInfo class in
 * samples/stock.  This version is strictly JAX-RPC compliant.  It uses
 * no AXIS enhancements.
 *
 * @author Russell Butek (butek@us.ibm.com)
 */
public class GetInfo {

    public static void main(String args[]) throws Exception {
        Options opts = new Options(args);

        args = opts.getRemainingArgs();

        if (args == null || args.length % 2 != 0) {
            System.err.println("Usage: GetInfo <symbol> <datatype>");
            System.exit(1);
        }

        String  symbol  = args[0];
        Service service = ServiceFactory.newInstance().createService(null);
        Call    call    = service.createCall();

        call.setTargetEndpointAddress(opts.getURL());
        call.setOperationName(new QName("urn:cominfo", "getInfo"));
        call.addParameter("symbol", XMLType.XSD_STRING, ParameterMode.IN);
        call.addParameter("info", XMLType.XSD_STRING, ParameterMode.IN);
        call.setReturnType(XMLType.XSD_STRING);
        if(opts.getUser()!=null)
            call.setProperty(Call.USERNAME_PROPERTY, opts.getUser());
        if(opts.getPassword()!=null)
            call.setProperty(Call.PASSWORD_PROPERTY, opts.getPassword());

        String res = (String) call.invoke(new Object[] {args[0], args[1]});

        System.out.println(symbol + ": " + res);
    } // main
}

