/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.utility;

import com.zerog.ia.download.WebInstallerApplet;
import com.zerog.ia.download.dialogs.ErrorDialog;
import com.zerog.ia.download.dialogs.ProgressDialog;
import com.zerog.ia.download.downloaders.BrowserDownloader;
import com.zerog.ia.download.downloaders.ZGDownloader;
import com.zerog.ia.download.outputListeners.GUIDownloadListener;
import com.zerog.ia.download.outputListeners.TimeoutListener;
import com.zerog.ia.download.utility.Gestalt;
import com.zerog.ia.download.utility.Util;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Observable;
import java.util.Observer;
import netscape.security.PrivilegeManager;

public class DiskSpaceCheckForDownload
implements Runnable,
Observer {
    private URL urlSource = null;
    private File diskSpaceCheckFile = null;
    private ProgressDialog progressDialog = null;
    private WebInstallerApplet applet = null;
    public static long contentLength;
    public static InputStream input;
    private boolean enoughDiskSpace = false;
    private boolean continueChecking = true;
    private boolean fileAlreadyExists = false;

    public DiskSpaceCheckForDownload(URL urlSource, File diskSpaceCheckFile, ProgressDialog progressDialog, WebInstallerApplet applet) {
        this.urlSource = urlSource;
        this.diskSpaceCheckFile = diskSpaceCheckFile;
        this.progressDialog = progressDialog;
        this.applet = applet;
    }

    /*
     * Loose catch block
     */
    public void run() {
        boolean otherErrorInSpaceChecking;
        ZGDownloader downloadProcess;
        block53: {
            downloadProcess = null;
            otherErrorInSpaceChecking = false;
            System.err.println("DiskSpaceCheck: beginning check for disk space availability...");
            if (Gestalt.isNetscapeSecurityModelAvailable()) {
                PrivilegeManager.enablePrivilege((String)Gestalt.NETSCAPE_FILE_ACCESS);
            }
            if (!Util.makeLeadingDirectories(this.diskSpaceCheckFile)) {
                System.err.println(String.valueOf(String.valueOf(new StringBuffer("DiskSpaceCheck: failure to create download directories: '").append(this.diskSpaceCheckFile.toString()).append("'"))));
            } else {
                System.err.println(String.valueOf(String.valueOf(new StringBuffer("DiskSpaceCheck: download directories created: '").append(this.diskSpaceCheckFile.toString()).append("'"))));
                this.lengthOfDownloadFile();
                System.err.println("DiskSpaceCheck: space required for download: ".concat(String.valueOf(String.valueOf(contentLength))));
                if (this.diskSpaceCheckFile.length() == contentLength) {
                    System.err.println("DiskSpaceCheck: Installer already present on machine (same size), aborting re-download");
                    this.progressDialog.setProgressDialogText(0, null, this.diskSpaceCheckFile.toString());
                    this.progressDialog.pack();
                    this.progressDialog.show();
                    this.fileAlreadyExists = true;
                    this.enoughDiskSpace = true;
                    this.continueChecking = true;
                }
            }
            if (!this.fileAlreadyExists) {
                System.err.println("DiskSpaceCheck: Installer not present on machine, downloading...");
                this.progressDialog.show();
                FileOutputStream FOSoutput = null;
                try {
                    FOSoutput = new FileOutputStream(this.diskSpaceCheckFile);
                    System.err.println("DiskSpaceCheck: FileOutputStream created");
                }
                catch (IOException e) {
                    System.err.println("DiskSpaceCheck: FileOutputStream failed creation, unable to determine disk space availability");
                    e.printStackTrace();
                    FOSoutput = null;
                    this.enoughDiskSpace = false;
                    otherErrorInSpaceChecking = true;
                }
                if (FOSoutput != null) {
                    byte[] oneKilobyteArray = new byte[1024];
                    long bytesWritten = 0L;
                    int percentDone = 0;
                    int prevPercentDone = 0;
                    for (long i = 0L; i < contentLength / (long)1024 && this.continueChecking; ++i) {
                        FOSoutput.write(oneKilobyteArray, 0, 1024);
                        percentDone = (int)((bytesWritten += (long)1024) * (long)100 / contentLength);
                        if (percentDone == prevPercentDone) continue;
                        this.progressDialog.setPercentDone(percentDone);
                        prevPercentDone = percentDone;
                    }
                    FOSoutput.write(oneKilobyteArray, 0, (int)(contentLength % (long)1024));
                    this.enoughDiskSpace = true;
                    Object var12_12 = null;
                    try {
                        if (FOSoutput != null) {
                            FOSoutput.flush();
                            FOSoutput.close();
                            FOSoutput = null;
                        }
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        this.enoughDiskSpace = false;
                    }
                    boolean success = false;
                    if (this.diskSpaceCheckFile.exists()) {
                        System.err.println("DiskSpaceCheck: attempting to delete disk space check file: ".concat(String.valueOf(String.valueOf(this.diskSpaceCheckFile.toString()))));
                        success = this.diskSpaceCheckFile.delete();
                        if (success) {
                            System.err.println("    - disk space check file deleted");
                        }
                    } else {
                        System.err.println("DiskSpaceCheck: disk space check file: ".concat(String.valueOf(String.valueOf(this.diskSpaceCheckFile.toString()))));
                        System.err.println("    - did not exist. There may not be enough disk space to continue");
                    }
                    String parentPath = null;
                    File parentFile = null;
                    try {
                        parentPath = this.diskSpaceCheckFile.getCanonicalPath();
                    }
                    catch (Exception ioe) {
                        parentPath = this.diskSpaceCheckFile.getAbsolutePath();
                    }
                    if (parentPath != null) {
                        parentPath = new File(parentPath).getParent();
                    }
                    if (parentPath != null) {
                        parentFile = new File(parentPath);
                    }
                    System.err.println("DiskSpaceCheck: attempting to delete parent directories: ".concat(String.valueOf(String.valueOf(parentFile.toString()))));
                    success = parentFile.delete();
                    if (success) {
                        System.err.println("    - disk space check file deleted");
                    }
                    break block53;
                    {
                        catch (Exception e) {
                            this.enoughDiskSpace = false;
                            Object var12_13 = null;
                            try {
                                if (FOSoutput != null) {
                                    FOSoutput.flush();
                                    FOSoutput.close();
                                    FOSoutput = null;
                                }
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                                this.enoughDiskSpace = false;
                            }
                            success = false;
                            if (this.diskSpaceCheckFile.exists()) {
                                System.err.println("DiskSpaceCheck: attempting to delete disk space check file: ".concat(String.valueOf(String.valueOf(this.diskSpaceCheckFile.toString()))));
                                success = this.diskSpaceCheckFile.delete();
                                if (success) {
                                    System.err.println("    - disk space check file deleted");
                                }
                            } else {
                                System.err.println("DiskSpaceCheck: disk space check file: ".concat(String.valueOf(String.valueOf(this.diskSpaceCheckFile.toString()))));
                                System.err.println("    - did not exist. There may not be enough disk space to continue");
                            }
                            parentPath = null;
                            parentFile = null;
                            try {
                                parentPath = this.diskSpaceCheckFile.getCanonicalPath();
                            }
                            catch (Exception ioe) {
                                parentPath = this.diskSpaceCheckFile.getAbsolutePath();
                            }
                            if (parentPath != null) {
                                parentPath = new File(parentPath).getParent();
                            }
                            if (parentPath != null) {
                                parentFile = new File(parentPath);
                            }
                            System.err.println("DiskSpaceCheck: attempting to delete parent directories: ".concat(String.valueOf(String.valueOf(parentFile.toString()))));
                            success = parentFile.delete();
                            if (success) {
                                System.err.println("    - disk space check file deleted");
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_14 = null;
                        try {
                            if (FOSoutput != null) {
                                FOSoutput.flush();
                                FOSoutput.close();
                                FOSoutput = null;
                            }
                        }
                        catch (IOException ioe) {
                            ioe.printStackTrace();
                            this.enoughDiskSpace = false;
                        }
                        success = false;
                        if (this.diskSpaceCheckFile.exists()) {
                            System.err.println("DiskSpaceCheck: attempting to delete disk space check file: ".concat(String.valueOf(String.valueOf(this.diskSpaceCheckFile.toString()))));
                            success = this.diskSpaceCheckFile.delete();
                            if (success) {
                                System.err.println("    - disk space check file deleted");
                            }
                        } else {
                            System.err.println("DiskSpaceCheck: disk space check file: ".concat(String.valueOf(String.valueOf(this.diskSpaceCheckFile.toString()))));
                            System.err.println("    - did not exist. There may not be enough disk space to continue");
                        }
                        parentPath = null;
                        parentFile = null;
                        try {
                            parentPath = this.diskSpaceCheckFile.getCanonicalPath();
                        }
                        catch (Exception ioe) {
                            parentPath = this.diskSpaceCheckFile.getAbsolutePath();
                        }
                        if (parentPath != null) {
                            parentPath = new File(parentPath).getParent();
                        }
                        if (parentPath != null) {
                            parentFile = new File(parentPath);
                        }
                        System.err.println("DiskSpaceCheck: attempting to delete parent directories: ".concat(String.valueOf(String.valueOf(parentFile.toString()))));
                        success = parentFile.delete();
                        if (success) {
                            System.err.println("    - disk space check file deleted");
                        }
                        throw throwable;
                    }
                }
            }
        }
        this.progressDialog.deleteObserver(this);
        if (this.continueChecking) {
            System.err.println("DiskSpaceCheck: confirming disk space availability results");
            if (!this.hasEnoughDiskSpace()) {
                String errorTitle = null;
                String errorMessage = null;
                if (otherErrorInSpaceChecking) {
                    System.err.println("DiskSpaceCheck: an error occurred attempting to verify disk space availability");
                    errorTitle = "An error occurred while determining available disk space.";
                } else {
                    System.err.println("DiskSpaceCheck: insufficient disk space");
                    errorTitle = "Unable to verify disk space on this volume.";
                }
                errorMessage = "Either write permissions do not exist on this volume or there\nmay not have been sufficient space to download the installer.\n\nYou will be asked to choose another location on your system\nin which to save the installer.  Once downloaded, the installer\nmay be run manually from the new location.";
                ErrorDialog errorDialog = new ErrorDialog(this.applet.getParentFrame(), errorTitle, errorMessage, this.applet);
                ((Component)this.progressDialog).setVisible(false);
                this.progressDialog.dispose();
                BrowserDownloader browserDownloadProcess = new BrowserDownloader(this.applet);
                browserDownloadProcess.setFileToDownload(this.urlSource);
                browserDownloadProcess.start();
                this.applet.downloadStopped();
            } else {
                System.err.println(String.valueOf(String.valueOf(new StringBuffer("DiskSpaceCheck: disk space okay (").append(this.continueChecking).append(",").append(this.progressDialog.isShowing()).append(")"))));
                if (this.continueChecking && this.progressDialog.isShowing()) {
                    System.err.println("DiskSpaceCheck: preparing downloader/executor object");
                    downloadProcess = new ZGDownloader(this.applet, this.progressDialog);
                    downloadProcess.addDownloadListener(new TimeoutListener(downloadProcess, 30000L));
                    downloadProcess.addDownloadListener(new GUIDownloadListener(downloadProcess, this.progressDialog));
                    downloadProcess.setFileToDownload(this.urlSource);
                    downloadProcess.setFileDestination(this.diskSpaceCheckFile);
                    System.err.println(String.valueOf(String.valueOf(new StringBuffer("DiskSpaceCheck: destination file = '").append(this.diskSpaceCheckFile).append("'"))));
                    System.err.println("DiskSpaceCheck: initiating downloader/executor object...");
                    downloadProcess.start();
                }
            }
        } else {
            System.err.println("DiskSpaceCheck: user has cancelled download/disk space checking");
            ((Component)this.progressDialog).setVisible(false);
            this.progressDialog.dispose();
            this.applet.downloadStopped();
        }
    }

    private void lengthOfDownloadFile() {
        URLConnection urlConnect = null;
        try {
            urlConnect = this.urlSource.openConnection();
            urlConnect.connect();
            input = urlConnect.getInputStream();
        }
        catch (Exception e) {
            System.err.println("DiskSpaceCheck.lengthOfDownloadFile():  exception establishing URL connection");
            e.printStackTrace();
        }
        contentLength = urlConnect.getContentLength();
    }

    public boolean hasEnoughDiskSpace() {
        return this.enoughDiskSpace;
    }

    public void update(Observable obs, Object event) {
        this.continueChecking = false;
        System.err.println("DiskSpaceCheck: cancelling disk space check on user request.");
        try {
            if (input != null) {
                input.close();
            }
            System.err.println("DiskSpaceCheck: streams have been closed");
        }
        catch (Exception ex) {
            System.err.println("DiskSpaceCheck: exception while attempting to close streams");
            ex.printStackTrace();
        }
    }

    static {
        input = null;
    }
}

