/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.dialogs;

import com.zerog.ia.download.utility.AppletResourceBundle;
import com.zerog.ia.download.utility.Gestalt;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;

public class ProgressBar
extends Canvas {
    int percentDone = 0;
    int fontHeight;
    long timerStarted = 0L;
    Image offscreenImage;
    Graphics offscreenGraphics;
    public static final String PERCENT_DONE = ".PercentDone";
    public static final String ABOUT_PREPEND = ".About.Prepend";
    public static final String ABOUT_POSTPEND = ".About.Postpend";
    public static final String ABOUT_A_MINUTE = ".AboutAMinute";
    public static final String LESS_A_MINUTE = ".AboutLessMinute";
    static Class class$com$zerog$ia$download$dialogs$ProgressBar;

    public ProgressBar() {
        this(300, 50);
    }

    public ProgressBar(int width, int height) {
        this.resize(width, height);
    }

    public void addNotify() {
        super.addNotify();
        this.fontHeight = this.getFontMetrics(this.getFont()).getHeight();
        this.offscreenImage = this.createImage(this.size().width, this.size().height);
        this.offscreenGraphics = this.offscreenImage.getGraphics();
        if (Gestalt.getVMVendor().equals(Gestalt.APPLE_VM)) {
            this.offscreenGraphics.setFont(new Font("SanSerif", 0, 10));
        } else {
            this.offscreenGraphics.setFont(new Font("Dialog", 0, 12));
        }
        this.offscreenGraphics.translate(2, 2);
        this.repaint();
    }

    public void paint(Graphics g) {
        g.drawImage(this.offscreenImage, 0, 0, this);
    }

    public void update(Graphics g) {
        Dimension sizeOfMe = this.size();
        Dimension sizeOfBar = this.size();
        sizeOfBar.height = (sizeOfMe.height >> 1) - 4;
        sizeOfBar.width = sizeOfMe.width - 4;
        String infoString = String.valueOf(String.valueOf(new StringBuffer("").append(this.percentDone).append("% ").append(AppletResourceBundle.getLocalizedString(this, PERCENT_DONE))));
        if (this.percentDone >= 10) {
            long timeSoFar = System.currentTimeMillis() - this.timerStarted;
            long secondsLeft = ((long)100 * timeSoFar / (long)this.percentDone - timeSoFar) / (long)1000;
            infoString = secondsLeft > (long)90 ? String.valueOf(String.valueOf(infoString)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" (").append(AppletResourceBundle.getLocalizedString(this, ABOUT_PREPEND)).append(" ").append((secondsLeft + (long)30) / (long)60).append(" ").append(AppletResourceBundle.getLocalizedString(this, ABOUT_POSTPEND)).append(")")))))) : (secondsLeft > (long)30 ? String.valueOf(String.valueOf(infoString)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" (").append(AppletResourceBundle.getLocalizedString(this, ABOUT_A_MINUTE)).append(")")))))) : String.valueOf(String.valueOf(infoString)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" (").append(AppletResourceBundle.getLocalizedString(this, LESS_A_MINUTE)).append(")")))))));
        }
        int progressPoint = this.percentDone * sizeOfBar.width / 100;
        this.offscreenGraphics.setColor(this.getBackground());
        this.offscreenGraphics.fillRect(-2, -2, sizeOfMe.width, sizeOfMe.height);
        this.offscreenGraphics.setColor(Color.black);
        this.offscreenGraphics.drawRect(0, 0, sizeOfMe.width - 5, sizeOfBar.height - 1);
        int divisions = 0;
        for (int i = 0; i <= divisions; ++i) {
            Color barColor = new Color(0, 0, 150);
            for (int j = i; j < divisions; ++j) {
                barColor = barColor.darker();
            }
            this.offscreenGraphics.setColor(barColor);
            this.offscreenGraphics.fillRect(i, i, progressPoint - i, sizeOfBar.height - 1 - i);
            float colorMagnitude = (float)i / (float)divisions;
            this.offscreenGraphics.setColor(new Color(colorMagnitude, colorMagnitude, colorMagnitude));
        }
        this.offscreenGraphics.setColor(Color.black);
        this.offscreenGraphics.drawString(infoString, 0, sizeOfBar.height + (this.fontHeight >> 1) + 5);
        this.paint(g);
    }

    public void setPercentDone(int _percentDone) {
        if (_percentDone == this.percentDone && _percentDone != 0) {
            return;
        }
        this.percentDone = _percentDone;
        if (this.percentDone < 0) {
            this.percentDone = 0;
        } else if (this.percentDone > 100) {
            this.percentDone = 100;
        }
        if (this.timerStarted == (long)0 && _percentDone > 0) {
            this.timerStarted = System.currentTimeMillis();
        }
        this.repaint();
    }

    public int getPercentDone() {
        return this.percentDone;
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        PERCENT_DONE = PERCENT_DONE;
        ABOUT_PREPEND = ABOUT_PREPEND;
        ABOUT_POSTPEND = ABOUT_POSTPEND;
        ABOUT_A_MINUTE = ABOUT_A_MINUTE;
        LESS_A_MINUTE = LESS_A_MINUTE;
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$dialogs$ProgressBar == null ? (class$com$zerog$ia$download$dialogs$ProgressBar = ProgressBar.class$("com.zerog.ia.download.dialogs.ProgressBar")) : class$com$zerog$ia$download$dialogs$ProgressBar, PERCENT_DONE, "done");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$dialogs$ProgressBar == null ? (class$com$zerog$ia$download$dialogs$ProgressBar = ProgressBar.class$("com.zerog.ia.download.dialogs.ProgressBar")) : class$com$zerog$ia$download$dialogs$ProgressBar, ABOUT_PREPEND, "About");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$dialogs$ProgressBar == null ? (class$com$zerog$ia$download$dialogs$ProgressBar = ProgressBar.class$("com.zerog.ia.download.dialogs.ProgressBar")) : class$com$zerog$ia$download$dialogs$ProgressBar, ABOUT_POSTPEND, "minutes remaining");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$dialogs$ProgressBar == null ? (class$com$zerog$ia$download$dialogs$ProgressBar = ProgressBar.class$("com.zerog.ia.download.dialogs.ProgressBar")) : class$com$zerog$ia$download$dialogs$ProgressBar, ABOUT_A_MINUTE, "About a minute remaining");
        AppletResourceBundle.setDefaultLocalizedString(class$com$zerog$ia$download$dialogs$ProgressBar == null ? (class$com$zerog$ia$download$dialogs$ProgressBar = ProgressBar.class$("com.zerog.ia.download.dialogs.ProgressBar")) : class$com$zerog$ia$download$dialogs$ProgressBar, LESS_A_MINUTE, "Less than a minute remaining");
    }
}

