/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.download.downloaders;

import com.zerog.ia.download.outputListeners.DownloadListener;
import com.zerog.ia.download.shared.DownloadContext;
import java.net.URL;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class FileDownloader
extends Thread
implements Observer {
    URL fileToDownload;
    DownloadContext context;
    boolean downloadCancelled = false;
    Vector downloadListenerList = new Vector(3, 1);

    public FileDownloader(DownloadContext _contextThisDownloadIsBeingRunIn) {
        this.context = _contextThisDownloadIsBeingRunIn;
    }

    public void start() {
        this.setPriority(1);
        super.start();
    }

    public void run() {
        super.run();
        try {
            this.downloadFileNow(this.fileToDownload);
        }
        catch (Exception e) {
            this.notifyErrorOccured(e);
        }
    }

    public void downloadFileNow(URL _fileToDownload) throws Exception {
    }

    public void setFileToDownload(URL _urlToDownloadFrom) {
        this.fileToDownload = _urlToDownloadFrom;
    }

    public boolean isDownloadCancelled() {
        return this.downloadCancelled;
    }

    public void cancelDownload() {
        this.downloadCancelled = true;
    }

    public void update(Observable obs, Object event) {
        this.notifyOutputDiagnosticMessage("FileDownloader:  Cancel download detected, setting downloadCancelled to true");
        this.downloadCancelled = true;
    }

    public void notifyDownloadStarted(String _filename) {
        Enumeration e = this.downloadListenerList.elements();
        while (e.hasMoreElements()) {
            ((DownloadListener)e.nextElement()).downloadStarted(_filename);
        }
    }

    public void notifyDownloadCompleted() {
        Enumeration e = this.downloadListenerList.elements();
        while (e.hasMoreElements()) {
            ((DownloadListener)e.nextElement()).downloadCompleted();
        }
        this.context.downloadStopped();
    }

    public void notifyDownloadCancelled() {
        Enumeration e = this.downloadListenerList.elements();
        while (e.hasMoreElements()) {
            DownloadListener dl = (DownloadListener)e.nextElement();
            dl.downloadCancelled();
        }
        this.context.downloadStopped();
    }

    public void notifySetFriendlyErrorMessage(String _msg) {
        this.getContext().notifySetFriendlyErrorMessage(_msg);
    }

    public void notifyOutputDiagnosticMessage(String _msg) {
        this.getContext().notifyOutputDiagnosticMessage(_msg);
    }

    public void notifyErrorOccured(Throwable _objectThrown) {
        Enumeration e = this.downloadListenerList.elements();
        while (e.hasMoreElements()) {
            DownloadListener dl = (DownloadListener)e.nextElement();
            dl.errorOccured();
            System.err.println("DownloadListener = ".concat(String.valueOf(String.valueOf(dl))));
        }
        this.context.downloadStopped();
        this.getContext().notifyErrorOccured(_objectThrown);
    }

    public void addDownloadListener(DownloadListener _dl) {
        this.downloadListenerList.addElement(_dl);
    }

    public void removeDownloadListener(DownloadListener _dl) {
        this.downloadListenerList.removeElement(_dl);
    }

    public Vector getDownloadListenerList() {
        return this.downloadListenerList;
    }

    public DownloadContext getContext() {
        return this.context;
    }
}

