#!/bin/bash
# living agents install script
# This script adjusts local settings within some installed files

dir="$(dirname $0)"
cd $dir/..
export PROJECT_HOME="$(pwd)"
echo "PROJECT_HOME is $PROJECT_HOME"

echo ""
more license.txt
echo ""
read -p "Enter 'y' to agree to the terms or 'n' to abort the installation: " -n 1
echo ""
echo ""

if [ "$REPLY" != "y" ]
then
	echo "Installation aborted."
	echo ""
	exit
fi

echo "--------------------------------------------------------------------"
echo "living agents(r) installation script"
echo "--------------------------------------------------------------------"

# replace <directory> <files> <old> <new>
# replaces string <old> by <new> in all <files> in <directory>
replace()
{
    echo "replacing '$3' thru '$4' in '$1/$2' ..."
    cd $PROJECT_HOME/$1
    #echo "directory $PROJECT_HOME/$1"
    for file in $2
    do
    	echo ".   processing file '$file' ..."
	[ ! -f ."$file".orig ] && mv "$file" ."$file".orig
	sed "s|$3|$4|g" ."$file".orig > "$file"
    done
}

mkdir log
mkdir log2

mv bin.Linux     bin
mv Toolbar.Linux Toolbar

replace 'Toolbar' '*' '/home/research/larsCE/_Source/livingagents' "$PROJECT_HOME"
replace 'bin' 'setEnvironment.sh' '/home/research/larsCE/_Source/livingagents' "$PROJECT_HOME"

echo ""
echo "living agents is installed."
echo "Now installing Java Runtime Environment."
read -p "Press Enter to continue. "
echo ""

cd $PROJECT_HOME
bin/j2re-1_3_1_01-linux-i386.bin

echo "done"

