/*
 * Copyright (c) 2001 living systems(R) AG, Germany. All rights reserved.
 * Original Author: Andreas Amann
 *
 * $Modtime:   06 Sep 2001 15:34:26  $
 */
 
/* objectFreight */
/* objectTruck */

package com.ls.demo.capabilities;

import java.util.Map;
import java.util.HashMap;
import java.util.Random;
import java.util.ArrayList;
import java.util.Iterator;
import com.ls.service.log.ILogger;

import com.ls.logiccontrol.capabilities.LogicCapabilities;
import com.ls.logiccontrol.LogicException;
import com.ls.logiccontrol.LogicConfigurationException;
import com.ls.TimeoutException;
import com.ls.logiccontrol.ILogicEngine;


import com.ls.lars.communication.*;

/**
 * Commerce
 *
 * @author  Last modified by $Author:   IKhazatzky  $
 * @version $Revision:   1.20  $
 *
 * @lsobject RFQ				# request for quote
 * @lsobject quote				# quote from supplier
 * @lsobject order				# order from buyer
 * @lsobject orderConfirmation
 * @lsobject invoice			# general invoice
 *
 */
public class Commerce extends LogicCapabilities implements Constants {
	
	/** The class name of this class used for the logging */
	private static final String CLASS_NAME 	= "Commerce";	

	/** 
     * Configuration of the Capabilities 
	 *
     * @param	configuration	The configuration of the Capabilities as a XMLFragment
	 * @throws	LogicConfigurationException If the Capabilities could not be configured
     */

    public void configure(Map configuration) throws LogicConfigurationException 
	{
		super.configure(configuration);
		
		if (configuration == null) {
			return;
		}
	}
	
	/********************** perceptions ****************************/

	/** 
     * Checks stock availability
     */
	
	public double perceptionStockAvailable(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{		
		String	METHOD_NAME = "perceptionStockAvailable";
		double returnValue = FALSE;
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "LogicEnvironment"+logicEnvironment);
		
		String	stock = (String) logicEnvironment.get(STOCK);
		if (stock != null)
		{
			int iStock = Integer.parseInt(stock);
			if (iStock > 0)
			{
				returnValue = TRUE;
				
			}else {
				returnValue = FALSE;
			}
		}else
		{
			iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "stock key is null");
		}
		
		iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue "+returnValue );
		iLogger.log("", ILogger.TRACE3, "", "");
		return returnValue;				
				
	}	// perceptionProductAvailable ------------------------------------
	
	/**
	 *	Checks if the order is confirmed.
	 */
	public double perceptionOrderConfirmed(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{		
		String	METHOD_NAME = "perceptionOrderConfirmed";
		double returnValue = FALSE;
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "LogicEnvironment"+logicEnvironment);
		String orderStatus = (String) logicEnvironment.get(ORDER_STATUS);
		if ((orderStatus != null) && (orderStatus.equals(CONFIRM) ) )
		{
			returnValue = TRUE;
		}
		iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue "+returnValue );
		iLogger.log("", ILogger.TRACE3, "", "");
		return returnValue;				
	}	// perceptionOrderConfirmed --------------------------------------

	/**
	 *	Returns a random value indicating how long ago the average stock.
	 */
	public double perceptionAverageStockUpToDate(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{		
		String	METHOD_NAME = "perceptionAverageStockUpToDate";
		double returnValue = FALSE;
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "LogicEnvironment"+logicEnvironment);
		
		Random randomTime = new Random();
		//returnValue = randomTime.nextDouble();
		if (randomTime.nextDouble() > 0.7) {
                    iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "I KNOW AVERAGE STOCK!!! LogicEnvironment"+logicEnvironment);
                    returnValue = TRUE; 
		}	
                iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue "+returnValue );
		iLogger.log("", ILogger.TRACE3, "", "");
                
                
		return returnValue;				
	}	
	
	/**
	 *	Checks, if the average amount of stock is known.
	*/
	public double perceptionKnowAverageStock(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{	
		String	METHOD_NAME = "perceptionKnowAverageStock";	
		double returnValue = FALSE;
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "LogicEnvironment"+logicEnvironment);
			
		String	StockStatus = (String) logicEnvironment.get(KNOW_AVERAGE_STOCK);
		if ((StockStatus != null) && (StockStatus.equals(YES)) ) 
		{
			returnValue = TRUE;
		}
		
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "returnValue "+returnValue );
		iLogger.log("", ILogger.TRACE3, "", "");
		return returnValue;				
		
	}	
	
	/**
	 *	Checks, if the average amount of stock is known.
	 */
	public double perceptionBelowAverageStock(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{	
		String	METHOD_NAME = "perceptionKnowAverageStock";	
		double returnValue = FALSE;
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "LogicEnvironment"+logicEnvironment);
		iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue "+returnValue );
		iLogger.log("", ILogger.TRACE3, "", "");
		return returnValue;				
	}	
	
	/**
	 *	Checks, if the average amount of stock is known.
	 */
	public double perceptionHaveAverageStock(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{	
		String	METHOD_NAME = "perceptionHaveAverageStock";	
		double returnValue = FALSE;
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "LogicEnvironment"+logicEnvironment);
		
		if ((String)logicEnvironment.get(AVERAGE_STOCK) == null) {
			logicEnvironment.put(AVERAGE_STOCK,""+logicEnvironment.get(STOCK));
		}
		if ((String)logicEnvironment.get(CONFIRMED_ORDERS) == null) {
			logicEnvironment.put(CONFIRMED_ORDERS,"0");
		}
		
		try {	
			if (logicEnvironment.containsKey(AVERAGE_STOCK) &&
				logicEnvironment.containsKey(STOCK) &&
				logicEnvironment.containsKey(CONFIRMED_ORDERS)) {
				int averagestock =  Integer.parseInt((String)logicEnvironment.get(AVERAGE_STOCK));
				int stock = Integer.parseInt((String)logicEnvironment.get(STOCK));//get own stock
				int confirmedOrders  =  Integer.parseInt((String)logicEnvironment.get(CONFIRMED_ORDERS)); 		
				int current_stock = confirmedOrders +  stock;
		
				if (current_stock  >= averagestock) {
					returnValue = TRUE;
				}else{
					returnValue = FALSE;
				}
			}
		}
		catch (NumberFormatException nfex) {
		}
				
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "returnValue "+returnValue );
		iLogger.log("", ILogger.TRACE3, "", "");
		return returnValue;				
		
	} 
	
	
	
	/********************** actions ****************************/
	
	/**
	 *	Delivers a product to a customer by reducing the internal stock by 1.
	*/
	public void actionDeliverProduct(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME 	= "actionDeliverProduct";	
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "logicEnvironment"+logicEnvironment);
		
		try {
			String stock = (String) logicEnvironment.get(STOCK);
			if (stock  != null) {
				int iStock = Integer.parseInt(stock);
				
				if (iStock > 0) {
					iStock--;
					logicEnvironment.put(STOCK, Integer.toString(iStock));					
					iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "My New Stock: " + iStock);
					sendStoreStockAmount(logicEnvironment);
                                }
				else {
					iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "stock amount is too less");
				}
			}
		}catch (NumberFormatException nfe) {
			iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "wrong format of the amount");
		}		
	}	
	
	/**
	 *	Creates an empty order object filled with random values.
	 */
	public void actionCreateOrder(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME 	= "actionCreateOrder";	
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "LogicEnvironment"+logicEnvironment);
		logicEnvironment.put("order", "1");
		
	}	

	/**
	 *	Performs a quality check and creates a quality check object.
	 */
	public void actionQualityCheck(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String	METHOD_NAME = "actionQualityCheck";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "LogicEnvironment"+logicEnvironment);

	}	

	/**
	 *	Build the average amount of stock.
	 */
	public void actionBuildAverageStock(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String	METHOD_NAME = "actionBuildAverageStock";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "LogicEnvironment"+logicEnvironment);
		logicEnvironment.put("averageStockStatus", "known");
		
	}	// actionBuildAverageStock ---------------------------------------
				
	/**
	 *	Select randomly one of the stores into the field "store".
	 */
	public void actionSelectStore(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME = "actionSelectStore";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "LogicEnvironment"+logicEnvironment);
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, ">>>>>>>> START <<<<<<<<");
		
		String 	noOfStore	= (String) logicEnvironment.get("noOfStores");
		if (noOfStore != null){
			int 	iNoOfStore 	= Integer.parseInt(noOfStore);
			Random	rnd			= new Random ();
			int		iSelected	= rnd.nextInt(iNoOfStore);
			iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "iNoOfStore        : " + iNoOfStore);
			iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "selected store no : " + iSelected);
			logicEnvironment.put(STORE, "AgentStore" + Integer.toString(iSelected) );
		}else {
			iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "noOfStores is null");
		}
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, ">>>>>>>> END <<<<<<<<");
	}	
	
	/**
	 *	Gets the Average Stock from the configured neighbors
	*/
	
	public void actionGetAverageStock(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME = "actionGetAverageStock";
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "LogicEnvironment"+logicEnvironment);
		HashMap neighbors = (HashMap)logicEnvironment.get(STORE_LIST);
		Iterator keyIterator = neighbors.keySet().iterator();
                while(keyIterator.hasNext()){		
                    String key = (String)keyIterator.next();
                    SingleMessage singleMessage = new SingleMessage("StockInquiry", key, null);
                    iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "Send message to "+key);
                    synchronized(iCommunication) {
                        iCommunication.sendMessage(singleMessage); 
                    }
                }
	}	
	
	/**
	 *	Place Order to Factory for stocks
	 */
	
	public void actionPlaceOrder(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		//places an order for stock to selected factory and wait for confirmation and respond accordingly
		//.. expecting in content of the reply message the status of the order
		String METHOD_NAME = "actionPlaceOrder";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "LogicEnvironment"+logicEnvironment);
		
		int stock 				= Integer.parseInt((String)logicEnvironment.get(STOCK));
		int confirmOrders 		= 0;
		boolean confirm 		= false; 
		ArrayList factoryList 	= (ArrayList)logicEnvironment.get("factoryList");
		confirmOrders 			= Integer.parseInt((String)logicEnvironment.get(CONFIRMED_ORDERS));
		Message message;
		if (logicEnvironment.get(CONFIRMED_ORDERS)== null) {
				logicEnvironment.put(CONFIRMED_ORDERS,"0");
		}
				for (int i=0;i<factoryList.size();i++) {
						message = new SingleMessage("order",(String)factoryList.get(i),"");
						message.setReplyWith(CLASS_NAME+System.currentTimeMillis());
						iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "ReplyMessage"+message);		
						try {
							Message replyMessage = iCommunication.sendSynchronousRequest(message,10000);
							if (replyMessage.getContent()!= null){
								iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "ReplyMessage"+replyMessage.getContent());				
								if (((String)replyMessage.getContent()).equals(CONFIRM)) {
									 confirm = true;
									 break;
								}
							}
						}catch(TimeoutException te) {}	
				}
			if (confirm) {
				confirmOrders++;
				logicEnvironment.put(CONFIRMED_ORDERS,""+confirmOrders);
                                /*Purely for the informing the viewer */ 
                                sendStoreStockAmount(logicEnvironment);
			}
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "LogicEnvironment"+logicEnvironment.get(ORDER_STATUS));
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "LogicEnvironment"+logicEnvironment.get(STOCK_TO_ACHIEVE));
	}	
	
	/**
	* Reset the environment  
	**/
	
	public void actionReset(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME = "actionReset";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "LogicEnvironment"+logicEnvironment);
		logicEnvironment.remove(KNOW_AVERAGE_STOCK);   // check by know stock status
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "");
	}
        
        /**
	* Return sum of actual stock and confirmed orders 
	**/
	
	public void actionGetSumAmount(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
            String action = "GetSumAmount";
            iLogger.log(CLASS_NAME, ILogger.TRACE4, action, "started");
            SingleMessage	message = (SingleMessage) logicEnvironment.get(ILogicEngine.REQUEST_MESSAGE_KEY);
            if ((message == null)) {
                    throw (new LogicException("Request message does exist. " +
                            "The logicEnvironment does not contain any message"));
            } 
            String sStock = (String)logicEnvironment.get(STOCK);
            String sOrders = (String)logicEnvironment.get(CONFIRMED_ORDERS);
            int sumStock = 0;
            if(sStock != null){
                sumStock = sumStock + Integer.parseInt(sStock);
            }
            if(sOrders != null){
                sumStock = sumStock + Integer.parseInt(sOrders);
            }
            
            SingleMessage singleMessage = new SingleMessage("StockInquiryResponse", message.getSender(), ""+sumStock);
            iLogger.log(CLASS_NAME, ILogger.TRACE4, action, "send StockInquiryResponse "+ singleMessage);
            synchronized(iCommunication) {
                iCommunication.sendMessage(singleMessage); 
            }
            
        }
        
        /**
	* Update average stock
	**/
	
	public void actionUpdateAverageStock(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
            String action = "actionUpdateAverageStock";
            iLogger.log(CLASS_NAME, ILogger.TRACE4, action, "started");
            SingleMessage	message = (SingleMessage) logicEnvironment.get(ILogicEngine.REQUEST_MESSAGE_KEY);
            if ((message == null)) {
                    throw (new LogicException("Request message does exist. " +
                            "The logicEnvironment does not contain any message"));
            } 
            String sender = message.getSender();
            String content = (String) message.getContent();
            iLogger.log(CLASS_NAME, ILogger.TRACE4, action, "Sender "+sender);
            if(content != null){
                HashMap neighbours = (HashMap)logicEnvironment.get(STORE_LIST);
                synchronized (neighbours){
                    neighbours.put(sender.substring(0,sender.indexOf('@')),content);
                    int averageStock = calculateAverageStock(logicEnvironment);
                    iLogger.log(CLASS_NAME, ILogger.TRACE4, action, "new average stock calculated "+averageStock);
                    String oldAverageStock = (String)logicEnvironment.get(AVERAGE_STOCK);
                    iLogger.log(CLASS_NAME, ILogger.TRACE4, action, "old average stock "+oldAverageStock);
                    if(!(""+averageStock).equals(oldAverageStock)){
                        logicEnvironment.put(AVERAGE_STOCK,""+averageStock);
                        sendStoreStockAmount(logicEnvironment);
                    }
                }
            }    
        }    
	
	
	public void actionUpdateStatus(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME = "actionUpdateStatus";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "LogicEnvironment"+logicEnvironment);
		// here we should increment the environment variable 'stock' and compare it against
		// the average stock variable and corresponding set the 'AVERAGE_STOCK' to above or
		//below average
		int diff = Integer.parseInt((String)logicEnvironment.get(STOCK_TO_ACHIEVE));
		
		if (diff < 1 ) {
			logicEnvironment.put(STOCK_STATUS,ABOVE_AVERAGE);	
			logicEnvironment.put(AVERAGE_STOCK,YES);	
		}else{
			logicEnvironment.put(STOCK_STATUS,BELOW_AVERAGE);	
		}
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "Stock Status"+logicEnvironment.get(STOCK_STATUS));				
	}
	
	
	// helper methods for Capabilities to calculate Average Stock
	
	private int calculateAverageStock(Map logicEnvironment)
	{
		String 	METHOD_NAME = "calculateAverageStock";
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "LogicEnvironment"+logicEnvironment);
		HashMap neighbours = (HashMap)logicEnvironment.get(STORE_LIST);
		Object replyToObject; 		 
		int stock = Integer.parseInt((String)logicEnvironment.get(STOCK));//get own stock
		int confirmedOrders = 0;
		int noOfResponses = 1;
		int averageStock = 0;
		int newStock = 0;
		Message message;
		if (logicEnvironment.get(CONFIRMED_ORDERS) != null) {
			confirmedOrders = Integer.parseInt((String)logicEnvironment.get(CONFIRMED_ORDERS));							
		}
		newStock = stock + confirmedOrders;
		synchronized(neighbours){
                    Iterator keyIterator = neighbours.keySet().iterator();
                    while(keyIterator.hasNext()){		
                        String key = (String)keyIterator.next();
                        if(neighbours.get(key) != null){
                            newStock = newStock + Integer.parseInt((String)neighbours.get(key));
                            noOfResponses++;
                        }
                    }
                }
		averageStock = Math.round(((float)newStock)/noOfResponses);
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "<----MY STOCK---->"+logicEnvironment.get(STOCK));		
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "<----AVERAGE STOCK---->"+averageStock);		
		return averageStock ;
	}
        protected void sendStoreStockAmount(Map logicEnvironment){
            HashMap sendMap = new HashMap();
            String stock = null;
            if(logicEnvironment.get(STOCK) != null){
                stock = (String) logicEnvironment.get(STOCK);
                
            } else {
                stock = "0";
            }    
            sendMap.put("productAmount",logicEnvironment.get(STOCK));
 
            if(logicEnvironment.get(AVERAGE_STOCK) != null){
                sendMap.put("averageAmount", ""+logicEnvironment.get(AVERAGE_STOCK));
            } else{
                sendMap.put("averageAmount",  stock);
            }
            
            if(logicEnvironment.get(CONFIRMED_ORDERS) != null){
                sendMap.put("productOrdered",""+logicEnvironment.get(CONFIRMED_ORDERS));
            } else {
                sendMap.put("productOrdered","0");
            }    
            
            SingleMessage singleMessage = new SingleMessage(SUBJECT_STORE_STOCK_AMOUNT, AGENT_USER_INTERFACE,  sendMap);
            synchronized(iCommunication) {
                iCommunication.sendMessage(singleMessage); 
            }
        }
}	
