/*
 * Copyright (c) 2001 living systems(R) AG, Germany. All rights reserved.
 * Original Author: Andreas Amann
 *
 * $Modtime:   06 Sep 2001 09:54:06  $
 */
 

package com.ls.demo.capabilities;

import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.HashSet;
import java.util.Set;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Random;

import com.ls.service.log.ILogger;
import com.ls.TimeoutException;
import com.ls.logiccontrol.capabilities.LogicCapabilities;
import com.ls.logiccontrol.LogicException;
import com.ls.logiccontrol.ILogicEngine;
import com.ls.logiccontrol.LogicConfigurationException;



import com.ls.lars.communication.*;


/**
 * Logistics
 *
 * @author  Last modified by $Author:   IKhazatzky  $
 * @version $Revision:   1.18  $
 *
 * @lsobject freight
 */
public class Logistics extends LogicCapabilities implements Constants {
	
	/** The class name of this class used for the logging */
	private static final String CLASS_NAME 	= "Logistic";	

	
	/** 
     * Configuration of the Capabilities 
	 *
     * @param	configuration	The configuration of the Capabilities as a XMLFragment
	 * @throws	LogicConfigurationException If the Capabilities could not be configured
     */

    public void  configure(Map configuration) throws LogicConfigurationException 
	{
		super.configure(configuration);
		
		if (configuration == null) {
			return;
		}
	}
	
	/********************** actions ****************************/
	
	/**
	 *	Creates a new Freight object and stores it in the freight list.
	 *
	 */
	public void  actionCreateFreight(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME 	= "actionCreateFreight";	
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "logicEnvironment"+logicEnvironment);
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, ">>>>>>>>>>> CREATE FREIGHT START <<<<<<<<<<<<");
		
		
		// get the freight list ------------------------------------------
		HashMap mapFreightlist = (HashMap) logicEnvironment.get(FREIGHT_LIST);
		// create new freight 		
		HashMap newFreight = new HashMap();
		newFreight.put (STORE, "unassigned");
		newFreight.put (TRUCK, "unassigned");
		int intialStock = Integer.parseInt((String)logicEnvironment.get(STOCK));
		if (null == mapFreightlist) {
		// if the list is not yet existing,creating one from the initial stock set in the configuration
			mapFreightlist= new HashMap();
			for (int i=0;i<intialStock;i++){
				mapFreightlist.put(""+(i+1),newFreight.clone());
			}	
			logicEnvironment.put(FREIGHT_LIST, mapFreightlist);
			logicEnvironment.put("lastCreatedFreightNo", ""+intialStock);
			iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME,""+mapFreightlist);
		}
		
		String 	strLastNo = (String) logicEnvironment.get("lastCreatedFreightNo");
		int 	newFreigthNo = Integer.parseInt(strLastNo);
		newFreigthNo++;
		String	newUnitNo = (String) Integer.toString(newFreigthNo);
		logicEnvironment.put("lastCreatedFreightNo", newUnitNo);
		// add the freight to the freight list !!!
		mapFreightlist.put(newUnitNo, newFreight);
		

		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "created freightNo : " + newUnitNo);
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "newFreight        : " + newFreight);
		
		// increase the stock amount !!!!
		String amout = (String) logicEnvironment.get(STOCK);
		int iAmount = Integer.parseInt(amout);
		iAmount++;
		logicEnvironment.put(STOCK, Integer.toString(iAmount) );

		statusReport(logicEnvironment);
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "new amount : " + iAmount);
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, ">>>>>>>>>>> CREATE FREIGHT END <<<<<<<<<<<<");
	}	
	
	/**
	 *	Removes the current freight from the freight list.
	 */
	public void  actionDeleteFreight(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME 	= "actionDeleteFreight";	
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "logicEnvironment"+logicEnvironment);
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, ">>>>>>>>>>> DELETE FREIGHT START <<<<<<<<<<<<");
		String	deleteNo = (String) logicEnvironment.get("freightNo");
		
		HashMap mapFreightlist = (HashMap) logicEnvironment.get(FREIGHT_LIST);
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "deleted freightNo : " + deleteNo);
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "FreightList : " + mapFreightlist);
		
		if ((mapFreightlist != null) && (deleteNo != null) && !(deleteNo.equals("-1"))) {
			// remove the freight from the freight list
					HashMap freight = (HashMap)mapFreightlist.get(deleteNo);
					iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "Freight: " + freight);
					mapFreightlist.remove(deleteNo);
					// delete the amount 
					String 	amout 	= (String) logicEnvironment.get(STOCK);
					int 	iAmount = Integer.parseInt(amout);
					
					if (iAmount > 0) iAmount--;
					logicEnvironment.put(STOCK, Integer.toString(iAmount) );
			
					iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "new amount : " + iAmount);
					statusReport(logicEnvironment);
			
		}else {
			iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "can't delete => no freight list created");
		}
		
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, ">>>>>>>>>>> DELETE FREIGHT END <<<<<<<<<<<<");
	}	

	/**
	 *	Loads  the  Assigned Freight To Truck
	 */
	public void  actionLoadFreight(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME 	= "actionLoadFreight";	
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "logicEnvironment"+logicEnvironment);
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, ">>>>>>>>>>> LOAD FREIGHT START <<<<<<<<<<<<");
		String	freightNo; 
		//message from the truck of his arrival
		SingleMessage	message = (SingleMessage) logicEnvironment.get(ILogicEngine.REQUEST_MESSAGE_KEY);
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME,"Msg-Content : "+message.getContent());	
		freightNo  = (String)message.getContent();	
		HashMap mapFreightlist = (HashMap) logicEnvironment.get(FREIGHT_LIST);
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "deleted freightNo : " + freightNo);
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "FreightList : " + mapFreightlist);
				if ((mapFreightlist != null) && (freightNo != null)){
					// remove the freight from the freight list
					HashMap freight = (HashMap)mapFreightlist.get(freightNo);
					iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "Freight: " + freight);
					String storeName = (String)freight.get(STORE);
					logicEnvironment.put(STORE,storeName);
					mapFreightlist.remove(freightNo);
					// delete the amount 
					iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "Store to go : " + storeName);
					String 	stock 	= (String) logicEnvironment.get(STOCK);
					int 	iStock = Integer.parseInt(stock);
					if (iStock > 0) iStock--;
					logicEnvironment.put(STOCK, Integer.toString(iStock) );
					iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "new amount : " + iStock);
					statusReport(logicEnvironment);
				}
				else		
				{
					iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "can't load => Freight Not Specified");
				}
		
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, ">>>>>>>>>>> LOAD FREIGHT END <<<<<<<<<<<<");
	}

	
	/**
	 *	Books the incoming freight by incrementing the internal stock by 1.
	 *	Deletes the store in the freight because it has arrived at the store.
	 *  The freight is free to be sold from now on.
	 */
	public void  actionBookFreight(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME 	= "actionBookFreight";	
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "logicEnvironment"+logicEnvironment);

		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, ">>>>>>>>>>> START <<<<<<<<<<<<");
		
			// increase the stock amount !!!!
			String 	stock   	= (String) logicEnvironment.get(STOCK);
			int    confOrders 	=  Integer.parseInt((String)logicEnvironment.get(CONFIRMED_ORDERS));
			int 	iStock= Integer.parseInt(stock);
			iStock++;
			confOrders--;
			logicEnvironment.put(STOCK, Integer.toString(iStock) );
			logicEnvironment.put(CONFIRMED_ORDERS, Integer.toString(confOrders));
			iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "new amount : " + iStock);
			HashMap TestMap = new HashMap();
			TestMap.put("productAmount",   Integer.toString(iStock) );
			TestMap.put("averageAmount", ""+logicEnvironment.get(AVERAGE_STOCK));
			TestMap.put("productOrdered", ""+logicEnvironment.get(CONFIRMED_ORDERS));
			iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "Content : " + TestMap);
			SingleMessage singleMessage = new SingleMessage(SUBJECT_STORE_STOCK_AMOUNT, AGENT_USER_INTERFACE,TestMap );
			iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "Message : " + singleMessage);
			synchronized(iCommunication) {
				iCommunication.sendMessage(singleMessage);
			}
			iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, ">>>>>>>>>>> END <<<<<<<<<<<<");
	}	// actionBookFreight ---------------------------------------------
	
	/**
	 *	Reserves one of the free freights for the requesting store.
	 */
	public void  actionAssignFreight2Store(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME 	= "actionAssignFreight2Store";	
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "logicEnvironment"+logicEnvironment);

		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, ">>>>>>>>>>> START <<<<<<<<<<<<");

		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "logicEnvironment : " + logicEnvironment.toString() );
		// get the store which want something
		String 	store = null;
		SingleMessage	message = (SingleMessage) logicEnvironment.get(ILogicEngine.REQUEST_MESSAGE_KEY);
		store = message.getSender();
		store = store.substring(0,store.indexOf("@"));//to place only AgentStoreXd
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "store to assign : " + store );
		logicEnvironment.put(STATUS,REJECT);
		// get the freight list
		HashMap mapFreight = (HashMap) logicEnvironment.get(FREIGHT_LIST);
		if (mapFreight == null ) 
		{
			iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "can't book freight => freight list is null");
			return;
		}
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "freightList : " + mapFreight.toString() );
		
		// get an iteration of the key in the freight list (iteration of freights)
		

			Iterator it = mapFreight.keySet().iterator();
			while (it.hasNext()) 
			{
				String	freightNo 	   = (String) it.next();
				HashMap freight 	   = (HashMap) mapFreight.get(freightNo);
				//iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "freight : " + freight.toString() );
		
				String 	strStoreAssign = (String) freight.get(STORE);
				
				// searching for an unassigned store 
				if (strStoreAssign.equals("unassigned"))
				{
					// set the store no to the freight 
					logicEnvironment.put(STATUS,CONFIRM);
					freight.put(STORE, store);
					iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "set store to freight no. :" + freightNo );		
					break;
				}
			}		
		statusReport(logicEnvironment);					
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "MapFreightList"+mapFreight);
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, ">>>>>>>>>>> END <<<<<<<<<<<<");
	}	// actionAssignFreight2Store -------------------------------------
	
	/**
	 *	Reserves one of ordered freights (by a store) for the requesting truck.
	 */
	public void   actionAssignFreight2Truck(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME 	= "actionAssignFreight2Truck";	
		String 	truck 	 	= null;
		String	freightNo = null;
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "logicEnvironment"+logicEnvironment);
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, ">>>>>>>>>>> START <<<<<<<<<<<<");

		// get the truck no which want the freight
		
		SingleMessage	message = (SingleMessage) logicEnvironment.get(ILogicEngine.REQUEST_MESSAGE_KEY);
		truck 	= message.getSender();
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "truck to assign : " + truck);
		
		// get the freight list
		HashMap mapFreight = (HashMap) logicEnvironment.get(FREIGHT_LIST);
		if (mapFreight == null ) {
			iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "can't book freight => freight list is null");
			return;
		}
		
		boolean	validfreight = false;
		// get an freight list iterator
		
			Iterator it = mapFreight.keySet().iterator();
			while (it.hasNext())
			{
				freightNo 	   		   = (String) it.next();
				HashMap freight 	   = (HashMap) mapFreight.get(freightNo);
				iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "freight : " + freight.toString() );
				
				
				String 	strStoreAssign = (String) freight.get(STORE);
				String 	strTruckAssign = (String) freight.get(TRUCK);
		
				// only search for trucks which are already assigned to stores
				if (!strStoreAssign.equals("unassigned") )
				{
					// searching for an unassigned truck
					if (strTruckAssign.equals("unassigned") )
					{
						// mark the freight as book for the specfifc truck
							freight.remove(TRUCK);
							freight.put(TRUCK, truck);
						
						iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "set truck to freight no. :" + freightNo );
						iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "mapFreight :" + mapFreight );
						validfreight = true;
						break;
					}
				}
			}		
		
		if (validfreight == true) {
			
			/* Place the destination  into env to be send to truck here */
			HashMap freightAssigned = new HashMap();
			freightAssigned.put("nodeID",(String)logicEnvironment.get("initialPosition"));
			freightAssigned.put("freightNoForTruck",""+freightNo);
			logicEnvironment.remove("destination");
			logicEnvironment.put("destination",freightAssigned);
		}else{
			iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
		}
		/* Status Report to Viewer */
		statusReport(logicEnvironment);
		/* Status Report to Viewer */
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "Env"+logicEnvironment);
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, ">>>>>>>>>>> END <<<<<<<<<<<<");
	}	// actionAssignFreight2Truck -------------------------------------
	
	/**
	 *	Selects on of the freights of the freight list (randomly).
	 *  This simulates the selection of the negative tested product.
	 */
	public void  actionSelectFreight(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME 	= "actionSelectFreight";	
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "logicEnvironment"+logicEnvironment);
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, ">>>>>>>>>>> SELECT FREIGHT START <<<<<<<<<<<<");

		// get the freight list
		HashMap mapFreight = (HashMap) logicEnvironment.get(FREIGHT_LIST);//not a thread safe object
		
		if (mapFreight != null)
		{
			int	noOfElements = mapFreight.size();
			
			Random rnd = new Random();
			int	freightIndex = rnd.nextInt(noOfElements);
			// get an iteration of the key in the freight list (iteration of freights)
			
			int		iCounter = 0;
			String	freightToSet = "-1";
					
				Iterator it = mapFreight.keySet().iterator();
				while (it.hasNext()) 
				{
					String freightNo = (String) it.next();
					
					if ((((String)((HashMap)mapFreight.get(freightNo)).get(TRUCK)).equals("unassigned")) && 
					    (((String)((HashMap)mapFreight.get(freightNo)).get(STORE)).equals("unassigned"))) 
					{
						freightToSet = freightNo;
						break;
					}
				}		
			logicEnvironment.put("freightNo", freightToSet);
			iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "selected freight no. :" + freightToSet);
		}
		else
		{
			iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "can't select freight => no freight list created");
		}
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, ">>>>>>>>>>> SELECT FREIGHT END <<<<<<<<<<<<");
	}	
	
	/**
	 *	Select one of the existing factories into the field "factory".
	 */
	public void  actionSelectFactory(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME 	= "actionSelectFactory";	
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "logicEnvironment"+logicEnvironment);
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, ">>>>>>>>>>> SELECT FACTORY START <<<<<<<<<<<<");

		String 	noOfFactories 	= (String) logicEnvironment.get("noOfFactories");
		if (noOfFactories != null) 
		{
			int 	iNoOfFactory	= Integer.parseInt(noOfFactories);
			Random	rnd				= new Random ();
			int		iSelected		= rnd.nextInt(iNoOfFactory);
			
			iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "iNoOfFactory        : " + iNoOfFactory);
			iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "selected factory no : " + iSelected);
			String	strReceiver = "AgentFactory" + Integer.toString(iSelected);
		
			iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "set receiver : " + strReceiver);
			
			logicEnvironment.put("factory", strReceiver);
		}
		else
		{
			iLogger.log(CLASS_NAME, ILogger.ERROR, METHOD_NAME, "noOfFactories is null");
		}
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, ">>>>>>>>>>> SELECT FACTORY END <<<<<<<<<<<<");
	}	// actionSelectFactory -------------------------------------------
	
	/**
	 *	Sorts the factory list by increasing distance relative to the current location.
	 */
	public void  actionGetSortFactories(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME 	= "actionGetSortFactories";	
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "logicEnvironment"+logicEnvironment);
		HashMap content = new HashMap();
		content.put("currentNodeID",(String)logicEnvironment.get(SUBJECT_INITIAL_POSITION));
		if (logicEnvironment.get("factoryList") == null) {
			Message message;
			message = new SingleMessage(SUBJECT_GET_FACTORY_LIST,AGENT_INFO,content);
			message.setReplyWith(CLASS_NAME+System.currentTimeMillis());
			try {
				Message replyMessage = iCommunication.sendSynchronousRequest(message,10000);
				iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "Reply Message"+replyMessage);
				if (replyMessage.getContent()!= null){
									logicEnvironment.put("factoryList",replyMessage.getContent());
				}
			}catch(TimeoutException te) {}	
		}
		
	}	// actionSortFactories -------------------------------------------
	
	/**
	 *	Retrieves the neighbors of each STORE
	**/
	public void  actionGetNeighborStores(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME 	= "actionGetNeighborStores";	
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "logicEnvironment"+logicEnvironment);
		HashMap content = new HashMap();
		content.put("currentNodeID",(String)logicEnvironment.get(SUBJECT_INITIAL_POSITION));
		if (logicEnvironment.get(STORE_LIST) == null) {
			Message message;
			message = new SingleMessage(SUBJECT_GET_STORE_LIST,AGENT_INFO,content);
			message.setReplyWith(CLASS_NAME+System.currentTimeMillis());
			try {
				Message replyMessage = iCommunication.sendSynchronousRequest(message,10000);
				iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "Reply Message"+replyMessage);
				iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "Reply Message"+replyMessage.getContent());
				if (replyMessage.getContent()!= null){
                                    logicEnvironment.put(STORE_LIST,replyMessage.getContent());
				}
			}catch(TimeoutException te) {}	
		}
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "Neighbors-->"+logicEnvironment.get(STORE_LIST));
	}
	/**
	 *	Sorts the node list by increasing distance relative to the current location.
	 */
	public void  actionSortNodes(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME 	= "actionSortNodes";	
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "logicEnvironment"+logicEnvironment);

		// under construction
		
	}	// actionSortNodes -----------------------------------------------
	
	/**
	 *	Drive to the next node.
	 */
	public void  actionDrive(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME 	= "actionDrive";	
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "logicEnvironment"+logicEnvironment);

		// under construction
		
	}	// actionDrive ---------------------------------------------------
	
	/**
	 *	
	 */
	public void  actionSavePosition(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME 	= "actionSavePosition";	
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "logicEnvironment"+logicEnvironment);
		
		// under construction
		
	}	// actionSavePosition --------------------------------------------
	
	
	/********************** perceptions ****************************/
	
	/**
	 *	Calculates the current driving speed and returns a linear value between 0 (for traffic jam) and 1 (for 150 m/h)
	 */
	public double perceptionFastDriving(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{		
		String	METHOD_NAME = "perceptionFastDriving";
		double returnValue = FALSE;
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "logicEnvironment"+logicEnvironment);
		
		String	speed 	= (String) logicEnvironment.get("speed");
		int 	iSpeed 	= Integer.parseInt(speed);
		
		double dValue = ( (double)iSpeed / 150.0);

		returnValue = dValue;
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "returnValue"+returnValue);
		return returnValue;
	}	// perceptionFastDriving -----------------------------------------
	
	/**
	 *	Returns TRUE if there is unassigned freight to be transported and also sets the .
	 */
	public double perceptionUnassignedFreight(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{		
		String	METHOD_NAME = "perceptionUnassignedFreight";
		double returnValue = FALSE;
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "logicEnvironment"+logicEnvironment);
		
		HashMap freightAssigned = new HashMap();
		freightAssigned.put("nodeID",(String)logicEnvironment.get("initialPosition"));
		freightAssigned.put("freightNoForTruck","-1");
		logicEnvironment.remove("destination");
		logicEnvironment.put("destination",freightAssigned);

		// get the freight list
		HashMap mapFreightlist = (HashMap) logicEnvironment.get(FREIGHT_LIST);
		// get an iteration of the key in the freight list (iteration of freights)
		if (mapFreightlist != null) {		
			Iterator it = mapFreightlist.keySet().iterator();
			while (it.hasNext()) {
				String	freightNo 	   = (String) it.next();
				HashMap freight 	   = (HashMap) mapFreightlist.get(freightNo);
				String 	strStoreAssign = (String) freight.get(STORE);
				String 	strTruckAssign = (String) freight.get(TRUCK);
				
				// searching for an unassigned store and truck
				if (!strStoreAssign.equals("unassigned")&& strTruckAssign.equals("unassigned")) 	{
					// there is at least one unassigned freight
					iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "found at least one unassigned freight !");
					returnValue = TRUE;
				}
			}
		}
		iLogger.log(CLASS_NAME, ILogger.TRACE2, METHOD_NAME, "returnValue"+returnValue);
		return returnValue ;
	}	// perceptionUnassignedFreight -----------------------------------

	/// helper method for the viewer 
	
	private void  statusReport(Map logicEnvironment) {
		String METHOD_NAME = "statusReport";
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "logicEnvironment"+logicEnvironment);
		int stock;
		int noOfAssignedTrucks =0; 
		int noOfAssignedStores =0;
		HashMap mapFreightlist = (HashMap) logicEnvironment.get(FREIGHT_LIST);
		
		if (mapFreightlist != null) {
			stock = mapFreightlist.size();
			Iterator it = mapFreightlist.keySet().iterator();
		
			while (it.hasNext()) 
			{
				String freightNo = (String) it.next();
				if (!((String)((HashMap)mapFreightlist.get(freightNo)).get(TRUCK)).equals("unassigned") ) {
					noOfAssignedTrucks++;
				}
				if (!((String)((HashMap)mapFreightlist.get(freightNo)).get(STORE)).equals("unassigned") ) {
					noOfAssignedStores++;
				}
			}						
		}else {
				stock = 0;
		}	
		/* Purely for viewer */
					HashMap sendMap = new HashMap();
					sendMap.put("productAmount",""+stock);
					sendMap.put("productAssignedToStore", ""+noOfAssignedStores);
					sendMap.put("productAssignedToTruck",""+noOfAssignedTrucks);
					iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "Status"+sendMap);
					SingleMessage singleMessage = new SingleMessage(SUBJECT_STORE_FACTORY_AMOUNT, AGENT_USER_INTERFACE,  sendMap);
					synchronized(iCommunication) {
						iCommunication.sendMessage(singleMessage);
					}
		/* Purely for viewer */
					
	}	
}	// closing class bracket ---------------------------------------------

