/*
 * Copyright (c) 2001 living systems(R) AG, Germany. All rights reserved.
 * Original Author: Christoph Kluge
 *
 * $Modtime:   Jul 02 2001 11:36:30  $
 */

package com.ls.demo.capabilities;

import java.util.Map;
import java.util.List;
import java.util.HashMap;
import java.util.Iterator;

import com.ls.service.log.ILogger;

import com.ls.logiccontrol.capabilities.LogicCapabilities;
import com.ls.logiccontrol.LogicException;
import com.ls.logiccontrol.LogicConfigurationException;

import	com.ls.util.xml.XMLFragment;

import	java.awt.Dimension;
import	java.awt.Toolkit;
import	java.awt.Frame;
import	java.awt.Point;
import	javax.swing.JFrame;
import	javax.swing.JOptionPane;


/**
 * The gui capabilities is able to popup message or confirm boxes.
 * @lsobject coffee
 *
 * @author  Last modified by $Author:   CKluge  $
 * @version $Revision:   1.6  $
 */
public class Swing extends LogicCapabilities {
	/** The name of the class used for the logging */
	public static final String CLASS_NAME 	= "Swing";	

	private static		boolean		dialogShownOnce = false;

	/** 
     * Basic empty Constructor 
     */
    public Swing()
	{
		
	}


	/** 
     * Configuration of the capabilities which allows to setup the look&feel of the message box.
	 *
     * @param configuration The configuration of the capabilities (usually a XMLFragment)
	 * @throws LogicConfigurationException If the capabilities could not be configured
     */

    public void configure(Map configuration) throws LogicConfigurationException 
	{
		super.configure(configuration);
		
		if (configuration == null) {
			return;
		}

		Iterator configurationIterator = ((XMLFragment)configuration).getChildren().iterator();

		while (configurationIterator.hasNext()) {
			XMLFragment configurationTag=(XMLFragment)configurationIterator.next();
			String tagName = configurationTag.getRootName();
		}
	}


	/**
	 * PopsUp a message box with the message passed in the "message" argument of 
	 * the action tag. 2001-10-09
	 *
	 *	@lsparam message
	 *
	 * @param	logicEnvironment 			The environment in which the action takes place or on which 
	 										the condition / perception is based.
	 * @throws	IllegalArgumentException	If an argument was missing which is needed by this action
	 * @throws	LogicException				If message box could not be displayed
	 */    	
	public void actionShowMessageDialog(Map logicEnvironment) 
    	throws LogicException, IllegalArgumentException
	{
		boolean ok = true;		

		Object messageObject = logicEnvironment.get("message");
		if (messageObject != null) {
		 	if((messageObject  instanceof String) && (logicEnvironment.containsKey(messageObject ))) {
				messageObject  = logicEnvironment.get(messageObject );
			}
		} else {		
			messageObject = new String("Default Message");
		}

		JFrame parent = getWorkaroundFrame();
		JOptionPane.showMessageDialog(parent, messageObject.toString(), "MessageDialog", JOptionPane.INFORMATION_MESSAGE);
		parent.hide();
	}


	/**
	 * Performs the condition and returns with a truthvalue which tells how true 
	 * the condition is. The default implementation does nothing.
	 *
	 *	@lsparam message
	 *
	 *
	 * @param	logicEnvironment 			The environment in which the action takes place or on which 
	 * 										the condition / perception is based.
	 * @return	The truth value of the perception
	 * @throws	IllegalArgumentException	If an argument was missing which is needed by this perception
	 * @throws	LogicException				If no descission could be made based on the validation
	 */    	
	
	public double perceptionShowConfirmDialog(Map logicEnvironment)
    	throws LogicException, IllegalArgumentException
	{
		double ok=FALSE;

		Object messageObject = logicEnvironment.get("message");
		if (messageObject != null) {
		 	if((messageObject  instanceof String) && (logicEnvironment.containsKey(messageObject ))) {
				messageObject  = logicEnvironment.get(messageObject );
			}
		} else {		
			messageObject = new String("Default Message");
		}
			
		JFrame parent = getWorkaroundFrame();
		int result = JOptionPane.showConfirmDialog(parent, messageObject.toString(), "ConfirmDialog", JOptionPane.YES_NO_OPTION);
		parent.hide();

		if(result == JOptionPane.YES_OPTION) {
			ok=TRUE;
		}

		return(ok);
	}

	/**
	 * Creates a frame in iconified mode and then pops it to the middle of the screen.
	 * Introduced to work around a bug in Win2000 that does not allow toFront() and therefore
	 * the JOptionPane was displayed behind other windows.
	 * @return An empty visible parent frame to be used for JOptionPane as parent
	 */
	private static JFrame getWorkaroundFrame()
	{
		JFrame	frame = new JFrame("Frame");
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		frame.setLocation(new Point(screenSize.width / 2, screenSize.height / 2));
		// this is a workaround for a bug in Win2000 that the window will be behind others
		// uncomment the following lines if the iconified behavior should only be done the
		// first time. That would be enough since the problem with Win2000 only occures
		// when displaying the dialog the first time.
//		if (!dialogShownOnce) {
			frame.setState(Frame.ICONIFIED); 
			frame.show();
			frame.setState(Frame.NORMAL);
//			dialogShownOnce = true;
//		} else {
//			frame.show();
//		}
		return frame;
	}
}
