/*
 * Copyright (c) 2001 living systems(R) AG, Germany. All rights reserved.
 * Original Author: Christoph Kluge
 *
 * $Modtime:   29 Aug 2001 17:57:20  $
 */
 

package com.ls.demo.capabilities;

import java.util.Map;
import java.util.Random;
import java.util.List;
import java.util.HashMap;
import java.util.Iterator;
import com.ls.logiccontrol.ILogicEngine;
import com.ls.service.log.ILogger;
import com.ls.lars.communication.*;
import com.ls.TimeoutException;
import com.ls.logiccontrol.capabilities.LogicCapabilities;
import com.ls.logiccontrol.LogicException;


/**
 * Basics
 *
 * @author  Last modified by $Author:   IKhazatzky  $
 * @version $Revision:   1.18  $
 *
 * @lsobject user	# user of the system
 *
 */
public class Basics extends LogicCapabilities implements Constants {
	
	/** The class name of this class used for the logging */
	private static final String CLASS_NAME 	= "Basics";	
	public static final String REPLY_STRING	= "_REPLY";	

	/********************** actions ****************************/

	/**
	*	Sets intial Configuration of the Environment
	*
	*/
	public void actionSetConfiguration(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME = "actionSetConfiguration";		
		
		HashMap configMap; 
		
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "logicEnvironment"+logicEnvironment);
		
		configMap  = (HashMap)logicEnvironment.get("configHash");
		if (configMap == null) {
			iLogger.log(CLASS_NAME, ILogger.INFO, "actionSetConfiguration", "Configuration is null");					
			configMap = new HashMap();
		}
		else
		{
			iLogger.log(CLASS_NAME, ILogger.INFO, "actionSetConfiguration", configMap.toString());		
		}
		Iterator it = configMap.keySet().iterator();
		
		while (it.hasNext()) 
		{
			String	key 	= (String) it.next();
			Object	value 	= (Object) configMap.get(key);
			
			iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "add to logicEnvironment key ["+key+"] value [" + value + "]");
			logicEnvironment.put(key, value);
		}
		logicEnvironment.put(CONDITION,STR_TRUE);
	}	// actionSetConfiguration ----------------------------------------
	
	/**
	*	Sends a message with the "service" accompanied by the "object" to the "receiver".
	*	@lsparam service
	*	@lsparam receiver
	*	@lsparam object
	*/
	public void actionSend(Map logicEnvironment) 
    	throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME = "actionSend";		
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "logicEnvironment"+logicEnvironment);
		
		String service	= (String)logicEnvironment.get("service");
		iLogger.log(CLASS_NAME, ILogger.INFO, "actionSend", "service--->"+ service);
		if (service 	== null) { 
			throw (new LogicException("The message.service is missing. " +
				"The logicEnvironment does not contain a message.service"));
		}

//		String receiver = (String)logicEnvironment.get((String)logicEnvironment.get("receiver"));
		String receiver = (String)logicEnvironment.get("receiver");
		iLogger.log(CLASS_NAME, ILogger.INFO, "actionSend", "receiver--->"+receiver);
		if (receiver	== null) {
			throw (new LogicException("The message.receiver is missing. " +
				"The logicEnvironment does not contain a message.receiver"));
		}
		Object content	= logicEnvironment.get("object");
		iLogger.log(CLASS_NAME, ILogger.INFO, "actionSend", "Object--->"+content.toString());
		if (content == null) {
			content = new String();
		}

		SingleMessage singleMessage = new SingleMessage(service, receiver, content);
		iLogger.log(CLASS_NAME, ILogger.TRACE3, "actionSend", "Message---->xxx"+singleMessage);
		iLogger.log(CLASS_NAME, ILogger.TRACE3, "actionSend", "MessageContent---->xxx"+singleMessage.getContent());
		synchronized(iCommunication) {
		iCommunication.sendMessage(singleMessage);
		}
	}
	
	/**
	*	Sends a message with the "service" accompanied by the "object" 
	*	to the "receiver". Then it waits for the reply and stores the replied 
	*	object in the "replyToObject".
	*	@lsparam service
	*	@lsparam receiver
	*	@lsparam object
	*	@lsparam replyToObject
	*/
	
	public void actionSendSync(Map logicEnvironment) 
    	throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME = "actionSendSync";		
		Object replyToObject = new Object();
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "logicEnvironment"+logicEnvironment);
		String service	= (String)logicEnvironment.get("service");
		if (service 	== null) { 
			throw (new LogicException("The message.service is missing. " +
				"The logicEnvironment does not contain a message.service"));
		}

		String receiver = (String)logicEnvironment.get("receiver");
		if (receiver	== null) {
			throw (new LogicException("The message.receiver is missing. " +
				"The logicEnvironment does not contain a message.receiver"));
		}

		Object content	= (Object) logicEnvironment.get("object");
		if (content == null) {
			content = new String();
		}
		
		Message message = new SingleMessage(service,receiver,content);
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "Reply Messagexxx"+message );	
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "Reply Messagexxx content"+message .getContent());	
		message.setInReplyTo(CLASS_NAME+System.currentTimeMillis());
		try {
			Message replyMessage = iCommunication.sendSynchronousRequest(message,10000);
			replyToObject 		 = replyMessage.getContent();
		}catch(TimeoutException te) {}
		logicEnvironment.put("replyToObject",replyToObject);
	}
	
	/**
	*	Sends a message back to the sender of a synchronized message.
	*	@lsparam replyToObject	
	*/
	public void actionReply(Map logicEnvironment) 
    	throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME = "actionReply";		
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "logicEnvironment"+logicEnvironment);
		
		SingleMessage	message = (SingleMessage) logicEnvironment.get(ILogicEngine.REQUEST_MESSAGE_KEY);
		if ((message == null)) {
			throw (new LogicException("Request message does exist. " +
				"The logicEnvironment does not contain any message"));
		}

		//List messageList = (List) logicEnvironment.get(ILogicEngine.REQUEST_MESSAGE_KEY);

			String service	= (String)logicEnvironment.get("service");
			if (service == null) { 
				service = message.getService() + REPLY_STRING;
			}

			Object content = logicEnvironment.get("replyToObject");
			if (content != null) {
			 	//if((content instanceof String) && (logicEnvironment.containsKey(content))) {
			 	if(logicEnvironment.containsKey(content)) {
					content = logicEnvironment.get(content);
				}
				
			} else {
				content = new HashMap();
			}
			Message m = message.createReply(service, content);
			iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "Reply Messagexxx"+m);	
			iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "Reply Messagexxx content"+m.getContent());	
			iCommunication.sendMessage(m);
		
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "");
	}
	
	/**
	*	Saves the whole serialized agent to disk.
	*
	*/
	
	public void actionSavePoint(Map logicEnvironment) 
    	throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME = "actionSavePoint";		
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "logicEnvironment"+logicEnvironment);
	}

	/**
	*	Sleeps for a random time. "maxSleep" is the parameter for the random function in secs.
	*	@lsparam maxSleep
	*/
	public void actionSleepRandom(Map logicEnvironment) 
    	throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME = "actionSleepRandom";		
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "logicEnvironment"+logicEnvironment);
		Random 	rand 		= new Random();		
		String	strMaxSleep = (String) logicEnvironment.get("maxSleep");
		/* used for runtime configuration for the agent */
		String	strChangeSleep = (String) logicEnvironment.get("newSleep");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "Time to sleep"+strMaxSleep);
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "Change sleep"+logicEnvironment.get("newSleep"));
		int 	timeToSleep = 0;
		if (null  == strChangeSleep) {		
			if (null == strMaxSleep){
				timeToSleep = rand.nextInt(15);	// creates a value between 0 and 5
				timeToSleep += 5;				// Create a time between 5 and 15 secs.
			}else {
				strMaxSleep = strMaxSleep.trim();
				timeToSleep = rand.nextInt(Integer.parseInt(strMaxSleep) );
			}
		}else{
				strChangeSleep = strChangeSleep.trim();
				timeToSleep = rand.nextInt(Integer.parseInt(strChangeSleep));
		}
		try{
			Thread.sleep(timeToSleep*1000);
		}catch(InterruptedException ie){}
	}
	
	
	/**
	*	Changes the  Environment
	*
	*/
	public void actionNewEnvironment(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME = "actionNewEnvironment";		
		HashMap configMap; 
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "logicEnvironment"+logicEnvironment);
		Message message = (SingleMessage)logicEnvironment.get(ILogicEngine.REQUEST_MESSAGE_KEY);
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "Message Content--->"+message.getContent());
		configMap  = (HashMap)logicEnvironment.get("configHash");
		if (configMap == null) {
			iLogger.log(CLASS_NAME, ILogger.INFO, "actionSetConfiguration", "Configuration is null");					
			configMap = new HashMap();
		}
		else
		{
			iLogger.log(CLASS_NAME, ILogger.INFO, "actionSetConfiguration", configMap.toString());		
		}
		Iterator it = configMap.keySet().iterator();
		
		while (it.hasNext()) 
		{
			String	key 	= (String) it.next();
			Object	value 	= (Object) configMap.get(key);
			
			iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "add to logicEnvironment key ["+key+"] value [" + value + "]");
			logicEnvironment.put(key, value);
		}
	}
	
	public void actionClear(Map logicEnvironment) throws LogicException, IllegalArgumentException 
	{
		String METHOD_NAME = "actionClear";		
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME, "logicEnvironment"+logicEnvironment);
		logicEnvironment.put(CONDITION,STR_FALSE);
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "logicEnvironment"+logicEnvironment);
	}


	/********************** perceptions ****************************/
	
	/**
	*	Returns true, if the agent is idle for at least the specified amount of time (in seconds).
	*	@lsparam idleTime	
	*/
		
	public double perceptionidle4Seconds(Map logicEnvironment) 
	   	throws LogicException, IllegalArgumentException 
	{
		String	METHOD_NAME = "perceptionidle4Seconds";	
		double returnValue = FALSE;
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "LogicEnvironment"+logicEnvironment);
		iLogger.log("", ILogger.TRACE3, "", "");
		returnValue  = TRUE;
		return returnValue ;		
	}
	
	/**
	*	returns TRUE
	*/
	public double perceptionTrue(Map logicEnvironment) 
	   	throws LogicException, IllegalArgumentException 
	{		
		String	METHOD_NAME = "perceptionTrue";	
		double returnValue = FALSE;
		
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.INFO, METHOD_NAME, "LogicEnvironment"+logicEnvironment);
		
		if (((String)logicEnvironment.get(CONDITION)).equals(STR_TRUE)) {
		returnValue  = TRUE;
		}
		
		iLogger.log(CLASS_NAME, ILogger.TRACE1, METHOD_NAME,"returnValue"+returnValue);
		iLogger.log("", ILogger.TRACE3, "", "");
		return returnValue ;		
	}
	
	/**
	*	returns TRUE
	*/
	public double perceptionProduce(Map logicEnvironment) 
	   	throws LogicException, IllegalArgumentException 
	{		
		String	METHOD_NAME = "perceptionProduce";	
		double returnValue = FALSE;
		iLogger.log(CLASS_NAME, ILogger.TRACE4, METHOD_NAME, "started");
		iLogger.log(CLASS_NAME, ILogger.TRACE3, METHOD_NAME, "LogicEnvironment"+logicEnvironment);
		iLogger.log("", ILogger.TRACE3, "", "");
		returnValue  = FALSE;
		return returnValue ;		
	}
}
