BEGIN {
	prev=""
	doc=0
}

/package / {
	gsub(";", "")
	print "<CAPABILITIES package=\"" $2 "\">"
	print ""
}

/\/\*\*[ \t]**$/ {
	#print "START OF JAVADOC"
	comment = ""
	doc=1
	i=0
	next
}

/\*[ \t]@lsobject/ {
	hashpos = index($0, "#")
	oname = $3
	gsub("^.*# *", "")
	if (hashpos > 0 ) {
		print "\t<OBJECT name=\"" oname "\">" 
		print "\t\t" $0 
		print "\t</OBJECT>"
	}
	else
		print "\t<OBJECT name=\"" oname "\"/>"
		
}

/\*[ \t]@lsparam/ {
	param[i] = $3
	i++
	next
	
}

/\*[ \t]*@/ {
	next
	
}

/\*[ \t]/ {
	if (doc == 1) {
		$1 = ""
		gsub("^[ \t]*", "")
		gsub(" *$", "")
		if (comment == "") 
			newline = ""
		else
			newline = "\n"
		comment = comment newline "\t\t" $0
	}
}

/public *void *action/ {
	gsub("public *void *action", "")
	gsub(/\(Map.*$/, "")
	actionname = tolower(substr($1, 1, 1)) substr($1,2)
	print "\t<ACTION name=\"" actionname "\">"
	if (comment != "") print comment
	for (i in param) {
		print "\t\t<PARAMETER name=\"" param[i] "\"/>"
	}
	print "\t</ACTION>"
	comment = ""
	doc=0
	i = 0
	delete param
}

/public *double *perception/ {
	gsub("public *double *perception", "")
	gsub(/\(Map.*$/, "")
	actionname = tolower(substr($1, 1, 1)) substr($1,2)
	print "\t<PERCEPTION name=\"" actionname "\">"
	print comment
	for (i in param) {
		print "\t\t<PARAMETER name=\"" param[i] "\"/>"
	}
	print "\t</PERCEPTION>"
	comment = ""
	doc=0
	i = 0
	delete param
}

END {
	print ""
	print "</CAPABILITIES>"
}

