#include "GrBay.h"


void gInitializeModel() {
	TModel::I().GlobalMod(&GrBay_module::I());
	GrBay_module::I().Initialize();
	GrBay_module::I().SetMInfo(TModule::kisGlobal,True);
	CONSUMERS_module::I().Initialize();
	DETRITUS_module::I().Initialize();
	DIN_module::I().Initialize();
	EELGRASS_module::I().Initialize();
	EPIPHYTES_module::I().Initialize();
	GLOBAL_module::I().Initialize();
	PHOSPHATE_module::I().Initialize();
	PHYTOPLANKTON_module::I().Initialize();
	SALT_module::I().Initialize();
	SEAWEED_module::I().Initialize();
	TSS_module::I().Initialize();
	GrBay_module::I().MakeConnections();
	CONSUMERS_module::I().MakeConnections();
	DETRITUS_module::I().MakeConnections();
	DIN_module::I().MakeConnections();
	EELGRASS_module::I().MakeConnections();
	EPIPHYTES_module::I().MakeConnections();
	GLOBAL_module::I().MakeConnections();
	PHOSPHATE_module::I().MakeConnections();
	PHYTOPLANKTON_module::I().MakeConnections();
	SALT_module::I().MakeConnections();
	SEAWEED_module::I().MakeConnections();
	TSS_module::I().MakeConnections();
}

// ---------------------------------------------------------------------------
//                    Class GrBay_module 
// ---------------------------------------------------------------------------
GrBay_module::GrBay_module(char* name) :
	TIME("TIME"),
	TModule(name) {

}	
GrBay_module* GrBay_module::fInstance = NULL;
GrBay_module* GrBay_module::kNullModel = (GrBay_module*)0x1;
int GrBay_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int GrBay_module::InitVars() {
	
	TIME.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int GrBay_module::Initialize() {
	InitVars();
	GrBay_module::I().AddSubModule(&CONSUMERS_module::I());
	GrBay_module::I().AddSubModule(&DETRITUS_module::I());
	GrBay_module::I().AddSubModule(&DIN_module::I());
	GrBay_module::I().AddSubModule(&EELGRASS_module::I());
	GrBay_module::I().AddSubModule(&EPIPHYTES_module::I());
	GrBay_module::I().AddSubModule(&GLOBAL_module::I());
	GrBay_module::I().AddSubModule(&PHOSPHATE_module::I());
	GrBay_module::I().AddSubModule(&PHYTOPLANKTON_module::I());
	GrBay_module::I().AddSubModule(&SALT_module::I());
	GrBay_module::I().AddSubModule(&SEAWEED_module::I());
	GrBay_module::I().AddSubModule(&TSS_module::I());
	Model::I0().ModuleList().Alphabetize();
	return 1;
}

int GrBay_module::MakeConnections() {
	CONSUMERS_module::I().P1_CELL_SIZE.Connect(&(GLOBAL_module::I().P1_CELL_SIZE));
	CONSUMERS_module::I().EPIPHYTES.Connect(&(EPIPHYTES_module::I().EPIPHYTES));
	CONSUMERS_module::I().ROOTSRHY.Connect(&(EELGRASS_module::I().ROOTSRHY));
	CONSUMERS_module::I().SHOOTS.Connect(&(EELGRASS_module::I().SHOOTS));
	CONSUMERS_module::I().PHYTOPLANKTON.Connect(&(PHYTOPLANKTON_module::I().PHYTOPLANKTON));
	CONSUMERS_module::I().SEAWEEDS.Connect(&(SEAWEED_module::I().SEAWEEDS));
	CONSUMERS_module::I().WRACK.Connect(&(DETRITUS_module::I().WRACK));
	CONSUMERS_module::I().P1_IC_MAC_PHBIO.Connect(&(EELGRASS_module::I().P1_IC_MAC_PHBIO));
	CONSUMERS_module::I().P1_SEPT_TO_JAN_CONV.Connect(&(EELGRASS_module::I().P1_SEPT_TO_JAN_CONV));
	CONSUMERS_module::I().H2O_TEMP.Connect(&(GLOBAL_module::I().H2O_TEMP));
	DETRITUS_module::I().CONS_EGEST.Connect(&(CONSUMERS_module::I().CONS_EGEST));
	DETRITUS_module::I().P1_CELL_SIZE.Connect(&(GLOBAL_module::I().P1_CELL_SIZE));
	DETRITUS_module::I().PHBIO_LITTERFALL.Connect(&(EELGRASS_module::I().PHBIO_LITTERFALL));
	DETRITUS_module::I().CONS_INGEST_WR.Connect(&(CONSUMERS_module::I().CONS_INGEST_WR));
	DETRITUS_module::I().P1_ON_MAP.Connect(&(GLOBAL_module::I().P1_ON_MAP));
	DETRITUS_module::I().P1_AIR_TEMP.Connect(&(GLOBAL_module::I().P1_AIR_TEMP));
	DETRITUS_module::I().EW_VECTOR.Connect(&(GLOBAL_module::I().EW_VECTOR));
	DETRITUS_module::I().EW_WIND_VECTOR.Connect(&(GLOBAL_module::I().EW_WIND_VECTOR));
	DETRITUS_module::I().NS_VECTOR.Connect(&(GLOBAL_module::I().NS_VECTOR));
	DETRITUS_module::I().NS_WIND_VECTOR.Connect(&(GLOBAL_module::I().NS_WIND_VECTOR));
	DETRITUS_module::I().DAYS.Connect(&(GLOBAL_module::I().DAYS));
	DIN_module::I().SF_WATER.Connect(&(GLOBAL_module::I().SF_WATER));
	DIN_module::I().WRACK_OM_DECOMP.Connect(&(DETRITUS_module::I().WRACK_OM_DECOMP));
	DIN_module::I().P1_WRACK_OM_NC.Connect(&(DETRITUS_module::I().P1_WRACK_OM_NC));
	DIN_module::I().PHT_NET_PROD.Connect(&(PHYTOPLANKTON_module::I().PHT_NET_PROD));
	DIN_module::I().P1_PHT_NC.Connect(&(PHYTOPLANKTON_module::I().P1_PHT_NC));
	DIN_module::I().P1_MAC_PH_NC.Connect(&(EELGRASS_module::I().P1_MAC_PH_NC));
	DIN_module::I().PHBIO_NET_PROD.Connect(&(EELGRASS_module::I().PHBIO_NET_PROD));
	DIN_module::I().SF_WT_E_X.Connect(&(GLOBAL_module::I().SF_WT_E_X));
	DIN_module::I().SF_WT_N_X.Connect(&(GLOBAL_module::I().SF_WT_N_X));
	DIN_module::I().SF_WT_S_X.Connect(&(GLOBAL_module::I().SF_WT_S_X));
	DIN_module::I().SF_WT_W_X.Connect(&(GLOBAL_module::I().SF_WT_W_X));
	DIN_module::I().P1_RIVER_DATA_CF.Connect(&(PHOSPHATE_module::I().P1_RIVER_DATA_CF));
	EELGRASS_module::I().P1_CELL_SIZE.Connect(&(GLOBAL_module::I().P1_CELL_SIZE));
	EELGRASS_module::I().CONS_INGEST_NPHBIO.Connect(&(CONSUMERS_module::I().CONS_INGEST_NPHBIO));
	EELGRASS_module::I().GEMINATION.Connect(&(DETRITUS_module::I().GEMINATION));
	EELGRASS_module::I().CONS_INGEST_PHBIO.Connect(&(CONSUMERS_module::I().CONS_INGEST_PHBIO));
	EELGRASS_module::I().P1_AIR_TEMP.Connect(&(GLOBAL_module::I().P1_AIR_TEMP));
	EELGRASS_module::I().H2O_TEMP.Connect(&(GLOBAL_module::I().H2O_TEMP));
	EELGRASS_module::I().P1_LEAF_GROW_SEASON.Connect(&(GLOBAL_module::I().P1_LEAF_GROW_SEASON));
	EELGRASS_module::I().P1_DIN_SED_CONC_MAP.Connect(&(DIN_module::I().P1_DIN_SED_CONC_MAP));
	EELGRASS_module::I().P1_PO4_SED_WT_CONC.Connect(&(PHOSPHATE_module::I().P1_PO4_SED_WT_CONC));
	EELGRASS_module::I().ZOSTRA_LIGHT_LIM.Connect(&(GLOBAL_module::I().ZOSTRA_LIGHT_LIM));
	EELGRASS_module::I().DAYS.Connect(&(GLOBAL_module::I().DAYS));
	EPIPHYTES_module::I().P1_CELL_SIZE.Connect(&(GLOBAL_module::I().P1_CELL_SIZE));
	EPIPHYTES_module::I().SHOOTS.Connect(&(EELGRASS_module::I().SHOOTS));
	EPIPHYTES_module::I().CONS_INGEST_EPI.Connect(&(CONSUMERS_module::I().CONS_INGEST_EPI));
	EPIPHYTES_module::I().PHBIO_LTTR_RATIO.Connect(&(EELGRASS_module::I().PHBIO_LTTR_RATIO));
	EPIPHYTES_module::I().DIN_CONC.Connect(&(DIN_module::I().DIN_CONC));
	EPIPHYTES_module::I().PO4_SF_WT_CONC.Connect(&(PHOSPHATE_module::I().PO4_SF_WT_CONC));
	EPIPHYTES_module::I().EPI_LIGHT_LIM.Connect(&(GLOBAL_module::I().EPI_LIGHT_LIM));
	EPIPHYTES_module::I().H2O_TEMP.Connect(&(GLOBAL_module::I().H2O_TEMP));
	EPIPHYTES_module::I().P1_IC_MAC_PHBIO.Connect(&(EELGRASS_module::I().P1_IC_MAC_PHBIO));
	EPIPHYTES_module::I().P1_SEPT_TO_JAN_CONV.Connect(&(EELGRASS_module::I().P1_SEPT_TO_JAN_CONV));
	GLOBAL_module::I().TSS_CONC.Connect(&(TSS_module::I().TSS_CONC));
	GLOBAL_module::I().PHT_CONC.Connect(&(PHYTOPLANKTON_module::I().PHT_CONC));
	GLOBAL_module::I().LEAF_LENGTH.Connect(&(EELGRASS_module::I().LEAF_LENGTH));
	GLOBAL_module::I().EPIPHYTES.Connect(&(EPIPHYTES_module::I().EPIPHYTES));
	PHOSPHATE_module::I().SF_WATER.Connect(&(GLOBAL_module::I().SF_WATER));
	PHOSPHATE_module::I().WRACK_OM_DECOMP.Connect(&(DETRITUS_module::I().WRACK_OM_DECOMP));
	PHOSPHATE_module::I().P1_WRACK_OM_PC.Connect(&(DETRITUS_module::I().P1_WRACK_OM_PC));
	PHOSPHATE_module::I().PHT_NET_PROD.Connect(&(PHYTOPLANKTON_module::I().PHT_NET_PROD));
	PHOSPHATE_module::I().P1_PHY_PC.Connect(&(PHYTOPLANKTON_module::I().P1_PHY_PC));
	PHOSPHATE_module::I().P1_MAC_PHBIO_PC.Connect(&(EELGRASS_module::I().P1_MAC_PHBIO_PC));
	PHOSPHATE_module::I().PHBIO_NET_PROD.Connect(&(EELGRASS_module::I().PHBIO_NET_PROD));
	PHOSPHATE_module::I().SF_WT_E_X.Connect(&(GLOBAL_module::I().SF_WT_E_X));
	PHOSPHATE_module::I().SF_WT_N_X.Connect(&(GLOBAL_module::I().SF_WT_N_X));
	PHOSPHATE_module::I().SF_WT_S_X.Connect(&(GLOBAL_module::I().SF_WT_S_X));
	PHOSPHATE_module::I().SF_WT_W_X.Connect(&(GLOBAL_module::I().SF_WT_W_X));
	PHYTOPLANKTON_module::I().WATER_DEPTH.Connect(&(GLOBAL_module::I().WATER_DEPTH));
	PHYTOPLANKTON_module::I().P1_CELL_SIZE.Connect(&(GLOBAL_module::I().P1_CELL_SIZE));
	PHYTOPLANKTON_module::I().SF_WATER.Connect(&(GLOBAL_module::I().SF_WATER));
	PHYTOPLANKTON_module::I().CONS_INGEST_PHT.Connect(&(CONSUMERS_module::I().CONS_INGEST_PHT));
	PHYTOPLANKTON_module::I().P1_RIVER_DATA_CF.Connect(&(PHOSPHATE_module::I().P1_RIVER_DATA_CF));
	PHYTOPLANKTON_module::I().DIN_CONC.Connect(&(DIN_module::I().DIN_CONC));
	PHYTOPLANKTON_module::I().PO4_SF_WT_CONC.Connect(&(PHOSPHATE_module::I().PO4_SF_WT_CONC));
	PHYTOPLANKTON_module::I().PHT_LIGHT_LIM.Connect(&(GLOBAL_module::I().PHT_LIGHT_LIM));
	PHYTOPLANKTON_module::I().H2O_TEMP.Connect(&(GLOBAL_module::I().H2O_TEMP));
	PHYTOPLANKTON_module::I().SF_WT_E_X.Connect(&(GLOBAL_module::I().SF_WT_E_X));
	PHYTOPLANKTON_module::I().SF_WT_N_X.Connect(&(GLOBAL_module::I().SF_WT_N_X));
	PHYTOPLANKTON_module::I().SF_WT_S_X.Connect(&(GLOBAL_module::I().SF_WT_S_X));
	PHYTOPLANKTON_module::I().SF_WT_W_X.Connect(&(GLOBAL_module::I().SF_WT_W_X));
	SALT_module::I().SF_WATER.Connect(&(GLOBAL_module::I().SF_WATER));
	SALT_module::I().SF_WT_E_X.Connect(&(GLOBAL_module::I().SF_WT_E_X));
	SALT_module::I().SF_WT_N_X.Connect(&(GLOBAL_module::I().SF_WT_N_X));
	SALT_module::I().SF_WT_S_X.Connect(&(GLOBAL_module::I().SF_WT_S_X));
	SALT_module::I().SF_WT_W_X.Connect(&(GLOBAL_module::I().SF_WT_W_X));
	SEAWEED_module::I().WATER_DEPTH.Connect(&(GLOBAL_module::I().WATER_DEPTH));
	SEAWEED_module::I().P1_CELL_SIZE.Connect(&(GLOBAL_module::I().P1_CELL_SIZE));
	SEAWEED_module::I().SF_WATER.Connect(&(GLOBAL_module::I().SF_WATER));
	SEAWEED_module::I().CONS_INGEST_SW.Connect(&(CONSUMERS_module::I().CONS_INGEST_SW));
	SEAWEED_module::I().P1_IC_MAC_PHBIO.Connect(&(EELGRASS_module::I().P1_IC_MAC_PHBIO));
	SEAWEED_module::I().P1_SEPT_TO_JAN_CONV.Connect(&(EELGRASS_module::I().P1_SEPT_TO_JAN_CONV));
	SEAWEED_module::I().SF_WT_E_X.Connect(&(GLOBAL_module::I().SF_WT_E_X));
	SEAWEED_module::I().DIN_CONC.Connect(&(DIN_module::I().DIN_CONC));
	SEAWEED_module::I().PO4_SF_WT_CONC.Connect(&(PHOSPHATE_module::I().PO4_SF_WT_CONC));
	SEAWEED_module::I().SF_WT_N_X.Connect(&(GLOBAL_module::I().SF_WT_N_X));
	SEAWEED_module::I().SW_LIGHT_LIM.Connect(&(GLOBAL_module::I().SW_LIGHT_LIM));
	SEAWEED_module::I().SF_WT_S_X.Connect(&(GLOBAL_module::I().SF_WT_S_X));
	SEAWEED_module::I().H2O_TEMP.Connect(&(GLOBAL_module::I().H2O_TEMP));
	SEAWEED_module::I().SF_WT_W_X.Connect(&(GLOBAL_module::I().SF_WT_W_X));
	SEAWEED_module::I().DAYS.Connect(&(GLOBAL_module::I().DAYS));
	SEAWEED_module::I().CURRENT_VELOCITY.Connect(&(GLOBAL_module::I().CURRENT_VELOCITY));
	TSS_module::I().SF_WATER.Connect(&(GLOBAL_module::I().SF_WATER));
	TSS_module::I().WATER_DEPTH.Connect(&(GLOBAL_module::I().WATER_DEPTH));
	TSS_module::I().VEG_STRUCTURE.Connect(&(CONSUMERS_module::I().VEG_STRUCTURE));
	TSS_module::I().SHEAR_STRESS.Connect(&(GLOBAL_module::I().SHEAR_STRESS));
	TSS_module::I().P1_RIVER_DATA_CF.Connect(&(PHOSPHATE_module::I().P1_RIVER_DATA_CF));
	TSS_module::I().SF_WT_E_X.Connect(&(GLOBAL_module::I().SF_WT_E_X));
	TSS_module::I().SF_WT_N_X.Connect(&(GLOBAL_module::I().SF_WT_N_X));
	TSS_module::I().SF_WT_S_X.Connect(&(GLOBAL_module::I().SF_WT_S_X));
	TSS_module::I().SF_WT_W_X.Connect(&(GLOBAL_module::I().SF_WT_W_X));
	return 0;
}

int GrBay_module::SetupEvents() {
	return 0;
}

int GrBay_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int GrBay_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int GrBay_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int GrBay_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

int GrBay_module::PostInit() {
	PostEventsByType(TEvent::kInit);
	return 1;
}

// ---------------------------------------------------------------------------
//                    Class CONSUMERS_module 
// ---------------------------------------------------------------------------
CONSUMERS_module::CONSUMERS_module(char* name) :
	TIME("TIME"),
	P1_CELL_SIZE("P1_CELL_SIZE"),
	EPIPHYTES("EPIPHYTES"),
	ROOTSRHY("ROOTSRHY"),
	SHOOTS("SHOOTS"),
	PHYTOPLANKTON("PHYTOPLANKTON"),
	SEAWEEDS("SEAWEEDS"),
	WRACK("WRACK"),
	P1_IC_MAC_PHBIO("P1_IC_MAC_PHBIO"),
	P1_SEPT_TO_JAN_CONV("P1_SEPT_TO_JAN_CONV"),
	H2O_TEMP("H2O_TEMP"),
	CONS_EGEST("CONS_EGEST"),
	CONS_INGEST_WR("CONS_INGEST_WR"),
	CONS_INGEST_NPHBIO("CONS_INGEST_NPHBIO"),
	CONS_INGEST_PHBIO("CONS_INGEST_PHBIO"),
	CONS_INGEST_EPI("CONS_INGEST_EPI"),
	CONS_INGEST_PHT("CONS_INGEST_PHT"),
	CONS_INGEST_SW("CONS_INGEST_SW"),
	VEG_STRUCTURE("VEG_STRUCTURE"),
	CONSUMERS("CONSUMERS"),
	CONS_INGEST("CONS_INGEST"),
	CONS_IN_X("CONS_IN_X"),
	CONS_MORTALITY("CONS_MORTALITY"),
	CONS_RESPIRATION("CONS_RESPIRATION"),
	CONS_OUT_X("CONS_OUT_X"),
	CONSDENS("CONSDENS"),
	CONSTOE("CONSTOE"),
	CONSTON("CONSTON"),
	CONSTOS("CONSTOS"),
	CONSTOW("CONSTOW"),
	CON_POT_INGEST("CON_POT_INGEST"),
	DENSITY_X_E("DENSITY_X_E"),
	DENSITY_X_N("DENSITY_X_N"),
	DENSITY_X_S("DENSITY_X_S"),
	DENSITY_X_W("DENSITY_X_W"),
	FOOD_X_E("FOOD_X_E"),
	FOOD_X_N("FOOD_X_N"),
	FOOD_X_S("FOOD_X_S"),
	FOOD_X_W("FOOD_X_W"),
	IC_CONSUMER("IC_CONSUMER"),
	OMTOTBIO("OMTOTBIO"),
	PREF_TOT("PREF_TOT"),
	RIVER_CON("RIVER_CON"),
	P1_CONS_NC("P1_CONS_NC"),
	P1_CONS_PC("P1_CONS_PC"),
	P1_C_EGEST_EFF("P1_C_EGEST_EFF"),
	P1_C_MORT_RT("P1_C_MORT_RT"),
	P1_C_RESP_RT("P1_C_RESP_RT"),
	P1_EP_PREF("P1_EP_PREF"),
	P1_INGESTION_RT("P1_INGESTION_RT"),
	P1_PH_PREF("P1_PH_PREF"),
	P1_RR_PREF("P1_RR_PREF"),
	P1_SH_PREF("P1_SH_PREF"),
	P1_SW_PREF("P1_SW_PREF"),
	P1_TRAVEL_TIME("P1_TRAVEL_TIME"),
	P1_VEG_DENS_COEFF("P1_VEG_DENS_COEFF"),
	P1_WR_PREF("P1_WR_PREF"),
	CONS_ACTIVITY("CONS_ACTIVITY"),
	TModule(name) {

	P1_CELL_SIZE.SetF(FisImport,True,"CG");
	EPIPHYTES.SetF(FisImport,True,"CG");
	ROOTSRHY.SetF(FisImport,True,"CG");
	SHOOTS.SetF(FisImport,True,"CG");
	PHYTOPLANKTON.SetF(FisImport,True,"CG");
	SEAWEEDS.SetF(FisImport,True,"CG");
	WRACK.SetF(FisImport,True,"CG");
	P1_IC_MAC_PHBIO.SetF(FisImport,True,"CG");
	P1_SEPT_TO_JAN_CONV.SetF(FisImport,True,"CG");
	H2O_TEMP.SetF(FisImport,True,"CG");
	CONS_EGEST.SetF(FisExport,True,"CG");
	CONS_INGEST_WR.SetF(FisExport,True,"CG");
	CONS_INGEST_NPHBIO.SetF(FisExport,True,"CG");
	CONS_INGEST_PHBIO.SetF(FisExport,True,"CG");
	CONS_INGEST_EPI.SetF(FisExport,True,"CG");
	CONS_INGEST_PHT.SetF(FisExport,True,"CG");
	CONS_INGEST_SW.SetF(FisExport,True,"CG");
	VEG_STRUCTURE.SetF(FisExport,True,"CG");
}	
int CONSUMERS_module::CONSUMERS_I0_exe() {
	float value;

	CONSUMERS.UpdateIntegrator();
	switch( CONSUMERS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONSUMERS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( CONS_INGEST.Value(p)+CONS_IN_X.Value(p) )-CONS_EGEST.Value(p) )-CONS_MORTALITY.Value(p) )-CONS_RESPIRATION.Value(p) )-CONS_OUT_X.Value(p) );
			CONSUMERS.Update( p, value, dT() );
		}
		CONSUMERS.GrabMemory();
		if( CONSUMERS.GetF(FLinkEdges) ) { CONSUMERS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( CONS_INGEST.Value()+CONS_IN_X.Value() )-CONS_EGEST.Value() )-CONS_MORTALITY.Value() )-CONS_RESPIRATION.Value() )-CONS_OUT_X.Value() );
			CONSUMERS.Update( value, dT() );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::CONSUMERS_i1_exe() {
	float value;

	CONSUMERS.UpdateIntegrator();
	switch( CONSUMERS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONSUMERS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( IC_CONSUMER.Value(p)*P1_CELL_SIZE.Value(p) );
			CONSUMERS.InitValue( p, value );
		}
		CONSUMERS.GrabMemory();
		if( CONSUMERS.GetF(FLinkEdges) ) { CONSUMERS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( IC_CONSUMER.Value()*P1_CELL_SIZE.Value() );
			CONSUMERS.InitValue( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::CONS_INGEST_u2_exe() {
	float value;

	switch( CONS_INGEST.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONS_INGEST.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( CONS_INGEST_EPI.Value(p)+CONS_INGEST_NPHBIO.Value(p) )+CONS_INGEST_PHBIO.Value(p) )+CONS_INGEST_PHT.Value(p) )+CONS_INGEST_SW.Value(p) )+CONS_INGEST_WR.Value(p) );
			CONS_INGEST.Update( p, value );
		}
		CONS_INGEST.GrabMemory();
		if( CONS_INGEST.GetF(FICFlux) ) CONS_INGEST.Cov().Set(0.0); 
		if( CONS_INGEST.GetF(FLinkEdges) ) { CONS_INGEST.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( CONS_INGEST_EPI.Value()+CONS_INGEST_NPHBIO.Value() )+CONS_INGEST_PHBIO.Value() )+CONS_INGEST_PHT.Value() )+CONS_INGEST_SW.Value() )+CONS_INGEST_WR.Value() );
			CONS_INGEST.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::CONS_IN_X_u3_exe() {
	float value;

	switch( CONS_IN_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONS_IN_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( CONSTOE.RelValue(p,0,-1,0,CVariable::kDefaultBC)+CONSTON.RelValue(p,1,0,0,CVariable::kDefaultBC) )+CONSTOS.RelValue(p,-1,0,0,CVariable::kDefaultBC) )+CONSTOW.RelValue(p,0,1,0,CVariable::kDefaultBC) );
			CONS_IN_X.Update( p, value );
		}
		CONS_IN_X.GrabMemory();
		if( CONS_IN_X.GetF(FICFlux) ) CONS_IN_X.Cov().Set(0.0); 
		if( CONS_IN_X.GetF(FLinkEdges) ) { CONS_IN_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( CONSTOE.Value()+CONSTON.Value() )+CONSTOS.Value() )+CONSTOW.Value() );
			CONS_IN_X.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::CONS_EGEST_u4_exe() {
	float value;

	switch( CONS_EGEST.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONS_EGEST.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( CONS_INGEST.Value(p)*P1_C_EGEST_EFF.Value(p) );
			CONS_EGEST.Update( p, value );
		}
		CONS_EGEST.GrabMemory();
		if( CONS_EGEST.GetF(FICFlux) ) CONS_EGEST.Cov().Set(0.0); 
		if( CONS_EGEST.GetF(FLinkEdges) ) { CONS_EGEST.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( CONS_INGEST.Value()*P1_C_EGEST_EFF.Value() );
			CONS_EGEST.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::CONS_MORTALITY_u5_exe() {
	float value;

	switch( CONS_MORTALITY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONS_MORTALITY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( CONSUMERS.Value(p)*( P1_C_MORT_RT.Value(p)*dT() ) );
			CONS_MORTALITY.Update( p, value );
		}
		CONS_MORTALITY.GrabMemory();
		if( CONS_MORTALITY.GetF(FICFlux) ) CONS_MORTALITY.Cov().Set(0.0); 
		if( CONS_MORTALITY.GetF(FLinkEdges) ) { CONS_MORTALITY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( CONSUMERS.Value()*( P1_C_MORT_RT.Value()*dT() ) );
			CONS_MORTALITY.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::CONS_RESPIRATION_u6_exe() {
	float value;

	switch( CONS_RESPIRATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONS_RESPIRATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( CONSUMERS.Value(p)*CONS_ACTIVITY.Value(p) )*( P1_C_RESP_RT.Value(p)*dT() ) );
			CONS_RESPIRATION.Update( p, value );
		}
		CONS_RESPIRATION.GrabMemory();
		if( CONS_RESPIRATION.GetF(FICFlux) ) CONS_RESPIRATION.Cov().Set(0.0); 
		if( CONS_RESPIRATION.GetF(FLinkEdges) ) { CONS_RESPIRATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( CONSUMERS.Value()*CONS_ACTIVITY.Value() )*( P1_C_RESP_RT.Value()*dT() ) );
			CONS_RESPIRATION.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::CONS_OUT_X_u7_exe() {
	float value;

	switch( CONS_OUT_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONS_OUT_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( CONSTOE.Value(p)+CONSTON.Value(p) )+CONSTOS.Value(p) )+CONSTOW.Value(p) );
			CONS_OUT_X.Update( p, value );
		}
		CONS_OUT_X.GrabMemory();
		if( CONS_OUT_X.GetF(FICFlux) ) CONS_OUT_X.Cov().Set(0.0); 
		if( CONS_OUT_X.GetF(FLinkEdges) ) { CONS_OUT_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( CONSTOE.Value()+CONSTON.Value() )+CONSTOS.Value() )+CONSTOW.Value() );
			CONS_OUT_X.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::CONSDENS_u8_exe() {
	float value;

	switch( CONSDENS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONSDENS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( RIVER_CON.Value(p)+CONSUMERS.Value(p) )/P1_CELL_SIZE.Value(p) );
			CONSDENS.Update( p, value );
		}
		CONSDENS.GrabMemory();
		if( CONSDENS.GetF(FLinkEdges) ) { CONSDENS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( RIVER_CON.Value()+CONSUMERS.Value() )/P1_CELL_SIZE.Value() );
			CONSDENS.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::CONSTOE_u9_exe() {
	float value;

	switch( CONSTOE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONSTOE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( DENSITY_X_E.Value(p)+FOOD_X_E.Value(p) ) >  ((float)1) ) ) ? ( CONSUMERS.Value(p) ) : ( ( ( DENSITY_X_E.Value(p)+FOOD_X_E.Value(p) )*CONSUMERS.Value(p) ) ) ) ;
			CONSTOE.Update( p, value );
		}
		CONSTOE.GrabMemory();
		if( CONSTOE.GetF(FLinkEdges) ) { CONSTOE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( DENSITY_X_E.Value()+FOOD_X_E.Value() ) >  ((float)1) ) ) ? ( CONSUMERS.Value() ) : ( ( ( DENSITY_X_E.Value()+FOOD_X_E.Value() )*CONSUMERS.Value() ) ) ) ;
			CONSTOE.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::CONSTON_u10_exe() {
	float value;

	switch( CONSTON.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONSTON.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( DENSITY_X_N.Value(p)+FOOD_X_N.Value(p) ) >  ((float)1) ) ) ? ( CONSUMERS.Value(p) ) : ( ( ( DENSITY_X_N.Value(p)+FOOD_X_N.Value(p) )*CONSUMERS.Value(p) ) ) ) ;
			CONSTON.Update( p, value );
		}
		CONSTON.GrabMemory();
		if( CONSTON.GetF(FLinkEdges) ) { CONSTON.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( DENSITY_X_N.Value()+FOOD_X_N.Value() ) >  ((float)1) ) ) ? ( CONSUMERS.Value() ) : ( ( ( DENSITY_X_N.Value()+FOOD_X_N.Value() )*CONSUMERS.Value() ) ) ) ;
			CONSTON.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::CONSTOS_u11_exe() {
	float value;

	switch( CONSTOS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONSTOS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( DENSITY_X_S.Value(p)+FOOD_X_S.Value(p) ) >  ((float)1) ) ) ? ( CONSUMERS.Value(p) ) : ( ( ( DENSITY_X_S.Value(p)+FOOD_X_S.Value(p) )*CONSUMERS.Value(p) ) ) ) ;
			CONSTOS.Update( p, value );
		}
		CONSTOS.GrabMemory();
		if( CONSTOS.GetF(FLinkEdges) ) { CONSTOS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( DENSITY_X_S.Value()+FOOD_X_S.Value() ) >  ((float)1) ) ) ? ( CONSUMERS.Value() ) : ( ( ( DENSITY_X_S.Value()+FOOD_X_S.Value() )*CONSUMERS.Value() ) ) ) ;
			CONSTOS.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::CONSTOW_u12_exe() {
	float value;

	switch( CONSTOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONSTOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( DENSITY_X_W.Value(p)+FOOD_X_W.Value(p) ) >  ((float)1) ) ) ? ( CONSUMERS.Value(p) ) : ( ( ( DENSITY_X_W.Value(p)+FOOD_X_W.Value(p) )*CONSUMERS.Value(p) ) ) ) ;
			CONSTOW.Update( p, value );
		}
		CONSTOW.GrabMemory();
		if( CONSTOW.GetF(FLinkEdges) ) { CONSTOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( DENSITY_X_W.Value()+FOOD_X_W.Value() ) >  ((float)1) ) ) ? ( CONSUMERS.Value() ) : ( ( ( DENSITY_X_W.Value()+FOOD_X_W.Value() )*CONSUMERS.Value() ) ) ) ;
			CONSTOW.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::CONS_INGEST_EPI_u13_exe() {
	float value;

	switch( CONS_INGEST_EPI.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONS_INGEST_EPI.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( EPIPHYTES.Value(p) <  ((float)1) ) ) ? ( ((float)0) ) : ( SL::Min(EPIPHYTES.Value(p), ( ( P1_EP_PREF.Value(p)/PREF_TOT.Value(p) )*CON_POT_INGEST.Value(p) )) ) ) ;
			CONS_INGEST_EPI.Update( p, value );
		}
		CONS_INGEST_EPI.GrabMemory();
		if( CONS_INGEST_EPI.GetF(FLinkEdges) ) { CONS_INGEST_EPI.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( EPIPHYTES.Value() <  ((float)1) ) ) ? ( ((float)0) ) : ( SL::Min(EPIPHYTES.Value(), ( ( P1_EP_PREF.Value()/PREF_TOT.Value() )*CON_POT_INGEST.Value() )) ) ) ;
			CONS_INGEST_EPI.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::CONS_INGEST_NPHBIO_u14_exe() {
	float value;

	switch( CONS_INGEST_NPHBIO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONS_INGEST_NPHBIO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(ROOTSRHY.Value(p), ( ( P1_RR_PREF.Value(p)/PREF_TOT.Value(p) )*CON_POT_INGEST.Value(p) ));
			CONS_INGEST_NPHBIO.Update( p, value );
		}
		CONS_INGEST_NPHBIO.GrabMemory();
		if( CONS_INGEST_NPHBIO.GetF(FLinkEdges) ) { CONS_INGEST_NPHBIO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(ROOTSRHY.Value(), ( ( P1_RR_PREF.Value()/PREF_TOT.Value() )*CON_POT_INGEST.Value() ));
			CONS_INGEST_NPHBIO.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::CONS_INGEST_PHBIO_u15_exe() {
	float value;

	switch( CONS_INGEST_PHBIO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONS_INGEST_PHBIO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(SHOOTS.Value(p), ( ( P1_SH_PREF.Value(p)/PREF_TOT.Value(p) )*CON_POT_INGEST.Value(p) ));
			CONS_INGEST_PHBIO.Update( p, value );
		}
		CONS_INGEST_PHBIO.GrabMemory();
		if( CONS_INGEST_PHBIO.GetF(FLinkEdges) ) { CONS_INGEST_PHBIO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(SHOOTS.Value(), ( ( P1_SH_PREF.Value()/PREF_TOT.Value() )*CON_POT_INGEST.Value() ));
			CONS_INGEST_PHBIO.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::CONS_INGEST_PHT_u16_exe() {
	float value;

	switch( CONS_INGEST_PHT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONS_INGEST_PHT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(PHYTOPLANKTON.Value(p), ( ( P1_PH_PREF.Value(p)/PREF_TOT.Value(p) )*CON_POT_INGEST.Value(p) ));
			CONS_INGEST_PHT.Update( p, value );
		}
		CONS_INGEST_PHT.GrabMemory();
		if( CONS_INGEST_PHT.GetF(FLinkEdges) ) { CONS_INGEST_PHT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(PHYTOPLANKTON.Value(), ( ( P1_PH_PREF.Value()/PREF_TOT.Value() )*CON_POT_INGEST.Value() ));
			CONS_INGEST_PHT.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::CONS_INGEST_SW_u17_exe() {
	float value;

	switch( CONS_INGEST_SW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONS_INGEST_SW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(SEAWEEDS.Value(p), ( ( P1_SW_PREF.Value(p)/PREF_TOT.Value(p) )*CON_POT_INGEST.Value(p) ));
			CONS_INGEST_SW.Update( p, value );
		}
		CONS_INGEST_SW.GrabMemory();
		if( CONS_INGEST_SW.GetF(FLinkEdges) ) { CONS_INGEST_SW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(SEAWEEDS.Value(), ( ( P1_SW_PREF.Value()/PREF_TOT.Value() )*CON_POT_INGEST.Value() ));
			CONS_INGEST_SW.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::CONS_INGEST_WR_u18_exe() {
	float value;

	switch( CONS_INGEST_WR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONS_INGEST_WR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(WRACK.Value(p), ( ( P1_WR_PREF.Value(p)/PREF_TOT.Value(p) )*CON_POT_INGEST.Value(p) ));
			CONS_INGEST_WR.Update( p, value );
		}
		CONS_INGEST_WR.GrabMemory();
		if( CONS_INGEST_WR.GetF(FLinkEdges) ) { CONS_INGEST_WR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(WRACK.Value(), ( ( P1_WR_PREF.Value()/PREF_TOT.Value() )*CON_POT_INGEST.Value() ));
			CONS_INGEST_WR.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::CON_POT_INGEST_u19_exe() {
	float value;

	switch( CON_POT_INGEST.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CON_POT_INGEST.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(OMTOTBIO.Value(p), ( ( P1_INGESTION_RT.Value(p)*CONS_ACTIVITY.Value(p) )*CONSUMERS.Value(p) ));
			CON_POT_INGEST.Update( p, value );
		}
		CON_POT_INGEST.GrabMemory();
		if( CON_POT_INGEST.GetF(FLinkEdges) ) { CON_POT_INGEST.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(OMTOTBIO.Value(), ( ( P1_INGESTION_RT.Value()*CONS_ACTIVITY.Value() )*CONSUMERS.Value() ));
			CON_POT_INGEST.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::DENSITY_X_E_u20_exe() {
	float value;

	switch( DENSITY_X_E.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DENSITY_X_E.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( CONSDENS.Value(p) <  CONSDENS.RelValue(p,0,1,0,CVariable::kDefaultBC) ) || ( CONSDENS.Value(p) <  ((float)1) ) ) ) ? ( ((float)0) ) : ( ( ( P1_TRAVEL_TIME.Value(p)*( CONSDENS.Value(p)-CONSDENS.RelValue(p,0,1,0,CVariable::kDefaultBC) ) )/CONSDENS.Value(p) ) ) ) ;
			DENSITY_X_E.Update( p, value );
		}
		DENSITY_X_E.GrabMemory();
		if( DENSITY_X_E.GetF(FLinkEdges) ) { DENSITY_X_E.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( CONSDENS.Value() <  CONSDENS.Value() ) || ( CONSDENS.Value() <  ((float)1) ) ) ) ? ( ((float)0) ) : ( ( ( P1_TRAVEL_TIME.Value()*( CONSDENS.Value()-CONSDENS.Value() ) )/CONSDENS.Value() ) ) ) ;
			DENSITY_X_E.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::DENSITY_X_N_u21_exe() {
	float value;

	switch( DENSITY_X_N.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DENSITY_X_N.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( CONSDENS.Value(p) <  CONSDENS.RelValue(p,-1,0,0,CVariable::kDefaultBC) ) || ( CONSDENS.Value(p) <  ((float)1) ) ) ) ? ( ((float)0) ) : ( ( ( P1_TRAVEL_TIME.Value(p)*( CONSDENS.Value(p)-CONSDENS.RelValue(p,-1,0,0,CVariable::kDefaultBC) ) )/CONSDENS.Value(p) ) ) ) ;
			DENSITY_X_N.Update( p, value );
		}
		DENSITY_X_N.GrabMemory();
		if( DENSITY_X_N.GetF(FLinkEdges) ) { DENSITY_X_N.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( CONSDENS.Value() <  CONSDENS.Value() ) || ( CONSDENS.Value() <  ((float)1) ) ) ) ? ( ((float)0) ) : ( ( ( P1_TRAVEL_TIME.Value()*( CONSDENS.Value()-CONSDENS.Value() ) )/CONSDENS.Value() ) ) ) ;
			DENSITY_X_N.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::DENSITY_X_S_u22_exe() {
	float value;

	switch( DENSITY_X_S.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DENSITY_X_S.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( CONSDENS.Value(p) <  CONSDENS.RelValue(p,1,0,0,CVariable::kDefaultBC) ) || ( CONSDENS.Value(p) <  ((float)1) ) ) ) ? ( ((float)0) ) : ( ( ( P1_TRAVEL_TIME.Value(p)*( CONSDENS.Value(p)-CONSDENS.RelValue(p,1,0,0,CVariable::kDefaultBC) ) )/CONSDENS.Value(p) ) ) ) ;
			DENSITY_X_S.Update( p, value );
		}
		DENSITY_X_S.GrabMemory();
		if( DENSITY_X_S.GetF(FLinkEdges) ) { DENSITY_X_S.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( CONSDENS.Value() <  CONSDENS.Value() ) || ( CONSDENS.Value() <  ((float)1) ) ) ) ? ( ((float)0) ) : ( ( ( P1_TRAVEL_TIME.Value()*( CONSDENS.Value()-CONSDENS.Value() ) )/CONSDENS.Value() ) ) ) ;
			DENSITY_X_S.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::DENSITY_X_W_u23_exe() {
	float value;

	switch( DENSITY_X_W.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DENSITY_X_W.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( CONSDENS.Value(p) <  CONSDENS.RelValue(p,0,-1,0,CVariable::kDefaultBC) ) || ( CONSDENS.Value(p) <  ((float)1) ) ) ) ? ( ((float)0) ) : ( ( ( P1_TRAVEL_TIME.Value(p)*( CONSDENS.Value(p)-CONSDENS.RelValue(p,0,-1,0,CVariable::kDefaultBC) ) )/CONSDENS.Value(p) ) ) ) ;
			DENSITY_X_W.Update( p, value );
		}
		DENSITY_X_W.GrabMemory();
		if( DENSITY_X_W.GetF(FLinkEdges) ) { DENSITY_X_W.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( CONSDENS.Value() <  CONSDENS.Value() ) || ( CONSDENS.Value() <  ((float)1) ) ) ) ? ( ((float)0) ) : ( ( ( P1_TRAVEL_TIME.Value()*( CONSDENS.Value()-CONSDENS.Value() ) )/CONSDENS.Value() ) ) ) ;
			DENSITY_X_W.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::FOOD_X_E_u24_exe() {
	float value;

	switch( FOOD_X_E.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FOOD_X_E.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( OMTOTBIO.Value(p) >  OMTOTBIO.RelValue(p,0,1,0,CVariable::kDefaultBC) ) || ( OMTOTBIO.Value(p) <  ((float)1) ) ) ) ? ( ((float)0) ) : ( ( ( P1_TRAVEL_TIME.Value(p)*( OMTOTBIO.RelValue(p,0,1,0,CVariable::kDefaultBC)-OMTOTBIO.Value(p) ) )/OMTOTBIO.Value(p) ) ) ) ;
			FOOD_X_E.Update( p, value );
		}
		FOOD_X_E.GrabMemory();
		if( FOOD_X_E.GetF(FLinkEdges) ) { FOOD_X_E.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( OMTOTBIO.Value() >  OMTOTBIO.Value() ) || ( OMTOTBIO.Value() <  ((float)1) ) ) ) ? ( ((float)0) ) : ( ( ( P1_TRAVEL_TIME.Value()*( OMTOTBIO.Value()-OMTOTBIO.Value() ) )/OMTOTBIO.Value() ) ) ) ;
			FOOD_X_E.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::FOOD_X_N_u25_exe() {
	float value;

	switch( FOOD_X_N.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FOOD_X_N.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( OMTOTBIO.Value(p) >  OMTOTBIO.RelValue(p,-1,0,0,CVariable::kDefaultBC) ) || ( OMTOTBIO.Value(p) <  ((float)1) ) ) ) ? ( ((float)0) ) : ( ( ( P1_TRAVEL_TIME.Value(p)*( OMTOTBIO.RelValue(p,-1,0,0,CVariable::kDefaultBC)-OMTOTBIO.Value(p) ) )/OMTOTBIO.Value(p) ) ) ) ;
			FOOD_X_N.Update( p, value );
		}
		FOOD_X_N.GrabMemory();
		if( FOOD_X_N.GetF(FLinkEdges) ) { FOOD_X_N.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( OMTOTBIO.Value() >  OMTOTBIO.Value() ) || ( OMTOTBIO.Value() <  ((float)1) ) ) ) ? ( ((float)0) ) : ( ( ( P1_TRAVEL_TIME.Value()*( OMTOTBIO.Value()-OMTOTBIO.Value() ) )/OMTOTBIO.Value() ) ) ) ;
			FOOD_X_N.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::FOOD_X_S_u26_exe() {
	float value;

	switch( FOOD_X_S.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FOOD_X_S.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( OMTOTBIO.Value(p) >  OMTOTBIO.RelValue(p,1,0,0,CVariable::kDefaultBC) ) || ( OMTOTBIO.Value(p) <  ((float)1) ) ) ) ? ( ((float)0) ) : ( ( ( P1_TRAVEL_TIME.Value(p)*( OMTOTBIO.RelValue(p,1,0,0,CVariable::kDefaultBC)-OMTOTBIO.Value(p) ) )/OMTOTBIO.Value(p) ) ) ) ;
			FOOD_X_S.Update( p, value );
		}
		FOOD_X_S.GrabMemory();
		if( FOOD_X_S.GetF(FLinkEdges) ) { FOOD_X_S.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( OMTOTBIO.Value() >  OMTOTBIO.Value() ) || ( OMTOTBIO.Value() <  ((float)1) ) ) ) ? ( ((float)0) ) : ( ( ( P1_TRAVEL_TIME.Value()*( OMTOTBIO.Value()-OMTOTBIO.Value() ) )/OMTOTBIO.Value() ) ) ) ;
			FOOD_X_S.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::FOOD_X_W_u27_exe() {
	float value;

	switch( FOOD_X_W.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FOOD_X_W.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( OMTOTBIO.Value(p) >  OMTOTBIO.RelValue(p,0,-1,0,CVariable::kDefaultBC) ) || ( OMTOTBIO.Value(p) <  ((float)1) ) ) ) ? ( ((float)0) ) : ( ( ( P1_TRAVEL_TIME.Value(p)*( OMTOTBIO.RelValue(p,0,-1,0,CVariable::kDefaultBC)-OMTOTBIO.Value(p) ) )/OMTOTBIO.Value(p) ) ) ) ;
			FOOD_X_W.Update( p, value );
		}
		FOOD_X_W.GrabMemory();
		if( FOOD_X_W.GetF(FLinkEdges) ) { FOOD_X_W.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( OMTOTBIO.Value() >  OMTOTBIO.Value() ) || ( OMTOTBIO.Value() <  ((float)1) ) ) ) ? ( ((float)0) ) : ( ( ( P1_TRAVEL_TIME.Value()*( OMTOTBIO.Value()-OMTOTBIO.Value() ) )/OMTOTBIO.Value() ) ) ) ;
			FOOD_X_W.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::IC_CONSUMER_u28_exe() {
	float value;

	switch( IC_CONSUMER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = IC_CONSUMER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_IC_MAC_PHBIO.Value(p)/P1_SEPT_TO_JAN_CONV.Value(p) )*.01 );
			IC_CONSUMER.Update( p, value );
		}
		IC_CONSUMER.GrabMemory();
		if( IC_CONSUMER.GetF(FLinkEdges) ) { IC_CONSUMER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_IC_MAC_PHBIO.Value()/P1_SEPT_TO_JAN_CONV.Value() )*.01 );
			IC_CONSUMER.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::OMTOTBIO_u29_exe() {
	float value;

	switch( OMTOTBIO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = OMTOTBIO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( PHYTOPLANKTON.Value(p)+SHOOTS.Value(p) )+ROOTSRHY.Value(p) )+EPIPHYTES.Value(p) )+SEAWEEDS.Value(p) )+WRACK.Value(p) );
			OMTOTBIO.Update( p, value );
		}
		OMTOTBIO.GrabMemory();
		if( OMTOTBIO.GetF(FLinkEdges) ) { OMTOTBIO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( PHYTOPLANKTON.Value()+SHOOTS.Value() )+ROOTSRHY.Value() )+EPIPHYTES.Value() )+SEAWEEDS.Value() )+WRACK.Value() );
			OMTOTBIO.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::PREF_TOT_u30_exe() {
	float value;

	switch( PREF_TOT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PREF_TOT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( P1_EP_PREF.Value(p)+P1_PH_PREF.Value(p) )+P1_RR_PREF.Value(p) )+P1_SH_PREF.Value(p) )+P1_SW_PREF.Value(p) )+P1_WR_PREF.Value(p) );
			PREF_TOT.Update( p, value );
		}
		PREF_TOT.GrabMemory();
		if( PREF_TOT.GetF(FLinkEdges) ) { PREF_TOT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( P1_EP_PREF.Value()+P1_PH_PREF.Value() )+P1_RR_PREF.Value() )+P1_SH_PREF.Value() )+P1_SW_PREF.Value() )+P1_WR_PREF.Value() );
			PREF_TOT.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::RIVER_CON_u31_exe() {
	float value;

	switch( RIVER_CON.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = RIVER_CON.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0;
			RIVER_CON.Update( p, RIVER_CON.ParameterValue(value,p) );
		}
		RIVER_CON.GrabMemory();
		if( RIVER_CON.GetF(FLinkEdges) ) { RIVER_CON.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0;
			RIVER_CON.Update( RIVER_CON.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::VEG_STRUCTURE_u32_exe() {
	float value;

	switch( VEG_STRUCTURE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = VEG_STRUCTURE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_VEG_DENS_COEFF.Value(p)/P1_CELL_SIZE.Value(p) )*( ( ( SHOOTS.Value(p)+ROOTSRHY.Value(p) )+SEAWEEDS.Value(p) )+EPIPHYTES.Value(p) ) );
			VEG_STRUCTURE.Update( p, value );
		}
		VEG_STRUCTURE.GrabMemory();
		if( VEG_STRUCTURE.GetF(FLinkEdges) ) { VEG_STRUCTURE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_VEG_DENS_COEFF.Value()/P1_CELL_SIZE.Value() )*( ( ( SHOOTS.Value()+ROOTSRHY.Value() )+SEAWEEDS.Value() )+EPIPHYTES.Value() ) );
			VEG_STRUCTURE.Update( value );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::P1_CONS_NC_u33_exe() {
	float value;

	switch( P1_CONS_NC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_CONS_NC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.010000;
			P1_CONS_NC.Update( p, P1_CONS_NC.ParameterValue(value,p) );
		}
		P1_CONS_NC.GrabMemory();
		if( P1_CONS_NC.GetF(FLinkEdges) ) { P1_CONS_NC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.010000;
			P1_CONS_NC.Update( P1_CONS_NC.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::P1_CONS_PC_u34_exe() {
	float value;

	switch( P1_CONS_PC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_CONS_PC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.005000;
			P1_CONS_PC.Update( p, P1_CONS_PC.ParameterValue(value,p) );
		}
		P1_CONS_PC.GrabMemory();
		if( P1_CONS_PC.GetF(FLinkEdges) ) { P1_CONS_PC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.005000;
			P1_CONS_PC.Update( P1_CONS_PC.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::P1_C_EGEST_EFF_u35_exe() {
	float value;

	switch( P1_C_EGEST_EFF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_EGEST_EFF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.750000;
			P1_C_EGEST_EFF.Update( p, P1_C_EGEST_EFF.ParameterValue(value,p) );
		}
		P1_C_EGEST_EFF.GrabMemory();
		if( P1_C_EGEST_EFF.GetF(FLinkEdges) ) { P1_C_EGEST_EFF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.750000;
			P1_C_EGEST_EFF.Update( P1_C_EGEST_EFF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::P1_C_MORT_RT_u36_exe() {
	float value;

	switch( P1_C_MORT_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_MORT_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000042;
			P1_C_MORT_RT.Update( p, P1_C_MORT_RT.ParameterValue(value,p) );
		}
		P1_C_MORT_RT.GrabMemory();
		if( P1_C_MORT_RT.GetF(FLinkEdges) ) { P1_C_MORT_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000042;
			P1_C_MORT_RT.Update( P1_C_MORT_RT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::P1_C_RESP_RT_u37_exe() {
	float value;

	switch( P1_C_RESP_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_C_RESP_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000012;
			P1_C_RESP_RT.Update( p, P1_C_RESP_RT.ParameterValue(value,p) );
		}
		P1_C_RESP_RT.GrabMemory();
		if( P1_C_RESP_RT.GetF(FLinkEdges) ) { P1_C_RESP_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000012;
			P1_C_RESP_RT.Update( P1_C_RESP_RT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::P1_EP_PREF_u38_exe() {
	float value;

	switch( P1_EP_PREF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_EP_PREF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  7;
			P1_EP_PREF.Update( p, P1_EP_PREF.ParameterValue(value,p) );
		}
		P1_EP_PREF.GrabMemory();
		if( P1_EP_PREF.GetF(FLinkEdges) ) { P1_EP_PREF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  7;
			P1_EP_PREF.Update( P1_EP_PREF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::P1_INGESTION_RT_u39_exe() {
	float value;

	switch( P1_INGESTION_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_INGESTION_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000125;
			P1_INGESTION_RT.Update( p, P1_INGESTION_RT.ParameterValue(value,p) );
		}
		P1_INGESTION_RT.GrabMemory();
		if( P1_INGESTION_RT.GetF(FLinkEdges) ) { P1_INGESTION_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000125;
			P1_INGESTION_RT.Update( P1_INGESTION_RT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::P1_PH_PREF_u40_exe() {
	float value;

	switch( P1_PH_PREF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PH_PREF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  7;
			P1_PH_PREF.Update( p, P1_PH_PREF.ParameterValue(value,p) );
		}
		P1_PH_PREF.GrabMemory();
		if( P1_PH_PREF.GetF(FLinkEdges) ) { P1_PH_PREF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  7;
			P1_PH_PREF.Update( P1_PH_PREF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::P1_RR_PREF_u41_exe() {
	float value;

	switch( P1_RR_PREF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_RR_PREF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_RR_PREF.Update( p, P1_RR_PREF.ParameterValue(value,p) );
		}
		P1_RR_PREF.GrabMemory();
		if( P1_RR_PREF.GetF(FLinkEdges) ) { P1_RR_PREF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_RR_PREF.Update( P1_RR_PREF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::P1_SH_PREF_u42_exe() {
	float value;

	switch( P1_SH_PREF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SH_PREF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  2;
			P1_SH_PREF.Update( p, P1_SH_PREF.ParameterValue(value,p) );
		}
		P1_SH_PREF.GrabMemory();
		if( P1_SH_PREF.GetF(FLinkEdges) ) { P1_SH_PREF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  2;
			P1_SH_PREF.Update( P1_SH_PREF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::P1_SW_PREF_u43_exe() {
	float value;

	switch( P1_SW_PREF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SW_PREF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  7;
			P1_SW_PREF.Update( p, P1_SW_PREF.ParameterValue(value,p) );
		}
		P1_SW_PREF.GrabMemory();
		if( P1_SW_PREF.GetF(FLinkEdges) ) { P1_SW_PREF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  7;
			P1_SW_PREF.Update( P1_SW_PREF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::P1_TRAVEL_TIME_u44_exe() {
	float value;

	switch( P1_TRAVEL_TIME.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_TRAVEL_TIME.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.001250;
			P1_TRAVEL_TIME.Update( p, P1_TRAVEL_TIME.ParameterValue(value,p) );
		}
		P1_TRAVEL_TIME.GrabMemory();
		if( P1_TRAVEL_TIME.GetF(FLinkEdges) ) { P1_TRAVEL_TIME.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.001250;
			P1_TRAVEL_TIME.Update( P1_TRAVEL_TIME.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::P1_VEG_DENS_COEFF_u45_exe() {
	float value;

	switch( P1_VEG_DENS_COEFF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_VEG_DENS_COEFF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.100000;
			P1_VEG_DENS_COEFF.Update( p, P1_VEG_DENS_COEFF.ParameterValue(value,p) );
		}
		P1_VEG_DENS_COEFF.GrabMemory();
		if( P1_VEG_DENS_COEFF.GetF(FLinkEdges) ) { P1_VEG_DENS_COEFF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.100000;
			P1_VEG_DENS_COEFF.Update( P1_VEG_DENS_COEFF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::P1_WR_PREF_u46_exe() {
	float value;

	switch( P1_WR_PREF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_WR_PREF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_WR_PREF.Update( p, P1_WR_PREF.ParameterValue(value,p) );
		}
		P1_WR_PREF.GrabMemory();
		if( P1_WR_PREF.GetF(FLinkEdges) ) { P1_WR_PREF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_WR_PREF.Update( P1_WR_PREF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int CONSUMERS_module::CONS_ACTIVITY_u47_exe() {
	float value;

	switch( CONS_ACTIVITY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CONS_ACTIVITY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph0(H2O_TEMP.Value(p));
			CONS_ACTIVITY.Update( p, value );
		}
		CONS_ACTIVITY.GrabMemory();
		if( CONS_ACTIVITY.GetF(FLinkEdges) ) { CONS_ACTIVITY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph0(H2O_TEMP.Value());
			CONS_ACTIVITY.Update( value );
	  } break;
	}
	return 0;
}

CONSUMERS_module* CONSUMERS_module::fInstance = NULL;
CONSUMERS_module* CONSUMERS_module::kNullModel = (CONSUMERS_module*)0x1;
int CONSUMERS_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int CONSUMERS_module::InitVars() {
	
	TIME.SSInit(this);
	P1_CELL_SIZE.SSInit(this);
	EPIPHYTES.SSInit(this);
	ROOTSRHY.SSInit(this);
	SHOOTS.SSInit(this);
	PHYTOPLANKTON.SSInit(this);
	SEAWEEDS.SSInit(this);
	WRACK.SSInit(this);
	P1_IC_MAC_PHBIO.SSInit(this);
	P1_SEPT_TO_JAN_CONV.SSInit(this);
	H2O_TEMP.SSInit(this);
	CONS_EGEST.SSInit(this);
	CONS_EGEST.SetOrigin(&CONSUMERS);
	CONS_INGEST_WR.SSInit(this);
	CONS_INGEST_NPHBIO.SSInit(this);
	CONS_INGEST_PHBIO.SSInit(this);
	CONS_INGEST_EPI.SSInit(this);
	CONS_INGEST_PHT.SSInit(this);
	CONS_INGEST_SW.SSInit(this);
	VEG_STRUCTURE.SSInit(this);
	CONSUMERS.SSInit(this);
	CONS_INGEST.SSInit(this);
	CONS_INGEST.SetDestination(&CONSUMERS);
	CONS_IN_X.SSInit(this);
	CONS_IN_X.SetDestination(&CONSUMERS);
	CONS_MORTALITY.SSInit(this);
	CONS_MORTALITY.SetOrigin(&CONSUMERS);
	CONS_RESPIRATION.SSInit(this);
	CONS_RESPIRATION.SetOrigin(&CONSUMERS);
	CONS_OUT_X.SSInit(this);
	CONS_OUT_X.SetOrigin(&CONSUMERS);
	CONSDENS.SSInit(this);
	CONSDENS.SetLinkEdges();
	CONSTOE.SSInit(this);
	CONSTOE.SetLinkEdges();
	CONSTON.SSInit(this);
	CONSTON.SetLinkEdges();
	CONSTOS.SSInit(this);
	CONSTOS.SetLinkEdges();
	CONSTOW.SSInit(this);
	CONSTOW.SetLinkEdges();
	CON_POT_INGEST.SSInit(this);
	DENSITY_X_E.SSInit(this);
	DENSITY_X_N.SSInit(this);
	DENSITY_X_S.SSInit(this);
	DENSITY_X_W.SSInit(this);
	FOOD_X_E.SSInit(this);
	FOOD_X_N.SSInit(this);
	FOOD_X_S.SSInit(this);
	FOOD_X_W.SSInit(this);
	IC_CONSUMER.SSInit(this);
	OMTOTBIO.SSInit(this);
	OMTOTBIO.SetLinkEdges();
	PREF_TOT.SSInit(this);
	RIVER_CON.SSInit(this);
	P1_CONS_NC.SSInit(this);
	P1_CONS_PC.SSInit(this);
	P1_C_EGEST_EFF.SSInit(this);
	P1_C_MORT_RT.SSInit(this);
	P1_C_RESP_RT.SSInit(this);
	P1_EP_PREF.SSInit(this);
	P1_INGESTION_RT.SSInit(this);
	P1_PH_PREF.SSInit(this);
	P1_RR_PREF.SSInit(this);
	P1_SH_PREF.SSInit(this);
	P1_SW_PREF.SSInit(this);
	P1_TRAVEL_TIME.SSInit(this);
	P1_VEG_DENS_COEFF.SSInit(this);
	P1_WR_PREF.SSInit(this);
	CONS_ACTIVITY.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int CONSUMERS_module::SetupEvents() {
	TImportCommand* P1_CELL_SIZE_import = (TImportCommand*) P1_CELL_SIZE.GetCommand("P1_CELL_SIZE_import",TCommand::kUndefined,TCommand::kImport);
	P1_CELL_SIZE_import->Code() = "Import P1_CELL_SIZE from GLOBAL_module";
	P1_CELL_SIZE_import->AddDependency(P1_CELL_SIZE);
	P1_CELL_SIZE_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* EPIPHYTES_import = (TImportCommand*) EPIPHYTES.GetCommand("EPIPHYTES_import",TCommand::kUndefined,TCommand::kImport);
	EPIPHYTES_import->Code() = "Import EPIPHYTES from EPIPHYTES_module";
	EPIPHYTES_import->AddDependency(EPIPHYTES);
	EPIPHYTES_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ROOTSRHY_import = (TImportCommand*) ROOTSRHY.GetCommand("ROOTSRHY_import",TCommand::kUndefined,TCommand::kImport);
	ROOTSRHY_import->Code() = "Import ROOTSRHY from EELGRASS_module";
	ROOTSRHY_import->AddDependency(ROOTSRHY);
	ROOTSRHY_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SHOOTS_import = (TImportCommand*) SHOOTS.GetCommand("SHOOTS_import",TCommand::kUndefined,TCommand::kImport);
	SHOOTS_import->Code() = "Import SHOOTS from EELGRASS_module";
	SHOOTS_import->AddDependency(SHOOTS);
	SHOOTS_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PHYTOPLANKTON_import = (TImportCommand*) PHYTOPLANKTON.GetCommand("PHYTOPLANKTON_import",TCommand::kUndefined,TCommand::kImport);
	PHYTOPLANKTON_import->Code() = "Import PHYTOPLANKTON from PHYTOPLANKTON_module";
	PHYTOPLANKTON_import->AddDependency(PHYTOPLANKTON);
	PHYTOPLANKTON_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SEAWEEDS_import = (TImportCommand*) SEAWEEDS.GetCommand("SEAWEEDS_import",TCommand::kUndefined,TCommand::kImport);
	SEAWEEDS_import->Code() = "Import SEAWEEDS from SEAWEED_module";
	SEAWEEDS_import->AddDependency(SEAWEEDS);
	SEAWEEDS_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* WRACK_import = (TImportCommand*) WRACK.GetCommand("WRACK_import",TCommand::kUndefined,TCommand::kImport);
	WRACK_import->Code() = "Import WRACK from DETRITUS_module";
	WRACK_import->AddDependency(WRACK);
	WRACK_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_IC_MAC_PHBIO_import = (TImportCommand*) P1_IC_MAC_PHBIO.GetCommand("P1_IC_MAC_PHBIO_import",TCommand::kUndefined,TCommand::kImport);
	P1_IC_MAC_PHBIO_import->Code() = "Import P1_IC_MAC_PHBIO from EELGRASS_module";
	P1_IC_MAC_PHBIO_import->AddDependency(P1_IC_MAC_PHBIO);
	P1_IC_MAC_PHBIO_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_SEPT_TO_JAN_CONV_import = (TImportCommand*) P1_SEPT_TO_JAN_CONV.GetCommand("P1_SEPT_TO_JAN_CONV_import",TCommand::kUndefined,TCommand::kImport);
	P1_SEPT_TO_JAN_CONV_import->Code() = "Import P1_SEPT_TO_JAN_CONV from EELGRASS_module";
	P1_SEPT_TO_JAN_CONV_import->AddDependency(P1_SEPT_TO_JAN_CONV);
	P1_SEPT_TO_JAN_CONV_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* H2O_TEMP_import = (TImportCommand*) H2O_TEMP.GetCommand("H2O_TEMP_import",TCommand::kUndefined,TCommand::kImport);
	H2O_TEMP_import->Code() = "Import H2O_TEMP from GLOBAL_module";
	H2O_TEMP_import->AddDependency(H2O_TEMP);
	H2O_TEMP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u4 = (TExecuteCommand*) CONS_EGEST.GetCommand("u4",TCommand::kUpdate,TCommand::kCode);
	u4->SetExecutable(&CONS_EGEST_u4_exe_g);
	u4->Code() = "u4 <- ( CONS_INGEST*P1_C_EGEST_EFF )";
	if( CONS_EGEST.GetF(FisClamped) ) { u4->AddDependency(CONSUMERS); }
	u4->AddDependency(CONS_INGEST);
	u4->AddDependency(P1_C_EGEST_EFF);
	u4->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u18 = (TExecuteCommand*) CONS_INGEST_WR.GetCommand("u18",TCommand::kUpdate,TCommand::kCode);
	u18->SetExecutable(&CONS_INGEST_WR_u18_exe_g);
	u18->Code() = "u18 <- SL::Min(WRACK, ( ( P1_WR_PREF/PREF_TOT )*CON_POT_INGEST ))";
	u18->AddDependency(WRACK);
	u18->AddDependency(P1_WR_PREF);
	u18->AddDependency(PREF_TOT);
	u18->AddDependency(CON_POT_INGEST);
	u18->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u14 = (TExecuteCommand*) CONS_INGEST_NPHBIO.GetCommand("u14",TCommand::kUpdate,TCommand::kCode);
	u14->SetExecutable(&CONS_INGEST_NPHBIO_u14_exe_g);
	u14->Code() = "u14 <- SL::Min(ROOTSRHY, ( ( P1_RR_PREF/PREF_TOT )*CON_POT_INGEST ))";
	u14->AddDependency(ROOTSRHY);
	u14->AddDependency(P1_RR_PREF);
	u14->AddDependency(PREF_TOT);
	u14->AddDependency(CON_POT_INGEST);
	u14->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u15 = (TExecuteCommand*) CONS_INGEST_PHBIO.GetCommand("u15",TCommand::kUpdate,TCommand::kCode);
	u15->SetExecutable(&CONS_INGEST_PHBIO_u15_exe_g);
	u15->Code() = "u15 <- SL::Min(SHOOTS, ( ( P1_SH_PREF/PREF_TOT )*CON_POT_INGEST ))";
	u15->AddDependency(SHOOTS);
	u15->AddDependency(P1_SH_PREF);
	u15->AddDependency(PREF_TOT);
	u15->AddDependency(CON_POT_INGEST);
	u15->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u13 = (TExecuteCommand*) CONS_INGEST_EPI.GetCommand("u13",TCommand::kUpdate,TCommand::kCode);
	u13->SetExecutable(&CONS_INGEST_EPI_u13_exe_g);
	u13->Code() = "u13 <-  ( ( ( EPIPHYTES <  ((float)1) ) ) ? ( ((float)0) ) : ( SL::Min(EPIPHYTES, ( ( P1_EP_PREF/PREF_TOT )*CON_POT_INGEST )) ) ) ";
	u13->AddDependency(EPIPHYTES);
	u13->AddDependency(P1_EP_PREF);
	u13->AddDependency(PREF_TOT);
	u13->AddDependency(CON_POT_INGEST);
	u13->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u16 = (TExecuteCommand*) CONS_INGEST_PHT.GetCommand("u16",TCommand::kUpdate,TCommand::kCode);
	u16->SetExecutable(&CONS_INGEST_PHT_u16_exe_g);
	u16->Code() = "u16 <- SL::Min(PHYTOPLANKTON, ( ( P1_PH_PREF/PREF_TOT )*CON_POT_INGEST ))";
	u16->AddDependency(PHYTOPLANKTON);
	u16->AddDependency(P1_PH_PREF);
	u16->AddDependency(PREF_TOT);
	u16->AddDependency(CON_POT_INGEST);
	u16->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u17 = (TExecuteCommand*) CONS_INGEST_SW.GetCommand("u17",TCommand::kUpdate,TCommand::kCode);
	u17->SetExecutable(&CONS_INGEST_SW_u17_exe_g);
	u17->Code() = "u17 <- SL::Min(SEAWEEDS, ( ( P1_SW_PREF/PREF_TOT )*CON_POT_INGEST ))";
	u17->AddDependency(SEAWEEDS);
	u17->AddDependency(P1_SW_PREF);
	u17->AddDependency(PREF_TOT);
	u17->AddDependency(CON_POT_INGEST);
	u17->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u32 = (TExecuteCommand*) VEG_STRUCTURE.GetCommand("u32",TCommand::kUpdate,TCommand::kCode);
	u32->SetExecutable(&VEG_STRUCTURE_u32_exe_g);
	u32->Code() = "u32 <- ( ( P1_VEG_DENS_COEFF/P1_CELL_SIZE )*( ( ( SHOOTS+ROOTSRHY )+SEAWEEDS )+EPIPHYTES ) )";
	u32->AddDependency(P1_VEG_DENS_COEFF);
	u32->AddDependency(P1_CELL_SIZE);
	u32->AddDependency(SHOOTS);
	u32->AddDependency(ROOTSRHY);
	u32->AddDependency(SEAWEEDS);
	u32->AddDependency(EPIPHYTES);
	u32->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I0 = (TExecuteCommand*) CONSUMERS.GetCommand("I0",TCommand::kIntegrate,TCommand::kCode);
	I0->SetExecutable(&CONSUMERS_I0_exe_g);
	I0->Code() = "I0 <- ( ( ( ( ( CONS_INGEST+CONS_IN_X )-CONS_EGEST )-CONS_MORTALITY )-CONS_RESPIRATION )-CONS_OUT_X )";
	I0->AddDependency(CONS_INGEST);
	I0->AddDependency(CONS_IN_X);
	I0->AddDependency(CONS_EGEST);
	I0->AddDependency(CONS_MORTALITY);
	I0->AddDependency(CONS_RESPIRATION);
	I0->AddDependency(CONS_OUT_X);
	I0->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i1 = (TExecuteCommand*) CONSUMERS.GetCommand("i1",TCommand::kInit,TCommand::kCode);
	i1->SetExecutable(&CONSUMERS_i1_exe_g);
	i1->Code() = "i1 <- ( IC_CONSUMER*P1_CELL_SIZE )";
	i1->AddDependency(IC_CONSUMER);
	i1->AddDependency(P1_CELL_SIZE);
	i1->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u2 = (TExecuteCommand*) CONS_INGEST.GetCommand("u2",TCommand::kUpdate,TCommand::kCode);
	u2->SetExecutable(&CONS_INGEST_u2_exe_g);
	u2->Code() = "u2 <- ( ( ( ( ( CONS_INGEST_EPI+CONS_INGEST_NPHBIO )+CONS_INGEST_PHBIO )+CONS_INGEST_PHT )+CONS_INGEST_SW )+CONS_INGEST_WR )";
	u2->AddDependency(CONS_INGEST_EPI);
	u2->AddDependency(CONS_INGEST_NPHBIO);
	u2->AddDependency(CONS_INGEST_PHBIO);
	u2->AddDependency(CONS_INGEST_PHT);
	u2->AddDependency(CONS_INGEST_SW);
	u2->AddDependency(CONS_INGEST_WR);
	u2->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u3 = (TExecuteCommand*) CONS_IN_X.GetCommand("u3",TCommand::kUpdate,TCommand::kCode);
	u3->SetExecutable(&CONS_IN_X_u3_exe_g);
	u3->Code() = "u3 <- ( ( ( CONSTOE@(0,-1,0)+CONSTON@(1,0,0) )+CONSTOS@(-1,0,0) )+CONSTOW@(0,1,0) )";
	u3->AddDependency(CONSTOE,"0,-1,0");
	u3->AddDependency(CONSTON,"1,0,0");
	u3->AddDependency(CONSTOS,"-1,0,0");
	u3->AddDependency(CONSTOW,"0,1,0");
	u3->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u5 = (TExecuteCommand*) CONS_MORTALITY.GetCommand("u5",TCommand::kUpdate,TCommand::kCode);
	u5->SetExecutable(&CONS_MORTALITY_u5_exe_g);
	u5->Code() = "u5 <- ( CONSUMERS*( P1_C_MORT_RT*dT() ) )";
	if( CONS_MORTALITY.GetF(FisClamped) ) { u5->AddDependency(CONSUMERS); }
	u5->AddDependency(CONSUMERS);
	u5->AddDependency(P1_C_MORT_RT);
	u5->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u6 = (TExecuteCommand*) CONS_RESPIRATION.GetCommand("u6",TCommand::kUpdate,TCommand::kCode);
	u6->SetExecutable(&CONS_RESPIRATION_u6_exe_g);
	u6->Code() = "u6 <- ( ( CONSUMERS*CONS_ACTIVITY )*( P1_C_RESP_RT*dT() ) )";
	if( CONS_RESPIRATION.GetF(FisClamped) ) { u6->AddDependency(CONSUMERS); }
	u6->AddDependency(CONSUMERS);
	u6->AddDependency(CONS_ACTIVITY);
	u6->AddDependency(P1_C_RESP_RT);
	u6->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u7 = (TExecuteCommand*) CONS_OUT_X.GetCommand("u7",TCommand::kUpdate,TCommand::kCode);
	u7->SetExecutable(&CONS_OUT_X_u7_exe_g);
	u7->Code() = "u7 <- ( ( ( CONSTOE+CONSTON )+CONSTOS )+CONSTOW )";
	if( CONS_OUT_X.GetF(FisClamped) ) { u7->AddDependency(CONSUMERS); }
	u7->AddDependency(CONSTOE);
	u7->AddDependency(CONSTON);
	u7->AddDependency(CONSTOS);
	u7->AddDependency(CONSTOW);
	u7->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u8 = (TExecuteCommand*) CONSDENS.GetCommand("u8",TCommand::kUpdate,TCommand::kCode);
	u8->SetExecutable(&CONSDENS_u8_exe_g);
	u8->Code() = "u8 <- ( ( RIVER_CON+CONSUMERS )/P1_CELL_SIZE )";
	u8->AddDependency(RIVER_CON);
	u8->AddDependency(CONSUMERS);
	u8->AddDependency(P1_CELL_SIZE);
	u8->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u9 = (TExecuteCommand*) CONSTOE.GetCommand("u9",TCommand::kUpdate,TCommand::kCode);
	u9->SetExecutable(&CONSTOE_u9_exe_g);
	u9->Code() = "u9 <-  ( ( ( ( DENSITY_X_E+FOOD_X_E ) >  ((float)1) ) ) ? ( CONSUMERS ) : ( ( ( DENSITY_X_E+FOOD_X_E )*CONSUMERS ) ) ) ";
	u9->AddDependency(DENSITY_X_E);
	u9->AddDependency(FOOD_X_E);
	u9->AddDependency(CONSUMERS);
	u9->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u10 = (TExecuteCommand*) CONSTON.GetCommand("u10",TCommand::kUpdate,TCommand::kCode);
	u10->SetExecutable(&CONSTON_u10_exe_g);
	u10->Code() = "u10 <-  ( ( ( ( DENSITY_X_N+FOOD_X_N ) >  ((float)1) ) ) ? ( CONSUMERS ) : ( ( ( DENSITY_X_N+FOOD_X_N )*CONSUMERS ) ) ) ";
	u10->AddDependency(DENSITY_X_N);
	u10->AddDependency(FOOD_X_N);
	u10->AddDependency(CONSUMERS);
	u10->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u11 = (TExecuteCommand*) CONSTOS.GetCommand("u11",TCommand::kUpdate,TCommand::kCode);
	u11->SetExecutable(&CONSTOS_u11_exe_g);
	u11->Code() = "u11 <-  ( ( ( ( DENSITY_X_S+FOOD_X_S ) >  ((float)1) ) ) ? ( CONSUMERS ) : ( ( ( DENSITY_X_S+FOOD_X_S )*CONSUMERS ) ) ) ";
	u11->AddDependency(DENSITY_X_S);
	u11->AddDependency(FOOD_X_S);
	u11->AddDependency(CONSUMERS);
	u11->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u12 = (TExecuteCommand*) CONSTOW.GetCommand("u12",TCommand::kUpdate,TCommand::kCode);
	u12->SetExecutable(&CONSTOW_u12_exe_g);
	u12->Code() = "u12 <-  ( ( ( ( DENSITY_X_W+FOOD_X_W ) >  ((float)1) ) ) ? ( CONSUMERS ) : ( ( ( DENSITY_X_W+FOOD_X_W )*CONSUMERS ) ) ) ";
	u12->AddDependency(DENSITY_X_W);
	u12->AddDependency(FOOD_X_W);
	u12->AddDependency(CONSUMERS);
	u12->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u19 = (TExecuteCommand*) CON_POT_INGEST.GetCommand("u19",TCommand::kUpdate,TCommand::kCode);
	u19->SetExecutable(&CON_POT_INGEST_u19_exe_g);
	u19->Code() = "u19 <- SL::Min(OMTOTBIO, ( ( P1_INGESTION_RT*CONS_ACTIVITY )*CONSUMERS ))";
	u19->AddDependency(OMTOTBIO);
	u19->AddDependency(P1_INGESTION_RT);
	u19->AddDependency(CONS_ACTIVITY);
	u19->AddDependency(CONSUMERS);
	u19->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u20 = (TExecuteCommand*) DENSITY_X_E.GetCommand("u20",TCommand::kUpdate,TCommand::kCode);
	u20->SetExecutable(&DENSITY_X_E_u20_exe_g);
	u20->Code() = "u20 <-  ( ( ( ( CONSDENS <  CONSDENS@(0,1,0) ) || ( CONSDENS <  ((float)1) ) ) ) ? ( ((float)0) ) : ( ( ( P1_TRAVEL_TIME*( CONSDENS-CONSDENS@(0,1,0) ) )/CONSDENS ) ) ) ";
	u20->AddDependency(CONSDENS);
	u20->AddDependency(P1_TRAVEL_TIME);
	u20->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u21 = (TExecuteCommand*) DENSITY_X_N.GetCommand("u21",TCommand::kUpdate,TCommand::kCode);
	u21->SetExecutable(&DENSITY_X_N_u21_exe_g);
	u21->Code() = "u21 <-  ( ( ( ( CONSDENS <  CONSDENS@(-1,0,0) ) || ( CONSDENS <  ((float)1) ) ) ) ? ( ((float)0) ) : ( ( ( P1_TRAVEL_TIME*( CONSDENS-CONSDENS@(-1,0,0) ) )/CONSDENS ) ) ) ";
	u21->AddDependency(CONSDENS);
	u21->AddDependency(P1_TRAVEL_TIME);
	u21->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u22 = (TExecuteCommand*) DENSITY_X_S.GetCommand("u22",TCommand::kUpdate,TCommand::kCode);
	u22->SetExecutable(&DENSITY_X_S_u22_exe_g);
	u22->Code() = "u22 <-  ( ( ( ( CONSDENS <  CONSDENS@(1,0,0) ) || ( CONSDENS <  ((float)1) ) ) ) ? ( ((float)0) ) : ( ( ( P1_TRAVEL_TIME*( CONSDENS-CONSDENS@(1,0,0) ) )/CONSDENS ) ) ) ";
	u22->AddDependency(CONSDENS);
	u22->AddDependency(P1_TRAVEL_TIME);
	u22->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u23 = (TExecuteCommand*) DENSITY_X_W.GetCommand("u23",TCommand::kUpdate,TCommand::kCode);
	u23->SetExecutable(&DENSITY_X_W_u23_exe_g);
	u23->Code() = "u23 <-  ( ( ( ( CONSDENS <  CONSDENS@(0,-1,0) ) || ( CONSDENS <  ((float)1) ) ) ) ? ( ((float)0) ) : ( ( ( P1_TRAVEL_TIME*( CONSDENS-CONSDENS@(0,-1,0) ) )/CONSDENS ) ) ) ";
	u23->AddDependency(CONSDENS);
	u23->AddDependency(P1_TRAVEL_TIME);
	u23->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u24 = (TExecuteCommand*) FOOD_X_E.GetCommand("u24",TCommand::kUpdate,TCommand::kCode);
	u24->SetExecutable(&FOOD_X_E_u24_exe_g);
	u24->Code() = "u24 <-  ( ( ( ( OMTOTBIO >  OMTOTBIO@(0,1,0) ) || ( OMTOTBIO <  ((float)1) ) ) ) ? ( ((float)0) ) : ( ( ( P1_TRAVEL_TIME*( OMTOTBIO@(0,1,0)-OMTOTBIO ) )/OMTOTBIO ) ) ) ";
	u24->AddDependency(OMTOTBIO);
	u24->AddDependency(P1_TRAVEL_TIME);
	u24->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u25 = (TExecuteCommand*) FOOD_X_N.GetCommand("u25",TCommand::kUpdate,TCommand::kCode);
	u25->SetExecutable(&FOOD_X_N_u25_exe_g);
	u25->Code() = "u25 <-  ( ( ( ( OMTOTBIO >  OMTOTBIO@(-1,0,0) ) || ( OMTOTBIO <  ((float)1) ) ) ) ? ( ((float)0) ) : ( ( ( P1_TRAVEL_TIME*( OMTOTBIO@(-1,0,0)-OMTOTBIO ) )/OMTOTBIO ) ) ) ";
	u25->AddDependency(OMTOTBIO);
	u25->AddDependency(P1_TRAVEL_TIME);
	u25->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u26 = (TExecuteCommand*) FOOD_X_S.GetCommand("u26",TCommand::kUpdate,TCommand::kCode);
	u26->SetExecutable(&FOOD_X_S_u26_exe_g);
	u26->Code() = "u26 <-  ( ( ( ( OMTOTBIO >  OMTOTBIO@(1,0,0) ) || ( OMTOTBIO <  ((float)1) ) ) ) ? ( ((float)0) ) : ( ( ( P1_TRAVEL_TIME*( OMTOTBIO@(1,0,0)-OMTOTBIO ) )/OMTOTBIO ) ) ) ";
	u26->AddDependency(OMTOTBIO);
	u26->AddDependency(P1_TRAVEL_TIME);
	u26->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u27 = (TExecuteCommand*) FOOD_X_W.GetCommand("u27",TCommand::kUpdate,TCommand::kCode);
	u27->SetExecutable(&FOOD_X_W_u27_exe_g);
	u27->Code() = "u27 <-  ( ( ( ( OMTOTBIO >  OMTOTBIO@(0,-1,0) ) || ( OMTOTBIO <  ((float)1) ) ) ) ? ( ((float)0) ) : ( ( ( P1_TRAVEL_TIME*( OMTOTBIO@(0,-1,0)-OMTOTBIO ) )/OMTOTBIO ) ) ) ";
	u27->AddDependency(OMTOTBIO);
	u27->AddDependency(P1_TRAVEL_TIME);
	u27->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u28 = (TExecuteCommand*) IC_CONSUMER.GetCommand("u28",TCommand::kUpdate,TCommand::kCode);
	u28->SetExecutable(&IC_CONSUMER_u28_exe_g);
	u28->Code() = "u28 <- ( ( P1_IC_MAC_PHBIO/P1_SEPT_TO_JAN_CONV )*.01 )";
	u28->AddDependency(P1_IC_MAC_PHBIO);
	u28->AddDependency(P1_SEPT_TO_JAN_CONV);
	u28->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u29 = (TExecuteCommand*) OMTOTBIO.GetCommand("u29",TCommand::kUpdate,TCommand::kCode);
	u29->SetExecutable(&OMTOTBIO_u29_exe_g);
	u29->Code() = "u29 <- ( ( ( ( ( PHYTOPLANKTON+SHOOTS )+ROOTSRHY )+EPIPHYTES )+SEAWEEDS )+WRACK )";
	u29->AddDependency(PHYTOPLANKTON);
	u29->AddDependency(SHOOTS);
	u29->AddDependency(ROOTSRHY);
	u29->AddDependency(EPIPHYTES);
	u29->AddDependency(SEAWEEDS);
	u29->AddDependency(WRACK);
	u29->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u30 = (TExecuteCommand*) PREF_TOT.GetCommand("u30",TCommand::kUpdate,TCommand::kCode);
	u30->SetExecutable(&PREF_TOT_u30_exe_g);
	u30->Code() = "u30 <- ( ( ( ( ( P1_EP_PREF+P1_PH_PREF )+P1_RR_PREF )+P1_SH_PREF )+P1_SW_PREF )+P1_WR_PREF )";
	u30->AddDependency(P1_EP_PREF);
	u30->AddDependency(P1_PH_PREF);
	u30->AddDependency(P1_RR_PREF);
	u30->AddDependency(P1_SH_PREF);
	u30->AddDependency(P1_SW_PREF);
	u30->AddDependency(P1_WR_PREF);
	u30->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u31 = (TExecuteCommand*) RIVER_CON.GetCommand("u31",TCommand::kUpdate,TCommand::kCode);
	u31->SetExecutable(&RIVER_CON_u31_exe_g);
	u31->Code() = "u31 <- 0";
	u31->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u33 = (TExecuteCommand*) P1_CONS_NC.GetCommand("u33",TCommand::kUpdate,TCommand::kCode);
	u33->SetExecutable(&P1_CONS_NC_u33_exe_g);
	u33->Code() = "u33 <- 0.010000";
	u33->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u34 = (TExecuteCommand*) P1_CONS_PC.GetCommand("u34",TCommand::kUpdate,TCommand::kCode);
	u34->SetExecutable(&P1_CONS_PC_u34_exe_g);
	u34->Code() = "u34 <- 0.005000";
	u34->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u35 = (TExecuteCommand*) P1_C_EGEST_EFF.GetCommand("u35",TCommand::kUpdate,TCommand::kCode);
	u35->SetExecutable(&P1_C_EGEST_EFF_u35_exe_g);
	u35->Code() = "u35 <- 0.750000";
	u35->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u36 = (TExecuteCommand*) P1_C_MORT_RT.GetCommand("u36",TCommand::kUpdate,TCommand::kCode);
	u36->SetExecutable(&P1_C_MORT_RT_u36_exe_g);
	u36->Code() = "u36 <- 0.000042";
	u36->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u37 = (TExecuteCommand*) P1_C_RESP_RT.GetCommand("u37",TCommand::kUpdate,TCommand::kCode);
	u37->SetExecutable(&P1_C_RESP_RT_u37_exe_g);
	u37->Code() = "u37 <- 0.000012";
	u37->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u38 = (TExecuteCommand*) P1_EP_PREF.GetCommand("u38",TCommand::kUpdate,TCommand::kCode);
	u38->SetExecutable(&P1_EP_PREF_u38_exe_g);
	u38->Code() = "u38 <- 7";
	u38->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u39 = (TExecuteCommand*) P1_INGESTION_RT.GetCommand("u39",TCommand::kUpdate,TCommand::kCode);
	u39->SetExecutable(&P1_INGESTION_RT_u39_exe_g);
	u39->Code() = "u39 <- 0.000125";
	u39->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u40 = (TExecuteCommand*) P1_PH_PREF.GetCommand("u40",TCommand::kUpdate,TCommand::kCode);
	u40->SetExecutable(&P1_PH_PREF_u40_exe_g);
	u40->Code() = "u40 <- 7";
	u40->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u41 = (TExecuteCommand*) P1_RR_PREF.GetCommand("u41",TCommand::kUpdate,TCommand::kCode);
	u41->SetExecutable(&P1_RR_PREF_u41_exe_g);
	u41->Code() = "u41 <- 1";
	u41->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u42 = (TExecuteCommand*) P1_SH_PREF.GetCommand("u42",TCommand::kUpdate,TCommand::kCode);
	u42->SetExecutable(&P1_SH_PREF_u42_exe_g);
	u42->Code() = "u42 <- 2";
	u42->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u43 = (TExecuteCommand*) P1_SW_PREF.GetCommand("u43",TCommand::kUpdate,TCommand::kCode);
	u43->SetExecutable(&P1_SW_PREF_u43_exe_g);
	u43->Code() = "u43 <- 7";
	u43->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u44 = (TExecuteCommand*) P1_TRAVEL_TIME.GetCommand("u44",TCommand::kUpdate,TCommand::kCode);
	u44->SetExecutable(&P1_TRAVEL_TIME_u44_exe_g);
	u44->Code() = "u44 <- 0.001250";
	u44->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u45 = (TExecuteCommand*) P1_VEG_DENS_COEFF.GetCommand("u45",TCommand::kUpdate,TCommand::kCode);
	u45->SetExecutable(&P1_VEG_DENS_COEFF_u45_exe_g);
	u45->Code() = "u45 <- 0.100000";
	u45->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u46 = (TExecuteCommand*) P1_WR_PREF.GetCommand("u46",TCommand::kUpdate,TCommand::kCode);
	u46->SetExecutable(&P1_WR_PREF_u46_exe_g);
	u46->Code() = "u46 <- 1";
	u46->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u47 = (TExecuteCommand*) CONS_ACTIVITY.GetCommand("u47",TCommand::kUpdate,TCommand::kCode);
	u47->SetExecutable(&CONS_ACTIVITY_u47_exe_g);
	u47->Code() = "u47 <- Graph0(H2O_TEMP)";
	u47->AddDependency(H2O_TEMP);
	u47->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int CONSUMERS_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int CONSUMERS_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int CONSUMERS_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int CONSUMERS_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class DETRITUS_module 
// ---------------------------------------------------------------------------
DETRITUS_module::DETRITUS_module(char* name) :
	TIME("TIME"),
	WRACK("WRACK"),
	CONS_EGEST("CONS_EGEST"),
	P1_CELL_SIZE("P1_CELL_SIZE"),
	PHBIO_LITTERFALL("PHBIO_LITTERFALL"),
	CONS_INGEST_WR("CONS_INGEST_WR"),
	P1_ON_MAP("P1_ON_MAP"),
	P1_AIR_TEMP("P1_AIR_TEMP"),
	EW_VECTOR("EW_VECTOR"),
	EW_WIND_VECTOR("EW_WIND_VECTOR"),
	NS_VECTOR("NS_VECTOR"),
	NS_WIND_VECTOR("NS_WIND_VECTOR"),
	DAYS("DAYS"),
	WRACK_OM_DECOMP("WRACK_OM_DECOMP"),
	P1_WRACK_OM_NC("P1_WRACK_OM_NC"),
	GEMINATION("GEMINATION"),
	P1_WRACK_OM_PC("P1_WRACK_OM_PC"),
	DETRITAL_POOL("DETRITAL_POOL"),
	WRACK_SINKING("WRACK_SINKING"),
	EGESTED_MATTER("EGESTED_MATTER"),
	SEEDS("SEEDS"),
	SEED_DROP_OUT("SEED_DROP_OUT"),
	SEED_LOSS("SEED_LOSS"),
	WRACK_PRODUCED("WRACK_PRODUCED"),
	WRACK_X_IN("WRACK_X_IN"),
	WRACK_CONSUMED("WRACK_CONSUMED"),
	WRACK_X_OUT("WRACK_X_OUT"),
	DECOMP_TEMP_H2O("DECOMP_TEMP_H2O"),
	DECOMP_TEMP_N("DECOMP_TEMP_N"),
	EW_WRACK_VECTOR("EW_WRACK_VECTOR"),
	NS_WRACK_VECTOR("NS_WRACK_VECTOR"),
	SEED_GERM("SEED_GERM"),
	VECTOR_ABS_SUM("VECTOR_ABS_SUM"),
	WRACK_EXPORT_EW("WRACK_EXPORT_EW"),
	WRACK_EXPORT_NS("WRACK_EXPORT_NS"),
	WRACK_E_X("WRACK_E_X"),
	WRACK_N_X("WRACK_N_X"),
	WRACK_S_X("WRACK_S_X"),
	WRACK_W_X("WRACK_W_X"),
	P1_HALF_SAT_H2O("P1_HALF_SAT_H2O"),
	P1_HALF_SAT_N("P1_HALF_SAT_N"),
	P1_IC_WRACK("P1_IC_WRACK"),
	P1_SEED_LOSS_RT("P1_SEED_LOSS_RT"),
	P1_SEED_WGT("P1_SEED_WGT"),
	P1_SHREDDING_BY_CONS("P1_SHREDDING_BY_CONS"),
	P1_SINK_RT("P1_SINK_RT"),
	P1_WIND_WRACK_FACTOR("P1_WIND_WRACK_FACTOR"),
	SEED_PROD("SEED_PROD"),
	TModule(name) {

	WRACK.SetF(FisExport,True,"CG");
	CONS_EGEST.SetF(FisImport,True,"CG");
	P1_CELL_SIZE.SetF(FisImport,True,"CG");
	PHBIO_LITTERFALL.SetF(FisImport,True,"CG");
	CONS_INGEST_WR.SetF(FisImport,True,"CG");
	P1_ON_MAP.SetF(FisImport,True,"CG");
	P1_AIR_TEMP.SetF(FisImport,True,"CG");
	EW_VECTOR.SetF(FisImport,True,"CG");
	EW_WIND_VECTOR.SetF(FisImport,True,"CG");
	NS_VECTOR.SetF(FisImport,True,"CG");
	NS_WIND_VECTOR.SetF(FisImport,True,"CG");
	DAYS.SetF(FisImport,True,"CG");
	WRACK_OM_DECOMP.SetF(FisExport,True,"CG");
	P1_WRACK_OM_NC.SetF(FisExport,True,"CG");
	GEMINATION.SetF(FisExport,True,"CG");
	P1_WRACK_OM_PC.SetF(FisExport,True,"CG");
}	
int DETRITUS_module::DETRITAL_POOL_I48_exe() {
	float value;

	DETRITAL_POOL.UpdateIntegrator();
	switch( DETRITAL_POOL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DETRITAL_POOL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( WRACK_SINKING.Value(p)+EGESTED_MATTER.Value(p) );
			DETRITAL_POOL.Update( p, value, dT() );
		}
		DETRITAL_POOL.GrabMemory();
		if( DETRITAL_POOL.GetF(FLinkEdges) ) { DETRITAL_POOL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( WRACK_SINKING.Value()+EGESTED_MATTER.Value() );
			DETRITAL_POOL.Update( value, dT() );
	  } break;
	}
	return 0;
}

int DETRITUS_module::DETRITAL_POOL_i49_exe() {
	float value;

	DETRITAL_POOL.UpdateIntegrator();
	switch( DETRITAL_POOL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DETRITAL_POOL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			DETRITAL_POOL.InitValue( p, value );
		}
		DETRITAL_POOL.GrabMemory();
		if( DETRITAL_POOL.GetF(FLinkEdges) ) { DETRITAL_POOL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			DETRITAL_POOL.InitValue( value );
	  } break;
	}
	return 0;
}

int DETRITUS_module::WRACK_SINKING_u50_exe() {
	float value;

	switch( WRACK_SINKING.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WRACK_SINKING.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_SINK_RT.Value(p)*dT() )*WRACK.Value(p) );
			WRACK_SINKING.Update( p, value );
		}
		WRACK_SINKING.GrabMemory();
		if( WRACK_SINKING.GetF(FICFlux) ) WRACK_SINKING.Cov().Set(0.0); 
		if( WRACK_SINKING.GetF(FLinkEdges) ) { WRACK_SINKING.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_SINK_RT.Value()*dT() )*WRACK.Value() );
			WRACK_SINKING.Update( value );
	  } break;
	}
	return 0;
}

int DETRITUS_module::EGESTED_MATTER_u51_exe() {
	float value;

	switch( EGESTED_MATTER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EGESTED_MATTER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  CONS_EGEST.Value(p);
			EGESTED_MATTER.Update( p, value );
		}
		EGESTED_MATTER.GrabMemory();
		if( EGESTED_MATTER.GetF(FICFlux) ) EGESTED_MATTER.Cov().Set(0.0); 
		if( EGESTED_MATTER.GetF(FLinkEdges) ) { EGESTED_MATTER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  CONS_EGEST.Value();
			EGESTED_MATTER.Update( value );
	  } break;
	}
	return 0;
}

int DETRITUS_module::SEEDS_I52_exe() {
	float value;

	SEEDS.UpdateIntegrator();
	switch( SEEDS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SEEDS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SEED_DROP_OUT.Value(p)-GEMINATION.Value(p) )-SEED_LOSS.Value(p) );
			SEEDS.Update( p, value, dT() );
		}
		SEEDS.GrabMemory();
		if( SEEDS.GetF(FLinkEdges) ) { SEEDS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SEED_DROP_OUT.Value()-GEMINATION.Value() )-SEED_LOSS.Value() );
			SEEDS.Update( value, dT() );
	  } break;
	}
	return 0;
}

int DETRITUS_module::SEEDS_i53_exe() {
	float value;

	SEEDS.UpdateIntegrator();
	switch( SEEDS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SEEDS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			SEEDS.InitValue( p, value );
		}
		SEEDS.GrabMemory();
		if( SEEDS.GetF(FLinkEdges) ) { SEEDS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			SEEDS.InitValue( value );
	  } break;
	}
	return 0;
}

int DETRITUS_module::SEED_DROP_OUT_u54_exe() {
	float value;

	switch( SEED_DROP_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SEED_DROP_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( WRACK.Value(p)*SEED_PROD.Value(p) )*P1_SEED_WGT.Value(p) );
			SEED_DROP_OUT.Update( p, value );
		}
		SEED_DROP_OUT.GrabMemory();
		if( SEED_DROP_OUT.GetF(FICFlux) ) SEED_DROP_OUT.Cov().Set(0.0); 
		if( SEED_DROP_OUT.GetF(FLinkEdges) ) { SEED_DROP_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( WRACK.Value()*SEED_PROD.Value() )*P1_SEED_WGT.Value() );
			SEED_DROP_OUT.Update( value );
	  } break;
	}
	return 0;
}

int DETRITUS_module::GEMINATION_u55_exe() {
	float value;

	switch( GEMINATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = GEMINATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SEEDS.Value(p)*SEED_GERM.Value(p) )*((float)0) );
			GEMINATION.Update( p, value );
		}
		GEMINATION.GrabMemory();
		if( GEMINATION.GetF(FICFlux) ) GEMINATION.Cov().Set(0.0); 
		if( GEMINATION.GetF(FLinkEdges) ) { GEMINATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SEEDS.Value()*SEED_GERM.Value() )*((float)0) );
			GEMINATION.Update( value );
	  } break;
	}
	return 0;
}

int DETRITUS_module::SEED_LOSS_u56_exe() {
	float value;

	switch( SEED_LOSS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SEED_LOSS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SEEDS.Value(p)*P1_SEED_LOSS_RT.Value(p) );
			SEED_LOSS.Update( p, value );
		}
		SEED_LOSS.GrabMemory();
		if( SEED_LOSS.GetF(FICFlux) ) SEED_LOSS.Cov().Set(0.0); 
		if( SEED_LOSS.GetF(FLinkEdges) ) { SEED_LOSS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SEEDS.Value()*P1_SEED_LOSS_RT.Value() );
			SEED_LOSS.Update( value );
	  } break;
	}
	return 0;
}

int DETRITUS_module::WRACK_I57_exe() {
	float value;

	WRACK.UpdateIntegrator();
	switch( WRACK.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WRACK.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( ( WRACK_PRODUCED.Value(p)+WRACK_X_IN.Value(p) )-WRACK_CONSUMED.Value(p) )-WRACK_OM_DECOMP.Value(p) )-WRACK_X_OUT.Value(p) )-SEED_DROP_OUT.Value(p) )-WRACK_SINKING.Value(p) );
			WRACK.Update( p, value, dT() );
		}
		WRACK.GrabMemory();
		if( WRACK.GetF(FLinkEdges) ) { WRACK.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( ( WRACK_PRODUCED.Value()+WRACK_X_IN.Value() )-WRACK_CONSUMED.Value() )-WRACK_OM_DECOMP.Value() )-WRACK_X_OUT.Value() )-SEED_DROP_OUT.Value() )-WRACK_SINKING.Value() );
			WRACK.Update( value, dT() );
	  } break;
	}
	return 0;
}

int DETRITUS_module::WRACK_i58_exe() {
	float value;

	WRACK.UpdateIntegrator();
	switch( WRACK.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WRACK.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_IC_WRACK.Value(p)*P1_CELL_SIZE.Value(p) );
			WRACK.InitValue( p, value );
		}
		WRACK.GrabMemory();
		if( WRACK.GetF(FLinkEdges) ) { WRACK.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_IC_WRACK.Value()*P1_CELL_SIZE.Value() );
			WRACK.InitValue( value );
	  } break;
	}
	return 0;
}

int DETRITUS_module::WRACK_PRODUCED_u59_exe() {
	float value;

	switch( WRACK_PRODUCED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WRACK_PRODUCED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  PHBIO_LITTERFALL.Value(p);
			WRACK_PRODUCED.Update( p, value );
		}
		WRACK_PRODUCED.GrabMemory();
		if( WRACK_PRODUCED.GetF(FICFlux) ) WRACK_PRODUCED.Cov().Set(0.0); 
		if( WRACK_PRODUCED.GetF(FLinkEdges) ) { WRACK_PRODUCED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  PHBIO_LITTERFALL.Value();
			WRACK_PRODUCED.Update( value );
	  } break;
	}
	return 0;
}

int DETRITUS_module::WRACK_X_IN_u60_exe() {
	float value;

	switch( WRACK_X_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WRACK_X_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( WRACK_E_X.RelValue(p,0,-1,0,CVariable::kZeroBC)+WRACK_N_X.RelValue(p,1,0,0,CVariable::kZeroBC) )+WRACK_S_X.RelValue(p,-1,0,0,CVariable::kZeroBC) )+WRACK_W_X.RelValue(p,0,1,0,CVariable::kZeroBC) );
			WRACK_X_IN.Update( p, value );
		}
		WRACK_X_IN.GrabMemory();
		if( WRACK_X_IN.GetF(FICFlux) ) WRACK_X_IN.Cov().Set(0.0); 
		if( WRACK_X_IN.GetF(FLinkEdges) ) { WRACK_X_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( WRACK_E_X.Value()+WRACK_N_X.Value() )+WRACK_S_X.Value() )+WRACK_W_X.Value() );
			WRACK_X_IN.Update( value );
	  } break;
	}
	return 0;
}

int DETRITUS_module::WRACK_CONSUMED_u61_exe() {
	float value;

	switch( WRACK_CONSUMED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WRACK_CONSUMED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0;
			WRACK_CONSUMED.Update( p, WRACK_CONSUMED.ParameterValue(value,p) );
		}
		WRACK_CONSUMED.GrabMemory();
		if( WRACK_CONSUMED.GetF(FICFlux) ) WRACK_CONSUMED.Cov().Set(0.0); 
		if( WRACK_CONSUMED.GetF(FLinkEdges) ) { WRACK_CONSUMED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0;
			WRACK_CONSUMED.Update( WRACK_CONSUMED.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DETRITUS_module::WRACK_OM_DECOMP_u62_exe() {
	float value;

	switch( WRACK_OM_DECOMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WRACK_OM_DECOMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( P1_ON_MAP.Value(p) == ((float)3) ) ) ? ( WRACK.Value(p) ) : (  ( ( ( P1_ON_MAP.Value(p) == ((float)2) ) ) ? ( ( ( WRACK.Value(p)*DECOMP_TEMP_N.Value(p) )*P1_SHREDDING_BY_CONS.Value(p) ) ) : ( ( ( WRACK.Value(p)*DECOMP_TEMP_H2O.Value(p) )*P1_SHREDDING_BY_CONS.Value(p) ) ) )  ) ) ;
			WRACK_OM_DECOMP.Update( p, value );
		}
		WRACK_OM_DECOMP.GrabMemory();
		if( WRACK_OM_DECOMP.GetF(FICFlux) ) WRACK_OM_DECOMP.Cov().Set(0.0); 
		if( WRACK_OM_DECOMP.GetF(FLinkEdges) ) { WRACK_OM_DECOMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( P1_ON_MAP.Value() == ((float)3) ) ) ? ( WRACK.Value() ) : (  ( ( ( P1_ON_MAP.Value() == ((float)2) ) ) ? ( ( ( WRACK.Value()*DECOMP_TEMP_N.Value() )*P1_SHREDDING_BY_CONS.Value() ) ) : ( ( ( WRACK.Value()*DECOMP_TEMP_H2O.Value() )*P1_SHREDDING_BY_CONS.Value() ) ) )  ) ) ;
			WRACK_OM_DECOMP.Update( value );
	  } break;
	}
	return 0;
}

int DETRITUS_module::WRACK_X_OUT_u63_exe() {
	float value;

	switch( WRACK_X_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WRACK_X_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( P1_ON_MAP.Value(p) == ((float)2) ) ) ? ( ((float)0) ) : ( ( ( ( WRACK_E_X.Value(p)+WRACK_N_X.Value(p) )+WRACK_S_X.Value(p) )+WRACK_W_X.Value(p) ) ) ) ;
			WRACK_X_OUT.Update( p, value );
		}
		WRACK_X_OUT.GrabMemory();
		if( WRACK_X_OUT.GetF(FICFlux) ) WRACK_X_OUT.Cov().Set(0.0); 
		if( WRACK_X_OUT.GetF(FLinkEdges) ) { WRACK_X_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( P1_ON_MAP.Value() == ((float)2) ) ) ? ( ((float)0) ) : ( ( ( ( WRACK_E_X.Value()+WRACK_N_X.Value() )+WRACK_S_X.Value() )+WRACK_W_X.Value() ) ) ) ;
			WRACK_X_OUT.Update( value );
	  } break;
	}
	return 0;
}

int DETRITUS_module::DECOMP_TEMP_H2O_u64_exe() {
	float value;

	switch( DECOMP_TEMP_H2O.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DECOMP_TEMP_H2O.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( P1_AIR_TEMP.Value(p) <= ((float)0) ) ) ? ( ((float)0) ) : ( ( pow((double)P1_AIR_TEMP.Value(p),(double)((float)4) )/( pow((double)P1_HALF_SAT_H2O.Value(p),(double)((float)4) )+pow((double)P1_AIR_TEMP.Value(p),(double)((float)4) ) ) ) ) ) ;
			DECOMP_TEMP_H2O.Update( p, value );
		}
		DECOMP_TEMP_H2O.GrabMemory();
		if( DECOMP_TEMP_H2O.GetF(FLinkEdges) ) { DECOMP_TEMP_H2O.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( P1_AIR_TEMP.Value() <= ((float)0) ) ) ? ( ((float)0) ) : ( ( pow((double)P1_AIR_TEMP.Value(),(double)((float)4) )/( pow((double)P1_HALF_SAT_H2O.Value(),(double)((float)4) )+pow((double)P1_AIR_TEMP.Value(),(double)((float)4) ) ) ) ) ) ;
			DECOMP_TEMP_H2O.Update( value );
	  } break;
	}
	return 0;
}

int DETRITUS_module::DECOMP_TEMP_N_u65_exe() {
	float value;

	switch( DECOMP_TEMP_N.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DECOMP_TEMP_N.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( P1_AIR_TEMP.Value(p) <= ((float)0) ) ) ? ( ((float)0) ) : ( ( pow((double)P1_AIR_TEMP.Value(p),(double)((float)4) )/( pow((double)P1_HALF_SAT_N.Value(p),(double)((float)4) )+pow((double)P1_AIR_TEMP.Value(p),(double)((float)4) ) ) ) ) ) ;
			DECOMP_TEMP_N.Update( p, value );
		}
		DECOMP_TEMP_N.GrabMemory();
		if( DECOMP_TEMP_N.GetF(FLinkEdges) ) { DECOMP_TEMP_N.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( P1_AIR_TEMP.Value() <= ((float)0) ) ) ? ( ((float)0) ) : ( ( pow((double)P1_AIR_TEMP.Value(),(double)((float)4) )/( pow((double)P1_HALF_SAT_N.Value(),(double)((float)4) )+pow((double)P1_AIR_TEMP.Value(),(double)((float)4) ) ) ) ) ) ;
			DECOMP_TEMP_N.Update( value );
	  } break;
	}
	return 0;
}

int DETRITUS_module::EW_WRACK_VECTOR_u66_exe() {
	float value;

	switch( EW_WRACK_VECTOR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EW_WRACK_VECTOR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( EW_VECTOR.Value(p)+( P1_WIND_WRACK_FACTOR.Value(p)*EW_WIND_VECTOR.Value(p) ) );
			EW_WRACK_VECTOR.Update( p, value );
		}
		EW_WRACK_VECTOR.GrabMemory();
		if( EW_WRACK_VECTOR.GetF(FLinkEdges) ) { EW_WRACK_VECTOR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( EW_VECTOR.Value()+( P1_WIND_WRACK_FACTOR.Value()*EW_WIND_VECTOR.Value() ) );
			EW_WRACK_VECTOR.Update( value );
	  } break;
	}
	return 0;
}

int DETRITUS_module::NS_WRACK_VECTOR_u67_exe() {
	float value;

	switch( NS_WRACK_VECTOR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NS_WRACK_VECTOR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( NS_VECTOR.Value(p)+( P1_WIND_WRACK_FACTOR.Value(p)*NS_WIND_VECTOR.Value(p) ) );
			NS_WRACK_VECTOR.Update( p, value );
		}
		NS_WRACK_VECTOR.GrabMemory();
		if( NS_WRACK_VECTOR.GetF(FLinkEdges) ) { NS_WRACK_VECTOR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( NS_VECTOR.Value()+( P1_WIND_WRACK_FACTOR.Value()*NS_WIND_VECTOR.Value() ) );
			NS_WRACK_VECTOR.Update( value );
	  } break;
	}
	return 0;
}

int DETRITUS_module::SEED_GERM_u68_exe() {
	float value;

	switch( SEED_GERM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SEED_GERM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( DAYS.Value(p) == ((float)100) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			SEED_GERM.Update( p, value );
		}
		SEED_GERM.GrabMemory();
		if( SEED_GERM.GetF(FLinkEdges) ) { SEED_GERM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( DAYS.Value() == ((float)100) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ;
			SEED_GERM.Update( value );
	  } break;
	}
	return 0;
}

int DETRITUS_module::VECTOR_ABS_SUM_u69_exe() {
	float value;

	switch( VECTOR_ABS_SUM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = VECTOR_ABS_SUM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SL::Abs(EW_WRACK_VECTOR.Value(p))+SL::Abs(NS_WRACK_VECTOR.Value(p)) );
			VECTOR_ABS_SUM.Update( p, value );
		}
		VECTOR_ABS_SUM.GrabMemory();
		if( VECTOR_ABS_SUM.GetF(FLinkEdges) ) { VECTOR_ABS_SUM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SL::Abs(EW_WRACK_VECTOR.Value())+SL::Abs(NS_WRACK_VECTOR.Value()) );
			VECTOR_ABS_SUM.Update( value );
	  } break;
	}
	return 0;
}

int DETRITUS_module::WRACK_EXPORT_EW_u70_exe() {
	float value;

	switch( WRACK_EXPORT_EW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WRACK_EXPORT_EW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( WRACK.Value(p)*( EW_WRACK_VECTOR.Value(p)/VECTOR_ABS_SUM.Value(p) ) )/SL::Sqrt(P1_CELL_SIZE.Value(p)) );
			WRACK_EXPORT_EW.Update( p, value );
		}
		WRACK_EXPORT_EW.GrabMemory();
		if( WRACK_EXPORT_EW.GetF(FLinkEdges) ) { WRACK_EXPORT_EW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( WRACK.Value()*( EW_WRACK_VECTOR.Value()/VECTOR_ABS_SUM.Value() ) )/SL::Sqrt(P1_CELL_SIZE.Value()) );
			WRACK_EXPORT_EW.Update( value );
	  } break;
	}
	return 0;
}

int DETRITUS_module::WRACK_EXPORT_NS_u71_exe() {
	float value;

	switch( WRACK_EXPORT_NS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WRACK_EXPORT_NS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( WRACK.Value(p)*( NS_WRACK_VECTOR.Value(p)/VECTOR_ABS_SUM.Value(p) ) )/SL::Sqrt(P1_CELL_SIZE.Value(p)) );
			WRACK_EXPORT_NS.Update( p, value );
		}
		WRACK_EXPORT_NS.GrabMemory();
		if( WRACK_EXPORT_NS.GetF(FLinkEdges) ) { WRACK_EXPORT_NS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( WRACK.Value()*( NS_WRACK_VECTOR.Value()/VECTOR_ABS_SUM.Value() ) )/SL::Sqrt(P1_CELL_SIZE.Value()) );
			WRACK_EXPORT_NS.Update( value );
	  } break;
	}
	return 0;
}

int DETRITUS_module::WRACK_E_X_u72_exe() {
	float value;

	switch( WRACK_E_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WRACK_E_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Max(((float)0), WRACK_EXPORT_EW.Value(p));
			WRACK_E_X.Update( p, value );
		}
		WRACK_E_X.GrabMemory();
		if( WRACK_E_X.GetF(FLinkEdges) ) { WRACK_E_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Max(((float)0), WRACK_EXPORT_EW.Value());
			WRACK_E_X.Update( value );
	  } break;
	}
	return 0;
}

int DETRITUS_module::WRACK_N_X_u73_exe() {
	float value;

	switch( WRACK_N_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WRACK_N_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Max(((float)0), WRACK_EXPORT_NS.Value(p));
			WRACK_N_X.Update( p, value );
		}
		WRACK_N_X.GrabMemory();
		if( WRACK_N_X.GetF(FLinkEdges) ) { WRACK_N_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Max(((float)0), WRACK_EXPORT_NS.Value());
			WRACK_N_X.Update( value );
	  } break;
	}
	return 0;
}

int DETRITUS_module::WRACK_S_X_u74_exe() {
	float value;

	switch( WRACK_S_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WRACK_S_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Max(((float)0), -WRACK_EXPORT_NS.Value(p));
			WRACK_S_X.Update( p, value );
		}
		WRACK_S_X.GrabMemory();
		if( WRACK_S_X.GetF(FLinkEdges) ) { WRACK_S_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Max(((float)0), -WRACK_EXPORT_NS.Value());
			WRACK_S_X.Update( value );
	  } break;
	}
	return 0;
}

int DETRITUS_module::WRACK_W_X_u75_exe() {
	float value;

	switch( WRACK_W_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WRACK_W_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Max(((float)0), -WRACK_EXPORT_EW.Value(p));
			WRACK_W_X.Update( p, value );
		}
		WRACK_W_X.GrabMemory();
		if( WRACK_W_X.GetF(FLinkEdges) ) { WRACK_W_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Max(((float)0), -WRACK_EXPORT_EW.Value());
			WRACK_W_X.Update( value );
	  } break;
	}
	return 0;
}

int DETRITUS_module::P1_HALF_SAT_H2O_u76_exe() {
	float value;

	switch( P1_HALF_SAT_H2O.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_HALF_SAT_H2O.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  20;
			P1_HALF_SAT_H2O.Update( p, P1_HALF_SAT_H2O.ParameterValue(value,p) );
		}
		P1_HALF_SAT_H2O.GrabMemory();
		if( P1_HALF_SAT_H2O.GetF(FLinkEdges) ) { P1_HALF_SAT_H2O.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  20;
			P1_HALF_SAT_H2O.Update( P1_HALF_SAT_H2O.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DETRITUS_module::P1_HALF_SAT_N_u77_exe() {
	float value;

	switch( P1_HALF_SAT_N.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_HALF_SAT_N.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  15;
			P1_HALF_SAT_N.Update( p, P1_HALF_SAT_N.ParameterValue(value,p) );
		}
		P1_HALF_SAT_N.GrabMemory();
		if( P1_HALF_SAT_N.GetF(FLinkEdges) ) { P1_HALF_SAT_N.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  15;
			P1_HALF_SAT_N.Update( P1_HALF_SAT_N.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DETRITUS_module::P1_IC_WRACK_u78_exe() {
	float value;

	switch( P1_IC_WRACK.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_IC_WRACK.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0;
			P1_IC_WRACK.Update( p, P1_IC_WRACK.ParameterValue(value,p) );
		}
		P1_IC_WRACK.GrabMemory();
		if( P1_IC_WRACK.GetF(FLinkEdges) ) { P1_IC_WRACK.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0;
			P1_IC_WRACK.Update( P1_IC_WRACK.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DETRITUS_module::P1_SEED_LOSS_RT_u79_exe() {
	float value;

	switch( P1_SEED_LOSS_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SEED_LOSS_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000058;
			P1_SEED_LOSS_RT.Update( p, P1_SEED_LOSS_RT.ParameterValue(value,p) );
		}
		P1_SEED_LOSS_RT.GrabMemory();
		if( P1_SEED_LOSS_RT.GetF(FLinkEdges) ) { P1_SEED_LOSS_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000058;
			P1_SEED_LOSS_RT.Update( P1_SEED_LOSS_RT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DETRITUS_module::P1_SEED_WGT_u80_exe() {
	float value;

	switch( P1_SEED_WGT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SEED_WGT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.001000;
			P1_SEED_WGT.Update( p, P1_SEED_WGT.ParameterValue(value,p) );
		}
		P1_SEED_WGT.GrabMemory();
		if( P1_SEED_WGT.GetF(FLinkEdges) ) { P1_SEED_WGT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.001000;
			P1_SEED_WGT.Update( P1_SEED_WGT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DETRITUS_module::P1_SHREDDING_BY_CONS_u81_exe() {
	float value;

	switch( P1_SHREDDING_BY_CONS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SHREDDING_BY_CONS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0;
			P1_SHREDDING_BY_CONS.Update( p, P1_SHREDDING_BY_CONS.ParameterValue(value,p) );
		}
		P1_SHREDDING_BY_CONS.GrabMemory();
		if( P1_SHREDDING_BY_CONS.GetF(FLinkEdges) ) { P1_SHREDDING_BY_CONS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0;
			P1_SHREDDING_BY_CONS.Update( P1_SHREDDING_BY_CONS.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DETRITUS_module::P1_SINK_RT_u82_exe() {
	float value;

	switch( P1_SINK_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SINK_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.500;
			P1_SINK_RT.Update( p, P1_SINK_RT.ParameterValue(value,p) );
		}
		P1_SINK_RT.GrabMemory();
		if( P1_SINK_RT.GetF(FLinkEdges) ) { P1_SINK_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.500;
			P1_SINK_RT.Update( P1_SINK_RT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DETRITUS_module::P1_WIND_WRACK_FACTOR_u83_exe() {
	float value;

	switch( P1_WIND_WRACK_FACTOR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_WIND_WRACK_FACTOR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.50000;
			P1_WIND_WRACK_FACTOR.Update( p, P1_WIND_WRACK_FACTOR.ParameterValue(value,p) );
		}
		P1_WIND_WRACK_FACTOR.GrabMemory();
		if( P1_WIND_WRACK_FACTOR.GetF(FLinkEdges) ) { P1_WIND_WRACK_FACTOR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.50000;
			P1_WIND_WRACK_FACTOR.Update( P1_WIND_WRACK_FACTOR.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DETRITUS_module::P1_WRACK_OM_NC_u84_exe() {
	float value;

	switch( P1_WRACK_OM_NC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_WRACK_OM_NC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.010000;
			P1_WRACK_OM_NC.Update( p, P1_WRACK_OM_NC.ParameterValue(value,p) );
		}
		P1_WRACK_OM_NC.GrabMemory();
		if( P1_WRACK_OM_NC.GetF(FLinkEdges) ) { P1_WRACK_OM_NC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.010000;
			P1_WRACK_OM_NC.Update( P1_WRACK_OM_NC.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DETRITUS_module::P1_WRACK_OM_PC_u85_exe() {
	float value;

	switch( P1_WRACK_OM_PC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_WRACK_OM_PC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.005000;
			P1_WRACK_OM_PC.Update( p, P1_WRACK_OM_PC.ParameterValue(value,p) );
		}
		P1_WRACK_OM_PC.GrabMemory();
		if( P1_WRACK_OM_PC.GetF(FLinkEdges) ) { P1_WRACK_OM_PC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.005000;
			P1_WRACK_OM_PC.Update( P1_WRACK_OM_PC.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DETRITUS_module::SEED_PROD_u86_exe() {
	float value;

	switch( SEED_PROD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SEED_PROD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph1(DAYS.Value(p));
			SEED_PROD.Update( p, value );
		}
		SEED_PROD.GrabMemory();
		if( SEED_PROD.GetF(FLinkEdges) ) { SEED_PROD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph1(DAYS.Value());
			SEED_PROD.Update( value );
	  } break;
	}
	return 0;
}

DETRITUS_module* DETRITUS_module::fInstance = NULL;
DETRITUS_module* DETRITUS_module::kNullModel = (DETRITUS_module*)0x1;
int DETRITUS_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int DETRITUS_module::InitVars() {
	
	TIME.SSInit(this);
	WRACK.SSInit(this);
	CONS_EGEST.SSInit(this);
	P1_CELL_SIZE.SSInit(this);
	PHBIO_LITTERFALL.SSInit(this);
	CONS_INGEST_WR.SSInit(this);
	P1_ON_MAP.SSInit(this);
	P1_AIR_TEMP.SSInit(this);
	EW_VECTOR.SSInit(this);
	EW_WIND_VECTOR.SSInit(this);
	NS_VECTOR.SSInit(this);
	NS_WIND_VECTOR.SSInit(this);
	DAYS.SSInit(this);
	WRACK_OM_DECOMP.SSInit(this);
	WRACK_OM_DECOMP.SetOrigin(&WRACK);
	P1_WRACK_OM_NC.SSInit(this);
	GEMINATION.SSInit(this);
	GEMINATION.SetOrigin(&SEEDS);
	P1_WRACK_OM_PC.SSInit(this);
	DETRITAL_POOL.SSInit(this);
	WRACK_SINKING.SSInit(this);
	WRACK_SINKING.SetOrigin(&WRACK);
	WRACK_SINKING.SetDestination(&DETRITAL_POOL);
	EGESTED_MATTER.SSInit(this);
	EGESTED_MATTER.SetDestination(&DETRITAL_POOL);
	SEEDS.SSInit(this);
	SEED_DROP_OUT.SSInit(this);
	SEED_DROP_OUT.SetOrigin(&WRACK);
	SEED_DROP_OUT.SetDestination(&SEEDS);
	SEED_LOSS.SSInit(this);
	SEED_LOSS.SetOrigin(&SEEDS);
	WRACK_PRODUCED.SSInit(this);
	WRACK_PRODUCED.SetDestination(&WRACK);
	WRACK_X_IN.SSInit(this);
	WRACK_X_IN.SetDestination(&WRACK);
	WRACK_CONSUMED.SSInit(this);
	WRACK_CONSUMED.SetOrigin(&WRACK);
	WRACK_X_OUT.SSInit(this);
	WRACK_X_OUT.SetOrigin(&WRACK);
	DECOMP_TEMP_H2O.SSInit(this);
	DECOMP_TEMP_N.SSInit(this);
	EW_WRACK_VECTOR.SSInit(this);
	NS_WRACK_VECTOR.SSInit(this);
	SEED_GERM.SSInit(this);
	VECTOR_ABS_SUM.SSInit(this);
	WRACK_EXPORT_EW.SSInit(this);
	WRACK_EXPORT_NS.SSInit(this);
	WRACK_E_X.SSInit(this);
	WRACK_E_X.SetLinkEdges();
	WRACK_N_X.SSInit(this);
	WRACK_N_X.SetLinkEdges();
	WRACK_S_X.SSInit(this);
	WRACK_S_X.SetLinkEdges();
	WRACK_W_X.SSInit(this);
	WRACK_W_X.SetLinkEdges();
	P1_HALF_SAT_H2O.SSInit(this);
	P1_HALF_SAT_N.SSInit(this);
	P1_IC_WRACK.SSInit(this);
	P1_SEED_LOSS_RT.SSInit(this);
	P1_SEED_WGT.SSInit(this);
	P1_SHREDDING_BY_CONS.SSInit(this);
	P1_SINK_RT.SSInit(this);
	P1_WIND_WRACK_FACTOR.SSInit(this);
	SEED_PROD.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int DETRITUS_module::SetupEvents() {
	TExecuteCommand* I57 = (TExecuteCommand*) WRACK.GetCommand("I57",TCommand::kIntegrate,TCommand::kCode);
	I57->SetExecutable(&WRACK_I57_exe_g);
	I57->Code() = "I57 <- ( ( ( ( ( ( WRACK_PRODUCED+WRACK_X_IN )-WRACK_CONSUMED )-WRACK_OM_DECOMP )-WRACK_X_OUT )-SEED_DROP_OUT )-WRACK_SINKING )";
	I57->AddDependency(WRACK_PRODUCED);
	I57->AddDependency(WRACK_X_IN);
	I57->AddDependency(WRACK_CONSUMED);
	I57->AddDependency(WRACK_OM_DECOMP);
	I57->AddDependency(WRACK_X_OUT);
	I57->AddDependency(SEED_DROP_OUT);
	I57->AddDependency(WRACK_SINKING);
	I57->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i58 = (TExecuteCommand*) WRACK.GetCommand("i58",TCommand::kInit,TCommand::kCode);
	i58->SetExecutable(&WRACK_i58_exe_g);
	i58->Code() = "i58 <- ( P1_IC_WRACK*P1_CELL_SIZE )";
	i58->AddDependency(P1_IC_WRACK);
	i58->AddDependency(P1_CELL_SIZE);
	i58->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* CONS_EGEST_import = (TImportCommand*) CONS_EGEST.GetCommand("CONS_EGEST_import",TCommand::kUndefined,TCommand::kImport);
	CONS_EGEST_import->Code() = "Import CONS_EGEST from CONSUMERS_module";
	CONS_EGEST_import->AddDependency(CONS_EGEST);
	CONS_EGEST_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_CELL_SIZE_import = (TImportCommand*) P1_CELL_SIZE.GetCommand("P1_CELL_SIZE_import",TCommand::kUndefined,TCommand::kImport);
	P1_CELL_SIZE_import->Code() = "Import P1_CELL_SIZE from GLOBAL_module";
	P1_CELL_SIZE_import->AddDependency(P1_CELL_SIZE);
	P1_CELL_SIZE_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PHBIO_LITTERFALL_import = (TImportCommand*) PHBIO_LITTERFALL.GetCommand("PHBIO_LITTERFALL_import",TCommand::kUndefined,TCommand::kImport);
	PHBIO_LITTERFALL_import->Code() = "Import PHBIO_LITTERFALL from EELGRASS_module";
	PHBIO_LITTERFALL_import->AddDependency(PHBIO_LITTERFALL);
	PHBIO_LITTERFALL_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* CONS_INGEST_WR_import = (TImportCommand*) CONS_INGEST_WR.GetCommand("CONS_INGEST_WR_import",TCommand::kUndefined,TCommand::kImport);
	CONS_INGEST_WR_import->Code() = "Import CONS_INGEST_WR from CONSUMERS_module";
	CONS_INGEST_WR_import->AddDependency(CONS_INGEST_WR);
	CONS_INGEST_WR_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_ON_MAP_import = (TImportCommand*) P1_ON_MAP.GetCommand("P1_ON_MAP_import",TCommand::kUndefined,TCommand::kImport);
	P1_ON_MAP_import->Code() = "Import P1_ON_MAP from GLOBAL_module";
	P1_ON_MAP_import->AddDependency(P1_ON_MAP);
	P1_ON_MAP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_AIR_TEMP_import = (TImportCommand*) P1_AIR_TEMP.GetCommand("P1_AIR_TEMP_import",TCommand::kUndefined,TCommand::kImport);
	P1_AIR_TEMP_import->Code() = "Import P1_AIR_TEMP from GLOBAL_module";
	P1_AIR_TEMP_import->AddDependency(P1_AIR_TEMP);
	P1_AIR_TEMP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* EW_VECTOR_import = (TImportCommand*) EW_VECTOR.GetCommand("EW_VECTOR_import",TCommand::kUndefined,TCommand::kImport);
	EW_VECTOR_import->Code() = "Import EW_VECTOR from GLOBAL_module";
	EW_VECTOR_import->AddDependency(EW_VECTOR);
	EW_VECTOR_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* EW_WIND_VECTOR_import = (TImportCommand*) EW_WIND_VECTOR.GetCommand("EW_WIND_VECTOR_import",TCommand::kUndefined,TCommand::kImport);
	EW_WIND_VECTOR_import->Code() = "Import EW_WIND_VECTOR from GLOBAL_module";
	EW_WIND_VECTOR_import->AddDependency(EW_WIND_VECTOR);
	EW_WIND_VECTOR_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* NS_VECTOR_import = (TImportCommand*) NS_VECTOR.GetCommand("NS_VECTOR_import",TCommand::kUndefined,TCommand::kImport);
	NS_VECTOR_import->Code() = "Import NS_VECTOR from GLOBAL_module";
	NS_VECTOR_import->AddDependency(NS_VECTOR);
	NS_VECTOR_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* NS_WIND_VECTOR_import = (TImportCommand*) NS_WIND_VECTOR.GetCommand("NS_WIND_VECTOR_import",TCommand::kUndefined,TCommand::kImport);
	NS_WIND_VECTOR_import->Code() = "Import NS_WIND_VECTOR from GLOBAL_module";
	NS_WIND_VECTOR_import->AddDependency(NS_WIND_VECTOR);
	NS_WIND_VECTOR_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DAYS_import = (TImportCommand*) DAYS.GetCommand("DAYS_import",TCommand::kUndefined,TCommand::kImport);
	DAYS_import->Code() = "Import DAYS from GLOBAL_module";
	DAYS_import->AddDependency(DAYS);
	DAYS_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u62 = (TExecuteCommand*) WRACK_OM_DECOMP.GetCommand("u62",TCommand::kUpdate,TCommand::kCode);
	u62->SetExecutable(&WRACK_OM_DECOMP_u62_exe_g);
	u62->Code() = "u62 <-  ( ( ( P1_ON_MAP == ((float)3) ) ) ? ( WRACK ) : (  ( ( ( P1_ON_MAP == ((float)2) ) ) ? ( ( ( WRACK*DECOMP_TEMP_N )*P1_SHREDDING_BY_CONS ) ) : ( ( ( WRACK*DECOMP_TEMP_H2O )*P1_SHREDDING_BY_CONS ) ) )  ) ) ";
	if( WRACK_OM_DECOMP.GetF(FisClamped) ) { u62->AddDependency(WRACK); }
	u62->AddDependency(P1_ON_MAP);
	u62->AddDependency(WRACK);
	u62->AddDependency(DECOMP_TEMP_N);
	u62->AddDependency(P1_SHREDDING_BY_CONS);
	u62->AddDependency(DECOMP_TEMP_H2O);
	u62->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u84 = (TExecuteCommand*) P1_WRACK_OM_NC.GetCommand("u84",TCommand::kUpdate,TCommand::kCode);
	u84->SetExecutable(&P1_WRACK_OM_NC_u84_exe_g);
	u84->Code() = "u84 <- 0.010000";
	u84->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u55 = (TExecuteCommand*) GEMINATION.GetCommand("u55",TCommand::kUpdate,TCommand::kCode);
	u55->SetExecutable(&GEMINATION_u55_exe_g);
	u55->Code() = "u55 <- ( ( SEEDS*SEED_GERM )*((float)0) )";
	if( GEMINATION.GetF(FisClamped) ) { u55->AddDependency(SEEDS); }
	u55->AddDependency(SEEDS);
	u55->AddDependency(SEED_GERM);
	u55->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u85 = (TExecuteCommand*) P1_WRACK_OM_PC.GetCommand("u85",TCommand::kUpdate,TCommand::kCode);
	u85->SetExecutable(&P1_WRACK_OM_PC_u85_exe_g);
	u85->Code() = "u85 <- 0.005000";
	u85->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* I48 = (TExecuteCommand*) DETRITAL_POOL.GetCommand("I48",TCommand::kIntegrate,TCommand::kCode);
	I48->SetExecutable(&DETRITAL_POOL_I48_exe_g);
	I48->Code() = "I48 <- ( WRACK_SINKING+EGESTED_MATTER )";
	I48->AddDependency(WRACK_SINKING);
	I48->AddDependency(EGESTED_MATTER);
	I48->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i49 = (TExecuteCommand*) DETRITAL_POOL.GetCommand("i49",TCommand::kInit,TCommand::kCode);
	i49->SetExecutable(&DETRITAL_POOL_i49_exe_g);
	i49->Code() = "i49 <- ((float)0)";
	i49->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u50 = (TExecuteCommand*) WRACK_SINKING.GetCommand("u50",TCommand::kUpdate,TCommand::kCode);
	u50->SetExecutable(&WRACK_SINKING_u50_exe_g);
	u50->Code() = "u50 <- ( ( P1_SINK_RT*dT() )*WRACK )";
	if( WRACK_SINKING.GetF(FisClamped) ) { u50->AddDependency(WRACK); }
	u50->AddDependency(P1_SINK_RT);
	u50->AddDependency(WRACK);
	u50->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u51 = (TExecuteCommand*) EGESTED_MATTER.GetCommand("u51",TCommand::kUpdate,TCommand::kCode);
	u51->SetExecutable(&EGESTED_MATTER_u51_exe_g);
	u51->Code() = "u51 <- CONS_EGEST";
	u51->AddDependency(CONS_EGEST);
	u51->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I52 = (TExecuteCommand*) SEEDS.GetCommand("I52",TCommand::kIntegrate,TCommand::kCode);
	I52->SetExecutable(&SEEDS_I52_exe_g);
	I52->Code() = "I52 <- ( ( SEED_DROP_OUT-GEMINATION )-SEED_LOSS )";
	I52->AddDependency(SEED_DROP_OUT);
	I52->AddDependency(GEMINATION);
	I52->AddDependency(SEED_LOSS);
	I52->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i53 = (TExecuteCommand*) SEEDS.GetCommand("i53",TCommand::kInit,TCommand::kCode);
	i53->SetExecutable(&SEEDS_i53_exe_g);
	i53->Code() = "i53 <- ((float)0)";
	i53->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u54 = (TExecuteCommand*) SEED_DROP_OUT.GetCommand("u54",TCommand::kUpdate,TCommand::kCode);
	u54->SetExecutable(&SEED_DROP_OUT_u54_exe_g);
	u54->Code() = "u54 <- ( ( WRACK*SEED_PROD )*P1_SEED_WGT )";
	if( SEED_DROP_OUT.GetF(FisClamped) ) { u54->AddDependency(WRACK); }
	u54->AddDependency(WRACK);
	u54->AddDependency(SEED_PROD);
	u54->AddDependency(P1_SEED_WGT);
	u54->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u56 = (TExecuteCommand*) SEED_LOSS.GetCommand("u56",TCommand::kUpdate,TCommand::kCode);
	u56->SetExecutable(&SEED_LOSS_u56_exe_g);
	u56->Code() = "u56 <- ( SEEDS*P1_SEED_LOSS_RT )";
	if( SEED_LOSS.GetF(FisClamped) ) { u56->AddDependency(SEEDS); }
	u56->AddDependency(SEEDS);
	u56->AddDependency(P1_SEED_LOSS_RT);
	u56->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u59 = (TExecuteCommand*) WRACK_PRODUCED.GetCommand("u59",TCommand::kUpdate,TCommand::kCode);
	u59->SetExecutable(&WRACK_PRODUCED_u59_exe_g);
	u59->Code() = "u59 <- PHBIO_LITTERFALL";
	u59->AddDependency(PHBIO_LITTERFALL);
	u59->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u60 = (TExecuteCommand*) WRACK_X_IN.GetCommand("u60",TCommand::kUpdate,TCommand::kCode);
	u60->SetExecutable(&WRACK_X_IN_u60_exe_g);
	u60->Code() = "u60 <- ( ( ( WRACK_E_X@(0,-1,0:0)+WRACK_N_X@(1,0,0:0) )+WRACK_S_X@(-1,0,0:0) )+WRACK_W_X@(0,1,0:0) )";
	u60->AddDependency(WRACK_E_X,"0,-1,0");
	u60->AddDependency(WRACK_N_X,"1,0,0");
	u60->AddDependency(WRACK_S_X,"-1,0,0");
	u60->AddDependency(WRACK_W_X,"0,1,0");
	u60->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u61 = (TExecuteCommand*) WRACK_CONSUMED.GetCommand("u61",TCommand::kUpdate,TCommand::kCode);
	u61->SetExecutable(&WRACK_CONSUMED_u61_exe_g);
	u61->Code() = "u61 <- 0";
	if( WRACK_CONSUMED.GetF(FisClamped) ) { u61->AddDependency(WRACK); }
	u61->AddDependency(CONS_INGEST_WR);
	u61->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u63 = (TExecuteCommand*) WRACK_X_OUT.GetCommand("u63",TCommand::kUpdate,TCommand::kCode);
	u63->SetExecutable(&WRACK_X_OUT_u63_exe_g);
	u63->Code() = "u63 <-  ( ( ( P1_ON_MAP == ((float)2) ) ) ? ( ((float)0) ) : ( ( ( ( WRACK_E_X+WRACK_N_X )+WRACK_S_X )+WRACK_W_X ) ) ) ";
	if( WRACK_X_OUT.GetF(FisClamped) ) { u63->AddDependency(WRACK); }
	u63->AddDependency(P1_ON_MAP);
	u63->AddDependency(WRACK_E_X);
	u63->AddDependency(WRACK_N_X);
	u63->AddDependency(WRACK_S_X);
	u63->AddDependency(WRACK_W_X);
	u63->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u64 = (TExecuteCommand*) DECOMP_TEMP_H2O.GetCommand("u64",TCommand::kUpdate,TCommand::kCode);
	u64->SetExecutable(&DECOMP_TEMP_H2O_u64_exe_g);
	u64->Code() = "u64 <-  ( ( ( P1_AIR_TEMP <= ((float)0) ) ) ? ( ((float)0) ) : ( ( pow((double)P1_AIR_TEMP,(double)((float)4) )/( pow((double)P1_HALF_SAT_H2O,(double)((float)4) )+pow((double)P1_AIR_TEMP,(double)((float)4) ) ) ) ) ) ";
	u64->AddDependency(P1_AIR_TEMP);
	u64->AddDependency(P1_HALF_SAT_H2O);
	u64->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u65 = (TExecuteCommand*) DECOMP_TEMP_N.GetCommand("u65",TCommand::kUpdate,TCommand::kCode);
	u65->SetExecutable(&DECOMP_TEMP_N_u65_exe_g);
	u65->Code() = "u65 <-  ( ( ( P1_AIR_TEMP <= ((float)0) ) ) ? ( ((float)0) ) : ( ( pow((double)P1_AIR_TEMP,(double)((float)4) )/( pow((double)P1_HALF_SAT_N,(double)((float)4) )+pow((double)P1_AIR_TEMP,(double)((float)4) ) ) ) ) ) ";
	u65->AddDependency(P1_AIR_TEMP);
	u65->AddDependency(P1_HALF_SAT_N);
	u65->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u66 = (TExecuteCommand*) EW_WRACK_VECTOR.GetCommand("u66",TCommand::kUpdate,TCommand::kCode);
	u66->SetExecutable(&EW_WRACK_VECTOR_u66_exe_g);
	u66->Code() = "u66 <- ( EW_VECTOR+( P1_WIND_WRACK_FACTOR*EW_WIND_VECTOR ) )";
	u66->AddDependency(EW_VECTOR);
	u66->AddDependency(P1_WIND_WRACK_FACTOR);
	u66->AddDependency(EW_WIND_VECTOR);
	u66->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u67 = (TExecuteCommand*) NS_WRACK_VECTOR.GetCommand("u67",TCommand::kUpdate,TCommand::kCode);
	u67->SetExecutable(&NS_WRACK_VECTOR_u67_exe_g);
	u67->Code() = "u67 <- ( NS_VECTOR+( P1_WIND_WRACK_FACTOR*NS_WIND_VECTOR ) )";
	u67->AddDependency(NS_VECTOR);
	u67->AddDependency(P1_WIND_WRACK_FACTOR);
	u67->AddDependency(NS_WIND_VECTOR);
	u67->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u68 = (TExecuteCommand*) SEED_GERM.GetCommand("u68",TCommand::kUpdate,TCommand::kCode);
	u68->SetExecutable(&SEED_GERM_u68_exe_g);
	u68->Code() = "u68 <-  ( ( ( DAYS == ((float)100) ) ) ? ( ((float)1) ) : ( ((float)0) ) ) ";
	u68->AddDependency(DAYS);
	u68->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u69 = (TExecuteCommand*) VECTOR_ABS_SUM.GetCommand("u69",TCommand::kUpdate,TCommand::kCode);
	u69->SetExecutable(&VECTOR_ABS_SUM_u69_exe_g);
	u69->Code() = "u69 <- ( SL::Abs(EW_WRACK_VECTOR)+SL::Abs(NS_WRACK_VECTOR) )";
	u69->AddDependency(EW_WRACK_VECTOR);
	u69->AddDependency(NS_WRACK_VECTOR);
	u69->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u70 = (TExecuteCommand*) WRACK_EXPORT_EW.GetCommand("u70",TCommand::kUpdate,TCommand::kCode);
	u70->SetExecutable(&WRACK_EXPORT_EW_u70_exe_g);
	u70->Code() = "u70 <- ( ( WRACK*( EW_WRACK_VECTOR/VECTOR_ABS_SUM ) )/SL::Sqrt(P1_CELL_SIZE) )";
	u70->AddDependency(WRACK);
	u70->AddDependency(EW_WRACK_VECTOR);
	u70->AddDependency(VECTOR_ABS_SUM);
	u70->AddDependency(P1_CELL_SIZE);
	u70->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u71 = (TExecuteCommand*) WRACK_EXPORT_NS.GetCommand("u71",TCommand::kUpdate,TCommand::kCode);
	u71->SetExecutable(&WRACK_EXPORT_NS_u71_exe_g);
	u71->Code() = "u71 <- ( ( WRACK*( NS_WRACK_VECTOR/VECTOR_ABS_SUM ) )/SL::Sqrt(P1_CELL_SIZE) )";
	u71->AddDependency(WRACK);
	u71->AddDependency(NS_WRACK_VECTOR);
	u71->AddDependency(VECTOR_ABS_SUM);
	u71->AddDependency(P1_CELL_SIZE);
	u71->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u72 = (TExecuteCommand*) WRACK_E_X.GetCommand("u72",TCommand::kUpdate,TCommand::kCode);
	u72->SetExecutable(&WRACK_E_X_u72_exe_g);
	u72->Code() = "u72 <- SL::Max(((float)0), WRACK_EXPORT_EW)";
	u72->AddDependency(WRACK_EXPORT_EW);
	u72->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u73 = (TExecuteCommand*) WRACK_N_X.GetCommand("u73",TCommand::kUpdate,TCommand::kCode);
	u73->SetExecutable(&WRACK_N_X_u73_exe_g);
	u73->Code() = "u73 <- SL::Max(((float)0), WRACK_EXPORT_NS)";
	u73->AddDependency(WRACK_EXPORT_NS);
	u73->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u74 = (TExecuteCommand*) WRACK_S_X.GetCommand("u74",TCommand::kUpdate,TCommand::kCode);
	u74->SetExecutable(&WRACK_S_X_u74_exe_g);
	u74->Code() = "u74 <- SL::Max(((float)0), -WRACK_EXPORT_NS)";
	u74->AddDependency(WRACK_EXPORT_NS);
	u74->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u75 = (TExecuteCommand*) WRACK_W_X.GetCommand("u75",TCommand::kUpdate,TCommand::kCode);
	u75->SetExecutable(&WRACK_W_X_u75_exe_g);
	u75->Code() = "u75 <- SL::Max(((float)0), -WRACK_EXPORT_EW)";
	u75->AddDependency(WRACK_EXPORT_EW);
	u75->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u76 = (TExecuteCommand*) P1_HALF_SAT_H2O.GetCommand("u76",TCommand::kUpdate,TCommand::kCode);
	u76->SetExecutable(&P1_HALF_SAT_H2O_u76_exe_g);
	u76->Code() = "u76 <- 20";
	u76->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u77 = (TExecuteCommand*) P1_HALF_SAT_N.GetCommand("u77",TCommand::kUpdate,TCommand::kCode);
	u77->SetExecutable(&P1_HALF_SAT_N_u77_exe_g);
	u77->Code() = "u77 <- 15";
	u77->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u78 = (TExecuteCommand*) P1_IC_WRACK.GetCommand("u78",TCommand::kUpdate,TCommand::kCode);
	u78->SetExecutable(&P1_IC_WRACK_u78_exe_g);
	u78->Code() = "u78 <- 0";
	u78->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u79 = (TExecuteCommand*) P1_SEED_LOSS_RT.GetCommand("u79",TCommand::kUpdate,TCommand::kCode);
	u79->SetExecutable(&P1_SEED_LOSS_RT_u79_exe_g);
	u79->Code() = "u79 <- 0.000058";
	u79->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u80 = (TExecuteCommand*) P1_SEED_WGT.GetCommand("u80",TCommand::kUpdate,TCommand::kCode);
	u80->SetExecutable(&P1_SEED_WGT_u80_exe_g);
	u80->Code() = "u80 <- 0.001000";
	u80->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u81 = (TExecuteCommand*) P1_SHREDDING_BY_CONS.GetCommand("u81",TCommand::kUpdate,TCommand::kCode);
	u81->SetExecutable(&P1_SHREDDING_BY_CONS_u81_exe_g);
	u81->Code() = "u81 <- 0";
	u81->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u82 = (TExecuteCommand*) P1_SINK_RT.GetCommand("u82",TCommand::kUpdate,TCommand::kCode);
	u82->SetExecutable(&P1_SINK_RT_u82_exe_g);
	u82->Code() = "u82 <- 0.500";
	u82->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u83 = (TExecuteCommand*) P1_WIND_WRACK_FACTOR.GetCommand("u83",TCommand::kUpdate,TCommand::kCode);
	u83->SetExecutable(&P1_WIND_WRACK_FACTOR_u83_exe_g);
	u83->Code() = "u83 <- 0.50000";
	u83->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u86 = (TExecuteCommand*) SEED_PROD.GetCommand("u86",TCommand::kUpdate,TCommand::kCode);
	u86->SetExecutable(&SEED_PROD_u86_exe_g);
	u86->Code() = "u86 <- Graph1(DAYS)";
	u86->AddDependency(DAYS);
	u86->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int DETRITUS_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int DETRITUS_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int DETRITUS_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int DETRITUS_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class DIN_module 
// ---------------------------------------------------------------------------
DIN_module::DIN_module(char* name) :
	TIME("TIME"),
	SF_WATER("SF_WATER"),
	WRACK_OM_DECOMP("WRACK_OM_DECOMP"),
	P1_WRACK_OM_NC("P1_WRACK_OM_NC"),
	PHT_NET_PROD("PHT_NET_PROD"),
	P1_PHT_NC("P1_PHT_NC"),
	P1_MAC_PH_NC("P1_MAC_PH_NC"),
	PHBIO_NET_PROD("PHBIO_NET_PROD"),
	SF_WT_E_X("SF_WT_E_X"),
	SF_WT_N_X("SF_WT_N_X"),
	SF_WT_S_X("SF_WT_S_X"),
	SF_WT_W_X("SF_WT_W_X"),
	P1_RIVER_DATA_CF("P1_RIVER_DATA_CF"),
	P1_DIN_SED_CONC_MAP("P1_DIN_SED_CONC_MAP"),
	DIN_CONC("DIN_CONC"),
	DIN_SF_WT("DIN_SF_WT"),
	DIN_SF_WT_MINER("DIN_SF_WT_MINER"),
	DIN_SF_WT_X_IN("DIN_SF_WT_X_IN"),
	DIN_DNFLOW("DIN_DNFLOW"),
	DIN_SF_WT_UPTAKE("DIN_SF_WT_UPTAKE"),
	DIN_SF_WT_X_OUT("DIN_SF_WT_X_OUT"),
	SOIL_NITROGEN("SOIL_NITROGEN"),
	DINEX("DINEX"),
	DINNX("DINNX"),
	DINSX("DINSX"),
	DINWX("DINWX"),
	RIVER_N("RIVER_N"),
	P1_DIN_DIFFUSION_COEFF("P1_DIN_DIFFUSION_COEFF"),
	P1_IC_DIN_SF_WT("P1_IC_DIN_SF_WT"),
	TModule(name) {

	SF_WATER.SetF(FisImport,True,"CG");
	WRACK_OM_DECOMP.SetF(FisImport,True,"CG");
	P1_WRACK_OM_NC.SetF(FisImport,True,"CG");
	PHT_NET_PROD.SetF(FisImport,True,"CG");
	P1_PHT_NC.SetF(FisImport,True,"CG");
	P1_MAC_PH_NC.SetF(FisImport,True,"CG");
	PHBIO_NET_PROD.SetF(FisImport,True,"CG");
	SF_WT_E_X.SetF(FisImport,True,"CG");
	SF_WT_N_X.SetF(FisImport,True,"CG");
	SF_WT_S_X.SetF(FisImport,True,"CG");
	SF_WT_W_X.SetF(FisImport,True,"CG");
	P1_RIVER_DATA_CF.SetF(FisImport,True,"CG");
	P1_DIN_SED_CONC_MAP.SetF(FisExport,True,"CG");
	DIN_CONC.SetF(FisExport,True,"CG");
}	
int DIN_module::DIN_SF_WT_I87_exe() {
	float value;

	DIN_SF_WT.UpdateIntegrator();
	switch( DIN_SF_WT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_SF_WT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( DIN_SF_WT_MINER.Value(p)+DIN_SF_WT_X_IN.Value(p) )-DIN_DNFLOW.Value(p) )-DIN_SF_WT_UPTAKE.Value(p) )-DIN_SF_WT_X_OUT.Value(p) );
			DIN_SF_WT.Update( p, value, dT() );
		}
		DIN_SF_WT.GrabMemory();
		if( DIN_SF_WT.GetF(FLinkEdges) ) { DIN_SF_WT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( DIN_SF_WT_MINER.Value()+DIN_SF_WT_X_IN.Value() )-DIN_DNFLOW.Value() )-DIN_SF_WT_UPTAKE.Value() )-DIN_SF_WT_X_OUT.Value() );
			DIN_SF_WT.Update( value, dT() );
	  } break;
	}
	return 0;
}

int DIN_module::DIN_SF_WT_i88_exe() {
	float value;

	DIN_SF_WT.UpdateIntegrator();
	switch( DIN_SF_WT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_SF_WT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SF_WATER.Value(p)*P1_IC_DIN_SF_WT.Value(p) )*.001 );
			DIN_SF_WT.InitValue( p, value );
		}
		DIN_SF_WT.GrabMemory();
		if( DIN_SF_WT.GetF(FLinkEdges) ) { DIN_SF_WT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SF_WATER.Value()*P1_IC_DIN_SF_WT.Value() )*.001 );
			DIN_SF_WT.InitValue( value );
	  } break;
	}
	return 0;
}

int DIN_module::DIN_SF_WT_MINER_u89_exe() {
	float value;

	switch( DIN_SF_WT_MINER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_SF_WT_MINER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( WRACK_OM_DECOMP.Value(p)*P1_WRACK_OM_NC.Value(p) );
			DIN_SF_WT_MINER.Update( p, value );
		}
		DIN_SF_WT_MINER.GrabMemory();
		if( DIN_SF_WT_MINER.GetF(FICFlux) ) DIN_SF_WT_MINER.Cov().Set(0.0); 
		if( DIN_SF_WT_MINER.GetF(FLinkEdges) ) { DIN_SF_WT_MINER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( WRACK_OM_DECOMP.Value()*P1_WRACK_OM_NC.Value() );
			DIN_SF_WT_MINER.Update( value );
	  } break;
	}
	return 0;
}

int DIN_module::DIN_SF_WT_X_IN_u90_exe() {
	float value;

	switch( DIN_SF_WT_X_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_SF_WT_X_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( DINEX.RelValue(p,0,-1,0,CVariable::kDefaultBC)+DINNX.RelValue(p,1,0,0,CVariable::kDefaultBC) )+DINSX.RelValue(p,-1,0,0,CVariable::kDefaultBC) )+DINWX.RelValue(p,0,1,0,CVariable::kDefaultBC) );
			DIN_SF_WT_X_IN.Update( p, value );
		}
		DIN_SF_WT_X_IN.GrabMemory();
		if( DIN_SF_WT_X_IN.GetF(FICFlux) ) DIN_SF_WT_X_IN.Cov().Set(0.0); 
		if( DIN_SF_WT_X_IN.GetF(FLinkEdges) ) { DIN_SF_WT_X_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( DINEX.Value()+DINNX.Value() )+DINSX.Value() )+DINWX.Value() );
			DIN_SF_WT_X_IN.Update( value );
	  } break;
	}
	return 0;
}

int DIN_module::DIN_DNFLOW_u91_exe() {
	float value;

	switch( DIN_DNFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_DNFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SL::Max(( ( DIN_CONC.Value(p)-P1_DIN_SED_CONC_MAP.Value(p) )*P1_DIN_DIFFUSION_COEFF.Value(p) ), ((float)0))+ ( ( ( SF_WATER.Value(p) <= ((float)0) ) ) ? ( DIN_SF_WT.Value(p) ) : ( ((float)0) ) )  );
			DIN_DNFLOW.Update( p, value );
		}
		DIN_DNFLOW.GrabMemory();
		if( DIN_DNFLOW.GetF(FICFlux) ) DIN_DNFLOW.Cov().Set(0.0); 
		if( DIN_DNFLOW.GetF(FLinkEdges) ) { DIN_DNFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SL::Max(( ( DIN_CONC.Value()-P1_DIN_SED_CONC_MAP.Value() )*P1_DIN_DIFFUSION_COEFF.Value() ), ((float)0))+ ( ( ( SF_WATER.Value() <= ((float)0) ) ) ? ( DIN_SF_WT.Value() ) : ( ((float)0) ) )  );
			DIN_DNFLOW.Update( value );
	  } break;
	}
	return 0;
}

int DIN_module::DIN_SF_WT_UPTAKE_u92_exe() {
	float value;

	switch( DIN_SF_WT_UPTAKE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_SF_WT_UPTAKE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SF_WATER.Value(p) <= ((float)0) ) ) ? ( ((float)0) ) : ( SL::Max(((float)0), ( ( PHT_NET_PROD.Value(p)*P1_PHT_NC.Value(p) )+( P1_MAC_PH_NC.Value(p)*PHBIO_NET_PROD.Value(p) ) )) ) ) ;
			DIN_SF_WT_UPTAKE.Update( p, value );
		}
		DIN_SF_WT_UPTAKE.GrabMemory();
		if( DIN_SF_WT_UPTAKE.GetF(FICFlux) ) DIN_SF_WT_UPTAKE.Cov().Set(0.0); 
		if( DIN_SF_WT_UPTAKE.GetF(FLinkEdges) ) { DIN_SF_WT_UPTAKE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SF_WATER.Value() <= ((float)0) ) ) ? ( ((float)0) ) : ( SL::Max(((float)0), ( ( PHT_NET_PROD.Value()*P1_PHT_NC.Value() )+( P1_MAC_PH_NC.Value()*PHBIO_NET_PROD.Value() ) )) ) ) ;
			DIN_SF_WT_UPTAKE.Update( value );
	  } break;
	}
	return 0;
}

int DIN_module::DIN_SF_WT_X_OUT_u93_exe() {
	float value;

	switch( DIN_SF_WT_X_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_SF_WT_X_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( DINEX.Value(p)+DINNX.Value(p) )+DINSX.Value(p) )+DINWX.Value(p) );
			DIN_SF_WT_X_OUT.Update( p, value );
		}
		DIN_SF_WT_X_OUT.GrabMemory();
		if( DIN_SF_WT_X_OUT.GetF(FICFlux) ) DIN_SF_WT_X_OUT.Cov().Set(0.0); 
		if( DIN_SF_WT_X_OUT.GetF(FLinkEdges) ) { DIN_SF_WT_X_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( DINEX.Value()+DINNX.Value() )+DINSX.Value() )+DINWX.Value() );
			DIN_SF_WT_X_OUT.Update( value );
	  } break;
	}
	return 0;
}

int DIN_module::SOIL_NITROGEN_I94_exe() {
	float value;

	SOIL_NITROGEN.UpdateIntegrator();
	switch( SOIL_NITROGEN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SOIL_NITROGEN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  DIN_DNFLOW.Value(p);
			SOIL_NITROGEN.Update( p, value, dT() );
		}
		SOIL_NITROGEN.GrabMemory();
		if( SOIL_NITROGEN.GetF(FLinkEdges) ) { SOIL_NITROGEN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  DIN_DNFLOW.Value();
			SOIL_NITROGEN.Update( value, dT() );
	  } break;
	}
	return 0;
}

int DIN_module::SOIL_NITROGEN_i95_exe() {
	float value;

	SOIL_NITROGEN.UpdateIntegrator();
	switch( SOIL_NITROGEN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SOIL_NITROGEN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			SOIL_NITROGEN.InitValue( p, value );
		}
		SOIL_NITROGEN.GrabMemory();
		if( SOIL_NITROGEN.GetF(FLinkEdges) ) { SOIL_NITROGEN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			SOIL_NITROGEN.InitValue( value );
	  } break;
	}
	return 0;
}

int DIN_module::DINEX_u96_exe() {
	float value;

	switch( DINEX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINEX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DIN_CONC.Value(p)*SF_WT_E_X.Value(p) );
			DINEX.Update( p, value );
		}
		DINEX.GrabMemory();
		if( DINEX.GetF(FLinkEdges) ) { DINEX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DIN_CONC.Value()*SF_WT_E_X.Value() );
			DINEX.Update( value );
	  } break;
	}
	return 0;
}

int DIN_module::DINNX_u97_exe() {
	float value;

	switch( DINNX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINNX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DIN_CONC.Value(p)*SF_WT_N_X.Value(p) );
			DINNX.Update( p, value );
		}
		DINNX.GrabMemory();
		if( DINNX.GetF(FLinkEdges) ) { DINNX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DIN_CONC.Value()*SF_WT_N_X.Value() );
			DINNX.Update( value );
	  } break;
	}
	return 0;
}

int DIN_module::DINSX_u98_exe() {
	float value;

	switch( DINSX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINSX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DIN_CONC.Value(p)*SF_WT_S_X.Value(p) );
			DINSX.Update( p, value );
		}
		DINSX.GrabMemory();
		if( DINSX.GetF(FLinkEdges) ) { DINSX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DIN_CONC.Value()*SF_WT_S_X.Value() );
			DINSX.Update( value );
	  } break;
	}
	return 0;
}

int DIN_module::DINWX_u99_exe() {
	float value;

	switch( DINWX.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DINWX.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( DIN_CONC.Value(p)*SF_WT_W_X.Value(p) );
			DINWX.Update( p, value );
		}
		DINWX.GrabMemory();
		if( DINWX.GetF(FLinkEdges) ) { DINWX.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( DIN_CONC.Value()*SF_WT_W_X.Value() );
			DINWX.Update( value );
	  } break;
	}
	return 0;
}

int DIN_module::DIN_CONC_u100_exe() {
	float value;

	switch( DIN_CONC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DIN_CONC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SF_WATER.Value(p) <  ((float)1) ) ) ? ( ((float)0) ) : ( SL::Max(( ( RIVER_N.Value(p)*P1_RIVER_DATA_CF.Value(p) )+( DIN_SF_WT.Value(p)/SF_WATER.Value(p) ) ), ((float)0)) ) ) ;
			DIN_CONC.Update( p, value );
		}
		DIN_CONC.GrabMemory();
		if( DIN_CONC.GetF(FLinkEdges) ) { DIN_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SF_WATER.Value() <  ((float)1) ) ) ? ( ((float)0) ) : ( SL::Max(( ( RIVER_N.Value()*P1_RIVER_DATA_CF.Value() )+( DIN_SF_WT.Value()/SF_WATER.Value() ) ), ((float)0)) ) ) ;
			DIN_CONC.Update( value );
	  } break;
	}
	return 0;
}

int DIN_module::RIVER_N_u101_exe() {
	float value;

	switch( RIVER_N.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = RIVER_N.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0;
			RIVER_N.Update( p, RIVER_N.ParameterValue(value,p) );
		}
		RIVER_N.GrabMemory();
		if( RIVER_N.GetF(FLinkEdges) ) { RIVER_N.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0;
			RIVER_N.Update( RIVER_N.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DIN_module::P1_DIN_DIFFUSION_COEFF_u102_exe() {
	float value;

	switch( P1_DIN_DIFFUSION_COEFF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_DIFFUSION_COEFF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_DIN_DIFFUSION_COEFF.Update( p, P1_DIN_DIFFUSION_COEFF.ParameterValue(value,p) );
		}
		P1_DIN_DIFFUSION_COEFF.GrabMemory();
		if( P1_DIN_DIFFUSION_COEFF.GetF(FLinkEdges) ) { P1_DIN_DIFFUSION_COEFF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_DIN_DIFFUSION_COEFF.Update( P1_DIN_DIFFUSION_COEFF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DIN_module::P1_DIN_SED_CONC_MAP_u103_exe() {
	float value;

	switch( P1_DIN_SED_CONC_MAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_DIN_SED_CONC_MAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  4.200000;
			P1_DIN_SED_CONC_MAP.Update( p, P1_DIN_SED_CONC_MAP.ParameterValue(value,p) );
		}
		P1_DIN_SED_CONC_MAP.GrabMemory();
		if( P1_DIN_SED_CONC_MAP.GetF(FLinkEdges) ) { P1_DIN_SED_CONC_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  4.200000;
			P1_DIN_SED_CONC_MAP.Update( P1_DIN_SED_CONC_MAP.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int DIN_module::P1_IC_DIN_SF_WT_u104_exe() {
	float value;

	switch( P1_IC_DIN_SF_WT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_IC_DIN_SF_WT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			P1_IC_DIN_SF_WT.Update( p, value );
		}
		P1_IC_DIN_SF_WT.GrabMemory();
		if( P1_IC_DIN_SF_WT.GetF(FLinkEdges) ) { P1_IC_DIN_SF_WT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			P1_IC_DIN_SF_WT.Update( value );
	  } break;
	}
	return 0;
}

DIN_module* DIN_module::fInstance = NULL;
DIN_module* DIN_module::kNullModel = (DIN_module*)0x1;
int DIN_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int DIN_module::InitVars() {
	
	TIME.SSInit(this);
	SF_WATER.SSInit(this);
	WRACK_OM_DECOMP.SSInit(this);
	P1_WRACK_OM_NC.SSInit(this);
	PHT_NET_PROD.SSInit(this);
	P1_PHT_NC.SSInit(this);
	P1_MAC_PH_NC.SSInit(this);
	PHBIO_NET_PROD.SSInit(this);
	SF_WT_E_X.SSInit(this);
	SF_WT_N_X.SSInit(this);
	SF_WT_S_X.SSInit(this);
	SF_WT_W_X.SSInit(this);
	P1_RIVER_DATA_CF.SSInit(this);
	P1_DIN_SED_CONC_MAP.SSInit(this);
	DIN_CONC.SSInit(this);
	DIN_SF_WT.SSInit(this);
	DIN_SF_WT_MINER.SSInit(this);
	DIN_SF_WT_MINER.SetDestination(&DIN_SF_WT);
	DIN_SF_WT_X_IN.SSInit(this);
	DIN_SF_WT_X_IN.SetDestination(&DIN_SF_WT);
	DIN_DNFLOW.SSInit(this);
	DIN_DNFLOW.SetOrigin(&DIN_SF_WT);
	DIN_DNFLOW.SetDestination(&SOIL_NITROGEN);
	DIN_SF_WT_UPTAKE.SSInit(this);
	DIN_SF_WT_UPTAKE.SetOrigin(&DIN_SF_WT);
	DIN_SF_WT_X_OUT.SSInit(this);
	DIN_SF_WT_X_OUT.SetOrigin(&DIN_SF_WT);
	SOIL_NITROGEN.SSInit(this);
	DINEX.SSInit(this);
	DINEX.SetLinkEdges();
	DINNX.SSInit(this);
	DINNX.SetLinkEdges();
	DINSX.SSInit(this);
	DINSX.SetLinkEdges();
	DINWX.SSInit(this);
	DINWX.SetLinkEdges();
	RIVER_N.SSInit(this);
	P1_DIN_DIFFUSION_COEFF.SSInit(this);
	P1_IC_DIN_SF_WT.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int DIN_module::SetupEvents() {
	TImportCommand* SF_WATER_import = (TImportCommand*) SF_WATER.GetCommand("SF_WATER_import",TCommand::kUndefined,TCommand::kImport);
	SF_WATER_import->Code() = "Import SF_WATER from GLOBAL_module";
	SF_WATER_import->AddDependency(SF_WATER);
	SF_WATER_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* WRACK_OM_DECOMP_import = (TImportCommand*) WRACK_OM_DECOMP.GetCommand("WRACK_OM_DECOMP_import",TCommand::kUndefined,TCommand::kImport);
	WRACK_OM_DECOMP_import->Code() = "Import WRACK_OM_DECOMP from DETRITUS_module";
	WRACK_OM_DECOMP_import->AddDependency(WRACK_OM_DECOMP);
	WRACK_OM_DECOMP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_WRACK_OM_NC_import = (TImportCommand*) P1_WRACK_OM_NC.GetCommand("P1_WRACK_OM_NC_import",TCommand::kUndefined,TCommand::kImport);
	P1_WRACK_OM_NC_import->Code() = "Import P1_WRACK_OM_NC from DETRITUS_module";
	P1_WRACK_OM_NC_import->AddDependency(P1_WRACK_OM_NC);
	P1_WRACK_OM_NC_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PHT_NET_PROD_import = (TImportCommand*) PHT_NET_PROD.GetCommand("PHT_NET_PROD_import",TCommand::kUndefined,TCommand::kImport);
	PHT_NET_PROD_import->Code() = "Import PHT_NET_PROD from PHYTOPLANKTON_module";
	PHT_NET_PROD_import->AddDependency(PHT_NET_PROD);
	PHT_NET_PROD_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_PHT_NC_import = (TImportCommand*) P1_PHT_NC.GetCommand("P1_PHT_NC_import",TCommand::kUndefined,TCommand::kImport);
	P1_PHT_NC_import->Code() = "Import P1_PHT_NC from PHYTOPLANKTON_module";
	P1_PHT_NC_import->AddDependency(P1_PHT_NC);
	P1_PHT_NC_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_MAC_PH_NC_import = (TImportCommand*) P1_MAC_PH_NC.GetCommand("P1_MAC_PH_NC_import",TCommand::kUndefined,TCommand::kImport);
	P1_MAC_PH_NC_import->Code() = "Import P1_MAC_PH_NC from EELGRASS_module";
	P1_MAC_PH_NC_import->AddDependency(P1_MAC_PH_NC);
	P1_MAC_PH_NC_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PHBIO_NET_PROD_import = (TImportCommand*) PHBIO_NET_PROD.GetCommand("PHBIO_NET_PROD_import",TCommand::kUndefined,TCommand::kImport);
	PHBIO_NET_PROD_import->Code() = "Import PHBIO_NET_PROD from EELGRASS_module";
	PHBIO_NET_PROD_import->AddDependency(PHBIO_NET_PROD);
	PHBIO_NET_PROD_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WT_E_X_import = (TImportCommand*) SF_WT_E_X.GetCommand("SF_WT_E_X_import",TCommand::kUndefined,TCommand::kImport);
	SF_WT_E_X_import->Code() = "Import SF_WT_E_X from GLOBAL_module";
	SF_WT_E_X_import->AddDependency(SF_WT_E_X);
	SF_WT_E_X_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WT_N_X_import = (TImportCommand*) SF_WT_N_X.GetCommand("SF_WT_N_X_import",TCommand::kUndefined,TCommand::kImport);
	SF_WT_N_X_import->Code() = "Import SF_WT_N_X from GLOBAL_module";
	SF_WT_N_X_import->AddDependency(SF_WT_N_X);
	SF_WT_N_X_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WT_S_X_import = (TImportCommand*) SF_WT_S_X.GetCommand("SF_WT_S_X_import",TCommand::kUndefined,TCommand::kImport);
	SF_WT_S_X_import->Code() = "Import SF_WT_S_X from GLOBAL_module";
	SF_WT_S_X_import->AddDependency(SF_WT_S_X);
	SF_WT_S_X_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WT_W_X_import = (TImportCommand*) SF_WT_W_X.GetCommand("SF_WT_W_X_import",TCommand::kUndefined,TCommand::kImport);
	SF_WT_W_X_import->Code() = "Import SF_WT_W_X from GLOBAL_module";
	SF_WT_W_X_import->AddDependency(SF_WT_W_X);
	SF_WT_W_X_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_RIVER_DATA_CF_import = (TImportCommand*) P1_RIVER_DATA_CF.GetCommand("P1_RIVER_DATA_CF_import",TCommand::kUndefined,TCommand::kImport);
	P1_RIVER_DATA_CF_import->Code() = "Import P1_RIVER_DATA_CF from PHOSPHATE_module";
	P1_RIVER_DATA_CF_import->AddDependency(P1_RIVER_DATA_CF);
	P1_RIVER_DATA_CF_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u103 = (TExecuteCommand*) P1_DIN_SED_CONC_MAP.GetCommand("u103",TCommand::kUpdate,TCommand::kCode);
	u103->SetExecutable(&P1_DIN_SED_CONC_MAP_u103_exe_g);
	u103->Code() = "u103 <- 4.200000";
	u103->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u100 = (TExecuteCommand*) DIN_CONC.GetCommand("u100",TCommand::kUpdate,TCommand::kCode);
	u100->SetExecutable(&DIN_CONC_u100_exe_g);
	u100->Code() = "u100 <-  ( ( ( SF_WATER <  ((float)1) ) ) ? ( ((float)0) ) : ( SL::Max(( ( RIVER_N*P1_RIVER_DATA_CF )+( DIN_SF_WT/SF_WATER ) ), ((float)0)) ) ) ";
	u100->AddDependency(SF_WATER);
	u100->AddDependency(RIVER_N);
	u100->AddDependency(P1_RIVER_DATA_CF);
	u100->AddDependency(DIN_SF_WT);
	u100->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I87 = (TExecuteCommand*) DIN_SF_WT.GetCommand("I87",TCommand::kIntegrate,TCommand::kCode);
	I87->SetExecutable(&DIN_SF_WT_I87_exe_g);
	I87->Code() = "I87 <- ( ( ( ( DIN_SF_WT_MINER+DIN_SF_WT_X_IN )-DIN_DNFLOW )-DIN_SF_WT_UPTAKE )-DIN_SF_WT_X_OUT )";
	I87->AddDependency(DIN_SF_WT_MINER);
	I87->AddDependency(DIN_SF_WT_X_IN);
	I87->AddDependency(DIN_DNFLOW);
	I87->AddDependency(DIN_SF_WT_UPTAKE);
	I87->AddDependency(DIN_SF_WT_X_OUT);
	I87->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i88 = (TExecuteCommand*) DIN_SF_WT.GetCommand("i88",TCommand::kInit,TCommand::kCode);
	i88->SetExecutable(&DIN_SF_WT_i88_exe_g);
	i88->Code() = "i88 <- ( ( SF_WATER*P1_IC_DIN_SF_WT )*.001 )";
	i88->AddDependency(SF_WATER);
	i88->AddDependency(P1_IC_DIN_SF_WT);
	i88->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u89 = (TExecuteCommand*) DIN_SF_WT_MINER.GetCommand("u89",TCommand::kUpdate,TCommand::kCode);
	u89->SetExecutable(&DIN_SF_WT_MINER_u89_exe_g);
	u89->Code() = "u89 <- ( WRACK_OM_DECOMP*P1_WRACK_OM_NC )";
	u89->AddDependency(WRACK_OM_DECOMP);
	u89->AddDependency(P1_WRACK_OM_NC);
	u89->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u90 = (TExecuteCommand*) DIN_SF_WT_X_IN.GetCommand("u90",TCommand::kUpdate,TCommand::kCode);
	u90->SetExecutable(&DIN_SF_WT_X_IN_u90_exe_g);
	u90->Code() = "u90 <- ( ( ( DINEX@(0,-1,0)+DINNX@(1,0,0) )+DINSX@(-1,0,0) )+DINWX@(0,1,0) )";
	u90->AddDependency(DINEX,"0,-1,0");
	u90->AddDependency(DINNX,"1,0,0");
	u90->AddDependency(DINSX,"-1,0,0");
	u90->AddDependency(DINWX,"0,1,0");
	u90->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u91 = (TExecuteCommand*) DIN_DNFLOW.GetCommand("u91",TCommand::kUpdate,TCommand::kCode);
	u91->SetExecutable(&DIN_DNFLOW_u91_exe_g);
	u91->Code() = "u91 <- ( SL::Max(( ( DIN_CONC-P1_DIN_SED_CONC_MAP )*P1_DIN_DIFFUSION_COEFF ), ((float)0))+ ( ( ( SF_WATER <= ((float)0) ) ) ? ( DIN_SF_WT ) : ( ((float)0) ) )  )";
	if( DIN_DNFLOW.GetF(FisClamped) ) { u91->AddDependency(DIN_SF_WT); }
	u91->AddDependency(DIN_CONC);
	u91->AddDependency(P1_DIN_SED_CONC_MAP);
	u91->AddDependency(P1_DIN_DIFFUSION_COEFF);
	u91->AddDependency(SF_WATER);
	u91->AddDependency(DIN_SF_WT);
	u91->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u92 = (TExecuteCommand*) DIN_SF_WT_UPTAKE.GetCommand("u92",TCommand::kUpdate,TCommand::kCode);
	u92->SetExecutable(&DIN_SF_WT_UPTAKE_u92_exe_g);
	u92->Code() = "u92 <-  ( ( ( SF_WATER <= ((float)0) ) ) ? ( ((float)0) ) : ( SL::Max(((float)0), ( ( PHT_NET_PROD*P1_PHT_NC )+( P1_MAC_PH_NC*PHBIO_NET_PROD ) )) ) ) ";
	if( DIN_SF_WT_UPTAKE.GetF(FisClamped) ) { u92->AddDependency(DIN_SF_WT); }
	u92->AddDependency(SF_WATER);
	u92->AddDependency(PHT_NET_PROD);
	u92->AddDependency(P1_PHT_NC);
	u92->AddDependency(P1_MAC_PH_NC);
	u92->AddDependency(PHBIO_NET_PROD);
	u92->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u93 = (TExecuteCommand*) DIN_SF_WT_X_OUT.GetCommand("u93",TCommand::kUpdate,TCommand::kCode);
	u93->SetExecutable(&DIN_SF_WT_X_OUT_u93_exe_g);
	u93->Code() = "u93 <- ( ( ( DINEX+DINNX )+DINSX )+DINWX )";
	if( DIN_SF_WT_X_OUT.GetF(FisClamped) ) { u93->AddDependency(DIN_SF_WT); }
	u93->AddDependency(DINEX);
	u93->AddDependency(DINNX);
	u93->AddDependency(DINSX);
	u93->AddDependency(DINWX);
	u93->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I94 = (TExecuteCommand*) SOIL_NITROGEN.GetCommand("I94",TCommand::kIntegrate,TCommand::kCode);
	I94->SetExecutable(&SOIL_NITROGEN_I94_exe_g);
	I94->Code() = "I94 <- DIN_DNFLOW";
	I94->AddDependency(DIN_DNFLOW);
	I94->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i95 = (TExecuteCommand*) SOIL_NITROGEN.GetCommand("i95",TCommand::kInit,TCommand::kCode);
	i95->SetExecutable(&SOIL_NITROGEN_i95_exe_g);
	i95->Code() = "i95 <- ((float)0)";
	i95->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u96 = (TExecuteCommand*) DINEX.GetCommand("u96",TCommand::kUpdate,TCommand::kCode);
	u96->SetExecutable(&DINEX_u96_exe_g);
	u96->Code() = "u96 <- ( DIN_CONC*SF_WT_E_X )";
	u96->AddDependency(DIN_CONC);
	u96->AddDependency(SF_WT_E_X);
	u96->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u97 = (TExecuteCommand*) DINNX.GetCommand("u97",TCommand::kUpdate,TCommand::kCode);
	u97->SetExecutable(&DINNX_u97_exe_g);
	u97->Code() = "u97 <- ( DIN_CONC*SF_WT_N_X )";
	u97->AddDependency(DIN_CONC);
	u97->AddDependency(SF_WT_N_X);
	u97->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u98 = (TExecuteCommand*) DINSX.GetCommand("u98",TCommand::kUpdate,TCommand::kCode);
	u98->SetExecutable(&DINSX_u98_exe_g);
	u98->Code() = "u98 <- ( DIN_CONC*SF_WT_S_X )";
	u98->AddDependency(DIN_CONC);
	u98->AddDependency(SF_WT_S_X);
	u98->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u99 = (TExecuteCommand*) DINWX.GetCommand("u99",TCommand::kUpdate,TCommand::kCode);
	u99->SetExecutable(&DINWX_u99_exe_g);
	u99->Code() = "u99 <- ( DIN_CONC*SF_WT_W_X )";
	u99->AddDependency(DIN_CONC);
	u99->AddDependency(SF_WT_W_X);
	u99->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u101 = (TExecuteCommand*) RIVER_N.GetCommand("u101",TCommand::kUpdate,TCommand::kCode);
	u101->SetExecutable(&RIVER_N_u101_exe_g);
	u101->Code() = "u101 <- 0";
	u101->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u102 = (TExecuteCommand*) P1_DIN_DIFFUSION_COEFF.GetCommand("u102",TCommand::kUpdate,TCommand::kCode);
	u102->SetExecutable(&P1_DIN_DIFFUSION_COEFF_u102_exe_g);
	u102->Code() = "u102 <- 1";
	u102->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u104 = (TExecuteCommand*) P1_IC_DIN_SF_WT.GetCommand("u104",TCommand::kUpdate,TCommand::kCode);
	u104->SetExecutable(&P1_IC_DIN_SF_WT_u104_exe_g);
	u104->Code() = "u104 <- ((float)0)";
	u104->SetObjInfo(TCommand::kDepIndex, 5);
	return 0;
}

int DIN_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int DIN_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int DIN_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int DIN_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class EELGRASS_module 
// ---------------------------------------------------------------------------
EELGRASS_module::EELGRASS_module(char* name) :
	TIME("TIME"),
	ROOTSRHY("ROOTSRHY"),
	SHOOTS("SHOOTS"),
	P1_IC_MAC_PHBIO("P1_IC_MAC_PHBIO"),
	P1_SEPT_TO_JAN_CONV("P1_SEPT_TO_JAN_CONV"),
	PHBIO_LITTERFALL("PHBIO_LITTERFALL"),
	P1_MAC_PH_NC("P1_MAC_PH_NC"),
	PHBIO_NET_PROD("PHBIO_NET_PROD"),
	P1_CELL_SIZE("P1_CELL_SIZE"),
	CONS_INGEST_NPHBIO("CONS_INGEST_NPHBIO"),
	GEMINATION("GEMINATION"),
	CONS_INGEST_PHBIO("CONS_INGEST_PHBIO"),
	P1_AIR_TEMP("P1_AIR_TEMP"),
	H2O_TEMP("H2O_TEMP"),
	P1_LEAF_GROW_SEASON("P1_LEAF_GROW_SEASON"),
	P1_DIN_SED_CONC_MAP("P1_DIN_SED_CONC_MAP"),
	P1_PO4_SED_WT_CONC("P1_PO4_SED_WT_CONC"),
	ZOSTRA_LIGHT_LIM("ZOSTRA_LIGHT_LIM"),
	DAYS("DAYS"),
	PHBIO_LTTR_RATIO("PHBIO_LTTR_RATIO"),
	LEAF_LENGTH("LEAF_LENGTH"),
	P1_MAC_PHBIO_PC("P1_MAC_PHBIO_PC"),
	NPH_MAC_GPP("NPH_MAC_GPP"),
	NPHBIO_RESP("NPHBIO_RESP"),
	NPHBIO_MORT("NPHBIO_MORT"),
	NPHBIO_CONSUMED("NPHBIO_CONSUMED"),
	PH_MAC_GPP("PH_MAC_GPP"),
	NEW_PLANTS("NEW_PLANTS"),
	PHBIO_RESP("PHBIO_RESP"),
	PHBIO_CONSUMED("PHBIO_CONSUMED"),
	ACTUAL_LEAF_GROWTH("ACTUAL_LEAF_GROWTH"),
	IC_MAC_NPHBIO("IC_MAC_NPHBIO"),
	LEAF_LIMIT_COEFF("LEAF_LIMIT_COEFF"),
	LL_CAL_CF("LL_CAL_CF"),
	MAC_NET_PROD("MAC_NET_PROD"),
	MAC_TEMP_RESP_LIM("MAC_TEMP_RESP_LIM"),
	NPHBIO_NET_PROD("NPHBIO_NET_PROD"),
	PHMAC_GROWTH_TO_ROOTS("PHMAC_GROWTH_TO_ROOTS"),
	ROOTS_TO_LEAVES("ROOTS_TO_LEAVES"),
	ZOSTRA_NUT_LIM("ZOSTRA_NUT_LIM"),
	ZOSTRA_PROD_LIM("ZOSTRA_PROD_LIM"),
	ZOSTRA_TEMP_LIM("ZOSTRA_TEMP_LIM"),
	P1_BETA("P1_BETA"),
	P1_MAC_NONPH_NC("P1_MAC_NONPH_NC"),
	P1_MAC_NONPH_PC("P1_MAC_NONPH_PC"),
	P1_MAC_PP_RATE("P1_MAC_PP_RATE"),
	P1_MAX_AIR_TEMP("P1_MAX_AIR_TEMP"),
	P1_NPHBIO_MORT_RATE("P1_NPHBIO_MORT_RATE"),
	P1_NPHBIO_RESP_RATE("P1_NPHBIO_RESP_RATE"),
	P1_PERC_NPHBIO("P1_PERC_NPHBIO"),
	P1_PHBIO_RESP_RATE("P1_PHBIO_RESP_RATE"),
	P1_SAT_N("P1_SAT_N"),
	P1_SAT_P("P1_SAT_P"),
	P1_SWITCH_AIR_TEMP_LIM("P1_SWITCH_AIR_TEMP_LIM"),
	P1_SWITCH_LIGHT_LIM("P1_SWITCH_LIGHT_LIM"),
	P1_SWITCH_NUTRIENT_LIM("P1_SWITCH_NUTRIENT_LIM"),
	P1_SWITCH_TEMP_LIM("P1_SWITCH_TEMP_LIM"),
	PI_INTERVAL("PI_INTERVAL"),
	TModule(name) {

	ROOTSRHY.SetF(FisExport,True,"CG");
	SHOOTS.SetF(FisExport,True,"CG");
	P1_IC_MAC_PHBIO.SetF(FisExport,True,"CG");
	P1_SEPT_TO_JAN_CONV.SetF(FisExport,True,"CG");
	PHBIO_LITTERFALL.SetF(FisExport,True,"CG");
	P1_MAC_PH_NC.SetF(FisExport,True,"CG");
	PHBIO_NET_PROD.SetF(FisExport,True,"CG");
	P1_CELL_SIZE.SetF(FisImport,True,"CG");
	CONS_INGEST_NPHBIO.SetF(FisImport,True,"CG");
	GEMINATION.SetF(FisImport,True,"CG");
	CONS_INGEST_PHBIO.SetF(FisImport,True,"CG");
	P1_AIR_TEMP.SetF(FisImport,True,"CG");
	H2O_TEMP.SetF(FisImport,True,"CG");
	P1_LEAF_GROW_SEASON.SetF(FisImport,True,"CG");
	P1_DIN_SED_CONC_MAP.SetF(FisImport,True,"CG");
	P1_PO4_SED_WT_CONC.SetF(FisImport,True,"CG");
	ZOSTRA_LIGHT_LIM.SetF(FisImport,True,"CG");
	DAYS.SetF(FisImport,True,"CG");
	PHBIO_LTTR_RATIO.SetF(FisExport,True,"CG");
	LEAF_LENGTH.SetF(FisExport,True,"CG");
	P1_MAC_PHBIO_PC.SetF(FisExport,True,"CG");
}	
int EELGRASS_module::ROOTSRHY_I105_exe() {
	float value;

	ROOTSRHY.UpdateIntegrator();
	switch( ROOTSRHY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ROOTSRHY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( NPH_MAC_GPP.Value(p)-NPHBIO_RESP.Value(p) )-NPHBIO_MORT.Value(p) )-NPHBIO_CONSUMED.Value(p) );
			ROOTSRHY.Update( p, value, dT() );
		}
		ROOTSRHY.GrabMemory();
		if( ROOTSRHY.GetF(FLinkEdges) ) { ROOTSRHY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( NPH_MAC_GPP.Value()-NPHBIO_RESP.Value() )-NPHBIO_MORT.Value() )-NPHBIO_CONSUMED.Value() );
			ROOTSRHY.Update( value, dT() );
	  } break;
	}
	return 0;
}

int EELGRASS_module::ROOTSRHY_i106_exe() {
	float value;

	ROOTSRHY.UpdateIntegrator();
	switch( ROOTSRHY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ROOTSRHY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_CELL_SIZE.Value(p)*IC_MAC_NPHBIO.Value(p) );
			ROOTSRHY.InitValue( p, value );
		}
		ROOTSRHY.GrabMemory();
		if( ROOTSRHY.GetF(FLinkEdges) ) { ROOTSRHY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_CELL_SIZE.Value()*IC_MAC_NPHBIO.Value() );
			ROOTSRHY.InitValue( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::NPH_MAC_GPP_u107_exe() {
	float value;

	switch( NPH_MAC_GPP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NPH_MAC_GPP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Max(((float)0), ( PHMAC_GROWTH_TO_ROOTS.Value(p)*PH_MAC_GPP.Value(p) ));
			NPH_MAC_GPP.Update( p, value );
		}
		NPH_MAC_GPP.GrabMemory();
		if( NPH_MAC_GPP.GetF(FICFlux) ) NPH_MAC_GPP.Cov().Set(0.0); 
		if( NPH_MAC_GPP.GetF(FLinkEdges) ) { NPH_MAC_GPP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Max(((float)0), ( PHMAC_GROWTH_TO_ROOTS.Value()*PH_MAC_GPP.Value() ));
			NPH_MAC_GPP.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::NPHBIO_RESP_u108_exe() {
	float value;

	switch( NPHBIO_RESP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NPHBIO_RESP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_NPHBIO_RESP_RATE.Value(p)*MAC_TEMP_RESP_LIM.Value(p) )*pow((double)ROOTSRHY.Value(p),(double)P1_BETA.Value(p) ) );
			NPHBIO_RESP.Update( p, value );
		}
		NPHBIO_RESP.GrabMemory();
		if( NPHBIO_RESP.GetF(FICFlux) ) NPHBIO_RESP.Cov().Set(0.0); 
		if( NPHBIO_RESP.GetF(FLinkEdges) ) { NPHBIO_RESP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_NPHBIO_RESP_RATE.Value()*MAC_TEMP_RESP_LIM.Value() )*pow((double)ROOTSRHY.Value(),(double)P1_BETA.Value() ) );
			NPHBIO_RESP.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::NPHBIO_MORT_u109_exe() {
	float value;

	switch( NPHBIO_MORT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NPHBIO_MORT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ROOTSRHY.Value(p)*P1_NPHBIO_MORT_RATE.Value(p) );
			NPHBIO_MORT.Update( p, value );
		}
		NPHBIO_MORT.GrabMemory();
		if( NPHBIO_MORT.GetF(FICFlux) ) NPHBIO_MORT.Cov().Set(0.0); 
		if( NPHBIO_MORT.GetF(FLinkEdges) ) { NPHBIO_MORT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ROOTSRHY.Value()*P1_NPHBIO_MORT_RATE.Value() );
			NPHBIO_MORT.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::NPHBIO_CONSUMED_u110_exe() {
	float value;

	switch( NPHBIO_CONSUMED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NPHBIO_CONSUMED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  CONS_INGEST_NPHBIO.Value(p);
			NPHBIO_CONSUMED.Update( p, value );
		}
		NPHBIO_CONSUMED.GrabMemory();
		if( NPHBIO_CONSUMED.GetF(FICFlux) ) NPHBIO_CONSUMED.Cov().Set(0.0); 
		if( NPHBIO_CONSUMED.GetF(FLinkEdges) ) { NPHBIO_CONSUMED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  CONS_INGEST_NPHBIO.Value();
			NPHBIO_CONSUMED.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::SHOOTS_I111_exe() {
	float value;

	SHOOTS.UpdateIntegrator();
	switch( SHOOTS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SHOOTS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( PH_MAC_GPP.Value(p)+NEW_PLANTS.Value(p) )-PHBIO_RESP.Value(p) )-PHBIO_CONSUMED.Value(p) )-PHBIO_LITTERFALL.Value(p) )-NPH_MAC_GPP.Value(p) );
			SHOOTS.Update( p, value, dT() );
		}
		SHOOTS.GrabMemory();
		if( SHOOTS.GetF(FLinkEdges) ) { SHOOTS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( PH_MAC_GPP.Value()+NEW_PLANTS.Value() )-PHBIO_RESP.Value() )-PHBIO_CONSUMED.Value() )-PHBIO_LITTERFALL.Value() )-NPH_MAC_GPP.Value() );
			SHOOTS.Update( value, dT() );
	  } break;
	}
	return 0;
}

int EELGRASS_module::SHOOTS_i112_exe() {
	float value;

	SHOOTS.UpdateIntegrator();
	switch( SHOOTS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SHOOTS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_CELL_SIZE.Value(p)*( P1_IC_MAC_PHBIO.Value(p)/P1_SEPT_TO_JAN_CONV.Value(p) ) );
			SHOOTS.InitValue( p, value );
		}
		SHOOTS.GrabMemory();
		if( SHOOTS.GetF(FLinkEdges) ) { SHOOTS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_CELL_SIZE.Value()*( P1_IC_MAC_PHBIO.Value()/P1_SEPT_TO_JAN_CONV.Value() ) );
			SHOOTS.InitValue( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::PH_MAC_GPP_u113_exe() {
	float value;

	switch( PH_MAC_GPP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PH_MAC_GPP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SHOOTS.Value(p) <  0.001 ) ) ? ( 0.0 ) : ( ( ( P1_MAC_PP_RATE.Value(p)*ZOSTRA_PROD_LIM.Value(p) )*pow((double)SHOOTS.Value(p),(double)P1_BETA.Value(p) ) ) ) ) ;
			PH_MAC_GPP.Update( p, value );
		}
		PH_MAC_GPP.GrabMemory();
		if( PH_MAC_GPP.GetF(FICFlux) ) PH_MAC_GPP.Cov().Set(0.0); 
		if( PH_MAC_GPP.GetF(FLinkEdges) ) { PH_MAC_GPP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SHOOTS.Value() <  0.001 ) ) ? ( 0.0 ) : ( ( ( P1_MAC_PP_RATE.Value()*ZOSTRA_PROD_LIM.Value() )*pow((double)SHOOTS.Value(),(double)P1_BETA.Value() ) ) ) ) ;
			PH_MAC_GPP.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::NEW_PLANTS_u114_exe() {
	float value;

	switch( NEW_PLANTS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NEW_PLANTS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  GEMINATION.Value(p);
			NEW_PLANTS.Update( p, value );
		}
		NEW_PLANTS.GrabMemory();
		if( NEW_PLANTS.GetF(FICFlux) ) NEW_PLANTS.Cov().Set(0.0); 
		if( NEW_PLANTS.GetF(FLinkEdges) ) { NEW_PLANTS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  GEMINATION.Value();
			NEW_PLANTS.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::PHBIO_RESP_u115_exe() {
	float value;

	switch( PHBIO_RESP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_RESP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_PHBIO_RESP_RATE.Value(p)*MAC_TEMP_RESP_LIM.Value(p) )*SHOOTS.Value(p) );
			PHBIO_RESP.Update( p, value );
		}
		PHBIO_RESP.GrabMemory();
		if( PHBIO_RESP.GetF(FICFlux) ) PHBIO_RESP.Cov().Set(0.0); 
		if( PHBIO_RESP.GetF(FLinkEdges) ) { PHBIO_RESP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_PHBIO_RESP_RATE.Value()*MAC_TEMP_RESP_LIM.Value() )*SHOOTS.Value() );
			PHBIO_RESP.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::PHBIO_CONSUMED_u116_exe() {
	float value;

	switch( PHBIO_CONSUMED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_CONSUMED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  CONS_INGEST_PHBIO.Value(p);
			PHBIO_CONSUMED.Update( p, value );
		}
		PHBIO_CONSUMED.GrabMemory();
		if( PHBIO_CONSUMED.GetF(FICFlux) ) PHBIO_CONSUMED.Cov().Set(0.0); 
		if( PHBIO_CONSUMED.GetF(FLinkEdges) ) { PHBIO_CONSUMED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  CONS_INGEST_PHBIO.Value();
			PHBIO_CONSUMED.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::PHBIO_LITTERFALL_u117_exe() {
	float value;

	switch( PHBIO_LITTERFALL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_LITTERFALL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ((float)1)/( PI_INTERVAL.Value(p)*((float)24) ) )*SHOOTS.Value(p) );
			PHBIO_LITTERFALL.Update( p, value );
		}
		PHBIO_LITTERFALL.GrabMemory();
		if( PHBIO_LITTERFALL.GetF(FICFlux) ) PHBIO_LITTERFALL.Cov().Set(0.0); 
		if( PHBIO_LITTERFALL.GetF(FLinkEdges) ) { PHBIO_LITTERFALL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ((float)1)/( PI_INTERVAL.Value()*((float)24) ) )*SHOOTS.Value() );
			PHBIO_LITTERFALL.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::ACTUAL_LEAF_GROWTH_u118_exe() {
	float value;

	switch( ACTUAL_LEAF_GROWTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ACTUAL_LEAF_GROWTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PH_MAC_GPP.Value(p)-NPH_MAC_GPP.Value(p) );
			ACTUAL_LEAF_GROWTH.Update( p, value );
		}
		ACTUAL_LEAF_GROWTH.GrabMemory();
		if( ACTUAL_LEAF_GROWTH.GetF(FLinkEdges) ) { ACTUAL_LEAF_GROWTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PH_MAC_GPP.Value()-NPH_MAC_GPP.Value() );
			ACTUAL_LEAF_GROWTH.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::IC_MAC_NPHBIO_u119_exe() {
	float value;

	switch( IC_MAC_NPHBIO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = IC_MAC_NPHBIO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_PERC_NPHBIO.Value(p)*P1_IC_MAC_PHBIO.Value(p) );
			IC_MAC_NPHBIO.Update( p, value );
		}
		IC_MAC_NPHBIO.GrabMemory();
		if( IC_MAC_NPHBIO.GetF(FLinkEdges) ) { IC_MAC_NPHBIO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_PERC_NPHBIO.Value()*P1_IC_MAC_PHBIO.Value() );
			IC_MAC_NPHBIO.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::LEAF_LENGTH_u120_exe() {
	float value;

	switch( LEAF_LENGTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LEAF_LENGTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ((float)5)*SHOOTS.Value(p) )/( ( .29*((float)500) )*P1_CELL_SIZE.Value(p) ) );
			LEAF_LENGTH.Update( p, value );
		}
		LEAF_LENGTH.GrabMemory();
		if( LEAF_LENGTH.GetF(FLinkEdges) ) { LEAF_LENGTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ((float)5)*SHOOTS.Value() )/( ( .29*((float)500) )*P1_CELL_SIZE.Value() ) );
			LEAF_LENGTH.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::LEAF_LIMIT_COEFF_u121_exe() {
	float value;

	switch( LEAF_LIMIT_COEFF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LEAF_LIMIT_COEFF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SHOOTS.Value(p) <= ((float)0) ) ) ? ( ((float)0) ) : ( ( LL_CAL_CF.Value(p)*SL::Max(((float)0), ( ROOTSRHY.Value(p)/SHOOTS.Value(p) )) ) ) ) ;
			LEAF_LIMIT_COEFF.Update( p, value );
		}
		LEAF_LIMIT_COEFF.GrabMemory();
		if( LEAF_LIMIT_COEFF.GetF(FLinkEdges) ) { LEAF_LIMIT_COEFF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SHOOTS.Value() <= ((float)0) ) ) ? ( ((float)0) ) : ( ( LL_CAL_CF.Value()*SL::Max(((float)0), ( ROOTSRHY.Value()/SHOOTS.Value() )) ) ) ) ;
			LEAF_LIMIT_COEFF.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::LL_CAL_CF_u122_exe() {
	float value;

	switch( LL_CAL_CF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LL_CAL_CF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			LL_CAL_CF.Update( p, LL_CAL_CF.ParameterValue(value,p) );
		}
		LL_CAL_CF.GrabMemory();
		if( LL_CAL_CF.GetF(FLinkEdges) ) { LL_CAL_CF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			LL_CAL_CF.Update( LL_CAL_CF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EELGRASS_module::MAC_NET_PROD_u123_exe() {
	float value;

	switch( MAC_NET_PROD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAC_NET_PROD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( NPHBIO_NET_PROD.Value(p)+PHBIO_NET_PROD.Value(p) );
			MAC_NET_PROD.Update( p, value );
		}
		MAC_NET_PROD.GrabMemory();
		if( MAC_NET_PROD.GetF(FLinkEdges) ) { MAC_NET_PROD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( NPHBIO_NET_PROD.Value()+PHBIO_NET_PROD.Value() );
			MAC_NET_PROD.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::MAC_TEMP_RESP_LIM_u124_exe() {
	float value;

	switch( MAC_TEMP_RESP_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = MAC_TEMP_RESP_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( P1_SWITCH_AIR_TEMP_LIM.Value(p) == ((float)1) ) ) ? ( ( ((float)1)-( ( ((float)40)-P1_AIR_TEMP.Value(p) )/40 ) ) ) : ( ( .0107*SL::Exp(( .047*H2O_TEMP.Value(p) )) ) ) ) ;
			MAC_TEMP_RESP_LIM.Update( p, value );
		}
		MAC_TEMP_RESP_LIM.GrabMemory();
		if( MAC_TEMP_RESP_LIM.GetF(FLinkEdges) ) { MAC_TEMP_RESP_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( P1_SWITCH_AIR_TEMP_LIM.Value() == ((float)1) ) ) ? ( ( ((float)1)-( ( ((float)40)-P1_AIR_TEMP.Value() )/40 ) ) ) : ( ( .0107*SL::Exp(( .047*H2O_TEMP.Value() )) ) ) ) ;
			MAC_TEMP_RESP_LIM.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::NPHBIO_NET_PROD_u125_exe() {
	float value;

	switch( NPHBIO_NET_PROD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NPHBIO_NET_PROD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( NPH_MAC_GPP.Value(p)-NPHBIO_RESP.Value(p) );
			NPHBIO_NET_PROD.Update( p, value );
		}
		NPHBIO_NET_PROD.GrabMemory();
		if( NPHBIO_NET_PROD.GetF(FLinkEdges) ) { NPHBIO_NET_PROD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( NPH_MAC_GPP.Value()-NPHBIO_RESP.Value() );
			NPHBIO_NET_PROD.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::PHBIO_LTTR_RATIO_u126_exe() {
	float value;

	switch( PHBIO_LTTR_RATIO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_LTTR_RATIO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SHOOTS.Value(p) == ((float)0) ) ) ? ( ((float)0) ) : ( ( PHBIO_LITTERFALL.Value(p)/SHOOTS.Value(p) ) ) ) ;
			PHBIO_LTTR_RATIO.Update( p, value );
		}
		PHBIO_LTTR_RATIO.GrabMemory();
		if( PHBIO_LTTR_RATIO.GetF(FLinkEdges) ) { PHBIO_LTTR_RATIO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SHOOTS.Value() == ((float)0) ) ) ? ( ((float)0) ) : ( ( PHBIO_LITTERFALL.Value()/SHOOTS.Value() ) ) ) ;
			PHBIO_LTTR_RATIO.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::PHBIO_NET_PROD_u127_exe() {
	float value;

	switch( PHBIO_NET_PROD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHBIO_NET_PROD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( PH_MAC_GPP.Value(p)-NPH_MAC_GPP.Value(p) )-PHBIO_RESP.Value(p) );
			PHBIO_NET_PROD.Update( p, value );
		}
		PHBIO_NET_PROD.GrabMemory();
		if( PHBIO_NET_PROD.GetF(FLinkEdges) ) { PHBIO_NET_PROD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( PH_MAC_GPP.Value()-NPH_MAC_GPP.Value() )-PHBIO_RESP.Value() );
			PHBIO_NET_PROD.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::PHMAC_GROWTH_TO_ROOTS_u128_exe() {
	float value;

	switch( PHMAC_GROWTH_TO_ROOTS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHMAC_GROWTH_TO_ROOTS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)1)-( LEAF_LIMIT_COEFF.Value(p)*P1_LEAF_GROW_SEASON.Value(p) ) );
			PHMAC_GROWTH_TO_ROOTS.Update( p, value );
		}
		PHMAC_GROWTH_TO_ROOTS.GrabMemory();
		if( PHMAC_GROWTH_TO_ROOTS.GetF(FLinkEdges) ) { PHMAC_GROWTH_TO_ROOTS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)1)-( LEAF_LIMIT_COEFF.Value()*P1_LEAF_GROW_SEASON.Value() ) );
			PHMAC_GROWTH_TO_ROOTS.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::ROOTS_TO_LEAVES_u129_exe() {
	float value;

	switch( ROOTS_TO_LEAVES.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ROOTS_TO_LEAVES.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SHOOTS.Value(p) <  ((float)1) ) ) ? ( ((float)0) ) : ( ( ROOTSRHY.Value(p)/SHOOTS.Value(p) ) ) ) ;
			ROOTS_TO_LEAVES.Update( p, value );
		}
		ROOTS_TO_LEAVES.GrabMemory();
		if( ROOTS_TO_LEAVES.GetF(FLinkEdges) ) { ROOTS_TO_LEAVES.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SHOOTS.Value() <  ((float)1) ) ) ? ( ((float)0) ) : ( ( ROOTSRHY.Value()/SHOOTS.Value() ) ) ) ;
			ROOTS_TO_LEAVES.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::ZOSTRA_NUT_LIM_u130_exe() {
	float value;

	switch( ZOSTRA_NUT_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ZOSTRA_NUT_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(( P1_DIN_SED_CONC_MAP.Value(p)/( P1_DIN_SED_CONC_MAP.Value(p)+P1_SAT_N.Value(p) ) ), ( P1_PO4_SED_WT_CONC.Value(p)/( P1_PO4_SED_WT_CONC.Value(p)+P1_SAT_P.Value(p) ) ));
			ZOSTRA_NUT_LIM.Update( p, value );
		}
		ZOSTRA_NUT_LIM.GrabMemory();
		if( ZOSTRA_NUT_LIM.GetF(FLinkEdges) ) { ZOSTRA_NUT_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(( P1_DIN_SED_CONC_MAP.Value()/( P1_DIN_SED_CONC_MAP.Value()+P1_SAT_N.Value() ) ), ( P1_PO4_SED_WT_CONC.Value()/( P1_PO4_SED_WT_CONC.Value()+P1_SAT_P.Value() ) ));
			ZOSTRA_NUT_LIM.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::ZOSTRA_PROD_LIM_u131_exe() {
	float value;

	switch( ZOSTRA_PROD_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ZOSTRA_PROD_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( pow((double)ZOSTRA_LIGHT_LIM.Value(p),(double)P1_SWITCH_LIGHT_LIM.Value(p) )*pow((double)ZOSTRA_NUT_LIM.Value(p),(double)P1_SWITCH_NUTRIENT_LIM.Value(p) ) )*pow((double)ZOSTRA_TEMP_LIM.Value(p),(double)P1_SWITCH_TEMP_LIM.Value(p) ) );
			ZOSTRA_PROD_LIM.Update( p, value );
		}
		ZOSTRA_PROD_LIM.GrabMemory();
		if( ZOSTRA_PROD_LIM.GetF(FLinkEdges) ) { ZOSTRA_PROD_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( pow((double)ZOSTRA_LIGHT_LIM.Value(),(double)P1_SWITCH_LIGHT_LIM.Value() )*pow((double)ZOSTRA_NUT_LIM.Value(),(double)P1_SWITCH_NUTRIENT_LIM.Value() ) )*pow((double)ZOSTRA_TEMP_LIM.Value(),(double)P1_SWITCH_TEMP_LIM.Value() ) );
			ZOSTRA_PROD_LIM.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::ZOSTRA_TEMP_LIM_u132_exe() {
	float value;

	switch( ZOSTRA_TEMP_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ZOSTRA_TEMP_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( P1_SWITCH_AIR_TEMP_LIM.Value(p) == ((float)1) ) ) ? (  ( ( ( P1_AIR_TEMP.Value(p) <= ((float)0) ) ) ? ( ((float)0) ) : ( ( ((float)1)-( ( P1_MAX_AIR_TEMP.Value(p)-P1_AIR_TEMP.Value(p) )/P1_MAX_AIR_TEMP.Value(p) ) ) ) )  ) : ( SL::Min(((float)1), ( .22*SL::Exp(( ( .07-( 0.00001*SL::Exp(( .28*H2O_TEMP.Value(p) )) ) )*H2O_TEMP.Value(p) )) )) ) ) ;
			ZOSTRA_TEMP_LIM.Update( p, value );
		}
		ZOSTRA_TEMP_LIM.GrabMemory();
		if( ZOSTRA_TEMP_LIM.GetF(FLinkEdges) ) { ZOSTRA_TEMP_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( P1_SWITCH_AIR_TEMP_LIM.Value() == ((float)1) ) ) ? (  ( ( ( P1_AIR_TEMP.Value() <= ((float)0) ) ) ? ( ((float)0) ) : ( ( ((float)1)-( ( P1_MAX_AIR_TEMP.Value()-P1_AIR_TEMP.Value() )/P1_MAX_AIR_TEMP.Value() ) ) ) )  ) : ( SL::Min(((float)1), ( .22*SL::Exp(( ( .07-( 0.00001*SL::Exp(( .28*H2O_TEMP.Value() )) ) )*H2O_TEMP.Value() )) )) ) ) ;
			ZOSTRA_TEMP_LIM.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::P1_BETA_u133_exe() {
	float value;

	switch( P1_BETA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_BETA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.500000;
			P1_BETA.Update( p, P1_BETA.ParameterValue(value,p) );
		}
		P1_BETA.GrabMemory();
		if( P1_BETA.GetF(FLinkEdges) ) { P1_BETA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.500000;
			P1_BETA.Update( P1_BETA.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EELGRASS_module::P1_IC_MAC_PHBIO_u134_exe() {
	float value;

	switch( P1_IC_MAC_PHBIO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_IC_MAC_PHBIO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.01225;
			P1_IC_MAC_PHBIO.Update( p, value );
		}
		P1_IC_MAC_PHBIO.GrabMemory();
		if( P1_IC_MAC_PHBIO.GetF(FLinkEdges) ) { P1_IC_MAC_PHBIO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.01225;
			P1_IC_MAC_PHBIO.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::P1_MAC_NONPH_NC_u135_exe() {
	float value;

	switch( P1_MAC_NONPH_NC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAC_NONPH_NC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.010000;
			P1_MAC_NONPH_NC.Update( p, P1_MAC_NONPH_NC.ParameterValue(value,p) );
		}
		P1_MAC_NONPH_NC.GrabMemory();
		if( P1_MAC_NONPH_NC.GetF(FLinkEdges) ) { P1_MAC_NONPH_NC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.010000;
			P1_MAC_NONPH_NC.Update( P1_MAC_NONPH_NC.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EELGRASS_module::P1_MAC_NONPH_PC_u136_exe() {
	float value;

	switch( P1_MAC_NONPH_PC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAC_NONPH_PC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.005000;
			P1_MAC_NONPH_PC.Update( p, P1_MAC_NONPH_PC.ParameterValue(value,p) );
		}
		P1_MAC_NONPH_PC.GrabMemory();
		if( P1_MAC_NONPH_PC.GetF(FLinkEdges) ) { P1_MAC_NONPH_PC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.005000;
			P1_MAC_NONPH_PC.Update( P1_MAC_NONPH_PC.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EELGRASS_module::P1_MAC_PHBIO_PC_u137_exe() {
	float value;

	switch( P1_MAC_PHBIO_PC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAC_PHBIO_PC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.005000;
			P1_MAC_PHBIO_PC.Update( p, P1_MAC_PHBIO_PC.ParameterValue(value,p) );
		}
		P1_MAC_PHBIO_PC.GrabMemory();
		if( P1_MAC_PHBIO_PC.GetF(FLinkEdges) ) { P1_MAC_PHBIO_PC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.005000;
			P1_MAC_PHBIO_PC.Update( P1_MAC_PHBIO_PC.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EELGRASS_module::P1_MAC_PH_NC_u138_exe() {
	float value;

	switch( P1_MAC_PH_NC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAC_PH_NC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.010000;
			P1_MAC_PH_NC.Update( p, P1_MAC_PH_NC.ParameterValue(value,p) );
		}
		P1_MAC_PH_NC.GrabMemory();
		if( P1_MAC_PH_NC.GetF(FLinkEdges) ) { P1_MAC_PH_NC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.010000;
			P1_MAC_PH_NC.Update( P1_MAC_PH_NC.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EELGRASS_module::P1_MAC_PP_RATE_u139_exe() {
	float value;

	switch( P1_MAC_PP_RATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAC_PP_RATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.052000;
			P1_MAC_PP_RATE.Update( p, P1_MAC_PP_RATE.ParameterValue(value,p) );
		}
		P1_MAC_PP_RATE.GrabMemory();
		if( P1_MAC_PP_RATE.GetF(FLinkEdges) ) { P1_MAC_PP_RATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.052000;
			P1_MAC_PP_RATE.Update( P1_MAC_PP_RATE.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EELGRASS_module::P1_MAX_AIR_TEMP_u140_exe() {
	float value;

	switch( P1_MAX_AIR_TEMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAX_AIR_TEMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  40;
			P1_MAX_AIR_TEMP.Update( p, P1_MAX_AIR_TEMP.ParameterValue(value,p) );
		}
		P1_MAX_AIR_TEMP.GrabMemory();
		if( P1_MAX_AIR_TEMP.GetF(FLinkEdges) ) { P1_MAX_AIR_TEMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  40;
			P1_MAX_AIR_TEMP.Update( P1_MAX_AIR_TEMP.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EELGRASS_module::P1_NPHBIO_MORT_RATE_u141_exe() {
	float value;

	switch( P1_NPHBIO_MORT_RATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_NPHBIO_MORT_RATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000075;
			P1_NPHBIO_MORT_RATE.Update( p, P1_NPHBIO_MORT_RATE.ParameterValue(value,p) );
		}
		P1_NPHBIO_MORT_RATE.GrabMemory();
		if( P1_NPHBIO_MORT_RATE.GetF(FLinkEdges) ) { P1_NPHBIO_MORT_RATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000075;
			P1_NPHBIO_MORT_RATE.Update( P1_NPHBIO_MORT_RATE.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EELGRASS_module::P1_NPHBIO_RESP_RATE_u142_exe() {
	float value;

	switch( P1_NPHBIO_RESP_RATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_NPHBIO_RESP_RATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000296;
			P1_NPHBIO_RESP_RATE.Update( p, P1_NPHBIO_RESP_RATE.ParameterValue(value,p) );
		}
		P1_NPHBIO_RESP_RATE.GrabMemory();
		if( P1_NPHBIO_RESP_RATE.GetF(FLinkEdges) ) { P1_NPHBIO_RESP_RATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000296;
			P1_NPHBIO_RESP_RATE.Update( P1_NPHBIO_RESP_RATE.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EELGRASS_module::P1_PERC_NPHBIO_u143_exe() {
	float value;

	switch( P1_PERC_NPHBIO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PERC_NPHBIO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)3)/7 );
			P1_PERC_NPHBIO.Update( p, value );
		}
		P1_PERC_NPHBIO.GrabMemory();
		if( P1_PERC_NPHBIO.GetF(FLinkEdges) ) { P1_PERC_NPHBIO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)3)/7 );
			P1_PERC_NPHBIO.Update( value );
	  } break;
	}
	return 0;
}

int EELGRASS_module::P1_PHBIO_RESP_RATE_u144_exe() {
	float value;

	switch( P1_PHBIO_RESP_RATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHBIO_RESP_RATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000100;
			P1_PHBIO_RESP_RATE.Update( p, P1_PHBIO_RESP_RATE.ParameterValue(value,p) );
		}
		P1_PHBIO_RESP_RATE.GrabMemory();
		if( P1_PHBIO_RESP_RATE.GetF(FLinkEdges) ) { P1_PHBIO_RESP_RATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000100;
			P1_PHBIO_RESP_RATE.Update( P1_PHBIO_RESP_RATE.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EELGRASS_module::P1_SAT_N_u145_exe() {
	float value;

	switch( P1_SAT_N.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SAT_N.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000005;
			P1_SAT_N.Update( p, P1_SAT_N.ParameterValue(value,p) );
		}
		P1_SAT_N.GrabMemory();
		if( P1_SAT_N.GetF(FLinkEdges) ) { P1_SAT_N.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000005;
			P1_SAT_N.Update( P1_SAT_N.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EELGRASS_module::P1_SAT_P_u146_exe() {
	float value;

	switch( P1_SAT_P.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SAT_P.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000002;
			P1_SAT_P.Update( p, P1_SAT_P.ParameterValue(value,p) );
		}
		P1_SAT_P.GrabMemory();
		if( P1_SAT_P.GetF(FLinkEdges) ) { P1_SAT_P.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000002;
			P1_SAT_P.Update( P1_SAT_P.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EELGRASS_module::P1_SEPT_TO_JAN_CONV_u147_exe() {
	float value;

	switch( P1_SEPT_TO_JAN_CONV.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SEPT_TO_JAN_CONV.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  20;
			P1_SEPT_TO_JAN_CONV.Update( p, P1_SEPT_TO_JAN_CONV.ParameterValue(value,p) );
		}
		P1_SEPT_TO_JAN_CONV.GrabMemory();
		if( P1_SEPT_TO_JAN_CONV.GetF(FLinkEdges) ) { P1_SEPT_TO_JAN_CONV.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  20;
			P1_SEPT_TO_JAN_CONV.Update( P1_SEPT_TO_JAN_CONV.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EELGRASS_module::P1_SWITCH_AIR_TEMP_LIM_u148_exe() {
	float value;

	switch( P1_SWITCH_AIR_TEMP_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SWITCH_AIR_TEMP_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0;
			P1_SWITCH_AIR_TEMP_LIM.Update( p, P1_SWITCH_AIR_TEMP_LIM.ParameterValue(value,p) );
		}
		P1_SWITCH_AIR_TEMP_LIM.GrabMemory();
		if( P1_SWITCH_AIR_TEMP_LIM.GetF(FLinkEdges) ) { P1_SWITCH_AIR_TEMP_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0;
			P1_SWITCH_AIR_TEMP_LIM.Update( P1_SWITCH_AIR_TEMP_LIM.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EELGRASS_module::P1_SWITCH_LIGHT_LIM_u149_exe() {
	float value;

	switch( P1_SWITCH_LIGHT_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SWITCH_LIGHT_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_SWITCH_LIGHT_LIM.Update( p, P1_SWITCH_LIGHT_LIM.ParameterValue(value,p) );
		}
		P1_SWITCH_LIGHT_LIM.GrabMemory();
		if( P1_SWITCH_LIGHT_LIM.GetF(FLinkEdges) ) { P1_SWITCH_LIGHT_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_SWITCH_LIGHT_LIM.Update( P1_SWITCH_LIGHT_LIM.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EELGRASS_module::P1_SWITCH_NUTRIENT_LIM_u150_exe() {
	float value;

	switch( P1_SWITCH_NUTRIENT_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SWITCH_NUTRIENT_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_SWITCH_NUTRIENT_LIM.Update( p, P1_SWITCH_NUTRIENT_LIM.ParameterValue(value,p) );
		}
		P1_SWITCH_NUTRIENT_LIM.GrabMemory();
		if( P1_SWITCH_NUTRIENT_LIM.GetF(FLinkEdges) ) { P1_SWITCH_NUTRIENT_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_SWITCH_NUTRIENT_LIM.Update( P1_SWITCH_NUTRIENT_LIM.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EELGRASS_module::P1_SWITCH_TEMP_LIM_u151_exe() {
	float value;

	switch( P1_SWITCH_TEMP_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SWITCH_TEMP_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_SWITCH_TEMP_LIM.Update( p, P1_SWITCH_TEMP_LIM.ParameterValue(value,p) );
		}
		P1_SWITCH_TEMP_LIM.GrabMemory();
		if( P1_SWITCH_TEMP_LIM.GetF(FLinkEdges) ) { P1_SWITCH_TEMP_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_SWITCH_TEMP_LIM.Update( P1_SWITCH_TEMP_LIM.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EELGRASS_module::PI_INTERVAL_u152_exe() {
	float value;

	switch( PI_INTERVAL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PI_INTERVAL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph2(DAYS.Value(p));
			PI_INTERVAL.Update( p, value );
		}
		PI_INTERVAL.GrabMemory();
		if( PI_INTERVAL.GetF(FLinkEdges) ) { PI_INTERVAL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph2(DAYS.Value());
			PI_INTERVAL.Update( value );
	  } break;
	}
	return 0;
}

EELGRASS_module* EELGRASS_module::fInstance = NULL;
EELGRASS_module* EELGRASS_module::kNullModel = (EELGRASS_module*)0x1;
int EELGRASS_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int EELGRASS_module::InitVars() {
	
	TIME.SSInit(this);
	ROOTSRHY.SSInit(this);
	SHOOTS.SSInit(this);
	P1_IC_MAC_PHBIO.SSInit(this);
	P1_SEPT_TO_JAN_CONV.SSInit(this);
	PHBIO_LITTERFALL.SSInit(this);
	PHBIO_LITTERFALL.SetOrigin(&SHOOTS);
	P1_MAC_PH_NC.SSInit(this);
	PHBIO_NET_PROD.SSInit(this);
	P1_CELL_SIZE.SSInit(this);
	CONS_INGEST_NPHBIO.SSInit(this);
	GEMINATION.SSInit(this);
	CONS_INGEST_PHBIO.SSInit(this);
	P1_AIR_TEMP.SSInit(this);
	H2O_TEMP.SSInit(this);
	P1_LEAF_GROW_SEASON.SSInit(this);
	P1_DIN_SED_CONC_MAP.SSInit(this);
	P1_PO4_SED_WT_CONC.SSInit(this);
	ZOSTRA_LIGHT_LIM.SSInit(this);
	DAYS.SSInit(this);
	PHBIO_LTTR_RATIO.SSInit(this);
	LEAF_LENGTH.SSInit(this);
	P1_MAC_PHBIO_PC.SSInit(this);
	NPH_MAC_GPP.SSInit(this);
	NPH_MAC_GPP.SetOrigin(&SHOOTS);
	NPH_MAC_GPP.SetDestination(&ROOTSRHY);
	NPHBIO_RESP.SSInit(this);
	NPHBIO_RESP.SetOrigin(&ROOTSRHY);
	NPHBIO_MORT.SSInit(this);
	NPHBIO_MORT.SetOrigin(&ROOTSRHY);
	NPHBIO_CONSUMED.SSInit(this);
	NPHBIO_CONSUMED.SetOrigin(&ROOTSRHY);
	PH_MAC_GPP.SSInit(this);
	PH_MAC_GPP.SetDestination(&SHOOTS);
	NEW_PLANTS.SSInit(this);
	NEW_PLANTS.SetDestination(&SHOOTS);
	PHBIO_RESP.SSInit(this);
	PHBIO_RESP.SetOrigin(&SHOOTS);
	PHBIO_CONSUMED.SSInit(this);
	PHBIO_CONSUMED.SetOrigin(&SHOOTS);
	ACTUAL_LEAF_GROWTH.SSInit(this);
	IC_MAC_NPHBIO.SSInit(this);
	LEAF_LIMIT_COEFF.SSInit(this);
	LL_CAL_CF.SSInit(this);
	MAC_NET_PROD.SSInit(this);
	MAC_TEMP_RESP_LIM.SSInit(this);
	NPHBIO_NET_PROD.SSInit(this);
	PHMAC_GROWTH_TO_ROOTS.SSInit(this);
	ROOTS_TO_LEAVES.SSInit(this);
	ZOSTRA_NUT_LIM.SSInit(this);
	ZOSTRA_PROD_LIM.SSInit(this);
	ZOSTRA_TEMP_LIM.SSInit(this);
	P1_BETA.SSInit(this);
	P1_MAC_NONPH_NC.SSInit(this);
	P1_MAC_NONPH_PC.SSInit(this);
	P1_MAC_PP_RATE.SSInit(this);
	P1_MAX_AIR_TEMP.SSInit(this);
	P1_NPHBIO_MORT_RATE.SSInit(this);
	P1_NPHBIO_RESP_RATE.SSInit(this);
	P1_PERC_NPHBIO.SSInit(this);
	P1_PHBIO_RESP_RATE.SSInit(this);
	P1_SAT_N.SSInit(this);
	P1_SAT_P.SSInit(this);
	P1_SWITCH_AIR_TEMP_LIM.SSInit(this);
	P1_SWITCH_LIGHT_LIM.SSInit(this);
	P1_SWITCH_NUTRIENT_LIM.SSInit(this);
	P1_SWITCH_TEMP_LIM.SSInit(this);
	PI_INTERVAL.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int EELGRASS_module::SetupEvents() {
	TExecuteCommand* I105 = (TExecuteCommand*) ROOTSRHY.GetCommand("I105",TCommand::kIntegrate,TCommand::kCode);
	I105->SetExecutable(&ROOTSRHY_I105_exe_g);
	I105->Code() = "I105 <- ( ( ( NPH_MAC_GPP-NPHBIO_RESP )-NPHBIO_MORT )-NPHBIO_CONSUMED )";
	I105->AddDependency(NPH_MAC_GPP);
	I105->AddDependency(NPHBIO_RESP);
	I105->AddDependency(NPHBIO_MORT);
	I105->AddDependency(NPHBIO_CONSUMED);
	I105->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i106 = (TExecuteCommand*) ROOTSRHY.GetCommand("i106",TCommand::kInit,TCommand::kCode);
	i106->SetExecutable(&ROOTSRHY_i106_exe_g);
	i106->Code() = "i106 <- ( P1_CELL_SIZE*IC_MAC_NPHBIO )";
	i106->AddDependency(P1_CELL_SIZE);
	i106->AddDependency(IC_MAC_NPHBIO);
	i106->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I111 = (TExecuteCommand*) SHOOTS.GetCommand("I111",TCommand::kIntegrate,TCommand::kCode);
	I111->SetExecutable(&SHOOTS_I111_exe_g);
	I111->Code() = "I111 <- ( ( ( ( ( PH_MAC_GPP+NEW_PLANTS )-PHBIO_RESP )-PHBIO_CONSUMED )-PHBIO_LITTERFALL )-NPH_MAC_GPP )";
	I111->AddDependency(PH_MAC_GPP);
	I111->AddDependency(NEW_PLANTS);
	I111->AddDependency(PHBIO_RESP);
	I111->AddDependency(PHBIO_CONSUMED);
	I111->AddDependency(PHBIO_LITTERFALL);
	I111->AddDependency(NPH_MAC_GPP);
	I111->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i112 = (TExecuteCommand*) SHOOTS.GetCommand("i112",TCommand::kInit,TCommand::kCode);
	i112->SetExecutable(&SHOOTS_i112_exe_g);
	i112->Code() = "i112 <- ( P1_CELL_SIZE*( P1_IC_MAC_PHBIO/P1_SEPT_TO_JAN_CONV ) )";
	i112->AddDependency(P1_CELL_SIZE);
	i112->AddDependency(P1_IC_MAC_PHBIO);
	i112->AddDependency(P1_SEPT_TO_JAN_CONV);
	i112->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u134 = (TExecuteCommand*) P1_IC_MAC_PHBIO.GetCommand("u134",TCommand::kUpdate,TCommand::kCode);
	u134->SetExecutable(&P1_IC_MAC_PHBIO_u134_exe_g);
	u134->Code() = "u134 <- 0.01225";
	u134->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u147 = (TExecuteCommand*) P1_SEPT_TO_JAN_CONV.GetCommand("u147",TCommand::kUpdate,TCommand::kCode);
	u147->SetExecutable(&P1_SEPT_TO_JAN_CONV_u147_exe_g);
	u147->Code() = "u147 <- 20";
	u147->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u117 = (TExecuteCommand*) PHBIO_LITTERFALL.GetCommand("u117",TCommand::kUpdate,TCommand::kCode);
	u117->SetExecutable(&PHBIO_LITTERFALL_u117_exe_g);
	u117->Code() = "u117 <- ( ( ((float)1)/( PI_INTERVAL*((float)24) ) )*SHOOTS )";
	if( PHBIO_LITTERFALL.GetF(FisClamped) ) { u117->AddDependency(SHOOTS); }
	u117->AddDependency(PI_INTERVAL);
	u117->AddDependency(SHOOTS);
	u117->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u138 = (TExecuteCommand*) P1_MAC_PH_NC.GetCommand("u138",TCommand::kUpdate,TCommand::kCode);
	u138->SetExecutable(&P1_MAC_PH_NC_u138_exe_g);
	u138->Code() = "u138 <- 0.010000";
	u138->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u127 = (TExecuteCommand*) PHBIO_NET_PROD.GetCommand("u127",TCommand::kUpdate,TCommand::kCode);
	u127->SetExecutable(&PHBIO_NET_PROD_u127_exe_g);
	u127->Code() = "u127 <- ( ( PH_MAC_GPP-NPH_MAC_GPP )-PHBIO_RESP )";
	u127->AddDependency(PH_MAC_GPP);
	u127->AddDependency(NPH_MAC_GPP);
	u127->AddDependency(PHBIO_RESP);
	u127->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_CELL_SIZE_import = (TImportCommand*) P1_CELL_SIZE.GetCommand("P1_CELL_SIZE_import",TCommand::kUndefined,TCommand::kImport);
	P1_CELL_SIZE_import->Code() = "Import P1_CELL_SIZE from GLOBAL_module";
	P1_CELL_SIZE_import->AddDependency(P1_CELL_SIZE);
	P1_CELL_SIZE_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* CONS_INGEST_NPHBIO_import = (TImportCommand*) CONS_INGEST_NPHBIO.GetCommand("CONS_INGEST_NPHBIO_import",TCommand::kUndefined,TCommand::kImport);
	CONS_INGEST_NPHBIO_import->Code() = "Import CONS_INGEST_NPHBIO from CONSUMERS_module";
	CONS_INGEST_NPHBIO_import->AddDependency(CONS_INGEST_NPHBIO);
	CONS_INGEST_NPHBIO_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* GEMINATION_import = (TImportCommand*) GEMINATION.GetCommand("GEMINATION_import",TCommand::kUndefined,TCommand::kImport);
	GEMINATION_import->Code() = "Import GEMINATION from DETRITUS_module";
	GEMINATION_import->AddDependency(GEMINATION);
	GEMINATION_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* CONS_INGEST_PHBIO_import = (TImportCommand*) CONS_INGEST_PHBIO.GetCommand("CONS_INGEST_PHBIO_import",TCommand::kUndefined,TCommand::kImport);
	CONS_INGEST_PHBIO_import->Code() = "Import CONS_INGEST_PHBIO from CONSUMERS_module";
	CONS_INGEST_PHBIO_import->AddDependency(CONS_INGEST_PHBIO);
	CONS_INGEST_PHBIO_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_AIR_TEMP_import = (TImportCommand*) P1_AIR_TEMP.GetCommand("P1_AIR_TEMP_import",TCommand::kUndefined,TCommand::kImport);
	P1_AIR_TEMP_import->Code() = "Import P1_AIR_TEMP from GLOBAL_module";
	P1_AIR_TEMP_import->AddDependency(P1_AIR_TEMP);
	P1_AIR_TEMP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* H2O_TEMP_import = (TImportCommand*) H2O_TEMP.GetCommand("H2O_TEMP_import",TCommand::kUndefined,TCommand::kImport);
	H2O_TEMP_import->Code() = "Import H2O_TEMP from GLOBAL_module";
	H2O_TEMP_import->AddDependency(H2O_TEMP);
	H2O_TEMP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_LEAF_GROW_SEASON_import = (TImportCommand*) P1_LEAF_GROW_SEASON.GetCommand("P1_LEAF_GROW_SEASON_import",TCommand::kUndefined,TCommand::kImport);
	P1_LEAF_GROW_SEASON_import->Code() = "Import P1_LEAF_GROW_SEASON from GLOBAL_module";
	P1_LEAF_GROW_SEASON_import->AddDependency(P1_LEAF_GROW_SEASON);
	P1_LEAF_GROW_SEASON_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_DIN_SED_CONC_MAP_import = (TImportCommand*) P1_DIN_SED_CONC_MAP.GetCommand("P1_DIN_SED_CONC_MAP_import",TCommand::kUndefined,TCommand::kImport);
	P1_DIN_SED_CONC_MAP_import->Code() = "Import P1_DIN_SED_CONC_MAP from DIN_module";
	P1_DIN_SED_CONC_MAP_import->AddDependency(P1_DIN_SED_CONC_MAP);
	P1_DIN_SED_CONC_MAP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_PO4_SED_WT_CONC_import = (TImportCommand*) P1_PO4_SED_WT_CONC.GetCommand("P1_PO4_SED_WT_CONC_import",TCommand::kUndefined,TCommand::kImport);
	P1_PO4_SED_WT_CONC_import->Code() = "Import P1_PO4_SED_WT_CONC from PHOSPHATE_module";
	P1_PO4_SED_WT_CONC_import->AddDependency(P1_PO4_SED_WT_CONC);
	P1_PO4_SED_WT_CONC_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* ZOSTRA_LIGHT_LIM_import = (TImportCommand*) ZOSTRA_LIGHT_LIM.GetCommand("ZOSTRA_LIGHT_LIM_import",TCommand::kUndefined,TCommand::kImport);
	ZOSTRA_LIGHT_LIM_import->Code() = "Import ZOSTRA_LIGHT_LIM from GLOBAL_module";
	ZOSTRA_LIGHT_LIM_import->AddDependency(ZOSTRA_LIGHT_LIM);
	ZOSTRA_LIGHT_LIM_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DAYS_import = (TImportCommand*) DAYS.GetCommand("DAYS_import",TCommand::kUndefined,TCommand::kImport);
	DAYS_import->Code() = "Import DAYS from GLOBAL_module";
	DAYS_import->AddDependency(DAYS);
	DAYS_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u126 = (TExecuteCommand*) PHBIO_LTTR_RATIO.GetCommand("u126",TCommand::kUpdate,TCommand::kCode);
	u126->SetExecutable(&PHBIO_LTTR_RATIO_u126_exe_g);
	u126->Code() = "u126 <-  ( ( ( SHOOTS == ((float)0) ) ) ? ( ((float)0) ) : ( ( PHBIO_LITTERFALL/SHOOTS ) ) ) ";
	u126->AddDependency(SHOOTS);
	u126->AddDependency(PHBIO_LITTERFALL);
	u126->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u120 = (TExecuteCommand*) LEAF_LENGTH.GetCommand("u120",TCommand::kUpdate,TCommand::kCode);
	u120->SetExecutable(&LEAF_LENGTH_u120_exe_g);
	u120->Code() = "u120 <- ( ( ((float)5)*SHOOTS )/( ( .29*((float)500) )*P1_CELL_SIZE ) )";
	u120->AddDependency(SHOOTS);
	u120->AddDependency(P1_CELL_SIZE);
	u120->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u137 = (TExecuteCommand*) P1_MAC_PHBIO_PC.GetCommand("u137",TCommand::kUpdate,TCommand::kCode);
	u137->SetExecutable(&P1_MAC_PHBIO_PC_u137_exe_g);
	u137->Code() = "u137 <- 0.005000";
	u137->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u107 = (TExecuteCommand*) NPH_MAC_GPP.GetCommand("u107",TCommand::kUpdate,TCommand::kCode);
	u107->SetExecutable(&NPH_MAC_GPP_u107_exe_g);
	u107->Code() = "u107 <- SL::Max(((float)0), ( PHMAC_GROWTH_TO_ROOTS*PH_MAC_GPP ))";
	if( NPH_MAC_GPP.GetF(FisClamped) ) { u107->AddDependency(SHOOTS); }
	u107->AddDependency(PHMAC_GROWTH_TO_ROOTS);
	u107->AddDependency(PH_MAC_GPP);
	u107->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u108 = (TExecuteCommand*) NPHBIO_RESP.GetCommand("u108",TCommand::kUpdate,TCommand::kCode);
	u108->SetExecutable(&NPHBIO_RESP_u108_exe_g);
	u108->Code() = "u108 <- ( ( P1_NPHBIO_RESP_RATE*MAC_TEMP_RESP_LIM )*pow((double)ROOTSRHY,(double)P1_BETA ) )";
	if( NPHBIO_RESP.GetF(FisClamped) ) { u108->AddDependency(ROOTSRHY); }
	u108->AddDependency(P1_NPHBIO_RESP_RATE);
	u108->AddDependency(MAC_TEMP_RESP_LIM);
	u108->AddDependency(ROOTSRHY);
	u108->AddDependency(P1_BETA);
	u108->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u109 = (TExecuteCommand*) NPHBIO_MORT.GetCommand("u109",TCommand::kUpdate,TCommand::kCode);
	u109->SetExecutable(&NPHBIO_MORT_u109_exe_g);
	u109->Code() = "u109 <- ( ROOTSRHY*P1_NPHBIO_MORT_RATE )";
	if( NPHBIO_MORT.GetF(FisClamped) ) { u109->AddDependency(ROOTSRHY); }
	u109->AddDependency(ROOTSRHY);
	u109->AddDependency(P1_NPHBIO_MORT_RATE);
	u109->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u110 = (TExecuteCommand*) NPHBIO_CONSUMED.GetCommand("u110",TCommand::kUpdate,TCommand::kCode);
	u110->SetExecutable(&NPHBIO_CONSUMED_u110_exe_g);
	u110->Code() = "u110 <- CONS_INGEST_NPHBIO";
	if( NPHBIO_CONSUMED.GetF(FisClamped) ) { u110->AddDependency(ROOTSRHY); }
	u110->AddDependency(CONS_INGEST_NPHBIO);
	u110->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u113 = (TExecuteCommand*) PH_MAC_GPP.GetCommand("u113",TCommand::kUpdate,TCommand::kCode);
	u113->SetExecutable(&PH_MAC_GPP_u113_exe_g);
	u113->Code() = "u113 <-  ( ( ( SHOOTS <  0.001 ) ) ? ( 0.0 ) : ( ( ( P1_MAC_PP_RATE*ZOSTRA_PROD_LIM )*pow((double)SHOOTS,(double)P1_BETA ) ) ) ) ";
	u113->AddDependency(SHOOTS);
	u113->AddDependency(P1_MAC_PP_RATE);
	u113->AddDependency(ZOSTRA_PROD_LIM);
	u113->AddDependency(P1_BETA);
	u113->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u114 = (TExecuteCommand*) NEW_PLANTS.GetCommand("u114",TCommand::kUpdate,TCommand::kCode);
	u114->SetExecutable(&NEW_PLANTS_u114_exe_g);
	u114->Code() = "u114 <- GEMINATION";
	u114->AddDependency(GEMINATION);
	u114->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u115 = (TExecuteCommand*) PHBIO_RESP.GetCommand("u115",TCommand::kUpdate,TCommand::kCode);
	u115->SetExecutable(&PHBIO_RESP_u115_exe_g);
	u115->Code() = "u115 <- ( ( P1_PHBIO_RESP_RATE*MAC_TEMP_RESP_LIM )*SHOOTS )";
	if( PHBIO_RESP.GetF(FisClamped) ) { u115->AddDependency(SHOOTS); }
	u115->AddDependency(P1_PHBIO_RESP_RATE);
	u115->AddDependency(MAC_TEMP_RESP_LIM);
	u115->AddDependency(SHOOTS);
	u115->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u116 = (TExecuteCommand*) PHBIO_CONSUMED.GetCommand("u116",TCommand::kUpdate,TCommand::kCode);
	u116->SetExecutable(&PHBIO_CONSUMED_u116_exe_g);
	u116->Code() = "u116 <- CONS_INGEST_PHBIO";
	if( PHBIO_CONSUMED.GetF(FisClamped) ) { u116->AddDependency(SHOOTS); }
	u116->AddDependency(CONS_INGEST_PHBIO);
	u116->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u118 = (TExecuteCommand*) ACTUAL_LEAF_GROWTH.GetCommand("u118",TCommand::kUpdate,TCommand::kCode);
	u118->SetExecutable(&ACTUAL_LEAF_GROWTH_u118_exe_g);
	u118->Code() = "u118 <- ( PH_MAC_GPP-NPH_MAC_GPP )";
	u118->AddDependency(PH_MAC_GPP);
	u118->AddDependency(NPH_MAC_GPP);
	u118->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u119 = (TExecuteCommand*) IC_MAC_NPHBIO.GetCommand("u119",TCommand::kUpdate,TCommand::kCode);
	u119->SetExecutable(&IC_MAC_NPHBIO_u119_exe_g);
	u119->Code() = "u119 <- ( P1_PERC_NPHBIO*P1_IC_MAC_PHBIO )";
	u119->AddDependency(P1_PERC_NPHBIO);
	u119->AddDependency(P1_IC_MAC_PHBIO);
	u119->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u121 = (TExecuteCommand*) LEAF_LIMIT_COEFF.GetCommand("u121",TCommand::kUpdate,TCommand::kCode);
	u121->SetExecutable(&LEAF_LIMIT_COEFF_u121_exe_g);
	u121->Code() = "u121 <-  ( ( ( SHOOTS <= ((float)0) ) ) ? ( ((float)0) ) : ( ( LL_CAL_CF*SL::Max(((float)0), ( ROOTSRHY/SHOOTS )) ) ) ) ";
	u121->AddDependency(SHOOTS);
	u121->AddDependency(LL_CAL_CF);
	u121->AddDependency(ROOTSRHY);
	u121->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u122 = (TExecuteCommand*) LL_CAL_CF.GetCommand("u122",TCommand::kUpdate,TCommand::kCode);
	u122->SetExecutable(&LL_CAL_CF_u122_exe_g);
	u122->Code() = "u122 <- 1";
	u122->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u123 = (TExecuteCommand*) MAC_NET_PROD.GetCommand("u123",TCommand::kUpdate,TCommand::kCode);
	u123->SetExecutable(&MAC_NET_PROD_u123_exe_g);
	u123->Code() = "u123 <- ( NPHBIO_NET_PROD+PHBIO_NET_PROD )";
	u123->AddDependency(NPHBIO_NET_PROD);
	u123->AddDependency(PHBIO_NET_PROD);
	u123->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u124 = (TExecuteCommand*) MAC_TEMP_RESP_LIM.GetCommand("u124",TCommand::kUpdate,TCommand::kCode);
	u124->SetExecutable(&MAC_TEMP_RESP_LIM_u124_exe_g);
	u124->Code() = "u124 <-  ( ( ( P1_SWITCH_AIR_TEMP_LIM == ((float)1) ) ) ? ( ( ((float)1)-( ( ((float)40)-P1_AIR_TEMP )/40 ) ) ) : ( ( .0107*SL::Exp(( .047*H2O_TEMP )) ) ) ) ";
	u124->AddDependency(P1_SWITCH_AIR_TEMP_LIM);
	u124->AddDependency(P1_AIR_TEMP);
	u124->AddDependency(H2O_TEMP);
	u124->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u125 = (TExecuteCommand*) NPHBIO_NET_PROD.GetCommand("u125",TCommand::kUpdate,TCommand::kCode);
	u125->SetExecutable(&NPHBIO_NET_PROD_u125_exe_g);
	u125->Code() = "u125 <- ( NPH_MAC_GPP-NPHBIO_RESP )";
	u125->AddDependency(NPH_MAC_GPP);
	u125->AddDependency(NPHBIO_RESP);
	u125->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u128 = (TExecuteCommand*) PHMAC_GROWTH_TO_ROOTS.GetCommand("u128",TCommand::kUpdate,TCommand::kCode);
	u128->SetExecutable(&PHMAC_GROWTH_TO_ROOTS_u128_exe_g);
	u128->Code() = "u128 <- ( ((float)1)-( LEAF_LIMIT_COEFF*P1_LEAF_GROW_SEASON ) )";
	u128->AddDependency(LEAF_LIMIT_COEFF);
	u128->AddDependency(P1_LEAF_GROW_SEASON);
	u128->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u129 = (TExecuteCommand*) ROOTS_TO_LEAVES.GetCommand("u129",TCommand::kUpdate,TCommand::kCode);
	u129->SetExecutable(&ROOTS_TO_LEAVES_u129_exe_g);
	u129->Code() = "u129 <-  ( ( ( SHOOTS <  ((float)1) ) ) ? ( ((float)0) ) : ( ( ROOTSRHY/SHOOTS ) ) ) ";
	u129->AddDependency(SHOOTS);
	u129->AddDependency(ROOTSRHY);
	u129->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u130 = (TExecuteCommand*) ZOSTRA_NUT_LIM.GetCommand("u130",TCommand::kUpdate,TCommand::kCode);
	u130->SetExecutable(&ZOSTRA_NUT_LIM_u130_exe_g);
	u130->Code() = "u130 <- SL::Min(( P1_DIN_SED_CONC_MAP/( P1_DIN_SED_CONC_MAP+P1_SAT_N ) ), ( P1_PO4_SED_WT_CONC/( P1_PO4_SED_WT_CONC+P1_SAT_P ) ))";
	u130->AddDependency(P1_DIN_SED_CONC_MAP);
	u130->AddDependency(P1_SAT_N);
	u130->AddDependency(P1_PO4_SED_WT_CONC);
	u130->AddDependency(P1_SAT_P);
	u130->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u131 = (TExecuteCommand*) ZOSTRA_PROD_LIM.GetCommand("u131",TCommand::kUpdate,TCommand::kCode);
	u131->SetExecutable(&ZOSTRA_PROD_LIM_u131_exe_g);
	u131->Code() = "u131 <- ( ( pow((double)ZOSTRA_LIGHT_LIM,(double)P1_SWITCH_LIGHT_LIM )*pow((double)ZOSTRA_NUT_LIM,(double)P1_SWITCH_NUTRIENT_LIM ) )*pow((double)ZOSTRA_TEMP_LIM,(double)P1_SWITCH_TEMP_LIM ) )";
	u131->AddDependency(ZOSTRA_LIGHT_LIM);
	u131->AddDependency(P1_SWITCH_LIGHT_LIM);
	u131->AddDependency(ZOSTRA_NUT_LIM);
	u131->AddDependency(P1_SWITCH_NUTRIENT_LIM);
	u131->AddDependency(ZOSTRA_TEMP_LIM);
	u131->AddDependency(P1_SWITCH_TEMP_LIM);
	u131->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u132 = (TExecuteCommand*) ZOSTRA_TEMP_LIM.GetCommand("u132",TCommand::kUpdate,TCommand::kCode);
	u132->SetExecutable(&ZOSTRA_TEMP_LIM_u132_exe_g);
	u132->Code() = "u132 <-  ( ( ( P1_SWITCH_AIR_TEMP_LIM == ((float)1) ) ) ? (  ( ( ( P1_AIR_TEMP <= ((float)0) ) ) ? ( ((float)0) ) : ( ( ((float)1)-( ( P1_MAX_AIR_TEMP-P1_AIR_TEMP )/P1_MAX_AIR_TEMP ) ) ) )  ) : ( SL::Min(((float)1), ( .22*SL::Exp(( ( .07-( 0.00001*SL::Exp(( .28*H2O_TEMP )) ) )*H2O_TEMP )) )) ) ) ";
	u132->AddDependency(P1_SWITCH_AIR_TEMP_LIM);
	u132->AddDependency(P1_AIR_TEMP);
	u132->AddDependency(P1_MAX_AIR_TEMP);
	u132->AddDependency(H2O_TEMP);
	u132->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u133 = (TExecuteCommand*) P1_BETA.GetCommand("u133",TCommand::kUpdate,TCommand::kCode);
	u133->SetExecutable(&P1_BETA_u133_exe_g);
	u133->Code() = "u133 <- 0.500000";
	u133->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u135 = (TExecuteCommand*) P1_MAC_NONPH_NC.GetCommand("u135",TCommand::kUpdate,TCommand::kCode);
	u135->SetExecutable(&P1_MAC_NONPH_NC_u135_exe_g);
	u135->Code() = "u135 <- 0.010000";
	u135->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u136 = (TExecuteCommand*) P1_MAC_NONPH_PC.GetCommand("u136",TCommand::kUpdate,TCommand::kCode);
	u136->SetExecutable(&P1_MAC_NONPH_PC_u136_exe_g);
	u136->Code() = "u136 <- 0.005000";
	u136->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u139 = (TExecuteCommand*) P1_MAC_PP_RATE.GetCommand("u139",TCommand::kUpdate,TCommand::kCode);
	u139->SetExecutable(&P1_MAC_PP_RATE_u139_exe_g);
	u139->Code() = "u139 <- 0.052000";
	u139->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u140 = (TExecuteCommand*) P1_MAX_AIR_TEMP.GetCommand("u140",TCommand::kUpdate,TCommand::kCode);
	u140->SetExecutable(&P1_MAX_AIR_TEMP_u140_exe_g);
	u140->Code() = "u140 <- 40";
	u140->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u141 = (TExecuteCommand*) P1_NPHBIO_MORT_RATE.GetCommand("u141",TCommand::kUpdate,TCommand::kCode);
	u141->SetExecutable(&P1_NPHBIO_MORT_RATE_u141_exe_g);
	u141->Code() = "u141 <- 0.000075";
	u141->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u142 = (TExecuteCommand*) P1_NPHBIO_RESP_RATE.GetCommand("u142",TCommand::kUpdate,TCommand::kCode);
	u142->SetExecutable(&P1_NPHBIO_RESP_RATE_u142_exe_g);
	u142->Code() = "u142 <- 0.000296";
	u142->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u143 = (TExecuteCommand*) P1_PERC_NPHBIO.GetCommand("u143",TCommand::kUpdate,TCommand::kCode);
	u143->SetExecutable(&P1_PERC_NPHBIO_u143_exe_g);
	u143->Code() = "u143 <- ( ((float)3)/7 )";
	u143->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u144 = (TExecuteCommand*) P1_PHBIO_RESP_RATE.GetCommand("u144",TCommand::kUpdate,TCommand::kCode);
	u144->SetExecutable(&P1_PHBIO_RESP_RATE_u144_exe_g);
	u144->Code() = "u144 <- 0.000100";
	u144->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u145 = (TExecuteCommand*) P1_SAT_N.GetCommand("u145",TCommand::kUpdate,TCommand::kCode);
	u145->SetExecutable(&P1_SAT_N_u145_exe_g);
	u145->Code() = "u145 <- 0.000005";
	u145->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u146 = (TExecuteCommand*) P1_SAT_P.GetCommand("u146",TCommand::kUpdate,TCommand::kCode);
	u146->SetExecutable(&P1_SAT_P_u146_exe_g);
	u146->Code() = "u146 <- 0.000002";
	u146->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u148 = (TExecuteCommand*) P1_SWITCH_AIR_TEMP_LIM.GetCommand("u148",TCommand::kUpdate,TCommand::kCode);
	u148->SetExecutable(&P1_SWITCH_AIR_TEMP_LIM_u148_exe_g);
	u148->Code() = "u148 <- 0";
	u148->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u149 = (TExecuteCommand*) P1_SWITCH_LIGHT_LIM.GetCommand("u149",TCommand::kUpdate,TCommand::kCode);
	u149->SetExecutable(&P1_SWITCH_LIGHT_LIM_u149_exe_g);
	u149->Code() = "u149 <- 1";
	u149->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u150 = (TExecuteCommand*) P1_SWITCH_NUTRIENT_LIM.GetCommand("u150",TCommand::kUpdate,TCommand::kCode);
	u150->SetExecutable(&P1_SWITCH_NUTRIENT_LIM_u150_exe_g);
	u150->Code() = "u150 <- 1";
	u150->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u151 = (TExecuteCommand*) P1_SWITCH_TEMP_LIM.GetCommand("u151",TCommand::kUpdate,TCommand::kCode);
	u151->SetExecutable(&P1_SWITCH_TEMP_LIM_u151_exe_g);
	u151->Code() = "u151 <- 1";
	u151->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u152 = (TExecuteCommand*) PI_INTERVAL.GetCommand("u152",TCommand::kUpdate,TCommand::kCode);
	u152->SetExecutable(&PI_INTERVAL_u152_exe_g);
	u152->Code() = "u152 <- Graph2(DAYS)";
	u152->AddDependency(DAYS);
	u152->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int EELGRASS_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int EELGRASS_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int EELGRASS_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int EELGRASS_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class EPIPHYTES_module 
// ---------------------------------------------------------------------------
EPIPHYTES_module::EPIPHYTES_module(char* name) :
	TIME("TIME"),
	EPIPHYTES("EPIPHYTES"),
	P1_CELL_SIZE("P1_CELL_SIZE"),
	SHOOTS("SHOOTS"),
	CONS_INGEST_EPI("CONS_INGEST_EPI"),
	PHBIO_LTTR_RATIO("PHBIO_LTTR_RATIO"),
	DIN_CONC("DIN_CONC"),
	PO4_SF_WT_CONC("PO4_SF_WT_CONC"),
	EPI_LIGHT_LIM("EPI_LIGHT_LIM"),
	H2O_TEMP("H2O_TEMP"),
	P1_IC_MAC_PHBIO("P1_IC_MAC_PHBIO"),
	P1_SEPT_TO_JAN_CONV("P1_SEPT_TO_JAN_CONV"),
	EPI_GROSS_PP("EPI_GROSS_PP"),
	EPI_SEEDING("EPI_SEEDING"),
	EPI_RESP("EPI_RESP"),
	EPI_CONSUMED("EPI_CONSUMED"),
	EPI_MORT("EPI_MORT"),
	EPI_NET_PROD("EPI_NET_PROD"),
	EPI_NUT_LIMIT("EPI_NUT_LIMIT"),
	EPI_PROD_LIM("EPI_PROD_LIM"),
	EPI_TEMP_LIM("EPI_TEMP_LIM"),
	IC_EPIPHYTES("IC_EPIPHYTES"),
	P1_EPI_ALPHA("P1_EPI_ALPHA"),
	P1_EPI_NC("P1_EPI_NC"),
	P1_EPI_N_SAT("P1_EPI_N_SAT"),
	P1_EPI_PC("P1_EPI_PC"),
	P1_EPI_PP_RT("P1_EPI_PP_RT"),
	P1_EPI_P_SAT("P1_EPI_P_SAT"),
	P1_EPI_RESP_RT("P1_EPI_RESP_RT"),
	P1_EPI_SEEDING_RT("P1_EPI_SEEDING_RT"),
	P1_EPI_TEMP_COEFF("P1_EPI_TEMP_COEFF"),
	EPI_SHOOT_LIM("EPI_SHOOT_LIM"),
	TModule(name) {

	EPIPHYTES.SetF(FisExport,True,"CG");
	P1_CELL_SIZE.SetF(FisImport,True,"CG");
	SHOOTS.SetF(FisImport,True,"CG");
	CONS_INGEST_EPI.SetF(FisImport,True,"CG");
	PHBIO_LTTR_RATIO.SetF(FisImport,True,"CG");
	DIN_CONC.SetF(FisImport,True,"CG");
	PO4_SF_WT_CONC.SetF(FisImport,True,"CG");
	EPI_LIGHT_LIM.SetF(FisImport,True,"CG");
	H2O_TEMP.SetF(FisImport,True,"CG");
	P1_IC_MAC_PHBIO.SetF(FisImport,True,"CG");
	P1_SEPT_TO_JAN_CONV.SetF(FisImport,True,"CG");
}	
int EPIPHYTES_module::EPIPHYTES_I153_exe() {
	float value;

	EPIPHYTES.UpdateIntegrator();
	switch( EPIPHYTES.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EPIPHYTES.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( EPI_GROSS_PP.Value(p)+EPI_SEEDING.Value(p) )-EPI_RESP.Value(p) )-EPI_CONSUMED.Value(p) )-EPI_MORT.Value(p) );
			EPIPHYTES.Update( p, value, dT() );
		}
		EPIPHYTES.GrabMemory();
		if( EPIPHYTES.GetF(FLinkEdges) ) { EPIPHYTES.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( EPI_GROSS_PP.Value()+EPI_SEEDING.Value() )-EPI_RESP.Value() )-EPI_CONSUMED.Value() )-EPI_MORT.Value() );
			EPIPHYTES.Update( value, dT() );
	  } break;
	}
	return 0;
}

int EPIPHYTES_module::EPIPHYTES_i154_exe() {
	float value;

	EPIPHYTES.UpdateIntegrator();
	switch( EPIPHYTES.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EPIPHYTES.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_CELL_SIZE.Value(p)*IC_EPIPHYTES.Value(p) );
			EPIPHYTES.InitValue( p, value );
		}
		EPIPHYTES.GrabMemory();
		if( EPIPHYTES.GetF(FLinkEdges) ) { EPIPHYTES.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_CELL_SIZE.Value()*IC_EPIPHYTES.Value() );
			EPIPHYTES.InitValue( value );
	  } break;
	}
	return 0;
}

int EPIPHYTES_module::EPI_GROSS_PP_u155_exe() {
	float value;

	switch( EPI_GROSS_PP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EPI_GROSS_PP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SL::Max(((float)0), ( ( ( EPI_PROD_LIM.Value(p)*P1_EPI_PP_RT.Value(p) )*dT() )*EPIPHYTES.Value(p) ))*P1_CELL_SIZE.Value(p) );
			EPI_GROSS_PP.Update( p, value );
		}
		EPI_GROSS_PP.GrabMemory();
		if( EPI_GROSS_PP.GetF(FICFlux) ) EPI_GROSS_PP.Cov().Set(0.0); 
		if( EPI_GROSS_PP.GetF(FLinkEdges) ) { EPI_GROSS_PP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SL::Max(((float)0), ( ( ( EPI_PROD_LIM.Value()*P1_EPI_PP_RT.Value() )*dT() )*EPIPHYTES.Value() ))*P1_CELL_SIZE.Value() );
			EPI_GROSS_PP.Update( value );
	  } break;
	}
	return 0;
}

int EPIPHYTES_module::EPI_SEEDING_u156_exe() {
	float value;

	switch( EPI_SEEDING.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EPI_SEEDING.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( SL::Rand(((float)0), ((float)1)) <  0.1 ) && ( SHOOTS.Value(p) >  ((float)1) ) ) ) ? ( P1_EPI_SEEDING_RT.Value(p) ) : ( ((float)0) ) ) ;
			EPI_SEEDING.Update( p, value );
		}
		EPI_SEEDING.GrabMemory();
		if( EPI_SEEDING.GetF(FICFlux) ) EPI_SEEDING.Cov().Set(0.0); 
		if( EPI_SEEDING.GetF(FLinkEdges) ) { EPI_SEEDING.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( SL::Rand(((float)0), ((float)1)) <  0.1 ) && ( SHOOTS.Value() >  ((float)1) ) ) ) ? ( P1_EPI_SEEDING_RT.Value() ) : ( ((float)0) ) ) ;
			EPI_SEEDING.Update( value );
	  } break;
	}
	return 0;
}

int EPIPHYTES_module::EPI_RESP_u157_exe() {
	float value;

	switch( EPI_RESP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EPI_RESP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( P1_EPI_RESP_RT.Value(p)*dT() )*EPI_TEMP_LIM.Value(p) )*pow((double)EPIPHYTES.Value(p),(double)P1_EPI_ALPHA.Value(p) ) );
			EPI_RESP.Update( p, value );
		}
		EPI_RESP.GrabMemory();
		if( EPI_RESP.GetF(FICFlux) ) EPI_RESP.Cov().Set(0.0); 
		if( EPI_RESP.GetF(FLinkEdges) ) { EPI_RESP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( P1_EPI_RESP_RT.Value()*dT() )*EPI_TEMP_LIM.Value() )*pow((double)EPIPHYTES.Value(),(double)P1_EPI_ALPHA.Value() ) );
			EPI_RESP.Update( value );
	  } break;
	}
	return 0;
}

int EPIPHYTES_module::EPI_CONSUMED_u158_exe() {
	float value;

	switch( EPI_CONSUMED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EPI_CONSUMED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  CONS_INGEST_EPI.Value(p);
			EPI_CONSUMED.Update( p, value );
		}
		EPI_CONSUMED.GrabMemory();
		if( EPI_CONSUMED.GetF(FICFlux) ) EPI_CONSUMED.Cov().Set(0.0); 
		if( EPI_CONSUMED.GetF(FLinkEdges) ) { EPI_CONSUMED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  CONS_INGEST_EPI.Value();
			EPI_CONSUMED.Update( value );
	  } break;
	}
	return 0;
}

int EPIPHYTES_module::EPI_MORT_u159_exe() {
	float value;

	switch( EPI_MORT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EPI_MORT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Max(((float)0),  ( ( ( ( SHOOTS.Value(p) == ((float)0) ) || ( EPIPHYTES.Value(p) == ((float)0) ) ) ) ? ( ((float)0) ) : ( ( ( EPIPHYTES.Value(p)*( EPIPHYTES.Value(p)/SL::Max(((float)1), SHOOTS.Value(p)) ) )*PHBIO_LTTR_RATIO.Value(p) ) ) ) );
			EPI_MORT.Update( p, value );
		}
		EPI_MORT.GrabMemory();
		if( EPI_MORT.GetF(FICFlux) ) EPI_MORT.Cov().Set(0.0); 
		if( EPI_MORT.GetF(FLinkEdges) ) { EPI_MORT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Max(((float)0),  ( ( ( ( SHOOTS.Value() == ((float)0) ) || ( EPIPHYTES.Value() == ((float)0) ) ) ) ? ( ((float)0) ) : ( ( ( EPIPHYTES.Value()*( EPIPHYTES.Value()/SL::Max(((float)1), SHOOTS.Value()) ) )*PHBIO_LTTR_RATIO.Value() ) ) ) );
			EPI_MORT.Update( value );
	  } break;
	}
	return 0;
}

int EPIPHYTES_module::EPI_NET_PROD_u160_exe() {
	float value;

	switch( EPI_NET_PROD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EPI_NET_PROD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( EPI_GROSS_PP.Value(p)-EPI_RESP.Value(p) );
			EPI_NET_PROD.Update( p, value );
		}
		EPI_NET_PROD.GrabMemory();
		if( EPI_NET_PROD.GetF(FLinkEdges) ) { EPI_NET_PROD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( EPI_GROSS_PP.Value()-EPI_RESP.Value() );
			EPI_NET_PROD.Update( value );
	  } break;
	}
	return 0;
}

int EPIPHYTES_module::EPI_NUT_LIMIT_u161_exe() {
	float value;

	switch( EPI_NUT_LIMIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EPI_NUT_LIMIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( DIN_CONC.Value(p) <= ((float)0) ) || ( PO4_SF_WT_CONC.Value(p) <= ((float)0) ) ) ) ? ( ((float)0) ) : ( SL::Min(( DIN_CONC.Value(p)/( DIN_CONC.Value(p)+P1_EPI_N_SAT.Value(p) ) ), ( PO4_SF_WT_CONC.Value(p)/( PO4_SF_WT_CONC.Value(p)+P1_EPI_P_SAT.Value(p) ) )) ) ) ;
			EPI_NUT_LIMIT.Update( p, value );
		}
		EPI_NUT_LIMIT.GrabMemory();
		if( EPI_NUT_LIMIT.GetF(FLinkEdges) ) { EPI_NUT_LIMIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( DIN_CONC.Value() <= ((float)0) ) || ( PO4_SF_WT_CONC.Value() <= ((float)0) ) ) ) ? ( ((float)0) ) : ( SL::Min(( DIN_CONC.Value()/( DIN_CONC.Value()+P1_EPI_N_SAT.Value() ) ), ( PO4_SF_WT_CONC.Value()/( PO4_SF_WT_CONC.Value()+P1_EPI_P_SAT.Value() ) )) ) ) ;
			EPI_NUT_LIMIT.Update( value );
	  } break;
	}
	return 0;
}

int EPIPHYTES_module::EPI_PROD_LIM_u162_exe() {
	float value;

	switch( EPI_PROD_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EPI_PROD_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( EPI_NUT_LIMIT.Value(p)*EPI_TEMP_LIM.Value(p) )*EPI_LIGHT_LIM.Value(p) )*EPI_SHOOT_LIM.Value(p) );
			EPI_PROD_LIM.Update( p, value );
		}
		EPI_PROD_LIM.GrabMemory();
		if( EPI_PROD_LIM.GetF(FLinkEdges) ) { EPI_PROD_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( EPI_NUT_LIMIT.Value()*EPI_TEMP_LIM.Value() )*EPI_LIGHT_LIM.Value() )*EPI_SHOOT_LIM.Value() );
			EPI_PROD_LIM.Update( value );
	  } break;
	}
	return 0;
}

int EPIPHYTES_module::EPI_TEMP_LIM_u163_exe() {
	float value;

	switch( EPI_TEMP_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EPI_TEMP_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( H2O_TEMP.Value(p)*P1_EPI_TEMP_COEFF.Value(p) )/40 );
			EPI_TEMP_LIM.Update( p, value );
		}
		EPI_TEMP_LIM.GrabMemory();
		if( EPI_TEMP_LIM.GetF(FLinkEdges) ) { EPI_TEMP_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( H2O_TEMP.Value()*P1_EPI_TEMP_COEFF.Value() )/40 );
			EPI_TEMP_LIM.Update( value );
	  } break;
	}
	return 0;
}

int EPIPHYTES_module::IC_EPIPHYTES_u164_exe() {
	float value;

	switch( IC_EPIPHYTES.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = IC_EPIPHYTES.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( .1*( P1_IC_MAC_PHBIO.Value(p)/P1_SEPT_TO_JAN_CONV.Value(p) ) );
			IC_EPIPHYTES.Update( p, value );
		}
		IC_EPIPHYTES.GrabMemory();
		if( IC_EPIPHYTES.GetF(FLinkEdges) ) { IC_EPIPHYTES.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( .1*( P1_IC_MAC_PHBIO.Value()/P1_SEPT_TO_JAN_CONV.Value() ) );
			IC_EPIPHYTES.Update( value );
	  } break;
	}
	return 0;
}

int EPIPHYTES_module::P1_EPI_ALPHA_u165_exe() {
	float value;

	switch( P1_EPI_ALPHA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_EPI_ALPHA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1.100000;
			P1_EPI_ALPHA.Update( p, P1_EPI_ALPHA.ParameterValue(value,p) );
		}
		P1_EPI_ALPHA.GrabMemory();
		if( P1_EPI_ALPHA.GetF(FLinkEdges) ) { P1_EPI_ALPHA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1.100000;
			P1_EPI_ALPHA.Update( P1_EPI_ALPHA.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EPIPHYTES_module::P1_EPI_NC_u166_exe() {
	float value;

	switch( P1_EPI_NC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_EPI_NC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.010000;
			P1_EPI_NC.Update( p, P1_EPI_NC.ParameterValue(value,p) );
		}
		P1_EPI_NC.GrabMemory();
		if( P1_EPI_NC.GetF(FLinkEdges) ) { P1_EPI_NC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.010000;
			P1_EPI_NC.Update( P1_EPI_NC.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EPIPHYTES_module::P1_EPI_N_SAT_u167_exe() {
	float value;

	switch( P1_EPI_N_SAT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_EPI_N_SAT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000025;
			P1_EPI_N_SAT.Update( p, P1_EPI_N_SAT.ParameterValue(value,p) );
		}
		P1_EPI_N_SAT.GrabMemory();
		if( P1_EPI_N_SAT.GetF(FLinkEdges) ) { P1_EPI_N_SAT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000025;
			P1_EPI_N_SAT.Update( P1_EPI_N_SAT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EPIPHYTES_module::P1_EPI_PC_u168_exe() {
	float value;

	switch( P1_EPI_PC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_EPI_PC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.005000;
			P1_EPI_PC.Update( p, P1_EPI_PC.ParameterValue(value,p) );
		}
		P1_EPI_PC.GrabMemory();
		if( P1_EPI_PC.GetF(FLinkEdges) ) { P1_EPI_PC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.005000;
			P1_EPI_PC.Update( P1_EPI_PC.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EPIPHYTES_module::P1_EPI_PP_RT_u169_exe() {
	float value;

	switch( P1_EPI_PP_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_EPI_PP_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000125;
			P1_EPI_PP_RT.Update( p, P1_EPI_PP_RT.ParameterValue(value,p) );
		}
		P1_EPI_PP_RT.GrabMemory();
		if( P1_EPI_PP_RT.GetF(FLinkEdges) ) { P1_EPI_PP_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000125;
			P1_EPI_PP_RT.Update( P1_EPI_PP_RT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EPIPHYTES_module::P1_EPI_P_SAT_u170_exe() {
	float value;

	switch( P1_EPI_P_SAT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_EPI_P_SAT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000002;
			P1_EPI_P_SAT.Update( p, P1_EPI_P_SAT.ParameterValue(value,p) );
		}
		P1_EPI_P_SAT.GrabMemory();
		if( P1_EPI_P_SAT.GetF(FLinkEdges) ) { P1_EPI_P_SAT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000002;
			P1_EPI_P_SAT.Update( P1_EPI_P_SAT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EPIPHYTES_module::P1_EPI_RESP_RT_u171_exe() {
	float value;

	switch( P1_EPI_RESP_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_EPI_RESP_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.020000;
			P1_EPI_RESP_RT.Update( p, P1_EPI_RESP_RT.ParameterValue(value,p) );
		}
		P1_EPI_RESP_RT.GrabMemory();
		if( P1_EPI_RESP_RT.GetF(FLinkEdges) ) { P1_EPI_RESP_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.020000;
			P1_EPI_RESP_RT.Update( P1_EPI_RESP_RT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EPIPHYTES_module::P1_EPI_SEEDING_RT_u172_exe() {
	float value;

	switch( P1_EPI_SEEDING_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_EPI_SEEDING_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.010000;
			P1_EPI_SEEDING_RT.Update( p, P1_EPI_SEEDING_RT.ParameterValue(value,p) );
		}
		P1_EPI_SEEDING_RT.GrabMemory();
		if( P1_EPI_SEEDING_RT.GetF(FLinkEdges) ) { P1_EPI_SEEDING_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.010000;
			P1_EPI_SEEDING_RT.Update( P1_EPI_SEEDING_RT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EPIPHYTES_module::P1_EPI_TEMP_COEFF_u173_exe() {
	float value;

	switch( P1_EPI_TEMP_COEFF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_EPI_TEMP_COEFF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.069000;
			P1_EPI_TEMP_COEFF.Update( p, P1_EPI_TEMP_COEFF.ParameterValue(value,p) );
		}
		P1_EPI_TEMP_COEFF.GrabMemory();
		if( P1_EPI_TEMP_COEFF.GetF(FLinkEdges) ) { P1_EPI_TEMP_COEFF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.069000;
			P1_EPI_TEMP_COEFF.Update( P1_EPI_TEMP_COEFF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int EPIPHYTES_module::EPI_SHOOT_LIM_u174_exe() {
	float value;

	switch( EPI_SHOOT_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EPI_SHOOT_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph3(SHOOTS.Value(p));
			EPI_SHOOT_LIM.Update( p, value );
		}
		EPI_SHOOT_LIM.GrabMemory();
		if( EPI_SHOOT_LIM.GetF(FLinkEdges) ) { EPI_SHOOT_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph3(SHOOTS.Value());
			EPI_SHOOT_LIM.Update( value );
	  } break;
	}
	return 0;
}

EPIPHYTES_module* EPIPHYTES_module::fInstance = NULL;
EPIPHYTES_module* EPIPHYTES_module::kNullModel = (EPIPHYTES_module*)0x1;
int EPIPHYTES_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int EPIPHYTES_module::InitVars() {
	
	TIME.SSInit(this);
	EPIPHYTES.SSInit(this);
	P1_CELL_SIZE.SSInit(this);
	SHOOTS.SSInit(this);
	CONS_INGEST_EPI.SSInit(this);
	PHBIO_LTTR_RATIO.SSInit(this);
	DIN_CONC.SSInit(this);
	PO4_SF_WT_CONC.SSInit(this);
	EPI_LIGHT_LIM.SSInit(this);
	H2O_TEMP.SSInit(this);
	P1_IC_MAC_PHBIO.SSInit(this);
	P1_SEPT_TO_JAN_CONV.SSInit(this);
	EPI_GROSS_PP.SSInit(this);
	EPI_GROSS_PP.SetDestination(&EPIPHYTES);
	EPI_SEEDING.SSInit(this);
	EPI_SEEDING.SetDestination(&EPIPHYTES);
	EPI_RESP.SSInit(this);
	EPI_RESP.SetOrigin(&EPIPHYTES);
	EPI_CONSUMED.SSInit(this);
	EPI_CONSUMED.SetOrigin(&EPIPHYTES);
	EPI_MORT.SSInit(this);
	EPI_MORT.SetOrigin(&EPIPHYTES);
	EPI_NET_PROD.SSInit(this);
	EPI_NUT_LIMIT.SSInit(this);
	EPI_PROD_LIM.SSInit(this);
	EPI_TEMP_LIM.SSInit(this);
	IC_EPIPHYTES.SSInit(this);
	P1_EPI_ALPHA.SSInit(this);
	P1_EPI_NC.SSInit(this);
	P1_EPI_N_SAT.SSInit(this);
	P1_EPI_PC.SSInit(this);
	P1_EPI_PP_RT.SSInit(this);
	P1_EPI_P_SAT.SSInit(this);
	P1_EPI_RESP_RT.SSInit(this);
	P1_EPI_SEEDING_RT.SSInit(this);
	P1_EPI_TEMP_COEFF.SSInit(this);
	EPI_SHOOT_LIM.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int EPIPHYTES_module::SetupEvents() {
	TExecuteCommand* I153 = (TExecuteCommand*) EPIPHYTES.GetCommand("I153",TCommand::kIntegrate,TCommand::kCode);
	I153->SetExecutable(&EPIPHYTES_I153_exe_g);
	I153->Code() = "I153 <- ( ( ( ( EPI_GROSS_PP+EPI_SEEDING )-EPI_RESP )-EPI_CONSUMED )-EPI_MORT )";
	I153->AddDependency(EPI_GROSS_PP);
	I153->AddDependency(EPI_SEEDING);
	I153->AddDependency(EPI_RESP);
	I153->AddDependency(EPI_CONSUMED);
	I153->AddDependency(EPI_MORT);
	I153->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i154 = (TExecuteCommand*) EPIPHYTES.GetCommand("i154",TCommand::kInit,TCommand::kCode);
	i154->SetExecutable(&EPIPHYTES_i154_exe_g);
	i154->Code() = "i154 <- ( P1_CELL_SIZE*IC_EPIPHYTES )";
	i154->AddDependency(P1_CELL_SIZE);
	i154->AddDependency(IC_EPIPHYTES);
	i154->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_CELL_SIZE_import = (TImportCommand*) P1_CELL_SIZE.GetCommand("P1_CELL_SIZE_import",TCommand::kUndefined,TCommand::kImport);
	P1_CELL_SIZE_import->Code() = "Import P1_CELL_SIZE from GLOBAL_module";
	P1_CELL_SIZE_import->AddDependency(P1_CELL_SIZE);
	P1_CELL_SIZE_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SHOOTS_import = (TImportCommand*) SHOOTS.GetCommand("SHOOTS_import",TCommand::kUndefined,TCommand::kImport);
	SHOOTS_import->Code() = "Import SHOOTS from EELGRASS_module";
	SHOOTS_import->AddDependency(SHOOTS);
	SHOOTS_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* CONS_INGEST_EPI_import = (TImportCommand*) CONS_INGEST_EPI.GetCommand("CONS_INGEST_EPI_import",TCommand::kUndefined,TCommand::kImport);
	CONS_INGEST_EPI_import->Code() = "Import CONS_INGEST_EPI from CONSUMERS_module";
	CONS_INGEST_EPI_import->AddDependency(CONS_INGEST_EPI);
	CONS_INGEST_EPI_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PHBIO_LTTR_RATIO_import = (TImportCommand*) PHBIO_LTTR_RATIO.GetCommand("PHBIO_LTTR_RATIO_import",TCommand::kUndefined,TCommand::kImport);
	PHBIO_LTTR_RATIO_import->Code() = "Import PHBIO_LTTR_RATIO from EELGRASS_module";
	PHBIO_LTTR_RATIO_import->AddDependency(PHBIO_LTTR_RATIO);
	PHBIO_LTTR_RATIO_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DIN_CONC_import = (TImportCommand*) DIN_CONC.GetCommand("DIN_CONC_import",TCommand::kUndefined,TCommand::kImport);
	DIN_CONC_import->Code() = "Import DIN_CONC from DIN_module";
	DIN_CONC_import->AddDependency(DIN_CONC);
	DIN_CONC_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PO4_SF_WT_CONC_import = (TImportCommand*) PO4_SF_WT_CONC.GetCommand("PO4_SF_WT_CONC_import",TCommand::kUndefined,TCommand::kImport);
	PO4_SF_WT_CONC_import->Code() = "Import PO4_SF_WT_CONC from PHOSPHATE_module";
	PO4_SF_WT_CONC_import->AddDependency(PO4_SF_WT_CONC);
	PO4_SF_WT_CONC_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* EPI_LIGHT_LIM_import = (TImportCommand*) EPI_LIGHT_LIM.GetCommand("EPI_LIGHT_LIM_import",TCommand::kUndefined,TCommand::kImport);
	EPI_LIGHT_LIM_import->Code() = "Import EPI_LIGHT_LIM from GLOBAL_module";
	EPI_LIGHT_LIM_import->AddDependency(EPI_LIGHT_LIM);
	EPI_LIGHT_LIM_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* H2O_TEMP_import = (TImportCommand*) H2O_TEMP.GetCommand("H2O_TEMP_import",TCommand::kUndefined,TCommand::kImport);
	H2O_TEMP_import->Code() = "Import H2O_TEMP from GLOBAL_module";
	H2O_TEMP_import->AddDependency(H2O_TEMP);
	H2O_TEMP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_IC_MAC_PHBIO_import = (TImportCommand*) P1_IC_MAC_PHBIO.GetCommand("P1_IC_MAC_PHBIO_import",TCommand::kUndefined,TCommand::kImport);
	P1_IC_MAC_PHBIO_import->Code() = "Import P1_IC_MAC_PHBIO from EELGRASS_module";
	P1_IC_MAC_PHBIO_import->AddDependency(P1_IC_MAC_PHBIO);
	P1_IC_MAC_PHBIO_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_SEPT_TO_JAN_CONV_import = (TImportCommand*) P1_SEPT_TO_JAN_CONV.GetCommand("P1_SEPT_TO_JAN_CONV_import",TCommand::kUndefined,TCommand::kImport);
	P1_SEPT_TO_JAN_CONV_import->Code() = "Import P1_SEPT_TO_JAN_CONV from EELGRASS_module";
	P1_SEPT_TO_JAN_CONV_import->AddDependency(P1_SEPT_TO_JAN_CONV);
	P1_SEPT_TO_JAN_CONV_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u155 = (TExecuteCommand*) EPI_GROSS_PP.GetCommand("u155",TCommand::kUpdate,TCommand::kCode);
	u155->SetExecutable(&EPI_GROSS_PP_u155_exe_g);
	u155->Code() = "u155 <- ( SL::Max(((float)0), ( ( ( EPI_PROD_LIM*P1_EPI_PP_RT )*dT() )*EPIPHYTES ))*P1_CELL_SIZE )";
	u155->AddDependency(EPI_PROD_LIM);
	u155->AddDependency(P1_EPI_PP_RT);
	u155->AddDependency(EPIPHYTES);
	u155->AddDependency(P1_CELL_SIZE);
	u155->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u156 = (TExecuteCommand*) EPI_SEEDING.GetCommand("u156",TCommand::kUpdate,TCommand::kCode);
	u156->SetExecutable(&EPI_SEEDING_u156_exe_g);
	u156->Code() = "u156 <-  ( ( ( ( SL::Rand(((float)0), ((float)1)) <  0.1 ) && ( SHOOTS >  ((float)1) ) ) ) ? ( P1_EPI_SEEDING_RT ) : ( ((float)0) ) ) ";
	u156->AddDependency(SHOOTS);
	u156->AddDependency(P1_EPI_SEEDING_RT);
	u156->AddDependency(TIME);
	u156->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u157 = (TExecuteCommand*) EPI_RESP.GetCommand("u157",TCommand::kUpdate,TCommand::kCode);
	u157->SetExecutable(&EPI_RESP_u157_exe_g);
	u157->Code() = "u157 <- ( ( ( P1_EPI_RESP_RT*dT() )*EPI_TEMP_LIM )*pow((double)EPIPHYTES,(double)P1_EPI_ALPHA ) )";
	if( EPI_RESP.GetF(FisClamped) ) { u157->AddDependency(EPIPHYTES); }
	u157->AddDependency(P1_EPI_RESP_RT);
	u157->AddDependency(EPI_TEMP_LIM);
	u157->AddDependency(EPIPHYTES);
	u157->AddDependency(P1_EPI_ALPHA);
	u157->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u158 = (TExecuteCommand*) EPI_CONSUMED.GetCommand("u158",TCommand::kUpdate,TCommand::kCode);
	u158->SetExecutable(&EPI_CONSUMED_u158_exe_g);
	u158->Code() = "u158 <- CONS_INGEST_EPI";
	if( EPI_CONSUMED.GetF(FisClamped) ) { u158->AddDependency(EPIPHYTES); }
	u158->AddDependency(CONS_INGEST_EPI);
	u158->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u159 = (TExecuteCommand*) EPI_MORT.GetCommand("u159",TCommand::kUpdate,TCommand::kCode);
	u159->SetExecutable(&EPI_MORT_u159_exe_g);
	u159->Code() = "u159 <- SL::Max(((float)0),  ( ( ( ( SHOOTS == ((float)0) ) || ( EPIPHYTES == ((float)0) ) ) ) ? ( ((float)0) ) : ( ( ( EPIPHYTES*( EPIPHYTES/SL::Max(((float)1), SHOOTS) ) )*PHBIO_LTTR_RATIO ) ) ) )";
	if( EPI_MORT.GetF(FisClamped) ) { u159->AddDependency(EPIPHYTES); }
	u159->AddDependency(SHOOTS);
	u159->AddDependency(EPIPHYTES);
	u159->AddDependency(PHBIO_LTTR_RATIO);
	u159->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u160 = (TExecuteCommand*) EPI_NET_PROD.GetCommand("u160",TCommand::kUpdate,TCommand::kCode);
	u160->SetExecutable(&EPI_NET_PROD_u160_exe_g);
	u160->Code() = "u160 <- ( EPI_GROSS_PP-EPI_RESP )";
	u160->AddDependency(EPI_GROSS_PP);
	u160->AddDependency(EPI_RESP);
	u160->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u161 = (TExecuteCommand*) EPI_NUT_LIMIT.GetCommand("u161",TCommand::kUpdate,TCommand::kCode);
	u161->SetExecutable(&EPI_NUT_LIMIT_u161_exe_g);
	u161->Code() = "u161 <-  ( ( ( ( DIN_CONC <= ((float)0) ) || ( PO4_SF_WT_CONC <= ((float)0) ) ) ) ? ( ((float)0) ) : ( SL::Min(( DIN_CONC/( DIN_CONC+P1_EPI_N_SAT ) ), ( PO4_SF_WT_CONC/( PO4_SF_WT_CONC+P1_EPI_P_SAT ) )) ) ) ";
	u161->AddDependency(DIN_CONC);
	u161->AddDependency(PO4_SF_WT_CONC);
	u161->AddDependency(P1_EPI_N_SAT);
	u161->AddDependency(P1_EPI_P_SAT);
	u161->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u162 = (TExecuteCommand*) EPI_PROD_LIM.GetCommand("u162",TCommand::kUpdate,TCommand::kCode);
	u162->SetExecutable(&EPI_PROD_LIM_u162_exe_g);
	u162->Code() = "u162 <- ( ( ( EPI_NUT_LIMIT*EPI_TEMP_LIM )*EPI_LIGHT_LIM )*EPI_SHOOT_LIM )";
	u162->AddDependency(EPI_NUT_LIMIT);
	u162->AddDependency(EPI_TEMP_LIM);
	u162->AddDependency(EPI_LIGHT_LIM);
	u162->AddDependency(EPI_SHOOT_LIM);
	u162->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u163 = (TExecuteCommand*) EPI_TEMP_LIM.GetCommand("u163",TCommand::kUpdate,TCommand::kCode);
	u163->SetExecutable(&EPI_TEMP_LIM_u163_exe_g);
	u163->Code() = "u163 <- ( ( H2O_TEMP*P1_EPI_TEMP_COEFF )/40 )";
	u163->AddDependency(H2O_TEMP);
	u163->AddDependency(P1_EPI_TEMP_COEFF);
	u163->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u164 = (TExecuteCommand*) IC_EPIPHYTES.GetCommand("u164",TCommand::kUpdate,TCommand::kCode);
	u164->SetExecutable(&IC_EPIPHYTES_u164_exe_g);
	u164->Code() = "u164 <- ( .1*( P1_IC_MAC_PHBIO/P1_SEPT_TO_JAN_CONV ) )";
	u164->AddDependency(P1_IC_MAC_PHBIO);
	u164->AddDependency(P1_SEPT_TO_JAN_CONV);
	u164->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u165 = (TExecuteCommand*) P1_EPI_ALPHA.GetCommand("u165",TCommand::kUpdate,TCommand::kCode);
	u165->SetExecutable(&P1_EPI_ALPHA_u165_exe_g);
	u165->Code() = "u165 <- 1.100000";
	u165->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u166 = (TExecuteCommand*) P1_EPI_NC.GetCommand("u166",TCommand::kUpdate,TCommand::kCode);
	u166->SetExecutable(&P1_EPI_NC_u166_exe_g);
	u166->Code() = "u166 <- 0.010000";
	u166->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u167 = (TExecuteCommand*) P1_EPI_N_SAT.GetCommand("u167",TCommand::kUpdate,TCommand::kCode);
	u167->SetExecutable(&P1_EPI_N_SAT_u167_exe_g);
	u167->Code() = "u167 <- 0.000025";
	u167->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u168 = (TExecuteCommand*) P1_EPI_PC.GetCommand("u168",TCommand::kUpdate,TCommand::kCode);
	u168->SetExecutable(&P1_EPI_PC_u168_exe_g);
	u168->Code() = "u168 <- 0.005000";
	u168->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u169 = (TExecuteCommand*) P1_EPI_PP_RT.GetCommand("u169",TCommand::kUpdate,TCommand::kCode);
	u169->SetExecutable(&P1_EPI_PP_RT_u169_exe_g);
	u169->Code() = "u169 <- 0.000125";
	u169->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u170 = (TExecuteCommand*) P1_EPI_P_SAT.GetCommand("u170",TCommand::kUpdate,TCommand::kCode);
	u170->SetExecutable(&P1_EPI_P_SAT_u170_exe_g);
	u170->Code() = "u170 <- 0.000002";
	u170->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u171 = (TExecuteCommand*) P1_EPI_RESP_RT.GetCommand("u171",TCommand::kUpdate,TCommand::kCode);
	u171->SetExecutable(&P1_EPI_RESP_RT_u171_exe_g);
	u171->Code() = "u171 <- 0.020000";
	u171->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u172 = (TExecuteCommand*) P1_EPI_SEEDING_RT.GetCommand("u172",TCommand::kUpdate,TCommand::kCode);
	u172->SetExecutable(&P1_EPI_SEEDING_RT_u172_exe_g);
	u172->Code() = "u172 <- 0.010000";
	u172->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u173 = (TExecuteCommand*) P1_EPI_TEMP_COEFF.GetCommand("u173",TCommand::kUpdate,TCommand::kCode);
	u173->SetExecutable(&P1_EPI_TEMP_COEFF_u173_exe_g);
	u173->Code() = "u173 <- 0.069000";
	u173->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u174 = (TExecuteCommand*) EPI_SHOOT_LIM.GetCommand("u174",TCommand::kUpdate,TCommand::kCode);
	u174->SetExecutable(&EPI_SHOOT_LIM_u174_exe_g);
	u174->Code() = "u174 <- Graph3(SHOOTS)";
	u174->AddDependency(SHOOTS);
	u174->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int EPIPHYTES_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int EPIPHYTES_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int EPIPHYTES_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int EPIPHYTES_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class GLOBAL_module 
// ---------------------------------------------------------------------------
GLOBAL_module::GLOBAL_module(char* name) :
	TIME("TIME"),
	P1_CELL_SIZE("P1_CELL_SIZE"),
	H2O_TEMP("H2O_TEMP"),
	P1_ON_MAP("P1_ON_MAP"),
	P1_AIR_TEMP("P1_AIR_TEMP"),
	EW_VECTOR("EW_VECTOR"),
	EW_WIND_VECTOR("EW_WIND_VECTOR"),
	NS_VECTOR("NS_VECTOR"),
	NS_WIND_VECTOR("NS_WIND_VECTOR"),
	DAYS("DAYS"),
	SF_WATER("SF_WATER"),
	SF_WT_E_X("SF_WT_E_X"),
	SF_WT_N_X("SF_WT_N_X"),
	SF_WT_S_X("SF_WT_S_X"),
	SF_WT_W_X("SF_WT_W_X"),
	P1_LEAF_GROW_SEASON("P1_LEAF_GROW_SEASON"),
	ZOSTRA_LIGHT_LIM("ZOSTRA_LIGHT_LIM"),
	EPI_LIGHT_LIM("EPI_LIGHT_LIM"),
	TSS_CONC("TSS_CONC"),
	PHT_CONC("PHT_CONC"),
	LEAF_LENGTH("LEAF_LENGTH"),
	EPIPHYTES("EPIPHYTES"),
	WATER_DEPTH("WATER_DEPTH"),
	PHT_LIGHT_LIM("PHT_LIGHT_LIM"),
	SW_LIGHT_LIM("SW_LIGHT_LIM"),
	CURRENT_VELOCITY("CURRENT_VELOCITY"),
	SHEAR_STRESS("SHEAR_STRESS"),
	COUNT_HOURS("COUNT_HOURS"),
	ALPHA("ALPHA"),
	ANGLE("ANGLE"),
	CURRENT_DIRECTION("CURRENT_DIRECTION"),
	DW_WAVE_L("DW_WAVE_L"),
	EC_H2O("EC_H2O"),
	EC_PLANTS("EC_PLANTS"),
	EW_CURRENT_VECTOR("EW_CURRENT_VECTOR"),
	FETCH("FETCH"),
	G_D("G_D"),
	G_F("G_F"),
	H1("H1"),
	H2("H2"),
	HA("HA"),
	HABB("HABB"),
	HOURS("HOURS"),
	LIGHT_AT_EPIPHYTES("LIGHT_AT_EPIPHYTES"),
	LIGHT_AT_PLANTS("LIGHT_AT_PLANTS"),
	LIGHT_TO_PHYTOPLANKTON("LIGHT_TO_PHYTOPLANKTON"),
	NS_CURRENT_VECTOR("NS_CURRENT_VECTOR"),
	ORBITAL_VELOCITY("ORBITAL_VELOCITY"),
	PHOTO_PERIOD("PHOTO_PERIOD"),
	RAND("RAND"),
	SDCLN("SDCLN"),
	SF_WT_EW_X("SF_WT_EW_X"),
	SF_WT_NS_X("SF_WT_NS_X"),
	SURFACE_LIGHT("SURFACE_LIGHT"),
	T1("T1"),
	T1A("T1A"),
	T1AB("T1AB"),
	T2("T2"),
	TIDE("TIDE"),
	TOTAL_SF_WT_X("TOTAL_SF_WT_X"),
	UA_UB("UA_UB"),
	WAVE_HEIGHT("WAVE_HEIGHT"),
	WAVE_L("WAVE_L"),
	WAVE_PERIOD("WAVE_PERIOD"),
	P1_CONVERT_CURRENTS("P1_CONVERT_CURRENTS"),
	P1_CONVERT_WSPD("P1_CONVERT_WSPD"),
	P1_EC_COEFF_SED("P1_EC_COEFF_SED"),
	P1_EC_COEFF_WATER("P1_EC_COEFF_WATER"),
	P1_EPI_LIGHT_K("P1_EPI_LIGHT_K"),
	P1_F_EAST("P1_F_EAST"),
	P1_F_NORTH("P1_F_NORTH"),
	P1_F_SOUTH("P1_F_SOUTH"),
	P1_F_WEST("P1_F_WEST"),
	P1_IC_SED_ELEV("P1_IC_SED_ELEV"),
	P1_LATITUDE("P1_LATITUDE"),
	P1_MAX_EC_COEFF_PLANTS("P1_MAX_EC_COEFF_PLANTS"),
	P1_PHYTO_LIGHT_K("P1_PHYTO_LIGHT_K"),
	P1_SW_LIGHT_K("P1_SW_LIGHT_K"),
	P1_ZOSTRA_LIGHT_K("P1_ZOSTRA_LIGHT_K"),
	DECLINE("DECLINE"),
	FRIC_COEF("FRIC_COEF"),
	H_ANGLE("H_ANGLE"),
	SKEW_WEATHER("SKEW_WEATHER"),
	P1_PRECIPITATION("P1_PRECIPITATION"),
	P1_WIND_DIRECTION("P1_WIND_DIRECTION"),
	P1_WIND_SPEED("P1_WIND_SPEED"),
	TModule(name) {

	P1_CELL_SIZE.SetF(FisExport,True,"CG");
	H2O_TEMP.SetF(FisExport,True,"CG");
	P1_ON_MAP.SetF(FisExport,True,"CG");
	P1_AIR_TEMP.SetF(FisExport,True,"CG");
	EW_VECTOR.SetF(FisExport,True,"CG");
	EW_WIND_VECTOR.SetF(FisExport,True,"CG");
	NS_VECTOR.SetF(FisExport,True,"CG");
	NS_WIND_VECTOR.SetF(FisExport,True,"CG");
	DAYS.SetF(FisExport,True,"CG");
	SF_WATER.SetF(FisExport,True,"CG");
	SF_WT_E_X.SetF(FisExport,True,"CG");
	SF_WT_N_X.SetF(FisExport,True,"CG");
	SF_WT_S_X.SetF(FisExport,True,"CG");
	SF_WT_W_X.SetF(FisExport,True,"CG");
	P1_LEAF_GROW_SEASON.SetF(FisExport,True,"CG");
	ZOSTRA_LIGHT_LIM.SetF(FisExport,True,"CG");
	EPI_LIGHT_LIM.SetF(FisExport,True,"CG");
	TSS_CONC.SetF(FisImport,True,"CG");
	PHT_CONC.SetF(FisImport,True,"CG");
	LEAF_LENGTH.SetF(FisImport,True,"CG");
	EPIPHYTES.SetF(FisImport,True,"CG");
	WATER_DEPTH.SetF(FisExport,True,"CG");
	PHT_LIGHT_LIM.SetF(FisExport,True,"CG");
	SW_LIGHT_LIM.SetF(FisExport,True,"CG");
	CURRENT_VELOCITY.SetF(FisExport,True,"CG");
	SHEAR_STRESS.SetF(FisExport,True,"CG");
}	
int GLOBAL_module::DAYS_I175_exe() {
	float value;

	DAYS.UpdateIntegrator();
	switch( DAYS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DAYS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  COUNT_HOURS.Value(p);
			DAYS.Update( p, value, dT() );
		}
		DAYS.GrabMemory();
		if( DAYS.GetF(FLinkEdges) ) { DAYS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  COUNT_HOURS.Value();
			DAYS.Update( value, dT() );
	  } break;
	}
	return 0;
}

int GLOBAL_module::DAYS_i176_exe() {
	float value;

	DAYS.UpdateIntegrator();
	switch( DAYS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DAYS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			DAYS.InitValue( p, value );
		}
		DAYS.GrabMemory();
		if( DAYS.GetF(FLinkEdges) ) { DAYS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			DAYS.InitValue( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::COUNT_HOURS_u177_exe() {
	float value;

	switch( COUNT_HOURS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = COUNT_HOURS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( HOURS.Value(p) == ((float)0) ) ) ? ( ( ((float)1)*dT() ) ) : ( ((float)0) ) ) ;
			COUNT_HOURS.Update( p, value );
		}
		COUNT_HOURS.GrabMemory();
		if( COUNT_HOURS.GetF(FICFlux) ) COUNT_HOURS.Cov().Set(0.0); 
		if( COUNT_HOURS.GetF(FLinkEdges) ) { COUNT_HOURS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( HOURS.Value() == ((float)0) ) ) ? ( ( ((float)1)*dT() ) ) : ( ((float)0) ) ) ;
			COUNT_HOURS.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::ALPHA_u178_exe() {
	float value;

	switch( ALPHA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ALPHA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ((float)1)+pow((double)UA_UB.Value(p),(double)((float)2) ) )+( ( ((float)2)*UA_UB.Value(p) )*SL::Cos(ANGLE.Value(p)) ) );
			ALPHA.Update( p, value );
		}
		ALPHA.GrabMemory();
		if( ALPHA.GetF(FLinkEdges) ) { ALPHA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ((float)1)+pow((double)UA_UB.Value(),(double)((float)2) ) )+( ( ((float)2)*UA_UB.Value() )*SL::Cos(ANGLE.Value()) ) );
			ALPHA.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::ANGLE_u179_exe() {
	float value;

	switch( ANGLE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ANGLE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SL::Abs(( CURRENT_DIRECTION.Value(p)-P1_WIND_DIRECTION.Value(p) ))/8 )*( ((float)2)*3.141590 ) );
			ANGLE.Update( p, value );
		}
		ANGLE.GrabMemory();
		if( ANGLE.GetF(FLinkEdges) ) { ANGLE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SL::Abs(( CURRENT_DIRECTION.Value()-P1_WIND_DIRECTION.Value() ))/8 )*( ((float)2)*3.141590 ) );
			ANGLE.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::CURRENT_DIRECTION_u180_exe() {
	float value;

	switch( CURRENT_DIRECTION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CURRENT_DIRECTION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ( NS_VECTOR.Value(p) == ((float)0) ) && ( EW_VECTOR.Value(p) == ((float)0) ) ) ) ? ( ((float)0) ) : (  ( ( ( ( ((float)450)-( SL::Arctan(( NS_VECTOR.Value(p)/EW_VECTOR.Value(p) ))*( ((float)360)/( ((float)2)*3.141590 ) ) ) ) >= ((float)360) ) ) ? ( ( ( ((float)450)-( SL::Arctan(( NS_VECTOR.Value(p)/EW_VECTOR.Value(p) ))*( ((float)360)/( ((float)2)*3.141590 ) ) ) )-((float)360) ) ) : ( ( ((float)450)-( SL::Arctan(( NS_VECTOR.Value(p)/EW_VECTOR.Value(p) ))*( ((float)360)/( ((float)2)*3.141590 ) ) ) ) ) )  ) ) ;
			CURRENT_DIRECTION.Update( p, value );
		}
		CURRENT_DIRECTION.GrabMemory();
		if( CURRENT_DIRECTION.GetF(FLinkEdges) ) { CURRENT_DIRECTION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ( NS_VECTOR.Value() == ((float)0) ) && ( EW_VECTOR.Value() == ((float)0) ) ) ) ? ( ((float)0) ) : (  ( ( ( ( ((float)450)-( SL::Arctan(( NS_VECTOR.Value()/EW_VECTOR.Value() ))*( ((float)360)/( ((float)2)*3.141590 ) ) ) ) >= ((float)360) ) ) ? ( ( ( ((float)450)-( SL::Arctan(( NS_VECTOR.Value()/EW_VECTOR.Value() ))*( ((float)360)/( ((float)2)*3.141590 ) ) ) )-((float)360) ) ) : ( ( ((float)450)-( SL::Arctan(( NS_VECTOR.Value()/EW_VECTOR.Value() ))*( ((float)360)/( ((float)2)*3.141590 ) ) ) ) ) )  ) ) ;
			CURRENT_DIRECTION.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::CURRENT_VELOCITY_u181_exe() {
	float value;

	switch( CURRENT_VELOCITY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = CURRENT_VELOCITY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Sqrt(( pow((double)EW_VECTOR.Value(p),(double)((float)2) )+pow((double)NS_VECTOR.Value(p),(double)((float)2) ) ));
			CURRENT_VELOCITY.Update( p, value );
		}
		CURRENT_VELOCITY.GrabMemory();
		if( CURRENT_VELOCITY.GetF(FLinkEdges) ) { CURRENT_VELOCITY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Sqrt(( pow((double)EW_VECTOR.Value(),(double)((float)2) )+pow((double)NS_VECTOR.Value(),(double)((float)2) ) ));
			CURRENT_VELOCITY.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::DW_WAVE_L_u182_exe() {
	float value;

	switch( DW_WAVE_L.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DW_WAVE_L.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( 9.8*pow((double)WAVE_PERIOD.Value(p),(double)((float)2) ) )/( ((float)2)*3.141590 ) );
			DW_WAVE_L.Update( p, value );
		}
		DW_WAVE_L.GrabMemory();
		if( DW_WAVE_L.GetF(FLinkEdges) ) { DW_WAVE_L.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( 9.8*pow((double)WAVE_PERIOD.Value(),(double)((float)2) ) )/( ((float)2)*3.141590 ) );
			DW_WAVE_L.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::EC_H2O_u183_exe() {
	float value;

	switch( EC_H2O.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EC_H2O.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_EC_COEFF_SED.Value(p)*( TSS_CONC.Value(p)+PHT_CONC.Value(p) ) )+P1_EC_COEFF_WATER.Value(p) );
			EC_H2O.Update( p, value );
		}
		EC_H2O.GrabMemory();
		if( EC_H2O.GetF(FLinkEdges) ) { EC_H2O.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_EC_COEFF_SED.Value()*( TSS_CONC.Value()+PHT_CONC.Value() ) )+P1_EC_COEFF_WATER.Value() );
			EC_H2O.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::EC_PLANTS_u184_exe() {
	float value;

	switch( EC_PLANTS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EC_PLANTS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_MAX_EC_COEFF_PLANTS.Value(p)*LEAF_LENGTH.Value(p) );
			EC_PLANTS.Update( p, value );
		}
		EC_PLANTS.GrabMemory();
		if( EC_PLANTS.GetF(FLinkEdges) ) { EC_PLANTS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_MAX_EC_COEFF_PLANTS.Value()*LEAF_LENGTH.Value() );
			EC_PLANTS.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::EPI_LIGHT_LIM_u185_exe() {
	float value;

	switch( EPI_LIGHT_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EPI_LIGHT_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( LIGHT_AT_EPIPHYTES.Value(p)/( P1_EPI_LIGHT_K.Value(p)+LIGHT_AT_EPIPHYTES.Value(p) ) );
			EPI_LIGHT_LIM.Update( p, value );
		}
		EPI_LIGHT_LIM.GrabMemory();
		if( EPI_LIGHT_LIM.GetF(FLinkEdges) ) { EPI_LIGHT_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( LIGHT_AT_EPIPHYTES.Value()/( P1_EPI_LIGHT_K.Value()+LIGHT_AT_EPIPHYTES.Value() ) );
			EPI_LIGHT_LIM.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::EW_CURRENT_VECTOR_u186_exe() {
	float value;

	switch( EW_CURRENT_VECTOR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EW_CURRENT_VECTOR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			EW_CURRENT_VECTOR.Update( p, value );
		}
		EW_CURRENT_VECTOR.GrabMemory();
		if( EW_CURRENT_VECTOR.GetF(FLinkEdges) ) { EW_CURRENT_VECTOR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			EW_CURRENT_VECTOR.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::EW_VECTOR_u187_exe() {
	float value;

	switch( EW_VECTOR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EW_VECTOR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( EW_CURRENT_VECTOR.Value(p)*P1_CONVERT_CURRENTS.Value(p) )+( 0.035*EW_WIND_VECTOR.Value(p) ) );
			EW_VECTOR.Update( p, value );
		}
		EW_VECTOR.GrabMemory();
		if( EW_VECTOR.GetF(FLinkEdges) ) { EW_VECTOR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( EW_CURRENT_VECTOR.Value()*P1_CONVERT_CURRENTS.Value() )+( 0.035*EW_WIND_VECTOR.Value() ) );
			EW_VECTOR.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::EW_WIND_VECTOR_u188_exe() {
	float value;

	switch( EW_WIND_VECTOR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EW_WIND_VECTOR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_WIND_SPEED.Value(p)*P1_CONVERT_WSPD.Value(p) )*SL::Sin(( ( ( ( ((float)180)+P1_WIND_DIRECTION.Value(p) )*((float)2) )*3.141590 )/360 )) );
			EW_WIND_VECTOR.Update( p, value );
		}
		EW_WIND_VECTOR.GrabMemory();
		if( EW_WIND_VECTOR.GetF(FLinkEdges) ) { EW_WIND_VECTOR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_WIND_SPEED.Value()*P1_CONVERT_WSPD.Value() )*SL::Sin(( ( ( ( ((float)180)+P1_WIND_DIRECTION.Value() )*((float)2) )*3.141590 )/360 )) );
			EW_WIND_VECTOR.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::FETCH_u189_exe() {
	float value;

	switch( FETCH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FETCH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( P1_WIND_DIRECTION.Value(p) <  ((float)45) ) ) ? ( P1_F_NORTH.Value(p) ) : (  ( ( ( P1_WIND_DIRECTION.Value(p) <  ((float)135) ) ) ? ( P1_F_EAST.Value(p) ) : (  ( ( ( P1_WIND_DIRECTION.Value(p) <  ((float)225) ) ) ? ( P1_F_SOUTH.Value(p) ) : (  ( ( ( P1_WIND_DIRECTION.Value(p) <  ((float)315) ) ) ? ( P1_F_WEST.Value(p) ) : ( P1_F_NORTH.Value(p) ) )  ) )  ) )  ) ) ;
			FETCH.Update( p, value );
		}
		FETCH.GrabMemory();
		if( FETCH.GetF(FLinkEdges) ) { FETCH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( P1_WIND_DIRECTION.Value() <  ((float)45) ) ) ? ( P1_F_NORTH.Value() ) : (  ( ( ( P1_WIND_DIRECTION.Value() <  ((float)135) ) ) ? ( P1_F_EAST.Value() ) : (  ( ( ( P1_WIND_DIRECTION.Value() <  ((float)225) ) ) ? ( P1_F_SOUTH.Value() ) : (  ( ( ( P1_WIND_DIRECTION.Value() <  ((float)315) ) ) ? ( P1_F_WEST.Value() ) : ( P1_F_NORTH.Value() ) )  ) )  ) )  ) ) ;
			FETCH.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::G_D_u190_exe() {
	float value;

	switch( G_D.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = G_D.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( WATER_DEPTH.Value(p)*9.7 )/pow((double)P1_WIND_SPEED.Value(p),(double)((float)2) ) );
			G_D.Update( p, value );
		}
		G_D.GrabMemory();
		if( G_D.GetF(FLinkEdges) ) { G_D.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( WATER_DEPTH.Value()*9.7 )/pow((double)P1_WIND_SPEED.Value(),(double)((float)2) ) );
			G_D.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::G_F_u191_exe() {
	float value;

	switch( G_F.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = G_F.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( FETCH.Value(p)*9.7 )/pow((double)P1_WIND_SPEED.Value(p),(double)((float)2) ) );
			G_F.Update( p, value );
		}
		G_F.GrabMemory();
		if( G_F.GetF(FLinkEdges) ) { G_F.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( FETCH.Value()*9.7 )/pow((double)P1_WIND_SPEED.Value(),(double)((float)2) ) );
			G_F.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::H1_u192_exe() {
	float value;

	switch( H1.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = H1.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( .53*pow((double)G_D.Value(p),(double).75 ) );
			H1.Update( p, value );
		}
		H1.GrabMemory();
		if( H1.GetF(FLinkEdges) ) { H1.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( .53*pow((double)G_D.Value(),(double).75 ) );
			H1.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::H2_u193_exe() {
	float value;

	switch( H2.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = H2.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( .00565*SL::Sqrt(G_F.Value(p)) );
			H2.Update( p, value );
		}
		H2.GrabMemory();
		if( H2.GetF(FLinkEdges) ) { H2.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( .00565*SL::Sqrt(G_F.Value()) );
			H2.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::H2O_TEMP_u194_exe() {
	float value;

	switch( H2O_TEMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = H2O_TEMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ((float)10)-( ((float)10)*SL::Cos(( ( ( ((float)2)*3.141590 )*( DAYS.Value(p)-((float)31) ) )/365 )) ) );
			H2O_TEMP.Update( p, value );
		}
		H2O_TEMP.GrabMemory();
		if( H2O_TEMP.GetF(FLinkEdges) ) { H2O_TEMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ((float)10)-( ((float)10)*SL::Cos(( ( ( ((float)2)*3.141590 )*( DAYS.Value()-((float)31) ) )/365 )) ) );
			H2O_TEMP.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::HA_u195_exe() {
	float value;

	switch( HA.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HA.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( SL::Exp(H1.Value(p))-SL::Exp(-H1.Value(p)) )/SL::Exp(H1.Value(p)) )+SL::Exp(-H1.Value(p)) );
			HA.Update( p, value );
		}
		HA.GrabMemory();
		if( HA.GetF(FLinkEdges) ) { HA.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( SL::Exp(H1.Value())-SL::Exp(-H1.Value()) )/SL::Exp(H1.Value()) )+SL::Exp(-H1.Value()) );
			HA.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::HABB_u196_exe() {
	float value;

	switch( HABB.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HABB.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SL::Exp(( H2.Value(p)/HA.Value(p) ))-SL::Exp(( -H2.Value(p)/HA.Value(p) )) )/( SL::Exp(( H2.Value(p)/HA.Value(p) ))+SL::Exp(( -H2.Value(p)/HA.Value(p) )) ) );
			HABB.Update( p, value );
		}
		HABB.GrabMemory();
		if( HABB.GetF(FLinkEdges) ) { HABB.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SL::Exp(( H2.Value()/HA.Value() ))-SL::Exp(( -H2.Value()/HA.Value() )) )/( SL::Exp(( H2.Value()/HA.Value() ))+SL::Exp(( -H2.Value()/HA.Value() )) ) );
			HABB.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::HOURS_u197_exe() {
	float value;

	switch( HOURS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = HOURS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Mod(TIME.Value(), ((float)24));
			HOURS.Update( p, value );
		}
		HOURS.GrabMemory();
		if( HOURS.GetF(FLinkEdges) ) { HOURS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Mod(TIME.Value(), ((float)24));
			HOURS.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::LIGHT_AT_EPIPHYTES_u198_exe() {
	float value;

	switch( LIGHT_AT_EPIPHYTES.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LIGHT_AT_EPIPHYTES.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SURFACE_LIGHT.Value(p)*SL::Exp(( -EC_H2O.Value(p)*SL::Max(((float)0), ( WATER_DEPTH.Value(p)-LEAF_LENGTH.Value(p) )) )) );
			LIGHT_AT_EPIPHYTES.Update( p, value );
		}
		LIGHT_AT_EPIPHYTES.GrabMemory();
		if( LIGHT_AT_EPIPHYTES.GetF(FLinkEdges) ) { LIGHT_AT_EPIPHYTES.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SURFACE_LIGHT.Value()*SL::Exp(( -EC_H2O.Value()*SL::Max(((float)0), ( WATER_DEPTH.Value()-LEAF_LENGTH.Value() )) )) );
			LIGHT_AT_EPIPHYTES.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::LIGHT_AT_PLANTS_u199_exe() {
	float value;

	switch( LIGHT_AT_PLANTS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LIGHT_AT_PLANTS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SURFACE_LIGHT.Value(p)*SL::Exp(( ( -EC_PLANTS.Value(p)*( WATER_DEPTH.Value(p)-( 0.5*LEAF_LENGTH.Value(p) ) ) )*EPIPHYTES.Value(p) )) );
			LIGHT_AT_PLANTS.Update( p, value );
		}
		LIGHT_AT_PLANTS.GrabMemory();
		if( LIGHT_AT_PLANTS.GetF(FLinkEdges) ) { LIGHT_AT_PLANTS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SURFACE_LIGHT.Value()*SL::Exp(( ( -EC_PLANTS.Value()*( WATER_DEPTH.Value()-( 0.5*LEAF_LENGTH.Value() ) ) )*EPIPHYTES.Value() )) );
			LIGHT_AT_PLANTS.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::LIGHT_TO_PHYTOPLANKTON_u200_exe() {
	float value;

	switch( LIGHT_TO_PHYTOPLANKTON.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = LIGHT_TO_PHYTOPLANKTON.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SURFACE_LIGHT.Value(p)*SL::Exp(( -EC_H2O.Value(p)*SL::Max(((float)0), ( WATER_DEPTH.Value(p)*0.5 )) )) );
			LIGHT_TO_PHYTOPLANKTON.Update( p, value );
		}
		LIGHT_TO_PHYTOPLANKTON.GrabMemory();
		if( LIGHT_TO_PHYTOPLANKTON.GetF(FLinkEdges) ) { LIGHT_TO_PHYTOPLANKTON.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SURFACE_LIGHT.Value()*SL::Exp(( -EC_H2O.Value()*SL::Max(((float)0), ( WATER_DEPTH.Value()*0.5 )) )) );
			LIGHT_TO_PHYTOPLANKTON.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::NS_CURRENT_VECTOR_u201_exe() {
	float value;

	switch( NS_CURRENT_VECTOR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NS_CURRENT_VECTOR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			NS_CURRENT_VECTOR.Update( p, value );
		}
		NS_CURRENT_VECTOR.GrabMemory();
		if( NS_CURRENT_VECTOR.GetF(FLinkEdges) ) { NS_CURRENT_VECTOR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			NS_CURRENT_VECTOR.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::NS_VECTOR_u202_exe() {
	float value;

	switch( NS_VECTOR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NS_VECTOR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( NS_CURRENT_VECTOR.Value(p)*P1_CONVERT_CURRENTS.Value(p) )+( 0.035*NS_WIND_VECTOR.Value(p) ) );
			NS_VECTOR.Update( p, value );
		}
		NS_VECTOR.GrabMemory();
		if( NS_VECTOR.GetF(FLinkEdges) ) { NS_VECTOR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( NS_CURRENT_VECTOR.Value()*P1_CONVERT_CURRENTS.Value() )+( 0.035*NS_WIND_VECTOR.Value() ) );
			NS_VECTOR.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::NS_WIND_VECTOR_u203_exe() {
	float value;

	switch( NS_WIND_VECTOR.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = NS_WIND_VECTOR.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_WIND_SPEED.Value(p)*P1_CONVERT_WSPD.Value(p) )*SL::Cos(( ( ( ( P1_WIND_DIRECTION.Value(p)+((float)180) )*((float)2) )*3.141590 )/360 )) );
			NS_WIND_VECTOR.Update( p, value );
		}
		NS_WIND_VECTOR.GrabMemory();
		if( NS_WIND_VECTOR.GetF(FLinkEdges) ) { NS_WIND_VECTOR.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_WIND_SPEED.Value()*P1_CONVERT_WSPD.Value() )*SL::Cos(( ( ( ( P1_WIND_DIRECTION.Value()+((float)180) )*((float)2) )*3.141590 )/360 )) );
			NS_WIND_VECTOR.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::ORBITAL_VELOCITY_u204_exe() {
	float value;

	switch( ORBITAL_VELOCITY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ORBITAL_VELOCITY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( WAVE_L.Value(p) <= ((float)0) ) ) ? ( ((float)0) ) : ( ( ( ( ( WAVE_HEIGHT.Value(p)*9.8 )*WAVE_PERIOD.Value(p) )/( ((float)2)*WAVE_L.Value(p) ) )*( ((float)1)/( ( SL::Exp(( ( ( ((float)2)*3.141590 )*WATER_DEPTH.Value(p) )/WAVE_L.Value(p) ))+SL::Exp(( -( ( ((float)2)*3.141590 )*WATER_DEPTH.Value(p) )/WAVE_L.Value(p) )) )/2 ) ) ) ) ) ;
			ORBITAL_VELOCITY.Update( p, value );
		}
		ORBITAL_VELOCITY.GrabMemory();
		if( ORBITAL_VELOCITY.GetF(FLinkEdges) ) { ORBITAL_VELOCITY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( WAVE_L.Value() <= ((float)0) ) ) ? ( ((float)0) ) : ( ( ( ( ( WAVE_HEIGHT.Value()*9.8 )*WAVE_PERIOD.Value() )/( ((float)2)*WAVE_L.Value() ) )*( ((float)1)/( ( SL::Exp(( ( ( ((float)2)*3.141590 )*WATER_DEPTH.Value() )/WAVE_L.Value() ))+SL::Exp(( -( ( ((float)2)*3.141590 )*WATER_DEPTH.Value() )/WAVE_L.Value() )) )/2 ) ) ) ) ) ;
			ORBITAL_VELOCITY.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::PHOTO_PERIOD_u205_exe() {
	float value;

	switch( PHOTO_PERIOD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHOTO_PERIOD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( 7.639437*H_ANGLE.Value(p) );
			PHOTO_PERIOD.Update( p, value );
		}
		PHOTO_PERIOD.GrabMemory();
		if( PHOTO_PERIOD.GetF(FLinkEdges) ) { PHOTO_PERIOD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( 7.639437*H_ANGLE.Value() );
			PHOTO_PERIOD.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::PHT_LIGHT_LIM_u206_exe() {
	float value;

	switch( PHT_LIGHT_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_LIGHT_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( LIGHT_TO_PHYTOPLANKTON.Value(p)/( LIGHT_TO_PHYTOPLANKTON.Value(p)+P1_PHYTO_LIGHT_K.Value(p) ) );
			PHT_LIGHT_LIM.Update( p, value );
		}
		PHT_LIGHT_LIM.GrabMemory();
		if( PHT_LIGHT_LIM.GetF(FLinkEdges) ) { PHT_LIGHT_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( LIGHT_TO_PHYTOPLANKTON.Value()/( LIGHT_TO_PHYTOPLANKTON.Value()+P1_PHYTO_LIGHT_K.Value() ) );
			PHT_LIGHT_LIM.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::RAND_u207_exe() {
	float value;

	switch( RAND.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = RAND.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Rand(((float)0), ((float)98));
			RAND.Update( p, value );
		}
		RAND.GrabMemory();
		if( RAND.GetF(FLinkEdges) ) { RAND.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Rand(((float)0), ((float)98));
			RAND.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::SDCLN_u208_exe() {
	float value;

	switch( SDCLN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SDCLN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( 0.00678+( 0.39762*SL::Cos(( 0.0172142*( DAYS.Value(p)-((float)172) ) )) ) )+( 0.00613*SL::Sin(( 0.0172142*( DAYS.Value(p)-((float)172) ) )) ) )-( 0.00661*SL::Cos(( 0.034428*( DAYS.Value(p)-((float)172) ) )) ) )-( 0.00159*SL::Sin(( 0.034428*( DAYS.Value(p)-((float)172) ) )) ) );
			SDCLN.Update( p, value );
		}
		SDCLN.GrabMemory();
		if( SDCLN.GetF(FLinkEdges) ) { SDCLN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( 0.00678+( 0.39762*SL::Cos(( 0.0172142*( DAYS.Value()-((float)172) ) )) ) )+( 0.00613*SL::Sin(( 0.0172142*( DAYS.Value()-((float)172) ) )) ) )-( 0.00661*SL::Cos(( 0.034428*( DAYS.Value()-((float)172) ) )) ) )-( 0.00159*SL::Sin(( 0.034428*( DAYS.Value()-((float)172) ) )) ) );
			SDCLN.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::SF_WATER_u209_exe() {
	float value;

	switch( SF_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SF_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_CELL_SIZE.Value(p)*WATER_DEPTH.Value(p) );
			SF_WATER.Update( p, value );
		}
		SF_WATER.GrabMemory();
		if( SF_WATER.GetF(FLinkEdges) ) { SF_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_CELL_SIZE.Value()*WATER_DEPTH.Value() );
			SF_WATER.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::SF_WT_EW_X_u210_exe() {
	float value;

	switch( SF_WT_EW_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SF_WT_EW_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0;
			SF_WT_EW_X.Update( p, SF_WT_EW_X.ParameterValue(value,p) );
		}
		SF_WT_EW_X.GrabMemory();
		if( SF_WT_EW_X.GetF(FLinkEdges) ) { SF_WT_EW_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0;
			SF_WT_EW_X.Update( SF_WT_EW_X.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBAL_module::SF_WT_E_X_u211_exe() {
	float value;

	switch( SF_WT_E_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SF_WT_E_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Max(((float)0), ( ( EW_VECTOR.Value(p)*SL::Sqrt(P1_CELL_SIZE.Value(p)) )*WATER_DEPTH.Value(p) ));
			SF_WT_E_X.Update( p, value );
		}
		SF_WT_E_X.GrabMemory();
		if( SF_WT_E_X.GetF(FLinkEdges) ) { SF_WT_E_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Max(((float)0), ( ( EW_VECTOR.Value()*SL::Sqrt(P1_CELL_SIZE.Value()) )*WATER_DEPTH.Value() ));
			SF_WT_E_X.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::SF_WT_NS_X_u212_exe() {
	float value;

	switch( SF_WT_NS_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SF_WT_NS_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0;
			SF_WT_NS_X.Update( p, SF_WT_NS_X.ParameterValue(value,p) );
		}
		SF_WT_NS_X.GrabMemory();
		if( SF_WT_NS_X.GetF(FLinkEdges) ) { SF_WT_NS_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0;
			SF_WT_NS_X.Update( SF_WT_NS_X.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBAL_module::SF_WT_N_X_u213_exe() {
	float value;

	switch( SF_WT_N_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SF_WT_N_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Max(((float)0), ( ( NS_VECTOR.Value(p)*SL::Sqrt(P1_CELL_SIZE.Value(p)) )*WATER_DEPTH.Value(p) ));
			SF_WT_N_X.Update( p, value );
		}
		SF_WT_N_X.GrabMemory();
		if( SF_WT_N_X.GetF(FLinkEdges) ) { SF_WT_N_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Max(((float)0), ( ( NS_VECTOR.Value()*SL::Sqrt(P1_CELL_SIZE.Value()) )*WATER_DEPTH.Value() ));
			SF_WT_N_X.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::SF_WT_S_X_u214_exe() {
	float value;

	switch( SF_WT_S_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SF_WT_S_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Max(((float)0), ( ( -NS_VECTOR.Value(p)*SL::Sqrt(P1_CELL_SIZE.Value(p)) )*WATER_DEPTH.Value(p) ));
			SF_WT_S_X.Update( p, value );
		}
		SF_WT_S_X.GrabMemory();
		if( SF_WT_S_X.GetF(FLinkEdges) ) { SF_WT_S_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Max(((float)0), ( ( -NS_VECTOR.Value()*SL::Sqrt(P1_CELL_SIZE.Value()) )*WATER_DEPTH.Value() ));
			SF_WT_S_X.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::SF_WT_W_X_u215_exe() {
	float value;

	switch( SF_WT_W_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SF_WT_W_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Max(((float)0), ( ( -EW_VECTOR.Value(p)*SL::Sqrt(P1_CELL_SIZE.Value(p)) )*WATER_DEPTH.Value(p) ));
			SF_WT_W_X.Update( p, value );
		}
		SF_WT_W_X.GrabMemory();
		if( SF_WT_W_X.GetF(FLinkEdges) ) { SF_WT_W_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Max(((float)0), ( ( -EW_VECTOR.Value()*SL::Sqrt(P1_CELL_SIZE.Value()) )*WATER_DEPTH.Value() ));
			SF_WT_W_X.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::SHEAR_STRESS_u216_exe() {
	float value;

	switch( SHEAR_STRESS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SHEAR_STRESS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( .5*FRIC_COEF.Value(p) )*ALPHA.Value(p) )*SL::Sqrt(pow((double)ORBITAL_VELOCITY.Value(p),(double)((float)2) )) );
			SHEAR_STRESS.Update( p, value );
		}
		SHEAR_STRESS.GrabMemory();
		if( SHEAR_STRESS.GetF(FLinkEdges) ) { SHEAR_STRESS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( .5*FRIC_COEF.Value() )*ALPHA.Value() )*SL::Sqrt(pow((double)ORBITAL_VELOCITY.Value(),(double)((float)2) )) );
			SHEAR_STRESS.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::SURFACE_LIGHT_u217_exe() {
	float value;

	switch( SURFACE_LIGHT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SURFACE_LIGHT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ((float)1)-SKEW_WEATHER.Value(p) )*( 37.665+( 23.275*SL::Sin(( ( 0.016252*DAYS.Value(p) )+5.0881 )) ) ) );
			SURFACE_LIGHT.Update( p, value );
		}
		SURFACE_LIGHT.GrabMemory();
		if( SURFACE_LIGHT.GetF(FLinkEdges) ) { SURFACE_LIGHT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ((float)1)-SKEW_WEATHER.Value() )*( 37.665+( 23.275*SL::Sin(( ( 0.016252*DAYS.Value() )+5.0881 )) ) ) );
			SURFACE_LIGHT.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::SW_LIGHT_LIM_u218_exe() {
	float value;

	switch( SW_LIGHT_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_LIGHT_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( LIGHT_AT_PLANTS.Value(p)/( LIGHT_AT_PLANTS.Value(p)+P1_SW_LIGHT_K.Value(p) ) );
			SW_LIGHT_LIM.Update( p, value );
		}
		SW_LIGHT_LIM.GrabMemory();
		if( SW_LIGHT_LIM.GetF(FLinkEdges) ) { SW_LIGHT_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( LIGHT_AT_PLANTS.Value()/( LIGHT_AT_PLANTS.Value()+P1_SW_LIGHT_K.Value() ) );
			SW_LIGHT_LIM.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::T1_u219_exe() {
	float value;

	switch( T1.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = T1.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( .833*pow((double)G_D.Value(p),(double).375 ) );
			T1.Update( p, value );
		}
		T1.GrabMemory();
		if( T1.GetF(FLinkEdges) ) { T1.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( .833*pow((double)G_D.Value(),(double).375 ) );
			T1.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::T1A_u220_exe() {
	float value;

	switch( T1A.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = T1A.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SL::Exp(T1.Value(p))-SL::Exp(-T1.Value(p)) )/( SL::Exp(T1.Value(p))+SL::Exp(-T1.Value(p)) ) );
			T1A.Update( p, value );
		}
		T1A.GrabMemory();
		if( T1A.GetF(FLinkEdges) ) { T1A.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SL::Exp(T1.Value())-SL::Exp(-T1.Value()) )/( SL::Exp(T1.Value())+SL::Exp(-T1.Value()) ) );
			T1A.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::T1AB_u221_exe() {
	float value;

	switch( T1AB.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = T1AB.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( T1A.Value(p) == ((float)0) ) ) ? ( ((float)0) ) : ( ( ( SL::Exp(( T2.Value(p)/T1A.Value(p) ))-SL::Exp(( -T2.Value(p)/T1A.Value(p) )) )/( SL::Exp(( T2.Value(p)/T1A.Value(p) ))+SL::Exp(( -T2.Value(p)/T1A.Value(p) )) ) ) ) ) ;
			T1AB.Update( p, value );
		}
		T1AB.GrabMemory();
		if( T1AB.GetF(FLinkEdges) ) { T1AB.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( T1A.Value() == ((float)0) ) ) ? ( ((float)0) ) : ( ( ( SL::Exp(( T2.Value()/T1A.Value() ))-SL::Exp(( -T2.Value()/T1A.Value() )) )/( SL::Exp(( T2.Value()/T1A.Value() ))+SL::Exp(( -T2.Value()/T1A.Value() )) ) ) ) ) ;
			T1AB.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::T2_u222_exe() {
	float value;

	switch( T2.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = T2.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( .0379*pow((double)G_F.Value(p),(double).333 ) );
			T2.Update( p, value );
		}
		T2.GrabMemory();
		if( T2.GetF(FLinkEdges) ) { T2.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( .0379*pow((double)G_F.Value(),(double).333 ) );
			T2.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::TIDE_u223_exe() {
	float value;

	switch( TIDE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TIDE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( 0.6096*( ( ( ( ( ( ( ( ( ( ( ( ( -0.3+( 0.14*SL::Cos(( ( ( ( ( 15.041*TIME.Value() )-75.1 )*((float)2) )*3.141590 )/360 )) ) )+( 0.065*SL::Cos(( ( ( ( ( 30.082*TIME.Value() )-304.3 )*((float)2) )*3.141590 )/360 )) ) )+( 0.041*SL::Cos(( ( ( ( ( 29.528*TIME.Value() )-298.9 )*((float)2) )*3.141590 )/360 )) ) )+( 1.468*SL::Cos(( ( ( ( ( 28.984*TIME.Value() )-270.7 )*((float)2) )*3.141590 )/360 )) ) )+( 0.1*SL::Cos(( ( ( ( ( 57.968*TIME.Value() )-16.6 )*((float)2) )*3.141590 )/360 )) ) )+( 0.164*SL::Cos(( ( ( ( ( 86.952*TIME.Value() )-3.7 )*((float)2) )*3.141590 )/360 )) ) )+( 0.32*SL::Cos(( ( ( ( ( 28.439*TIME.Value() )-227.7 )*((float)2) )*3.141590 )/360 )) ) )+( 0.043*SL::Cos(( ( ( ( ( 27.895*TIME.Value() )-199.7 )*((float)2) )*3.141590 )/360 )) ) )+( 0.047*SL::Cos(( ( ( ( ( 13.943*TIME.Value() )-51.2 )*((float)2) )*3.141590 )/360 )) ) )+( 0.047*SL::Cos(( ( ( ( ( 14.958*TIME.Value() )-70.7 )*((float)2) )*3.141590 )/360 )) ) )+( 0.239*SL::Cos(( ( ( ( ( ((float)30)*TIME.Value() )-310.6 )*((float)2) )*3.141590 )/360 )) ) )+( 0.014*SL::Cos(( ( ( ( ( 29.958*TIME.Value() )-283.1 )*((float)2) )*3.141590 )/360 )) ) )+( 0.062*SL::Cos(( ( ( ( ( 28.512*TIME.Value() )-234.5 )*((float)2) )*3.141590 )/360 )) ) ) );
			TIDE.Update( p, value );
		}
		TIDE.GrabMemory();
		if( TIDE.GetF(FLinkEdges) ) { TIDE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( 0.6096*( ( ( ( ( ( ( ( ( ( ( ( ( -0.3+( 0.14*SL::Cos(( ( ( ( ( 15.041*TIME.Value() )-75.1 )*((float)2) )*3.141590 )/360 )) ) )+( 0.065*SL::Cos(( ( ( ( ( 30.082*TIME.Value() )-304.3 )*((float)2) )*3.141590 )/360 )) ) )+( 0.041*SL::Cos(( ( ( ( ( 29.528*TIME.Value() )-298.9 )*((float)2) )*3.141590 )/360 )) ) )+( 1.468*SL::Cos(( ( ( ( ( 28.984*TIME.Value() )-270.7 )*((float)2) )*3.141590 )/360 )) ) )+( 0.1*SL::Cos(( ( ( ( ( 57.968*TIME.Value() )-16.6 )*((float)2) )*3.141590 )/360 )) ) )+( 0.164*SL::Cos(( ( ( ( ( 86.952*TIME.Value() )-3.7 )*((float)2) )*3.141590 )/360 )) ) )+( 0.32*SL::Cos(( ( ( ( ( 28.439*TIME.Value() )-227.7 )*((float)2) )*3.141590 )/360 )) ) )+( 0.043*SL::Cos(( ( ( ( ( 27.895*TIME.Value() )-199.7 )*((float)2) )*3.141590 )/360 )) ) )+( 0.047*SL::Cos(( ( ( ( ( 13.943*TIME.Value() )-51.2 )*((float)2) )*3.141590 )/360 )) ) )+( 0.047*SL::Cos(( ( ( ( ( 14.958*TIME.Value() )-70.7 )*((float)2) )*3.141590 )/360 )) ) )+( 0.239*SL::Cos(( ( ( ( ( ((float)30)*TIME.Value() )-310.6 )*((float)2) )*3.141590 )/360 )) ) )+( 0.014*SL::Cos(( ( ( ( ( 29.958*TIME.Value() )-283.1 )*((float)2) )*3.141590 )/360 )) ) )+( 0.062*SL::Cos(( ( ( ( ( 28.512*TIME.Value() )-234.5 )*((float)2) )*3.141590 )/360 )) ) ) );
			TIDE.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::TOTAL_SF_WT_X_u224_exe() {
	float value;

	switch( TOTAL_SF_WT_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TOTAL_SF_WT_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( SF_WT_E_X.Value(p)+SF_WT_N_X.Value(p) )+SF_WT_S_X.Value(p) )+SF_WT_W_X.Value(p) );
			TOTAL_SF_WT_X.Update( p, value );
		}
		TOTAL_SF_WT_X.GrabMemory();
		if( TOTAL_SF_WT_X.GetF(FLinkEdges) ) { TOTAL_SF_WT_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( SF_WT_E_X.Value()+SF_WT_N_X.Value() )+SF_WT_S_X.Value() )+SF_WT_W_X.Value() );
			TOTAL_SF_WT_X.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::UA_UB_u225_exe() {
	float value;

	switch( UA_UB.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = UA_UB.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( ORBITAL_VELOCITY.Value(p) >  CURRENT_VELOCITY.Value(p) ) ) ? ( ( CURRENT_VELOCITY.Value(p)/ORBITAL_VELOCITY.Value(p) ) ) : ( ((float)0) ) ) ;
			UA_UB.Update( p, value );
		}
		UA_UB.GrabMemory();
		if( UA_UB.GetF(FLinkEdges) ) { UA_UB.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( ORBITAL_VELOCITY.Value() >  CURRENT_VELOCITY.Value() ) ) ? ( ( CURRENT_VELOCITY.Value()/ORBITAL_VELOCITY.Value() ) ) : ( ((float)0) ) ) ;
			UA_UB.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::WATER_DEPTH_u226_exe() {
	float value;

	switch( WATER_DEPTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WATER_DEPTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  5;
			WATER_DEPTH.Update( p, WATER_DEPTH.ParameterValue(value,p) );
		}
		WATER_DEPTH.GrabMemory();
		if( WATER_DEPTH.GetF(FLinkEdges) ) { WATER_DEPTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  5;
			WATER_DEPTH.Update( WATER_DEPTH.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBAL_module::WAVE_HEIGHT_u227_exe() {
	float value;

	switch( WAVE_HEIGHT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WAVE_HEIGHT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( .283*pow((double)P1_WIND_SPEED.Value(p),(double)((float)2) ) )*HA.Value(p) )*HABB.Value(p) )/9.7 );
			WAVE_HEIGHT.Update( p, value );
		}
		WAVE_HEIGHT.GrabMemory();
		if( WAVE_HEIGHT.GetF(FLinkEdges) ) { WAVE_HEIGHT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( .283*pow((double)P1_WIND_SPEED.Value(),(double)((float)2) ) )*HA.Value() )*HABB.Value() )/9.7 );
			WAVE_HEIGHT.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::WAVE_L_u228_exe() {
	float value;

	switch( WAVE_L.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WAVE_L.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( DW_WAVE_L.Value(p) <= ((float)0) ) ) ? ( ((float)0) ) : (  ( ( ( WATER_DEPTH.Value(p) >  ( ((float)2)*DW_WAVE_L.Value(p) ) ) ) ? ( DW_WAVE_L.Value(p) ) : ( ( DW_WAVE_L.Value(p)*SL::Sqrt(( ( SL::Exp(( ( ( ((float)2)*3.141590 )*WATER_DEPTH.Value(p) )/DW_WAVE_L.Value(p) ))-SL::Exp(( -( ( ((float)2)*3.141590 )*WATER_DEPTH.Value(p) )/DW_WAVE_L.Value(p) )) )/( SL::Exp(( ( ( ((float)2)*3.141590 )*WATER_DEPTH.Value(p) )/DW_WAVE_L.Value(p) ))+SL::Exp(( -( ( ((float)2)*3.141590 )*WATER_DEPTH.Value(p) )/DW_WAVE_L.Value(p) )) ) )) ) ) )  ) ) ;
			WAVE_L.Update( p, value );
		}
		WAVE_L.GrabMemory();
		if( WAVE_L.GetF(FLinkEdges) ) { WAVE_L.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( DW_WAVE_L.Value() <= ((float)0) ) ) ? ( ((float)0) ) : (  ( ( ( WATER_DEPTH.Value() >  ( ((float)2)*DW_WAVE_L.Value() ) ) ) ? ( DW_WAVE_L.Value() ) : ( ( DW_WAVE_L.Value()*SL::Sqrt(( ( SL::Exp(( ( ( ((float)2)*3.141590 )*WATER_DEPTH.Value() )/DW_WAVE_L.Value() ))-SL::Exp(( -( ( ((float)2)*3.141590 )*WATER_DEPTH.Value() )/DW_WAVE_L.Value() )) )/( SL::Exp(( ( ( ((float)2)*3.141590 )*WATER_DEPTH.Value() )/DW_WAVE_L.Value() ))+SL::Exp(( -( ( ((float)2)*3.141590 )*WATER_DEPTH.Value() )/DW_WAVE_L.Value() )) ) )) ) ) )  ) ) ;
			WAVE_L.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::WAVE_PERIOD_u229_exe() {
	float value;

	switch( WAVE_PERIOD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = WAVE_PERIOD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( T1A.Value(p) == ((float)0) ) ) ? ( ((float)0) ) : ( ( ( ( ( 7.54*P1_WIND_SPEED.Value(p) )/9.8 )*T1AB.Value(p) )*T1A.Value(p) ) ) ) ;
			WAVE_PERIOD.Update( p, value );
		}
		WAVE_PERIOD.GrabMemory();
		if( WAVE_PERIOD.GetF(FLinkEdges) ) { WAVE_PERIOD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( T1A.Value() == ((float)0) ) ) ? ( ((float)0) ) : ( ( ( ( ( 7.54*P1_WIND_SPEED.Value() )/9.8 )*T1AB.Value() )*T1A.Value() ) ) ) ;
			WAVE_PERIOD.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::ZOSTRA_LIGHT_LIM_u230_exe() {
	float value;

	switch( ZOSTRA_LIGHT_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = ZOSTRA_LIGHT_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( LIGHT_AT_PLANTS.Value(p)/( LIGHT_AT_PLANTS.Value(p)+P1_ZOSTRA_LIGHT_K.Value(p) ) );
			ZOSTRA_LIGHT_LIM.Update( p, value );
		}
		ZOSTRA_LIGHT_LIM.GrabMemory();
		if( ZOSTRA_LIGHT_LIM.GetF(FLinkEdges) ) { ZOSTRA_LIGHT_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( LIGHT_AT_PLANTS.Value()/( LIGHT_AT_PLANTS.Value()+P1_ZOSTRA_LIGHT_K.Value() ) );
			ZOSTRA_LIGHT_LIM.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::P1_CELL_SIZE_u231_exe() {
	float value;

	switch( P1_CELL_SIZE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_CELL_SIZE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  9216;
			P1_CELL_SIZE.Update( p, P1_CELL_SIZE.ParameterValue(value,p) );
		}
		P1_CELL_SIZE.GrabMemory();
		if( P1_CELL_SIZE.GetF(FLinkEdges) ) { P1_CELL_SIZE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  9216;
			P1_CELL_SIZE.Update( P1_CELL_SIZE.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBAL_module::P1_CONVERT_CURRENTS_u232_exe() {
	float value;

	switch( P1_CONVERT_CURRENTS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_CONVERT_CURRENTS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_CONVERT_CURRENTS.Update( p, P1_CONVERT_CURRENTS.ParameterValue(value,p) );
		}
		P1_CONVERT_CURRENTS.GrabMemory();
		if( P1_CONVERT_CURRENTS.GetF(FLinkEdges) ) { P1_CONVERT_CURRENTS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_CONVERT_CURRENTS.Update( P1_CONVERT_CURRENTS.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBAL_module::P1_CONVERT_WSPD_u233_exe() {
	float value;

	switch( P1_CONVERT_WSPD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_CONVERT_WSPD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_CONVERT_WSPD.Update( p, P1_CONVERT_WSPD.ParameterValue(value,p) );
		}
		P1_CONVERT_WSPD.GrabMemory();
		if( P1_CONVERT_WSPD.GetF(FLinkEdges) ) { P1_CONVERT_WSPD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_CONVERT_WSPD.Update( P1_CONVERT_WSPD.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBAL_module::P1_EC_COEFF_SED_u234_exe() {
	float value;

	switch( P1_EC_COEFF_SED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_EC_COEFF_SED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000700;
			P1_EC_COEFF_SED.Update( p, P1_EC_COEFF_SED.ParameterValue(value,p) );
		}
		P1_EC_COEFF_SED.GrabMemory();
		if( P1_EC_COEFF_SED.GetF(FLinkEdges) ) { P1_EC_COEFF_SED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000700;
			P1_EC_COEFF_SED.Update( P1_EC_COEFF_SED.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBAL_module::P1_EC_COEFF_WATER_u235_exe() {
	float value;

	switch( P1_EC_COEFF_WATER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_EC_COEFF_WATER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000070;
			P1_EC_COEFF_WATER.Update( p, P1_EC_COEFF_WATER.ParameterValue(value,p) );
		}
		P1_EC_COEFF_WATER.GrabMemory();
		if( P1_EC_COEFF_WATER.GetF(FLinkEdges) ) { P1_EC_COEFF_WATER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000070;
			P1_EC_COEFF_WATER.Update( P1_EC_COEFF_WATER.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBAL_module::P1_EPI_LIGHT_K_u236_exe() {
	float value;

	switch( P1_EPI_LIGHT_K.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_EPI_LIGHT_K.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_EPI_LIGHT_K.Update( p, P1_EPI_LIGHT_K.ParameterValue(value,p) );
		}
		P1_EPI_LIGHT_K.GrabMemory();
		if( P1_EPI_LIGHT_K.GetF(FLinkEdges) ) { P1_EPI_LIGHT_K.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_EPI_LIGHT_K.Update( P1_EPI_LIGHT_K.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBAL_module::P1_F_EAST_u237_exe() {
	float value;

	switch( P1_F_EAST.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_F_EAST.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)800);
			P1_F_EAST.Update( p, value );
		}
		P1_F_EAST.GrabMemory();
		if( P1_F_EAST.GetF(FLinkEdges) ) { P1_F_EAST.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)800);
			P1_F_EAST.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::P1_F_NORTH_u238_exe() {
	float value;

	switch( P1_F_NORTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_F_NORTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)500);
			P1_F_NORTH.Update( p, value );
		}
		P1_F_NORTH.GrabMemory();
		if( P1_F_NORTH.GetF(FLinkEdges) ) { P1_F_NORTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)500);
			P1_F_NORTH.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::P1_F_SOUTH_u239_exe() {
	float value;

	switch( P1_F_SOUTH.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_F_SOUTH.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  500;
			P1_F_SOUTH.Update( p, P1_F_SOUTH.ParameterValue(value,p) );
		}
		P1_F_SOUTH.GrabMemory();
		if( P1_F_SOUTH.GetF(FLinkEdges) ) { P1_F_SOUTH.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  500;
			P1_F_SOUTH.Update( P1_F_SOUTH.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBAL_module::P1_F_WEST_u240_exe() {
	float value;

	switch( P1_F_WEST.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_F_WEST.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  50;
			P1_F_WEST.Update( p, P1_F_WEST.ParameterValue(value,p) );
		}
		P1_F_WEST.GrabMemory();
		if( P1_F_WEST.GetF(FLinkEdges) ) { P1_F_WEST.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  50;
			P1_F_WEST.Update( P1_F_WEST.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBAL_module::P1_IC_SED_ELEV_u241_exe() {
	float value;

	switch( P1_IC_SED_ELEV.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_IC_SED_ELEV.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)3);
			P1_IC_SED_ELEV.Update( p, value );
		}
		P1_IC_SED_ELEV.GrabMemory();
		if( P1_IC_SED_ELEV.GetF(FLinkEdges) ) { P1_IC_SED_ELEV.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)3);
			P1_IC_SED_ELEV.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::P1_LATITUDE_u242_exe() {
	float value;

	switch( P1_LATITUDE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_LATITUDE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  38.500000;
			P1_LATITUDE.Update( p, P1_LATITUDE.ParameterValue(value,p) );
		}
		P1_LATITUDE.GrabMemory();
		if( P1_LATITUDE.GetF(FLinkEdges) ) { P1_LATITUDE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  38.500000;
			P1_LATITUDE.Update( P1_LATITUDE.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBAL_module::P1_MAX_EC_COEFF_PLANTS_u243_exe() {
	float value;

	switch( P1_MAX_EC_COEFF_PLANTS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_MAX_EC_COEFF_PLANTS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.500000;
			P1_MAX_EC_COEFF_PLANTS.Update( p, P1_MAX_EC_COEFF_PLANTS.ParameterValue(value,p) );
		}
		P1_MAX_EC_COEFF_PLANTS.GrabMemory();
		if( P1_MAX_EC_COEFF_PLANTS.GetF(FLinkEdges) ) { P1_MAX_EC_COEFF_PLANTS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.500000;
			P1_MAX_EC_COEFF_PLANTS.Update( P1_MAX_EC_COEFF_PLANTS.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBAL_module::P1_ON_MAP_u244_exe() {
	float value;

	switch( P1_ON_MAP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_ON_MAP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_ON_MAP.Update( p, P1_ON_MAP.ParameterValue(value,p) );
		}
		P1_ON_MAP.GrabMemory();
		if( P1_ON_MAP.GetF(FLinkEdges) ) { P1_ON_MAP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_ON_MAP.Update( P1_ON_MAP.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBAL_module::P1_PHYTO_LIGHT_K_u245_exe() {
	float value;

	switch( P1_PHYTO_LIGHT_K.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHYTO_LIGHT_K.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_PHYTO_LIGHT_K.Update( p, P1_PHYTO_LIGHT_K.ParameterValue(value,p) );
		}
		P1_PHYTO_LIGHT_K.GrabMemory();
		if( P1_PHYTO_LIGHT_K.GetF(FLinkEdges) ) { P1_PHYTO_LIGHT_K.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_PHYTO_LIGHT_K.Update( P1_PHYTO_LIGHT_K.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBAL_module::P1_SW_LIGHT_K_u246_exe() {
	float value;

	switch( P1_SW_LIGHT_K.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SW_LIGHT_K.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  2;
			P1_SW_LIGHT_K.Update( p, P1_SW_LIGHT_K.ParameterValue(value,p) );
		}
		P1_SW_LIGHT_K.GrabMemory();
		if( P1_SW_LIGHT_K.GetF(FLinkEdges) ) { P1_SW_LIGHT_K.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  2;
			P1_SW_LIGHT_K.Update( P1_SW_LIGHT_K.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBAL_module::P1_ZOSTRA_LIGHT_K_u247_exe() {
	float value;

	switch( P1_ZOSTRA_LIGHT_K.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_ZOSTRA_LIGHT_K.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_ZOSTRA_LIGHT_K.Update( p, P1_ZOSTRA_LIGHT_K.ParameterValue(value,p) );
		}
		P1_ZOSTRA_LIGHT_K.GrabMemory();
		if( P1_ZOSTRA_LIGHT_K.GetF(FLinkEdges) ) { P1_ZOSTRA_LIGHT_K.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_ZOSTRA_LIGHT_K.Update( P1_ZOSTRA_LIGHT_K.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int GLOBAL_module::DECLINE_u248_exe() {
	float value;

	switch( DECLINE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = DECLINE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph4(SDCLN.Value(p));
			DECLINE.Update( p, value );
		}
		DECLINE.GrabMemory();
		if( DECLINE.GetF(FLinkEdges) ) { DECLINE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph4(SDCLN.Value());
			DECLINE.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::FRIC_COEF_u249_exe() {
	float value;

	switch( FRIC_COEF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = FRIC_COEF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph5(UA_UB.Value(p));
			FRIC_COEF.Update( p, value );
		}
		FRIC_COEF.GrabMemory();
		if( FRIC_COEF.GetF(FLinkEdges) ) { FRIC_COEF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph5(UA_UB.Value());
			FRIC_COEF.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::H_ANGLE_u250_exe() {
	float value;

	switch( H_ANGLE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = H_ANGLE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph6(( -SL::Tan(( P1_LATITUDE.Value(p)*0.0174533 ))*SL::Tan(DECLINE.Value(p)) ));
			H_ANGLE.Update( p, value );
		}
		H_ANGLE.GrabMemory();
		if( H_ANGLE.GetF(FLinkEdges) ) { H_ANGLE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph6(( -SL::Tan(( P1_LATITUDE.Value()*0.0174533 ))*SL::Tan(DECLINE.Value()) ));
			H_ANGLE.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::SKEW_WEATHER_u251_exe() {
	float value;

	switch( SKEW_WEATHER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SKEW_WEATHER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph7(RAND.Value(p));
			SKEW_WEATHER.Update( p, value );
		}
		SKEW_WEATHER.GrabMemory();
		if( SKEW_WEATHER.GetF(FLinkEdges) ) { SKEW_WEATHER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph7(RAND.Value());
			SKEW_WEATHER.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::P1_AIR_TEMP_u252_exe() {
	float value;

	switch( P1_AIR_TEMP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_AIR_TEMP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph8(DAYS.Value(p));
			P1_AIR_TEMP.Update( p, value );
		}
		P1_AIR_TEMP.GrabMemory();
		if( P1_AIR_TEMP.GetF(FLinkEdges) ) { P1_AIR_TEMP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph8(DAYS.Value());
			P1_AIR_TEMP.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::P1_LEAF_GROW_SEASON_u253_exe() {
	float value;

	switch( P1_LEAF_GROW_SEASON.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_LEAF_GROW_SEASON.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph9(DAYS.Value(p));
			P1_LEAF_GROW_SEASON.Update( p, value );
		}
		P1_LEAF_GROW_SEASON.GrabMemory();
		if( P1_LEAF_GROW_SEASON.GetF(FLinkEdges) ) { P1_LEAF_GROW_SEASON.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph9(DAYS.Value());
			P1_LEAF_GROW_SEASON.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::P1_PRECIPITATION_u254_exe() {
	float value;

	switch( P1_PRECIPITATION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PRECIPITATION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph10(DAYS.Value(p));
			P1_PRECIPITATION.Update( p, value );
		}
		P1_PRECIPITATION.GrabMemory();
		if( P1_PRECIPITATION.GetF(FLinkEdges) ) { P1_PRECIPITATION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph10(DAYS.Value());
			P1_PRECIPITATION.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::P1_WIND_DIRECTION_u255_exe() {
	float value;

	switch( P1_WIND_DIRECTION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_WIND_DIRECTION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph11(DAYS.Value(p));
			P1_WIND_DIRECTION.Update( p, value );
		}
		P1_WIND_DIRECTION.GrabMemory();
		if( P1_WIND_DIRECTION.GetF(FLinkEdges) ) { P1_WIND_DIRECTION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph11(DAYS.Value());
			P1_WIND_DIRECTION.Update( value );
	  } break;
	}
	return 0;
}

int GLOBAL_module::P1_WIND_SPEED_u256_exe() {
	float value;

	switch( P1_WIND_SPEED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_WIND_SPEED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph12(DAYS.Value(p));
			P1_WIND_SPEED.Update( p, value );
		}
		P1_WIND_SPEED.GrabMemory();
		if( P1_WIND_SPEED.GetF(FLinkEdges) ) { P1_WIND_SPEED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph12(DAYS.Value());
			P1_WIND_SPEED.Update( value );
	  } break;
	}
	return 0;
}

GLOBAL_module* GLOBAL_module::fInstance = NULL;
GLOBAL_module* GLOBAL_module::kNullModel = (GLOBAL_module*)0x1;
int GLOBAL_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int GLOBAL_module::InitVars() {
	
	TIME.SSInit(this);
	P1_CELL_SIZE.SSInit(this);
	H2O_TEMP.SSInit(this);
	P1_ON_MAP.SSInit(this);
	P1_AIR_TEMP.SSInit(this);
	EW_VECTOR.SSInit(this);
	EW_WIND_VECTOR.SSInit(this);
	NS_VECTOR.SSInit(this);
	NS_WIND_VECTOR.SSInit(this);
	DAYS.SSInit(this);
	SF_WATER.SSInit(this);
	SF_WT_E_X.SSInit(this);
	SF_WT_N_X.SSInit(this);
	SF_WT_S_X.SSInit(this);
	SF_WT_W_X.SSInit(this);
	P1_LEAF_GROW_SEASON.SSInit(this);
	ZOSTRA_LIGHT_LIM.SSInit(this);
	EPI_LIGHT_LIM.SSInit(this);
	TSS_CONC.SSInit(this);
	PHT_CONC.SSInit(this);
	LEAF_LENGTH.SSInit(this);
	EPIPHYTES.SSInit(this);
	WATER_DEPTH.SSInit(this);
	PHT_LIGHT_LIM.SSInit(this);
	SW_LIGHT_LIM.SSInit(this);
	CURRENT_VELOCITY.SSInit(this);
	SHEAR_STRESS.SSInit(this);
	COUNT_HOURS.SSInit(this);
	COUNT_HOURS.SetDestination(&DAYS);
	ALPHA.SSInit(this);
	ANGLE.SSInit(this);
	CURRENT_DIRECTION.SSInit(this);
	DW_WAVE_L.SSInit(this);
	EC_H2O.SSInit(this);
	EC_PLANTS.SSInit(this);
	EW_CURRENT_VECTOR.SSInit(this);
	FETCH.SSInit(this);
	G_D.SSInit(this);
	G_F.SSInit(this);
	H1.SSInit(this);
	H2.SSInit(this);
	HA.SSInit(this);
	HABB.SSInit(this);
	HOURS.SSInit(this);
	LIGHT_AT_EPIPHYTES.SSInit(this);
	LIGHT_AT_PLANTS.SSInit(this);
	LIGHT_TO_PHYTOPLANKTON.SSInit(this);
	NS_CURRENT_VECTOR.SSInit(this);
	ORBITAL_VELOCITY.SSInit(this);
	PHOTO_PERIOD.SSInit(this);
	RAND.SSInit(this);
	SDCLN.SSInit(this);
	SF_WT_EW_X.SSInit(this);
	SF_WT_NS_X.SSInit(this);
	SURFACE_LIGHT.SSInit(this);
	T1.SSInit(this);
	T1A.SSInit(this);
	T1AB.SSInit(this);
	T2.SSInit(this);
	TIDE.SSInit(this);
	TOTAL_SF_WT_X.SSInit(this);
	UA_UB.SSInit(this);
	WAVE_HEIGHT.SSInit(this);
	WAVE_L.SSInit(this);
	WAVE_PERIOD.SSInit(this);
	P1_CONVERT_CURRENTS.SSInit(this);
	P1_CONVERT_WSPD.SSInit(this);
	P1_EC_COEFF_SED.SSInit(this);
	P1_EC_COEFF_WATER.SSInit(this);
	P1_EPI_LIGHT_K.SSInit(this);
	P1_F_EAST.SSInit(this);
	P1_F_NORTH.SSInit(this);
	P1_F_SOUTH.SSInit(this);
	P1_F_WEST.SSInit(this);
	P1_IC_SED_ELEV.SSInit(this);
	P1_LATITUDE.SSInit(this);
	P1_MAX_EC_COEFF_PLANTS.SSInit(this);
	P1_PHYTO_LIGHT_K.SSInit(this);
	P1_SW_LIGHT_K.SSInit(this);
	P1_ZOSTRA_LIGHT_K.SSInit(this);
	DECLINE.SSInit(this);
	FRIC_COEF.SSInit(this);
	H_ANGLE.SSInit(this);
	SKEW_WEATHER.SSInit(this);
	P1_PRECIPITATION.SSInit(this);
	P1_WIND_DIRECTION.SSInit(this);
	P1_WIND_SPEED.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int GLOBAL_module::SetupEvents() {
	TExecuteCommand* u231 = (TExecuteCommand*) P1_CELL_SIZE.GetCommand("u231",TCommand::kUpdate,TCommand::kCode);
	u231->SetExecutable(&P1_CELL_SIZE_u231_exe_g);
	u231->Code() = "u231 <- 9216";
	u231->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u194 = (TExecuteCommand*) H2O_TEMP.GetCommand("u194",TCommand::kUpdate,TCommand::kCode);
	u194->SetExecutable(&H2O_TEMP_u194_exe_g);
	u194->Code() = "u194 <- ( ((float)10)-( ((float)10)*SL::Cos(( ( ( ((float)2)*3.141590 )*( DAYS-((float)31) ) )/365 )) ) )";
	u194->AddDependency(DAYS);
	u194->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u244 = (TExecuteCommand*) P1_ON_MAP.GetCommand("u244",TCommand::kUpdate,TCommand::kCode);
	u244->SetExecutable(&P1_ON_MAP_u244_exe_g);
	u244->Code() = "u244 <- 1";
	u244->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u252 = (TExecuteCommand*) P1_AIR_TEMP.GetCommand("u252",TCommand::kUpdate,TCommand::kCode);
	u252->SetExecutable(&P1_AIR_TEMP_u252_exe_g);
	u252->Code() = "u252 <- Graph8(DAYS)";
	u252->AddDependency(DAYS);
	u252->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u187 = (TExecuteCommand*) EW_VECTOR.GetCommand("u187",TCommand::kUpdate,TCommand::kCode);
	u187->SetExecutable(&EW_VECTOR_u187_exe_g);
	u187->Code() = "u187 <- ( ( EW_CURRENT_VECTOR*P1_CONVERT_CURRENTS )+( 0.035*EW_WIND_VECTOR ) )";
	u187->AddDependency(EW_CURRENT_VECTOR);
	u187->AddDependency(P1_CONVERT_CURRENTS);
	u187->AddDependency(EW_WIND_VECTOR);
	u187->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u188 = (TExecuteCommand*) EW_WIND_VECTOR.GetCommand("u188",TCommand::kUpdate,TCommand::kCode);
	u188->SetExecutable(&EW_WIND_VECTOR_u188_exe_g);
	u188->Code() = "u188 <- ( ( P1_WIND_SPEED*P1_CONVERT_WSPD )*SL::Sin(( ( ( ( ((float)180)+P1_WIND_DIRECTION )*((float)2) )*3.141590 )/360 )) )";
	u188->AddDependency(P1_WIND_SPEED);
	u188->AddDependency(P1_CONVERT_WSPD);
	u188->AddDependency(P1_WIND_DIRECTION);
	u188->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u202 = (TExecuteCommand*) NS_VECTOR.GetCommand("u202",TCommand::kUpdate,TCommand::kCode);
	u202->SetExecutable(&NS_VECTOR_u202_exe_g);
	u202->Code() = "u202 <- ( ( NS_CURRENT_VECTOR*P1_CONVERT_CURRENTS )+( 0.035*NS_WIND_VECTOR ) )";
	u202->AddDependency(NS_CURRENT_VECTOR);
	u202->AddDependency(P1_CONVERT_CURRENTS);
	u202->AddDependency(NS_WIND_VECTOR);
	u202->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u203 = (TExecuteCommand*) NS_WIND_VECTOR.GetCommand("u203",TCommand::kUpdate,TCommand::kCode);
	u203->SetExecutable(&NS_WIND_VECTOR_u203_exe_g);
	u203->Code() = "u203 <- ( ( P1_WIND_SPEED*P1_CONVERT_WSPD )*SL::Cos(( ( ( ( P1_WIND_DIRECTION+((float)180) )*((float)2) )*3.141590 )/360 )) )";
	u203->AddDependency(P1_WIND_SPEED);
	u203->AddDependency(P1_CONVERT_WSPD);
	u203->AddDependency(P1_WIND_DIRECTION);
	u203->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I175 = (TExecuteCommand*) DAYS.GetCommand("I175",TCommand::kIntegrate,TCommand::kCode);
	I175->SetExecutable(&DAYS_I175_exe_g);
	I175->Code() = "I175 <- COUNT_HOURS";
	I175->AddDependency(COUNT_HOURS);
	I175->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i176 = (TExecuteCommand*) DAYS.GetCommand("i176",TCommand::kInit,TCommand::kCode);
	i176->SetExecutable(&DAYS_i176_exe_g);
	i176->Code() = "i176 <- ((float)0)";
	i176->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u209 = (TExecuteCommand*) SF_WATER.GetCommand("u209",TCommand::kUpdate,TCommand::kCode);
	u209->SetExecutable(&SF_WATER_u209_exe_g);
	u209->Code() = "u209 <- ( P1_CELL_SIZE*WATER_DEPTH )";
	u209->AddDependency(P1_CELL_SIZE);
	u209->AddDependency(WATER_DEPTH);
	u209->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u211 = (TExecuteCommand*) SF_WT_E_X.GetCommand("u211",TCommand::kUpdate,TCommand::kCode);
	u211->SetExecutable(&SF_WT_E_X_u211_exe_g);
	u211->Code() = "u211 <- SL::Max(((float)0), ( ( EW_VECTOR*SL::Sqrt(P1_CELL_SIZE) )*WATER_DEPTH ))";
	u211->AddDependency(EW_VECTOR);
	u211->AddDependency(P1_CELL_SIZE);
	u211->AddDependency(WATER_DEPTH);
	u211->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u213 = (TExecuteCommand*) SF_WT_N_X.GetCommand("u213",TCommand::kUpdate,TCommand::kCode);
	u213->SetExecutable(&SF_WT_N_X_u213_exe_g);
	u213->Code() = "u213 <- SL::Max(((float)0), ( ( NS_VECTOR*SL::Sqrt(P1_CELL_SIZE) )*WATER_DEPTH ))";
	u213->AddDependency(NS_VECTOR);
	u213->AddDependency(P1_CELL_SIZE);
	u213->AddDependency(WATER_DEPTH);
	u213->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u214 = (TExecuteCommand*) SF_WT_S_X.GetCommand("u214",TCommand::kUpdate,TCommand::kCode);
	u214->SetExecutable(&SF_WT_S_X_u214_exe_g);
	u214->Code() = "u214 <- SL::Max(((float)0), ( ( -NS_VECTOR*SL::Sqrt(P1_CELL_SIZE) )*WATER_DEPTH ))";
	u214->AddDependency(NS_VECTOR);
	u214->AddDependency(P1_CELL_SIZE);
	u214->AddDependency(WATER_DEPTH);
	u214->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u215 = (TExecuteCommand*) SF_WT_W_X.GetCommand("u215",TCommand::kUpdate,TCommand::kCode);
	u215->SetExecutable(&SF_WT_W_X_u215_exe_g);
	u215->Code() = "u215 <- SL::Max(((float)0), ( ( -EW_VECTOR*SL::Sqrt(P1_CELL_SIZE) )*WATER_DEPTH ))";
	u215->AddDependency(EW_VECTOR);
	u215->AddDependency(P1_CELL_SIZE);
	u215->AddDependency(WATER_DEPTH);
	u215->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u253 = (TExecuteCommand*) P1_LEAF_GROW_SEASON.GetCommand("u253",TCommand::kUpdate,TCommand::kCode);
	u253->SetExecutable(&P1_LEAF_GROW_SEASON_u253_exe_g);
	u253->Code() = "u253 <- Graph9(DAYS)";
	u253->AddDependency(DAYS);
	u253->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u230 = (TExecuteCommand*) ZOSTRA_LIGHT_LIM.GetCommand("u230",TCommand::kUpdate,TCommand::kCode);
	u230->SetExecutable(&ZOSTRA_LIGHT_LIM_u230_exe_g);
	u230->Code() = "u230 <- ( LIGHT_AT_PLANTS/( LIGHT_AT_PLANTS+P1_ZOSTRA_LIGHT_K ) )";
	u230->AddDependency(LIGHT_AT_PLANTS);
	u230->AddDependency(P1_ZOSTRA_LIGHT_K);
	u230->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u185 = (TExecuteCommand*) EPI_LIGHT_LIM.GetCommand("u185",TCommand::kUpdate,TCommand::kCode);
	u185->SetExecutable(&EPI_LIGHT_LIM_u185_exe_g);
	u185->Code() = "u185 <- ( LIGHT_AT_EPIPHYTES/( P1_EPI_LIGHT_K+LIGHT_AT_EPIPHYTES ) )";
	u185->AddDependency(LIGHT_AT_EPIPHYTES);
	u185->AddDependency(P1_EPI_LIGHT_K);
	u185->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* TSS_CONC_import = (TImportCommand*) TSS_CONC.GetCommand("TSS_CONC_import",TCommand::kUndefined,TCommand::kImport);
	TSS_CONC_import->Code() = "Import TSS_CONC from TSS_module";
	TSS_CONC_import->AddDependency(TSS_CONC);
	TSS_CONC_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PHT_CONC_import = (TImportCommand*) PHT_CONC.GetCommand("PHT_CONC_import",TCommand::kUndefined,TCommand::kImport);
	PHT_CONC_import->Code() = "Import PHT_CONC from PHYTOPLANKTON_module";
	PHT_CONC_import->AddDependency(PHT_CONC);
	PHT_CONC_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* LEAF_LENGTH_import = (TImportCommand*) LEAF_LENGTH.GetCommand("LEAF_LENGTH_import",TCommand::kUndefined,TCommand::kImport);
	LEAF_LENGTH_import->Code() = "Import LEAF_LENGTH from EELGRASS_module";
	LEAF_LENGTH_import->AddDependency(LEAF_LENGTH);
	LEAF_LENGTH_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* EPIPHYTES_import = (TImportCommand*) EPIPHYTES.GetCommand("EPIPHYTES_import",TCommand::kUndefined,TCommand::kImport);
	EPIPHYTES_import->Code() = "Import EPIPHYTES from EPIPHYTES_module";
	EPIPHYTES_import->AddDependency(EPIPHYTES);
	EPIPHYTES_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u226 = (TExecuteCommand*) WATER_DEPTH.GetCommand("u226",TCommand::kUpdate,TCommand::kCode);
	u226->SetExecutable(&WATER_DEPTH_u226_exe_g);
	u226->Code() = "u226 <- 5";
	u226->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u206 = (TExecuteCommand*) PHT_LIGHT_LIM.GetCommand("u206",TCommand::kUpdate,TCommand::kCode);
	u206->SetExecutable(&PHT_LIGHT_LIM_u206_exe_g);
	u206->Code() = "u206 <- ( LIGHT_TO_PHYTOPLANKTON/( LIGHT_TO_PHYTOPLANKTON+P1_PHYTO_LIGHT_K ) )";
	u206->AddDependency(LIGHT_TO_PHYTOPLANKTON);
	u206->AddDependency(P1_PHYTO_LIGHT_K);
	u206->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u218 = (TExecuteCommand*) SW_LIGHT_LIM.GetCommand("u218",TCommand::kUpdate,TCommand::kCode);
	u218->SetExecutable(&SW_LIGHT_LIM_u218_exe_g);
	u218->Code() = "u218 <- ( LIGHT_AT_PLANTS/( LIGHT_AT_PLANTS+P1_SW_LIGHT_K ) )";
	u218->AddDependency(LIGHT_AT_PLANTS);
	u218->AddDependency(P1_SW_LIGHT_K);
	u218->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u181 = (TExecuteCommand*) CURRENT_VELOCITY.GetCommand("u181",TCommand::kUpdate,TCommand::kCode);
	u181->SetExecutable(&CURRENT_VELOCITY_u181_exe_g);
	u181->Code() = "u181 <- SL::Sqrt(( pow((double)EW_VECTOR,(double)((float)2) )+pow((double)NS_VECTOR,(double)((float)2) ) ))";
	u181->AddDependency(EW_VECTOR);
	u181->AddDependency(NS_VECTOR);
	u181->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u216 = (TExecuteCommand*) SHEAR_STRESS.GetCommand("u216",TCommand::kUpdate,TCommand::kCode);
	u216->SetExecutable(&SHEAR_STRESS_u216_exe_g);
	u216->Code() = "u216 <- ( ( ( .5*FRIC_COEF )*ALPHA )*SL::Sqrt(pow((double)ORBITAL_VELOCITY,(double)((float)2) )) )";
	u216->AddDependency(FRIC_COEF);
	u216->AddDependency(ALPHA);
	u216->AddDependency(ORBITAL_VELOCITY);
	u216->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u177 = (TExecuteCommand*) COUNT_HOURS.GetCommand("u177",TCommand::kUpdate,TCommand::kCode);
	u177->SetExecutable(&COUNT_HOURS_u177_exe_g);
	u177->Code() = "u177 <-  ( ( ( HOURS == ((float)0) ) ) ? ( ( ((float)1)*dT() ) ) : ( ((float)0) ) ) ";
	u177->AddDependency(HOURS);
	u177->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u178 = (TExecuteCommand*) ALPHA.GetCommand("u178",TCommand::kUpdate,TCommand::kCode);
	u178->SetExecutable(&ALPHA_u178_exe_g);
	u178->Code() = "u178 <- ( ( ((float)1)+pow((double)UA_UB,(double)((float)2) ) )+( ( ((float)2)*UA_UB )*SL::Cos(ANGLE) ) )";
	u178->AddDependency(UA_UB);
	u178->AddDependency(ANGLE);
	u178->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u179 = (TExecuteCommand*) ANGLE.GetCommand("u179",TCommand::kUpdate,TCommand::kCode);
	u179->SetExecutable(&ANGLE_u179_exe_g);
	u179->Code() = "u179 <- ( ( SL::Abs(( CURRENT_DIRECTION-P1_WIND_DIRECTION ))/8 )*( ((float)2)*3.141590 ) )";
	u179->AddDependency(CURRENT_DIRECTION);
	u179->AddDependency(P1_WIND_DIRECTION);
	u179->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u180 = (TExecuteCommand*) CURRENT_DIRECTION.GetCommand("u180",TCommand::kUpdate,TCommand::kCode);
	u180->SetExecutable(&CURRENT_DIRECTION_u180_exe_g);
	u180->Code() = "u180 <-  ( ( ( ( NS_VECTOR == ((float)0) ) && ( EW_VECTOR == ((float)0) ) ) ) ? ( ((float)0) ) : (  ( ( ( ( ((float)450)-( SL::Arctan(( NS_VECTOR/EW_VECTOR ))*( ((float)360)/( ((float)2)*3.141590 ) ) ) ) >= ((float)360) ) ) ? ( ( ( ((float)450)-( SL::Arctan(( NS_VECTOR/EW_VECTOR ))*( ((float)360)/( ((float)2)*3.141590 ) ) ) )-((float)360) ) ) : ( ( ((float)450)-( SL::Arctan(( NS_VECTOR/EW_VECTOR ))*( ((float)360)/( ((float)2)*3.141590 ) ) ) ) ) )  ) ) ";
	u180->AddDependency(NS_VECTOR);
	u180->AddDependency(EW_VECTOR);
	u180->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u182 = (TExecuteCommand*) DW_WAVE_L.GetCommand("u182",TCommand::kUpdate,TCommand::kCode);
	u182->SetExecutable(&DW_WAVE_L_u182_exe_g);
	u182->Code() = "u182 <- ( ( 9.8*pow((double)WAVE_PERIOD,(double)((float)2) ) )/( ((float)2)*3.141590 ) )";
	u182->AddDependency(WAVE_PERIOD);
	u182->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u183 = (TExecuteCommand*) EC_H2O.GetCommand("u183",TCommand::kUpdate,TCommand::kCode);
	u183->SetExecutable(&EC_H2O_u183_exe_g);
	u183->Code() = "u183 <- ( ( P1_EC_COEFF_SED*( TSS_CONC+PHT_CONC ) )+P1_EC_COEFF_WATER )";
	u183->AddDependency(P1_EC_COEFF_SED);
	u183->AddDependency(TSS_CONC);
	u183->AddDependency(PHT_CONC);
	u183->AddDependency(P1_EC_COEFF_WATER);
	u183->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u184 = (TExecuteCommand*) EC_PLANTS.GetCommand("u184",TCommand::kUpdate,TCommand::kCode);
	u184->SetExecutable(&EC_PLANTS_u184_exe_g);
	u184->Code() = "u184 <- ( P1_MAX_EC_COEFF_PLANTS*LEAF_LENGTH )";
	u184->AddDependency(P1_MAX_EC_COEFF_PLANTS);
	u184->AddDependency(LEAF_LENGTH);
	u184->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u186 = (TExecuteCommand*) EW_CURRENT_VECTOR.GetCommand("u186",TCommand::kUpdate,TCommand::kCode);
	u186->SetExecutable(&EW_CURRENT_VECTOR_u186_exe_g);
	u186->Code() = "u186 <- ((float)0)";
	u186->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u189 = (TExecuteCommand*) FETCH.GetCommand("u189",TCommand::kUpdate,TCommand::kCode);
	u189->SetExecutable(&FETCH_u189_exe_g);
	u189->Code() = "u189 <-  ( ( ( P1_WIND_DIRECTION <  ((float)45) ) ) ? ( P1_F_NORTH ) : (  ( ( ( P1_WIND_DIRECTION <  ((float)135) ) ) ? ( P1_F_EAST ) : (  ( ( ( P1_WIND_DIRECTION <  ((float)225) ) ) ? ( P1_F_SOUTH ) : (  ( ( ( P1_WIND_DIRECTION <  ((float)315) ) ) ? ( P1_F_WEST ) : ( P1_F_NORTH ) )  ) )  ) )  ) ) ";
	u189->AddDependency(P1_WIND_DIRECTION);
	u189->AddDependency(P1_F_NORTH);
	u189->AddDependency(P1_F_EAST);
	u189->AddDependency(P1_F_SOUTH);
	u189->AddDependency(P1_F_WEST);
	u189->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u190 = (TExecuteCommand*) G_D.GetCommand("u190",TCommand::kUpdate,TCommand::kCode);
	u190->SetExecutable(&G_D_u190_exe_g);
	u190->Code() = "u190 <- ( ( WATER_DEPTH*9.7 )/pow((double)P1_WIND_SPEED,(double)((float)2) ) )";
	u190->AddDependency(WATER_DEPTH);
	u190->AddDependency(P1_WIND_SPEED);
	u190->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u191 = (TExecuteCommand*) G_F.GetCommand("u191",TCommand::kUpdate,TCommand::kCode);
	u191->SetExecutable(&G_F_u191_exe_g);
	u191->Code() = "u191 <- ( ( FETCH*9.7 )/pow((double)P1_WIND_SPEED,(double)((float)2) ) )";
	u191->AddDependency(FETCH);
	u191->AddDependency(P1_WIND_SPEED);
	u191->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u192 = (TExecuteCommand*) H1.GetCommand("u192",TCommand::kUpdate,TCommand::kCode);
	u192->SetExecutable(&H1_u192_exe_g);
	u192->Code() = "u192 <- ( .53*pow((double)G_D,(double).75 ) )";
	u192->AddDependency(G_D);
	u192->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u193 = (TExecuteCommand*) H2.GetCommand("u193",TCommand::kUpdate,TCommand::kCode);
	u193->SetExecutable(&H2_u193_exe_g);
	u193->Code() = "u193 <- ( .00565*SL::Sqrt(G_F) )";
	u193->AddDependency(G_F);
	u193->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u195 = (TExecuteCommand*) HA.GetCommand("u195",TCommand::kUpdate,TCommand::kCode);
	u195->SetExecutable(&HA_u195_exe_g);
	u195->Code() = "u195 <- ( ( ( SL::Exp(H1)-SL::Exp(-H1) )/SL::Exp(H1) )+SL::Exp(-H1) )";
	u195->AddDependency(H1);
	u195->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u196 = (TExecuteCommand*) HABB.GetCommand("u196",TCommand::kUpdate,TCommand::kCode);
	u196->SetExecutable(&HABB_u196_exe_g);
	u196->Code() = "u196 <- ( ( SL::Exp(( H2/HA ))-SL::Exp(( -H2/HA )) )/( SL::Exp(( H2/HA ))+SL::Exp(( -H2/HA )) ) )";
	u196->AddDependency(H2);
	u196->AddDependency(HA);
	u196->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u197 = (TExecuteCommand*) HOURS.GetCommand("u197",TCommand::kUpdate,TCommand::kCode);
	u197->SetExecutable(&HOURS_u197_exe_g);
	u197->Code() = "u197 <- SL::Mod(TIME, ((float)24))";
	u197->AddDependency(TIME);
	u197->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u198 = (TExecuteCommand*) LIGHT_AT_EPIPHYTES.GetCommand("u198",TCommand::kUpdate,TCommand::kCode);
	u198->SetExecutable(&LIGHT_AT_EPIPHYTES_u198_exe_g);
	u198->Code() = "u198 <- ( SURFACE_LIGHT*SL::Exp(( -EC_H2O*SL::Max(((float)0), ( WATER_DEPTH-LEAF_LENGTH )) )) )";
	u198->AddDependency(SURFACE_LIGHT);
	u198->AddDependency(EC_H2O);
	u198->AddDependency(WATER_DEPTH);
	u198->AddDependency(LEAF_LENGTH);
	u198->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u199 = (TExecuteCommand*) LIGHT_AT_PLANTS.GetCommand("u199",TCommand::kUpdate,TCommand::kCode);
	u199->SetExecutable(&LIGHT_AT_PLANTS_u199_exe_g);
	u199->Code() = "u199 <- ( SURFACE_LIGHT*SL::Exp(( ( -EC_PLANTS*( WATER_DEPTH-( 0.5*LEAF_LENGTH ) ) )*EPIPHYTES )) )";
	u199->AddDependency(SURFACE_LIGHT);
	u199->AddDependency(EC_PLANTS);
	u199->AddDependency(WATER_DEPTH);
	u199->AddDependency(LEAF_LENGTH);
	u199->AddDependency(EPIPHYTES);
	u199->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u200 = (TExecuteCommand*) LIGHT_TO_PHYTOPLANKTON.GetCommand("u200",TCommand::kUpdate,TCommand::kCode);
	u200->SetExecutable(&LIGHT_TO_PHYTOPLANKTON_u200_exe_g);
	u200->Code() = "u200 <- ( SURFACE_LIGHT*SL::Exp(( -EC_H2O*SL::Max(((float)0), ( WATER_DEPTH*0.5 )) )) )";
	u200->AddDependency(SURFACE_LIGHT);
	u200->AddDependency(EC_H2O);
	u200->AddDependency(WATER_DEPTH);
	u200->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u201 = (TExecuteCommand*) NS_CURRENT_VECTOR.GetCommand("u201",TCommand::kUpdate,TCommand::kCode);
	u201->SetExecutable(&NS_CURRENT_VECTOR_u201_exe_g);
	u201->Code() = "u201 <- ((float)0)";
	u201->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u204 = (TExecuteCommand*) ORBITAL_VELOCITY.GetCommand("u204",TCommand::kUpdate,TCommand::kCode);
	u204->SetExecutable(&ORBITAL_VELOCITY_u204_exe_g);
	u204->Code() = "u204 <-  ( ( ( WAVE_L <= ((float)0) ) ) ? ( ((float)0) ) : ( ( ( ( ( WAVE_HEIGHT*9.8 )*WAVE_PERIOD )/( ((float)2)*WAVE_L ) )*( ((float)1)/( ( SL::Exp(( ( ( ((float)2)*3.141590 )*WATER_DEPTH )/WAVE_L ))+SL::Exp(( -( ( ((float)2)*3.141590 )*WATER_DEPTH )/WAVE_L )) )/2 ) ) ) ) ) ";
	u204->AddDependency(WAVE_L);
	u204->AddDependency(WAVE_HEIGHT);
	u204->AddDependency(WAVE_PERIOD);
	u204->AddDependency(WATER_DEPTH);
	u204->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u205 = (TExecuteCommand*) PHOTO_PERIOD.GetCommand("u205",TCommand::kUpdate,TCommand::kCode);
	u205->SetExecutable(&PHOTO_PERIOD_u205_exe_g);
	u205->Code() = "u205 <- ( 7.639437*H_ANGLE )";
	u205->AddDependency(H_ANGLE);
	u205->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u207 = (TExecuteCommand*) RAND.GetCommand("u207",TCommand::kUpdate,TCommand::kCode);
	u207->SetExecutable(&RAND_u207_exe_g);
	u207->Code() = "u207 <- SL::Rand(((float)0), ((float)98))";
	u207->AddDependency(TIME);
	u207->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u208 = (TExecuteCommand*) SDCLN.GetCommand("u208",TCommand::kUpdate,TCommand::kCode);
	u208->SetExecutable(&SDCLN_u208_exe_g);
	u208->Code() = "u208 <- ( ( ( ( 0.00678+( 0.39762*SL::Cos(( 0.0172142*( DAYS-((float)172) ) )) ) )+( 0.00613*SL::Sin(( 0.0172142*( DAYS-((float)172) ) )) ) )-( 0.00661*SL::Cos(( 0.034428*( DAYS-((float)172) ) )) ) )-( 0.00159*SL::Sin(( 0.034428*( DAYS-((float)172) ) )) ) )";
	u208->AddDependency(DAYS);
	u208->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u210 = (TExecuteCommand*) SF_WT_EW_X.GetCommand("u210",TCommand::kUpdate,TCommand::kCode);
	u210->SetExecutable(&SF_WT_EW_X_u210_exe_g);
	u210->Code() = "u210 <- 0";
	u210->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u212 = (TExecuteCommand*) SF_WT_NS_X.GetCommand("u212",TCommand::kUpdate,TCommand::kCode);
	u212->SetExecutable(&SF_WT_NS_X_u212_exe_g);
	u212->Code() = "u212 <- 0";
	u212->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u217 = (TExecuteCommand*) SURFACE_LIGHT.GetCommand("u217",TCommand::kUpdate,TCommand::kCode);
	u217->SetExecutable(&SURFACE_LIGHT_u217_exe_g);
	u217->Code() = "u217 <- ( ( ((float)1)-SKEW_WEATHER )*( 37.665+( 23.275*SL::Sin(( ( 0.016252*DAYS )+5.0881 )) ) ) )";
	u217->AddDependency(SKEW_WEATHER);
	u217->AddDependency(DAYS);
	u217->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u219 = (TExecuteCommand*) T1.GetCommand("u219",TCommand::kUpdate,TCommand::kCode);
	u219->SetExecutable(&T1_u219_exe_g);
	u219->Code() = "u219 <- ( .833*pow((double)G_D,(double).375 ) )";
	u219->AddDependency(G_D);
	u219->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u220 = (TExecuteCommand*) T1A.GetCommand("u220",TCommand::kUpdate,TCommand::kCode);
	u220->SetExecutable(&T1A_u220_exe_g);
	u220->Code() = "u220 <- ( ( SL::Exp(T1)-SL::Exp(-T1) )/( SL::Exp(T1)+SL::Exp(-T1) ) )";
	u220->AddDependency(T1);
	u220->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u221 = (TExecuteCommand*) T1AB.GetCommand("u221",TCommand::kUpdate,TCommand::kCode);
	u221->SetExecutable(&T1AB_u221_exe_g);
	u221->Code() = "u221 <-  ( ( ( T1A == ((float)0) ) ) ? ( ((float)0) ) : ( ( ( SL::Exp(( T2/T1A ))-SL::Exp(( -T2/T1A )) )/( SL::Exp(( T2/T1A ))+SL::Exp(( -T2/T1A )) ) ) ) ) ";
	u221->AddDependency(T1A);
	u221->AddDependency(T2);
	u221->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u222 = (TExecuteCommand*) T2.GetCommand("u222",TCommand::kUpdate,TCommand::kCode);
	u222->SetExecutable(&T2_u222_exe_g);
	u222->Code() = "u222 <- ( .0379*pow((double)G_F,(double).333 ) )";
	u222->AddDependency(G_F);
	u222->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u223 = (TExecuteCommand*) TIDE.GetCommand("u223",TCommand::kUpdate,TCommand::kCode);
	u223->SetExecutable(&TIDE_u223_exe_g);
	u223->Code() = "u223 <- ( 0.6096*( ( ( ( ( ( ( ( ( ( ( ( ( -0.3+( 0.14*SL::Cos(( ( ( ( ( 15.041*TIME )-75.1 )*((float)2) )*3.141590 )/360 )) ) )+( 0.065*SL::Cos(( ( ( ( ( 30.082*TIME )-304.3 )*((float)2) )*3.141590 )/360 )) ) )+( 0.041*SL::Cos(( ( ( ( ( 29.528*TIME )-298.9 )*((float)2) )*3.141590 )/360 )) ) )+( 1.468*SL::Cos(( ( ( ( ( 28.984*TIME )-270.7 )*((float)2) )*3.141590 )/360 )) ) )+( 0.1*SL::Cos(( ( ( ( ( 57.968*TIME )-16.6 )*((float)2) )*3.141590 )/360 )) ) )+( 0.164*SL::Cos(( ( ( ( ( 86.952*TIME )-3.7 )*((float)2) )*3.141590 )/360 )) ) )+( 0.32*SL::Cos(( ( ( ( ( 28.439*TIME )-227.7 )*((float)2) )*3.141590 )/360 )) ) )+( 0.043*SL::Cos(( ( ( ( ( 27.895*TIME )-199.7 )*((float)2) )*3.141590 )/360 )) ) )+( 0.047*SL::Cos(( ( ( ( ( 13.943*TIME )-51.2 )*((float)2) )*3.141590 )/360 )) ) )+( 0.047*SL::Cos(( ( ( ( ( 14.958*TIME )-70.7 )*((float)2) )*3.141590 )/360 )) ) )+( 0.239*SL::Cos(( ( ( ( ( ((float)30)*TIME )-310.6 )*((float)2) )*3.141590 )/360 )) ) )+( 0.014*SL::Cos(( ( ( ( ( 29.958*TIME )-283.1 )*((float)2) )*3.141590 )/360 )) ) )+( 0.062*SL::Cos(( ( ( ( ( 28.512*TIME )-234.5 )*((float)2) )*3.141590 )/360 )) ) ) )";
	u223->AddDependency(TIME);
	u223->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u224 = (TExecuteCommand*) TOTAL_SF_WT_X.GetCommand("u224",TCommand::kUpdate,TCommand::kCode);
	u224->SetExecutable(&TOTAL_SF_WT_X_u224_exe_g);
	u224->Code() = "u224 <- ( ( ( SF_WT_E_X+SF_WT_N_X )+SF_WT_S_X )+SF_WT_W_X )";
	u224->AddDependency(SF_WT_E_X);
	u224->AddDependency(SF_WT_N_X);
	u224->AddDependency(SF_WT_S_X);
	u224->AddDependency(SF_WT_W_X);
	u224->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u225 = (TExecuteCommand*) UA_UB.GetCommand("u225",TCommand::kUpdate,TCommand::kCode);
	u225->SetExecutable(&UA_UB_u225_exe_g);
	u225->Code() = "u225 <-  ( ( ( ORBITAL_VELOCITY >  CURRENT_VELOCITY ) ) ? ( ( CURRENT_VELOCITY/ORBITAL_VELOCITY ) ) : ( ((float)0) ) ) ";
	u225->AddDependency(ORBITAL_VELOCITY);
	u225->AddDependency(CURRENT_VELOCITY);
	u225->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u227 = (TExecuteCommand*) WAVE_HEIGHT.GetCommand("u227",TCommand::kUpdate,TCommand::kCode);
	u227->SetExecutable(&WAVE_HEIGHT_u227_exe_g);
	u227->Code() = "u227 <- ( ( ( ( .283*pow((double)P1_WIND_SPEED,(double)((float)2) ) )*HA )*HABB )/9.7 )";
	u227->AddDependency(P1_WIND_SPEED);
	u227->AddDependency(HA);
	u227->AddDependency(HABB);
	u227->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u228 = (TExecuteCommand*) WAVE_L.GetCommand("u228",TCommand::kUpdate,TCommand::kCode);
	u228->SetExecutable(&WAVE_L_u228_exe_g);
	u228->Code() = "u228 <-  ( ( ( DW_WAVE_L <= ((float)0) ) ) ? ( ((float)0) ) : (  ( ( ( WATER_DEPTH >  ( ((float)2)*DW_WAVE_L ) ) ) ? ( DW_WAVE_L ) : ( ( DW_WAVE_L*SL::Sqrt(( ( SL::Exp(( ( ( ((float)2)*3.141590 )*WATER_DEPTH )/DW_WAVE_L ))-SL::Exp(( -( ( ((float)2)*3.141590 )*WATER_DEPTH )/DW_WAVE_L )) )/( SL::Exp(( ( ( ((float)2)*3.141590 )*WATER_DEPTH )/DW_WAVE_L ))+SL::Exp(( -( ( ((float)2)*3.141590 )*WATER_DEPTH )/DW_WAVE_L )) ) )) ) ) )  ) ) ";
	u228->AddDependency(DW_WAVE_L);
	u228->AddDependency(WATER_DEPTH);
	u228->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u229 = (TExecuteCommand*) WAVE_PERIOD.GetCommand("u229",TCommand::kUpdate,TCommand::kCode);
	u229->SetExecutable(&WAVE_PERIOD_u229_exe_g);
	u229->Code() = "u229 <-  ( ( ( T1A == ((float)0) ) ) ? ( ((float)0) ) : ( ( ( ( ( 7.54*P1_WIND_SPEED )/9.8 )*T1AB )*T1A ) ) ) ";
	u229->AddDependency(T1A);
	u229->AddDependency(P1_WIND_SPEED);
	u229->AddDependency(T1AB);
	u229->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u232 = (TExecuteCommand*) P1_CONVERT_CURRENTS.GetCommand("u232",TCommand::kUpdate,TCommand::kCode);
	u232->SetExecutable(&P1_CONVERT_CURRENTS_u232_exe_g);
	u232->Code() = "u232 <- 1";
	u232->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u233 = (TExecuteCommand*) P1_CONVERT_WSPD.GetCommand("u233",TCommand::kUpdate,TCommand::kCode);
	u233->SetExecutable(&P1_CONVERT_WSPD_u233_exe_g);
	u233->Code() = "u233 <- 1";
	u233->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u234 = (TExecuteCommand*) P1_EC_COEFF_SED.GetCommand("u234",TCommand::kUpdate,TCommand::kCode);
	u234->SetExecutable(&P1_EC_COEFF_SED_u234_exe_g);
	u234->Code() = "u234 <- 0.000700";
	u234->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u235 = (TExecuteCommand*) P1_EC_COEFF_WATER.GetCommand("u235",TCommand::kUpdate,TCommand::kCode);
	u235->SetExecutable(&P1_EC_COEFF_WATER_u235_exe_g);
	u235->Code() = "u235 <- 0.000070";
	u235->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u236 = (TExecuteCommand*) P1_EPI_LIGHT_K.GetCommand("u236",TCommand::kUpdate,TCommand::kCode);
	u236->SetExecutable(&P1_EPI_LIGHT_K_u236_exe_g);
	u236->Code() = "u236 <- 1";
	u236->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u237 = (TExecuteCommand*) P1_F_EAST.GetCommand("u237",TCommand::kUpdate,TCommand::kCode);
	u237->SetExecutable(&P1_F_EAST_u237_exe_g);
	u237->Code() = "u237 <- ((float)800)";
	u237->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u238 = (TExecuteCommand*) P1_F_NORTH.GetCommand("u238",TCommand::kUpdate,TCommand::kCode);
	u238->SetExecutable(&P1_F_NORTH_u238_exe_g);
	u238->Code() = "u238 <- ((float)500)";
	u238->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u239 = (TExecuteCommand*) P1_F_SOUTH.GetCommand("u239",TCommand::kUpdate,TCommand::kCode);
	u239->SetExecutable(&P1_F_SOUTH_u239_exe_g);
	u239->Code() = "u239 <- 500";
	u239->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u240 = (TExecuteCommand*) P1_F_WEST.GetCommand("u240",TCommand::kUpdate,TCommand::kCode);
	u240->SetExecutable(&P1_F_WEST_u240_exe_g);
	u240->Code() = "u240 <- 50";
	u240->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u241 = (TExecuteCommand*) P1_IC_SED_ELEV.GetCommand("u241",TCommand::kUpdate,TCommand::kCode);
	u241->SetExecutable(&P1_IC_SED_ELEV_u241_exe_g);
	u241->Code() = "u241 <- ((float)3)";
	u241->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u242 = (TExecuteCommand*) P1_LATITUDE.GetCommand("u242",TCommand::kUpdate,TCommand::kCode);
	u242->SetExecutable(&P1_LATITUDE_u242_exe_g);
	u242->Code() = "u242 <- 38.500000";
	u242->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u243 = (TExecuteCommand*) P1_MAX_EC_COEFF_PLANTS.GetCommand("u243",TCommand::kUpdate,TCommand::kCode);
	u243->SetExecutable(&P1_MAX_EC_COEFF_PLANTS_u243_exe_g);
	u243->Code() = "u243 <- 0.500000";
	u243->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u245 = (TExecuteCommand*) P1_PHYTO_LIGHT_K.GetCommand("u245",TCommand::kUpdate,TCommand::kCode);
	u245->SetExecutable(&P1_PHYTO_LIGHT_K_u245_exe_g);
	u245->Code() = "u245 <- 1";
	u245->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u246 = (TExecuteCommand*) P1_SW_LIGHT_K.GetCommand("u246",TCommand::kUpdate,TCommand::kCode);
	u246->SetExecutable(&P1_SW_LIGHT_K_u246_exe_g);
	u246->Code() = "u246 <- 2";
	u246->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u247 = (TExecuteCommand*) P1_ZOSTRA_LIGHT_K.GetCommand("u247",TCommand::kUpdate,TCommand::kCode);
	u247->SetExecutable(&P1_ZOSTRA_LIGHT_K_u247_exe_g);
	u247->Code() = "u247 <- 1";
	u247->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u248 = (TExecuteCommand*) DECLINE.GetCommand("u248",TCommand::kUpdate,TCommand::kCode);
	u248->SetExecutable(&DECLINE_u248_exe_g);
	u248->Code() = "u248 <- Graph4(SDCLN)";
	u248->AddDependency(SDCLN);
	u248->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u249 = (TExecuteCommand*) FRIC_COEF.GetCommand("u249",TCommand::kUpdate,TCommand::kCode);
	u249->SetExecutable(&FRIC_COEF_u249_exe_g);
	u249->Code() = "u249 <- Graph5(UA_UB)";
	u249->AddDependency(UA_UB);
	u249->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u250 = (TExecuteCommand*) H_ANGLE.GetCommand("u250",TCommand::kUpdate,TCommand::kCode);
	u250->SetExecutable(&H_ANGLE_u250_exe_g);
	u250->Code() = "u250 <- Graph6(( -SL::Tan(( P1_LATITUDE*0.0174533 ))*SL::Tan(DECLINE) ))";
	u250->AddDependency(P1_LATITUDE);
	u250->AddDependency(DECLINE);
	u250->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u251 = (TExecuteCommand*) SKEW_WEATHER.GetCommand("u251",TCommand::kUpdate,TCommand::kCode);
	u251->SetExecutable(&SKEW_WEATHER_u251_exe_g);
	u251->Code() = "u251 <- Graph7(RAND)";
	u251->AddDependency(RAND);
	u251->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u254 = (TExecuteCommand*) P1_PRECIPITATION.GetCommand("u254",TCommand::kUpdate,TCommand::kCode);
	u254->SetExecutable(&P1_PRECIPITATION_u254_exe_g);
	u254->Code() = "u254 <- Graph10(DAYS)";
	u254->AddDependency(DAYS);
	u254->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u255 = (TExecuteCommand*) P1_WIND_DIRECTION.GetCommand("u255",TCommand::kUpdate,TCommand::kCode);
	u255->SetExecutable(&P1_WIND_DIRECTION_u255_exe_g);
	u255->Code() = "u255 <- Graph11(DAYS)";
	u255->AddDependency(DAYS);
	u255->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u256 = (TExecuteCommand*) P1_WIND_SPEED.GetCommand("u256",TCommand::kUpdate,TCommand::kCode);
	u256->SetExecutable(&P1_WIND_SPEED_u256_exe_g);
	u256->Code() = "u256 <- Graph12(DAYS)";
	u256->AddDependency(DAYS);
	u256->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int GLOBAL_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int GLOBAL_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int GLOBAL_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int GLOBAL_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class PHOSPHATE_module 
// ---------------------------------------------------------------------------
PHOSPHATE_module::PHOSPHATE_module(char* name) :
	TIME("TIME"),
	P1_RIVER_DATA_CF("P1_RIVER_DATA_CF"),
	P1_PO4_SED_WT_CONC("P1_PO4_SED_WT_CONC"),
	PO4_SF_WT_CONC("PO4_SF_WT_CONC"),
	SF_WATER("SF_WATER"),
	WRACK_OM_DECOMP("WRACK_OM_DECOMP"),
	P1_WRACK_OM_PC("P1_WRACK_OM_PC"),
	PHT_NET_PROD("PHT_NET_PROD"),
	P1_PHY_PC("P1_PHY_PC"),
	P1_MAC_PHBIO_PC("P1_MAC_PHBIO_PC"),
	PHBIO_NET_PROD("PHBIO_NET_PROD"),
	SF_WT_E_X("SF_WT_E_X"),
	SF_WT_N_X("SF_WT_N_X"),
	SF_WT_S_X("SF_WT_S_X"),
	SF_WT_W_X("SF_WT_W_X"),
	PO4_SF_WT("PO4_SF_WT"),
	PO4_SF_WT_MINER("PO4_SF_WT_MINER"),
	PO4_SF_X_IN("PO4_SF_X_IN"),
	PO4_DNFLOW("PO4_DNFLOW"),
	PO4_SF_WT_UPTAK("PO4_SF_WT_UPTAK"),
	PO4_X_OUT("PO4_X_OUT"),
	PO4_SOIL("PO4_SOIL"),
	PO4_E_X("PO4_E_X"),
	PO4_N_X("PO4_N_X"),
	PO4_S_X("PO4_S_X"),
	PO4_W_X("PO4_W_X"),
	RIVER_P("RIVER_P"),
	P1_IC_PO4("P1_IC_PO4"),
	P1_PO4_DIFFUSION_COEFF("P1_PO4_DIFFUSION_COEFF"),
	TModule(name) {

	P1_RIVER_DATA_CF.SetF(FisExport,True,"CG");
	P1_PO4_SED_WT_CONC.SetF(FisExport,True,"CG");
	PO4_SF_WT_CONC.SetF(FisExport,True,"CG");
	SF_WATER.SetF(FisImport,True,"CG");
	WRACK_OM_DECOMP.SetF(FisImport,True,"CG");
	P1_WRACK_OM_PC.SetF(FisImport,True,"CG");
	PHT_NET_PROD.SetF(FisImport,True,"CG");
	P1_PHY_PC.SetF(FisImport,True,"CG");
	P1_MAC_PHBIO_PC.SetF(FisImport,True,"CG");
	PHBIO_NET_PROD.SetF(FisImport,True,"CG");
	SF_WT_E_X.SetF(FisImport,True,"CG");
	SF_WT_N_X.SetF(FisImport,True,"CG");
	SF_WT_S_X.SetF(FisImport,True,"CG");
	SF_WT_W_X.SetF(FisImport,True,"CG");
}	
int PHOSPHATE_module::PO4_SF_WT_I257_exe() {
	float value;

	PO4_SF_WT.UpdateIntegrator();
	switch( PO4_SF_WT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PO4_SF_WT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( PO4_SF_WT_MINER.Value(p)+PO4_SF_X_IN.Value(p) )-PO4_DNFLOW.Value(p) )-PO4_SF_WT_UPTAK.Value(p) )-PO4_X_OUT.Value(p) );
			PO4_SF_WT.Update( p, value, dT() );
		}
		PO4_SF_WT.GrabMemory();
		if( PO4_SF_WT.GetF(FLinkEdges) ) { PO4_SF_WT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( PO4_SF_WT_MINER.Value()+PO4_SF_X_IN.Value() )-PO4_DNFLOW.Value() )-PO4_SF_WT_UPTAK.Value() )-PO4_X_OUT.Value() );
			PO4_SF_WT.Update( value, dT() );
	  } break;
	}
	return 0;
}

int PHOSPHATE_module::PO4_SF_WT_i258_exe() {
	float value;

	PO4_SF_WT.UpdateIntegrator();
	switch( PO4_SF_WT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PO4_SF_WT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SF_WATER.Value(p)*P1_IC_PO4.Value(p) )*.001 );
			PO4_SF_WT.InitValue( p, value );
		}
		PO4_SF_WT.GrabMemory();
		if( PO4_SF_WT.GetF(FLinkEdges) ) { PO4_SF_WT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SF_WATER.Value()*P1_IC_PO4.Value() )*.001 );
			PO4_SF_WT.InitValue( value );
	  } break;
	}
	return 0;
}

int PHOSPHATE_module::PO4_SF_WT_MINER_u259_exe() {
	float value;

	switch( PO4_SF_WT_MINER.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PO4_SF_WT_MINER.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( WRACK_OM_DECOMP.Value(p)*P1_WRACK_OM_PC.Value(p) );
			PO4_SF_WT_MINER.Update( p, value );
		}
		PO4_SF_WT_MINER.GrabMemory();
		if( PO4_SF_WT_MINER.GetF(FICFlux) ) PO4_SF_WT_MINER.Cov().Set(0.0); 
		if( PO4_SF_WT_MINER.GetF(FLinkEdges) ) { PO4_SF_WT_MINER.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( WRACK_OM_DECOMP.Value()*P1_WRACK_OM_PC.Value() );
			PO4_SF_WT_MINER.Update( value );
	  } break;
	}
	return 0;
}

int PHOSPHATE_module::PO4_SF_X_IN_u260_exe() {
	float value;

	switch( PO4_SF_X_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PO4_SF_X_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( PO4_E_X.RelValue(p,0,-1,0,CVariable::kDefaultBC)+PO4_N_X.RelValue(p,1,0,0,CVariable::kDefaultBC) )+PO4_S_X.RelValue(p,-1,0,0,CVariable::kDefaultBC) )+PO4_W_X.RelValue(p,0,1,0,CVariable::kDefaultBC) );
			PO4_SF_X_IN.Update( p, value );
		}
		PO4_SF_X_IN.GrabMemory();
		if( PO4_SF_X_IN.GetF(FICFlux) ) PO4_SF_X_IN.Cov().Set(0.0); 
		if( PO4_SF_X_IN.GetF(FLinkEdges) ) { PO4_SF_X_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( PO4_E_X.Value()+PO4_N_X.Value() )+PO4_S_X.Value() )+PO4_W_X.Value() );
			PO4_SF_X_IN.Update( value );
	  } break;
	}
	return 0;
}

int PHOSPHATE_module::PO4_DNFLOW_u261_exe() {
	float value;

	switch( PO4_DNFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PO4_DNFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SL::Max(( ( PO4_SF_WT_CONC.Value(p)-P1_PO4_SED_WT_CONC.Value(p) )*P1_PO4_DIFFUSION_COEFF.Value(p) ), ((float)0))+ ( ( ( SF_WATER.Value(p) == ((float)0) ) ) ? ( PO4_SF_WT.Value(p) ) : ( ((float)0) ) )  );
			PO4_DNFLOW.Update( p, value );
		}
		PO4_DNFLOW.GrabMemory();
		if( PO4_DNFLOW.GetF(FICFlux) ) PO4_DNFLOW.Cov().Set(0.0); 
		if( PO4_DNFLOW.GetF(FLinkEdges) ) { PO4_DNFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SL::Max(( ( PO4_SF_WT_CONC.Value()-P1_PO4_SED_WT_CONC.Value() )*P1_PO4_DIFFUSION_COEFF.Value() ), ((float)0))+ ( ( ( SF_WATER.Value() == ((float)0) ) ) ? ( PO4_SF_WT.Value() ) : ( ((float)0) ) )  );
			PO4_DNFLOW.Update( value );
	  } break;
	}
	return 0;
}

int PHOSPHATE_module::PO4_SF_WT_UPTAK_u262_exe() {
	float value;

	switch( PO4_SF_WT_UPTAK.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PO4_SF_WT_UPTAK.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SF_WATER.Value(p) == ((float)0) ) ) ? ( ((float)0) ) : ( SL::Max(((float)0), ( ( ( PHT_NET_PROD.Value(p)*P1_PHY_PC.Value(p) )*1.0 )+( P1_MAC_PHBIO_PC.Value(p)*PHBIO_NET_PROD.Value(p) ) )) ) ) ;
			PO4_SF_WT_UPTAK.Update( p, value );
		}
		PO4_SF_WT_UPTAK.GrabMemory();
		if( PO4_SF_WT_UPTAK.GetF(FICFlux) ) PO4_SF_WT_UPTAK.Cov().Set(0.0); 
		if( PO4_SF_WT_UPTAK.GetF(FLinkEdges) ) { PO4_SF_WT_UPTAK.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SF_WATER.Value() == ((float)0) ) ) ? ( ((float)0) ) : ( SL::Max(((float)0), ( ( ( PHT_NET_PROD.Value()*P1_PHY_PC.Value() )*1.0 )+( P1_MAC_PHBIO_PC.Value()*PHBIO_NET_PROD.Value() ) )) ) ) ;
			PO4_SF_WT_UPTAK.Update( value );
	  } break;
	}
	return 0;
}

int PHOSPHATE_module::PO4_X_OUT_u263_exe() {
	float value;

	switch( PO4_X_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PO4_X_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( PO4_E_X.Value(p)+PO4_N_X.Value(p) )+PO4_S_X.Value(p) )+PO4_W_X.Value(p) );
			PO4_X_OUT.Update( p, value );
		}
		PO4_X_OUT.GrabMemory();
		if( PO4_X_OUT.GetF(FICFlux) ) PO4_X_OUT.Cov().Set(0.0); 
		if( PO4_X_OUT.GetF(FLinkEdges) ) { PO4_X_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( PO4_E_X.Value()+PO4_N_X.Value() )+PO4_S_X.Value() )+PO4_W_X.Value() );
			PO4_X_OUT.Update( value );
	  } break;
	}
	return 0;
}

int PHOSPHATE_module::PO4_SOIL_I264_exe() {
	float value;

	PO4_SOIL.UpdateIntegrator();
	switch( PO4_SOIL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PO4_SOIL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  PO4_DNFLOW.Value(p);
			PO4_SOIL.Update( p, value, dT() );
		}
		PO4_SOIL.GrabMemory();
		if( PO4_SOIL.GetF(FLinkEdges) ) { PO4_SOIL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  PO4_DNFLOW.Value();
			PO4_SOIL.Update( value, dT() );
	  } break;
	}
	return 0;
}

int PHOSPHATE_module::PO4_SOIL_i265_exe() {
	float value;

	PO4_SOIL.UpdateIntegrator();
	switch( PO4_SOIL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PO4_SOIL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ((float)0);
			PO4_SOIL.InitValue( p, value );
		}
		PO4_SOIL.GrabMemory();
		if( PO4_SOIL.GetF(FLinkEdges) ) { PO4_SOIL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ((float)0);
			PO4_SOIL.InitValue( value );
	  } break;
	}
	return 0;
}

int PHOSPHATE_module::PO4_E_X_u266_exe() {
	float value;

	switch( PO4_E_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PO4_E_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PO4_SF_WT_CONC.Value(p)*SF_WT_E_X.Value(p) );
			PO4_E_X.Update( p, value );
		}
		PO4_E_X.GrabMemory();
		if( PO4_E_X.GetF(FLinkEdges) ) { PO4_E_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PO4_SF_WT_CONC.Value()*SF_WT_E_X.Value() );
			PO4_E_X.Update( value );
	  } break;
	}
	return 0;
}

int PHOSPHATE_module::PO4_N_X_u267_exe() {
	float value;

	switch( PO4_N_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PO4_N_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PO4_SF_WT_CONC.Value(p)*SF_WT_N_X.Value(p) );
			PO4_N_X.Update( p, value );
		}
		PO4_N_X.GrabMemory();
		if( PO4_N_X.GetF(FLinkEdges) ) { PO4_N_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PO4_SF_WT_CONC.Value()*SF_WT_N_X.Value() );
			PO4_N_X.Update( value );
	  } break;
	}
	return 0;
}

int PHOSPHATE_module::PO4_SF_WT_CONC_u268_exe() {
	float value;

	switch( PO4_SF_WT_CONC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PO4_SF_WT_CONC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SF_WATER.Value(p) <  ((float)1) ) ) ? ( ((float)0) ) : ( SL::Max(( ( RIVER_P.Value(p)*P1_RIVER_DATA_CF.Value(p) )+( PO4_SF_WT.Value(p)/SF_WATER.Value(p) ) ), ((float)0)) ) ) ;
			PO4_SF_WT_CONC.Update( p, value );
		}
		PO4_SF_WT_CONC.GrabMemory();
		if( PO4_SF_WT_CONC.GetF(FLinkEdges) ) { PO4_SF_WT_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SF_WATER.Value() <  ((float)1) ) ) ? ( ((float)0) ) : ( SL::Max(( ( RIVER_P.Value()*P1_RIVER_DATA_CF.Value() )+( PO4_SF_WT.Value()/SF_WATER.Value() ) ), ((float)0)) ) ) ;
			PO4_SF_WT_CONC.Update( value );
	  } break;
	}
	return 0;
}

int PHOSPHATE_module::PO4_S_X_u269_exe() {
	float value;

	switch( PO4_S_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PO4_S_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PO4_SF_WT_CONC.Value(p)*SF_WT_S_X.Value(p) );
			PO4_S_X.Update( p, value );
		}
		PO4_S_X.GrabMemory();
		if( PO4_S_X.GetF(FLinkEdges) ) { PO4_S_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PO4_SF_WT_CONC.Value()*SF_WT_S_X.Value() );
			PO4_S_X.Update( value );
	  } break;
	}
	return 0;
}

int PHOSPHATE_module::PO4_W_X_u270_exe() {
	float value;

	switch( PO4_W_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PO4_W_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PO4_SF_WT_CONC.Value(p)*SF_WT_W_X.Value(p) );
			PO4_W_X.Update( p, value );
		}
		PO4_W_X.GrabMemory();
		if( PO4_W_X.GetF(FLinkEdges) ) { PO4_W_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PO4_SF_WT_CONC.Value()*SF_WT_W_X.Value() );
			PO4_W_X.Update( value );
	  } break;
	}
	return 0;
}

int PHOSPHATE_module::RIVER_P_u271_exe() {
	float value;

	switch( RIVER_P.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = RIVER_P.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0;
			RIVER_P.Update( p, RIVER_P.ParameterValue(value,p) );
		}
		RIVER_P.GrabMemory();
		if( RIVER_P.GetF(FLinkEdges) ) { RIVER_P.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0;
			RIVER_P.Update( RIVER_P.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int PHOSPHATE_module::P1_IC_PO4_u272_exe() {
	float value;

	switch( P1_IC_PO4.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_IC_PO4.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.002000;
			P1_IC_PO4.Update( p, P1_IC_PO4.ParameterValue(value,p) );
		}
		P1_IC_PO4.GrabMemory();
		if( P1_IC_PO4.GetF(FLinkEdges) ) { P1_IC_PO4.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.002000;
			P1_IC_PO4.Update( P1_IC_PO4.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int PHOSPHATE_module::P1_PO4_DIFFUSION_COEFF_u273_exe() {
	float value;

	switch( P1_PO4_DIFFUSION_COEFF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PO4_DIFFUSION_COEFF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_PO4_DIFFUSION_COEFF.Update( p, P1_PO4_DIFFUSION_COEFF.ParameterValue(value,p) );
		}
		P1_PO4_DIFFUSION_COEFF.GrabMemory();
		if( P1_PO4_DIFFUSION_COEFF.GetF(FLinkEdges) ) { P1_PO4_DIFFUSION_COEFF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_PO4_DIFFUSION_COEFF.Update( P1_PO4_DIFFUSION_COEFF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int PHOSPHATE_module::P1_PO4_SED_WT_CONC_u274_exe() {
	float value;

	switch( P1_PO4_SED_WT_CONC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PO4_SED_WT_CONC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_PO4_SED_WT_CONC.Update( p, P1_PO4_SED_WT_CONC.ParameterValue(value,p) );
		}
		P1_PO4_SED_WT_CONC.GrabMemory();
		if( P1_PO4_SED_WT_CONC.GetF(FLinkEdges) ) { P1_PO4_SED_WT_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_PO4_SED_WT_CONC.Update( P1_PO4_SED_WT_CONC.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int PHOSPHATE_module::P1_RIVER_DATA_CF_u275_exe() {
	float value;

	switch( P1_RIVER_DATA_CF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_RIVER_DATA_CF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.001000;
			P1_RIVER_DATA_CF.Update( p, P1_RIVER_DATA_CF.ParameterValue(value,p) );
		}
		P1_RIVER_DATA_CF.GrabMemory();
		if( P1_RIVER_DATA_CF.GetF(FLinkEdges) ) { P1_RIVER_DATA_CF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.001000;
			P1_RIVER_DATA_CF.Update( P1_RIVER_DATA_CF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

PHOSPHATE_module* PHOSPHATE_module::fInstance = NULL;
PHOSPHATE_module* PHOSPHATE_module::kNullModel = (PHOSPHATE_module*)0x1;
int PHOSPHATE_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int PHOSPHATE_module::InitVars() {
	
	TIME.SSInit(this);
	P1_RIVER_DATA_CF.SSInit(this);
	P1_PO4_SED_WT_CONC.SSInit(this);
	PO4_SF_WT_CONC.SSInit(this);
	SF_WATER.SSInit(this);
	WRACK_OM_DECOMP.SSInit(this);
	P1_WRACK_OM_PC.SSInit(this);
	PHT_NET_PROD.SSInit(this);
	P1_PHY_PC.SSInit(this);
	P1_MAC_PHBIO_PC.SSInit(this);
	PHBIO_NET_PROD.SSInit(this);
	SF_WT_E_X.SSInit(this);
	SF_WT_N_X.SSInit(this);
	SF_WT_S_X.SSInit(this);
	SF_WT_W_X.SSInit(this);
	PO4_SF_WT.SSInit(this);
	PO4_SF_WT_MINER.SSInit(this);
	PO4_SF_WT_MINER.SetDestination(&PO4_SF_WT);
	PO4_SF_X_IN.SSInit(this);
	PO4_SF_X_IN.SetDestination(&PO4_SF_WT);
	PO4_DNFLOW.SSInit(this);
	PO4_DNFLOW.SetOrigin(&PO4_SF_WT);
	PO4_DNFLOW.SetDestination(&PO4_SOIL);
	PO4_SF_WT_UPTAK.SSInit(this);
	PO4_SF_WT_UPTAK.SetOrigin(&PO4_SF_WT);
	PO4_X_OUT.SSInit(this);
	PO4_X_OUT.SetOrigin(&PO4_SF_WT);
	PO4_SOIL.SSInit(this);
	PO4_E_X.SSInit(this);
	PO4_E_X.SetLinkEdges();
	PO4_N_X.SSInit(this);
	PO4_N_X.SetLinkEdges();
	PO4_S_X.SSInit(this);
	PO4_S_X.SetLinkEdges();
	PO4_W_X.SSInit(this);
	PO4_W_X.SetLinkEdges();
	RIVER_P.SSInit(this);
	P1_IC_PO4.SSInit(this);
	P1_PO4_DIFFUSION_COEFF.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int PHOSPHATE_module::SetupEvents() {
	TExecuteCommand* u275 = (TExecuteCommand*) P1_RIVER_DATA_CF.GetCommand("u275",TCommand::kUpdate,TCommand::kCode);
	u275->SetExecutable(&P1_RIVER_DATA_CF_u275_exe_g);
	u275->Code() = "u275 <- 0.001000";
	u275->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u274 = (TExecuteCommand*) P1_PO4_SED_WT_CONC.GetCommand("u274",TCommand::kUpdate,TCommand::kCode);
	u274->SetExecutable(&P1_PO4_SED_WT_CONC_u274_exe_g);
	u274->Code() = "u274 <- 1";
	u274->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u268 = (TExecuteCommand*) PO4_SF_WT_CONC.GetCommand("u268",TCommand::kUpdate,TCommand::kCode);
	u268->SetExecutable(&PO4_SF_WT_CONC_u268_exe_g);
	u268->Code() = "u268 <-  ( ( ( SF_WATER <  ((float)1) ) ) ? ( ((float)0) ) : ( SL::Max(( ( RIVER_P*P1_RIVER_DATA_CF )+( PO4_SF_WT/SF_WATER ) ), ((float)0)) ) ) ";
	u268->AddDependency(SF_WATER);
	u268->AddDependency(RIVER_P);
	u268->AddDependency(P1_RIVER_DATA_CF);
	u268->AddDependency(PO4_SF_WT);
	u268->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WATER_import = (TImportCommand*) SF_WATER.GetCommand("SF_WATER_import",TCommand::kUndefined,TCommand::kImport);
	SF_WATER_import->Code() = "Import SF_WATER from GLOBAL_module";
	SF_WATER_import->AddDependency(SF_WATER);
	SF_WATER_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* WRACK_OM_DECOMP_import = (TImportCommand*) WRACK_OM_DECOMP.GetCommand("WRACK_OM_DECOMP_import",TCommand::kUndefined,TCommand::kImport);
	WRACK_OM_DECOMP_import->Code() = "Import WRACK_OM_DECOMP from DETRITUS_module";
	WRACK_OM_DECOMP_import->AddDependency(WRACK_OM_DECOMP);
	WRACK_OM_DECOMP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_WRACK_OM_PC_import = (TImportCommand*) P1_WRACK_OM_PC.GetCommand("P1_WRACK_OM_PC_import",TCommand::kUndefined,TCommand::kImport);
	P1_WRACK_OM_PC_import->Code() = "Import P1_WRACK_OM_PC from DETRITUS_module";
	P1_WRACK_OM_PC_import->AddDependency(P1_WRACK_OM_PC);
	P1_WRACK_OM_PC_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PHT_NET_PROD_import = (TImportCommand*) PHT_NET_PROD.GetCommand("PHT_NET_PROD_import",TCommand::kUndefined,TCommand::kImport);
	PHT_NET_PROD_import->Code() = "Import PHT_NET_PROD from PHYTOPLANKTON_module";
	PHT_NET_PROD_import->AddDependency(PHT_NET_PROD);
	PHT_NET_PROD_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_PHY_PC_import = (TImportCommand*) P1_PHY_PC.GetCommand("P1_PHY_PC_import",TCommand::kUndefined,TCommand::kImport);
	P1_PHY_PC_import->Code() = "Import P1_PHY_PC from PHYTOPLANKTON_module";
	P1_PHY_PC_import->AddDependency(P1_PHY_PC);
	P1_PHY_PC_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_MAC_PHBIO_PC_import = (TImportCommand*) P1_MAC_PHBIO_PC.GetCommand("P1_MAC_PHBIO_PC_import",TCommand::kUndefined,TCommand::kImport);
	P1_MAC_PHBIO_PC_import->Code() = "Import P1_MAC_PHBIO_PC from EELGRASS_module";
	P1_MAC_PHBIO_PC_import->AddDependency(P1_MAC_PHBIO_PC);
	P1_MAC_PHBIO_PC_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PHBIO_NET_PROD_import = (TImportCommand*) PHBIO_NET_PROD.GetCommand("PHBIO_NET_PROD_import",TCommand::kUndefined,TCommand::kImport);
	PHBIO_NET_PROD_import->Code() = "Import PHBIO_NET_PROD from EELGRASS_module";
	PHBIO_NET_PROD_import->AddDependency(PHBIO_NET_PROD);
	PHBIO_NET_PROD_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WT_E_X_import = (TImportCommand*) SF_WT_E_X.GetCommand("SF_WT_E_X_import",TCommand::kUndefined,TCommand::kImport);
	SF_WT_E_X_import->Code() = "Import SF_WT_E_X from GLOBAL_module";
	SF_WT_E_X_import->AddDependency(SF_WT_E_X);
	SF_WT_E_X_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WT_N_X_import = (TImportCommand*) SF_WT_N_X.GetCommand("SF_WT_N_X_import",TCommand::kUndefined,TCommand::kImport);
	SF_WT_N_X_import->Code() = "Import SF_WT_N_X from GLOBAL_module";
	SF_WT_N_X_import->AddDependency(SF_WT_N_X);
	SF_WT_N_X_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WT_S_X_import = (TImportCommand*) SF_WT_S_X.GetCommand("SF_WT_S_X_import",TCommand::kUndefined,TCommand::kImport);
	SF_WT_S_X_import->Code() = "Import SF_WT_S_X from GLOBAL_module";
	SF_WT_S_X_import->AddDependency(SF_WT_S_X);
	SF_WT_S_X_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WT_W_X_import = (TImportCommand*) SF_WT_W_X.GetCommand("SF_WT_W_X_import",TCommand::kUndefined,TCommand::kImport);
	SF_WT_W_X_import->Code() = "Import SF_WT_W_X from GLOBAL_module";
	SF_WT_W_X_import->AddDependency(SF_WT_W_X);
	SF_WT_W_X_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I257 = (TExecuteCommand*) PO4_SF_WT.GetCommand("I257",TCommand::kIntegrate,TCommand::kCode);
	I257->SetExecutable(&PO4_SF_WT_I257_exe_g);
	I257->Code() = "I257 <- ( ( ( ( PO4_SF_WT_MINER+PO4_SF_X_IN )-PO4_DNFLOW )-PO4_SF_WT_UPTAK )-PO4_X_OUT )";
	I257->AddDependency(PO4_SF_WT_MINER);
	I257->AddDependency(PO4_SF_X_IN);
	I257->AddDependency(PO4_DNFLOW);
	I257->AddDependency(PO4_SF_WT_UPTAK);
	I257->AddDependency(PO4_X_OUT);
	I257->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i258 = (TExecuteCommand*) PO4_SF_WT.GetCommand("i258",TCommand::kInit,TCommand::kCode);
	i258->SetExecutable(&PO4_SF_WT_i258_exe_g);
	i258->Code() = "i258 <- ( ( SF_WATER*P1_IC_PO4 )*.001 )";
	i258->AddDependency(SF_WATER);
	i258->AddDependency(P1_IC_PO4);
	i258->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u259 = (TExecuteCommand*) PO4_SF_WT_MINER.GetCommand("u259",TCommand::kUpdate,TCommand::kCode);
	u259->SetExecutable(&PO4_SF_WT_MINER_u259_exe_g);
	u259->Code() = "u259 <- ( WRACK_OM_DECOMP*P1_WRACK_OM_PC )";
	u259->AddDependency(WRACK_OM_DECOMP);
	u259->AddDependency(P1_WRACK_OM_PC);
	u259->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u260 = (TExecuteCommand*) PO4_SF_X_IN.GetCommand("u260",TCommand::kUpdate,TCommand::kCode);
	u260->SetExecutable(&PO4_SF_X_IN_u260_exe_g);
	u260->Code() = "u260 <- ( ( ( PO4_E_X@(0,-1,0)+PO4_N_X@(1,0,0) )+PO4_S_X@(-1,0,0) )+PO4_W_X@(0,1,0) )";
	u260->AddDependency(PO4_E_X,"0,-1,0");
	u260->AddDependency(PO4_N_X,"1,0,0");
	u260->AddDependency(PO4_S_X,"-1,0,0");
	u260->AddDependency(PO4_W_X,"0,1,0");
	u260->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u261 = (TExecuteCommand*) PO4_DNFLOW.GetCommand("u261",TCommand::kUpdate,TCommand::kCode);
	u261->SetExecutable(&PO4_DNFLOW_u261_exe_g);
	u261->Code() = "u261 <- ( SL::Max(( ( PO4_SF_WT_CONC-P1_PO4_SED_WT_CONC )*P1_PO4_DIFFUSION_COEFF ), ((float)0))+ ( ( ( SF_WATER == ((float)0) ) ) ? ( PO4_SF_WT ) : ( ((float)0) ) )  )";
	if( PO4_DNFLOW.GetF(FisClamped) ) { u261->AddDependency(PO4_SF_WT); }
	u261->AddDependency(PO4_SF_WT_CONC);
	u261->AddDependency(P1_PO4_SED_WT_CONC);
	u261->AddDependency(P1_PO4_DIFFUSION_COEFF);
	u261->AddDependency(SF_WATER);
	u261->AddDependency(PO4_SF_WT);
	u261->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u262 = (TExecuteCommand*) PO4_SF_WT_UPTAK.GetCommand("u262",TCommand::kUpdate,TCommand::kCode);
	u262->SetExecutable(&PO4_SF_WT_UPTAK_u262_exe_g);
	u262->Code() = "u262 <-  ( ( ( SF_WATER == ((float)0) ) ) ? ( ((float)0) ) : ( SL::Max(((float)0), ( ( ( PHT_NET_PROD*P1_PHY_PC )*1.0 )+( P1_MAC_PHBIO_PC*PHBIO_NET_PROD ) )) ) ) ";
	if( PO4_SF_WT_UPTAK.GetF(FisClamped) ) { u262->AddDependency(PO4_SF_WT); }
	u262->AddDependency(SF_WATER);
	u262->AddDependency(PHT_NET_PROD);
	u262->AddDependency(P1_PHY_PC);
	u262->AddDependency(P1_MAC_PHBIO_PC);
	u262->AddDependency(PHBIO_NET_PROD);
	u262->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u263 = (TExecuteCommand*) PO4_X_OUT.GetCommand("u263",TCommand::kUpdate,TCommand::kCode);
	u263->SetExecutable(&PO4_X_OUT_u263_exe_g);
	u263->Code() = "u263 <- ( ( ( PO4_E_X+PO4_N_X )+PO4_S_X )+PO4_W_X )";
	if( PO4_X_OUT.GetF(FisClamped) ) { u263->AddDependency(PO4_SF_WT); }
	u263->AddDependency(PO4_E_X);
	u263->AddDependency(PO4_N_X);
	u263->AddDependency(PO4_S_X);
	u263->AddDependency(PO4_W_X);
	u263->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I264 = (TExecuteCommand*) PO4_SOIL.GetCommand("I264",TCommand::kIntegrate,TCommand::kCode);
	I264->SetExecutable(&PO4_SOIL_I264_exe_g);
	I264->Code() = "I264 <- PO4_DNFLOW";
	I264->AddDependency(PO4_DNFLOW);
	I264->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i265 = (TExecuteCommand*) PO4_SOIL.GetCommand("i265",TCommand::kInit,TCommand::kCode);
	i265->SetExecutable(&PO4_SOIL_i265_exe_g);
	i265->Code() = "i265 <- ((float)0)";
	i265->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u266 = (TExecuteCommand*) PO4_E_X.GetCommand("u266",TCommand::kUpdate,TCommand::kCode);
	u266->SetExecutable(&PO4_E_X_u266_exe_g);
	u266->Code() = "u266 <- ( PO4_SF_WT_CONC*SF_WT_E_X )";
	u266->AddDependency(PO4_SF_WT_CONC);
	u266->AddDependency(SF_WT_E_X);
	u266->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u267 = (TExecuteCommand*) PO4_N_X.GetCommand("u267",TCommand::kUpdate,TCommand::kCode);
	u267->SetExecutable(&PO4_N_X_u267_exe_g);
	u267->Code() = "u267 <- ( PO4_SF_WT_CONC*SF_WT_N_X )";
	u267->AddDependency(PO4_SF_WT_CONC);
	u267->AddDependency(SF_WT_N_X);
	u267->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u269 = (TExecuteCommand*) PO4_S_X.GetCommand("u269",TCommand::kUpdate,TCommand::kCode);
	u269->SetExecutable(&PO4_S_X_u269_exe_g);
	u269->Code() = "u269 <- ( PO4_SF_WT_CONC*SF_WT_S_X )";
	u269->AddDependency(PO4_SF_WT_CONC);
	u269->AddDependency(SF_WT_S_X);
	u269->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u270 = (TExecuteCommand*) PO4_W_X.GetCommand("u270",TCommand::kUpdate,TCommand::kCode);
	u270->SetExecutable(&PO4_W_X_u270_exe_g);
	u270->Code() = "u270 <- ( PO4_SF_WT_CONC*SF_WT_W_X )";
	u270->AddDependency(PO4_SF_WT_CONC);
	u270->AddDependency(SF_WT_W_X);
	u270->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u271 = (TExecuteCommand*) RIVER_P.GetCommand("u271",TCommand::kUpdate,TCommand::kCode);
	u271->SetExecutable(&RIVER_P_u271_exe_g);
	u271->Code() = "u271 <- 0";
	u271->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u272 = (TExecuteCommand*) P1_IC_PO4.GetCommand("u272",TCommand::kUpdate,TCommand::kCode);
	u272->SetExecutable(&P1_IC_PO4_u272_exe_g);
	u272->Code() = "u272 <- 0.002000";
	u272->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u273 = (TExecuteCommand*) P1_PO4_DIFFUSION_COEFF.GetCommand("u273",TCommand::kUpdate,TCommand::kCode);
	u273->SetExecutable(&P1_PO4_DIFFUSION_COEFF_u273_exe_g);
	u273->Code() = "u273 <- 1";
	u273->SetObjInfo(TCommand::kDepIndex, 5);
	return 0;
}

int PHOSPHATE_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int PHOSPHATE_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int PHOSPHATE_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int PHOSPHATE_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class PHYTOPLANKTON_module 
// ---------------------------------------------------------------------------
PHYTOPLANKTON_module::PHYTOPLANKTON_module(char* name) :
	TIME("TIME"),
	PHYTOPLANKTON("PHYTOPLANKTON"),
	PHT_NET_PROD("PHT_NET_PROD"),
	P1_PHT_NC("P1_PHT_NC"),
	PHT_CONC("PHT_CONC"),
	P1_PHY_PC("P1_PHY_PC"),
	WATER_DEPTH("WATER_DEPTH"),
	P1_CELL_SIZE("P1_CELL_SIZE"),
	SF_WATER("SF_WATER"),
	CONS_INGEST_PHT("CONS_INGEST_PHT"),
	P1_RIVER_DATA_CF("P1_RIVER_DATA_CF"),
	DIN_CONC("DIN_CONC"),
	PO4_SF_WT_CONC("PO4_SF_WT_CONC"),
	PHT_LIGHT_LIM("PHT_LIGHT_LIM"),
	H2O_TEMP("H2O_TEMP"),
	SF_WT_E_X("SF_WT_E_X"),
	SF_WT_N_X("SF_WT_N_X"),
	SF_WT_S_X("SF_WT_S_X"),
	SF_WT_W_X("SF_WT_W_X"),
	PHT_GROSS_PP("PHT_GROSS_PP"),
	PHT_X_IN("PHT_X_IN"),
	PHT_X_OUT("PHT_X_OUT"),
	PHT_RESP("PHT_RESP"),
	PHT_CONSUMED("PHT_CONSUMED"),
	PHT_MORTALITY("PHT_MORTALITY"),
	PHT_DOWNFLOW("PHT_DOWNFLOW"),
	PHT_NUT_LIMIT("PHT_NUT_LIMIT"),
	PHT_PROD_LIM("PHT_PROD_LIM"),
	PHT_TEMP_LIM("PHT_TEMP_LIM"),
	PHT_X_E("PHT_X_E"),
	PHT_X_N("PHT_X_N"),
	PHT_X_S("PHT_X_S"),
	PHT_X_W("PHT_X_W"),
	RIVER_PHT("RIVER_PHT"),
	P1_IC_PHT("P1_IC_PHT"),
	P1_PHT_GROSS_PP_RT("P1_PHT_GROSS_PP_RT"),
	P1_PHT_MORTALITY_RT("P1_PHT_MORTALITY_RT"),
	P1_PHT_N_SAT("P1_PHT_N_SAT"),
	P1_PHT_P_SAT("P1_PHT_P_SAT"),
	P1_PHT_RESP_RT("P1_PHT_RESP_RT"),
	P1_PHT_TEMP_COEFF("P1_PHT_TEMP_COEFF"),
	TModule(name) {

	PHYTOPLANKTON.SetF(FisExport,True,"CG");
	PHT_NET_PROD.SetF(FisExport,True,"CG");
	P1_PHT_NC.SetF(FisExport,True,"CG");
	PHT_CONC.SetF(FisExport,True,"CG");
	P1_PHY_PC.SetF(FisExport,True,"CG");
	WATER_DEPTH.SetF(FisImport,True,"CG");
	P1_CELL_SIZE.SetF(FisImport,True,"CG");
	SF_WATER.SetF(FisImport,True,"CG");
	CONS_INGEST_PHT.SetF(FisImport,True,"CG");
	P1_RIVER_DATA_CF.SetF(FisImport,True,"CG");
	DIN_CONC.SetF(FisImport,True,"CG");
	PO4_SF_WT_CONC.SetF(FisImport,True,"CG");
	PHT_LIGHT_LIM.SetF(FisImport,True,"CG");
	H2O_TEMP.SetF(FisImport,True,"CG");
	SF_WT_E_X.SetF(FisImport,True,"CG");
	SF_WT_N_X.SetF(FisImport,True,"CG");
	SF_WT_S_X.SetF(FisImport,True,"CG");
	SF_WT_W_X.SetF(FisImport,True,"CG");
}	
int PHYTOPLANKTON_module::PHYTOPLANKTON_I276_exe() {
	float value;

	PHYTOPLANKTON.UpdateIntegrator();
	switch( PHYTOPLANKTON.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHYTOPLANKTON.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( ( PHT_GROSS_PP.Value(p)+PHT_X_IN.Value(p) )-PHT_X_OUT.Value(p) )-PHT_RESP.Value(p) )-PHT_CONSUMED.Value(p) )-PHT_MORTALITY.Value(p) )-PHT_DOWNFLOW.Value(p) );
			PHYTOPLANKTON.Update( p, value, dT() );
		}
		PHYTOPLANKTON.GrabMemory();
		if( PHYTOPLANKTON.GetF(FLinkEdges) ) { PHYTOPLANKTON.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( ( PHT_GROSS_PP.Value()+PHT_X_IN.Value() )-PHT_X_OUT.Value() )-PHT_RESP.Value() )-PHT_CONSUMED.Value() )-PHT_MORTALITY.Value() )-PHT_DOWNFLOW.Value() );
			PHYTOPLANKTON.Update( value, dT() );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::PHYTOPLANKTON_i277_exe() {
	float value;

	PHYTOPLANKTON.UpdateIntegrator();
	switch( PHYTOPLANKTON.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHYTOPLANKTON.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( WATER_DEPTH.Value(p)*P1_CELL_SIZE.Value(p) )*P1_IC_PHT.Value(p) )*.001 );
			PHYTOPLANKTON.InitValue( p, value );
		}
		PHYTOPLANKTON.GrabMemory();
		if( PHYTOPLANKTON.GetF(FLinkEdges) ) { PHYTOPLANKTON.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( WATER_DEPTH.Value()*P1_CELL_SIZE.Value() )*P1_IC_PHT.Value() )*.001 );
			PHYTOPLANKTON.InitValue( value );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::PHT_GROSS_PP_u278_exe() {
	float value;

	switch( PHT_GROSS_PP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_GROSS_PP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SF_WATER.Value(p) == ((float)0) ) ) ? ( ((float)0) ) : ( ( ( ( PHT_PROD_LIM.Value(p)*P1_PHT_GROSS_PP_RT.Value(p) )*dT() )*pow((double)PHYTOPLANKTON.Value(p),(double)((float)1) ) ) ) ) ;
			PHT_GROSS_PP.Update( p, value );
		}
		PHT_GROSS_PP.GrabMemory();
		if( PHT_GROSS_PP.GetF(FICFlux) ) PHT_GROSS_PP.Cov().Set(0.0); 
		if( PHT_GROSS_PP.GetF(FLinkEdges) ) { PHT_GROSS_PP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SF_WATER.Value() == ((float)0) ) ) ? ( ((float)0) ) : ( ( ( ( PHT_PROD_LIM.Value()*P1_PHT_GROSS_PP_RT.Value() )*dT() )*pow((double)PHYTOPLANKTON.Value(),(double)((float)1) ) ) ) ) ;
			PHT_GROSS_PP.Update( value );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::PHT_X_IN_u279_exe() {
	float value;

	switch( PHT_X_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_X_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( PHT_X_W.RelValue(p,0,1,0,CVariable::kDefaultBC)+PHT_X_N.RelValue(p,1,0,0,CVariable::kDefaultBC) )+PHT_X_E.RelValue(p,0,-1,0,CVariable::kDefaultBC) )+PHT_X_S.RelValue(p,-1,0,0,CVariable::kDefaultBC) );
			PHT_X_IN.Update( p, value );
		}
		PHT_X_IN.GrabMemory();
		if( PHT_X_IN.GetF(FICFlux) ) PHT_X_IN.Cov().Set(0.0); 
		if( PHT_X_IN.GetF(FLinkEdges) ) { PHT_X_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( PHT_X_W.Value()+PHT_X_N.Value() )+PHT_X_E.Value() )+PHT_X_S.Value() );
			PHT_X_IN.Update( value );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::PHT_X_OUT_u280_exe() {
	float value;

	switch( PHT_X_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_X_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( PHT_X_E.Value(p)+PHT_X_N.Value(p) )+PHT_X_S.Value(p) )+PHT_X_W.Value(p) );
			PHT_X_OUT.Update( p, value );
		}
		PHT_X_OUT.GrabMemory();
		if( PHT_X_OUT.GetF(FICFlux) ) PHT_X_OUT.Cov().Set(0.0); 
		if( PHT_X_OUT.GetF(FLinkEdges) ) { PHT_X_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( PHT_X_E.Value()+PHT_X_N.Value() )+PHT_X_S.Value() )+PHT_X_W.Value() );
			PHT_X_OUT.Update( value );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::PHT_RESP_u281_exe() {
	float value;

	switch( PHT_RESP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_RESP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SF_WATER.Value(p) >  ((float)0) ) ) ? ( ( ( ( P1_PHT_RESP_RT.Value(p)*PHT_TEMP_LIM.Value(p) )*PHYTOPLANKTON.Value(p) )*dT() ) ) : ( ((float)0) ) ) ;
			PHT_RESP.Update( p, value );
		}
		PHT_RESP.GrabMemory();
		if( PHT_RESP.GetF(FICFlux) ) PHT_RESP.Cov().Set(0.0); 
		if( PHT_RESP.GetF(FLinkEdges) ) { PHT_RESP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SF_WATER.Value() >  ((float)0) ) ) ? ( ( ( ( P1_PHT_RESP_RT.Value()*PHT_TEMP_LIM.Value() )*PHYTOPLANKTON.Value() )*dT() ) ) : ( ((float)0) ) ) ;
			PHT_RESP.Update( value );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::PHT_CONSUMED_u282_exe() {
	float value;

	switch( PHT_CONSUMED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_CONSUMED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  CONS_INGEST_PHT.Value(p);
			PHT_CONSUMED.Update( p, value );
		}
		PHT_CONSUMED.GrabMemory();
		if( PHT_CONSUMED.GetF(FICFlux) ) PHT_CONSUMED.Cov().Set(0.0); 
		if( PHT_CONSUMED.GetF(FLinkEdges) ) { PHT_CONSUMED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  CONS_INGEST_PHT.Value();
			PHT_CONSUMED.Update( value );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::PHT_MORTALITY_u283_exe() {
	float value;

	switch( PHT_MORTALITY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_MORTALITY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PHYTOPLANKTON.Value(p)*( P1_PHT_MORTALITY_RT.Value(p)*dT() ) );
			PHT_MORTALITY.Update( p, value );
		}
		PHT_MORTALITY.GrabMemory();
		if( PHT_MORTALITY.GetF(FICFlux) ) PHT_MORTALITY.Cov().Set(0.0); 
		if( PHT_MORTALITY.GetF(FLinkEdges) ) { PHT_MORTALITY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PHYTOPLANKTON.Value()*( P1_PHT_MORTALITY_RT.Value()*dT() ) );
			PHT_MORTALITY.Update( value );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::PHT_DOWNFLOW_u284_exe() {
	float value;

	switch( PHT_DOWNFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_DOWNFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SF_WATER.Value(p) == ((float)0) ) ) ? ( PHYTOPLANKTON.Value(p) ) : ( ((float)0) ) ) ;
			PHT_DOWNFLOW.Update( p, value );
		}
		PHT_DOWNFLOW.GrabMemory();
		if( PHT_DOWNFLOW.GetF(FICFlux) ) PHT_DOWNFLOW.Cov().Set(0.0); 
		if( PHT_DOWNFLOW.GetF(FLinkEdges) ) { PHT_DOWNFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SF_WATER.Value() == ((float)0) ) ) ? ( PHYTOPLANKTON.Value() ) : ( ((float)0) ) ) ;
			PHT_DOWNFLOW.Update( value );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::PHT_CONC_u285_exe() {
	float value;

	switch( PHT_CONC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_CONC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SF_WATER.Value(p) <= ((float)0) ) ) ? ( ((float)0) ) : ( SL::Max(( ( RIVER_PHT.Value(p)*P1_RIVER_DATA_CF.Value(p) )+( PHYTOPLANKTON.Value(p)/SF_WATER.Value(p) ) ), ((float)0)) ) ) ;
			PHT_CONC.Update( p, value );
		}
		PHT_CONC.GrabMemory();
		if( PHT_CONC.GetF(FLinkEdges) ) { PHT_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SF_WATER.Value() <= ((float)0) ) ) ? ( ((float)0) ) : ( SL::Max(( ( RIVER_PHT.Value()*P1_RIVER_DATA_CF.Value() )+( PHYTOPLANKTON.Value()/SF_WATER.Value() ) ), ((float)0)) ) ) ;
			PHT_CONC.Update( value );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::PHT_NET_PROD_u286_exe() {
	float value;

	switch( PHT_NET_PROD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_NET_PROD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PHT_GROSS_PP.Value(p)-PHT_RESP.Value(p) );
			PHT_NET_PROD.Update( p, value );
		}
		PHT_NET_PROD.GrabMemory();
		if( PHT_NET_PROD.GetF(FLinkEdges) ) { PHT_NET_PROD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PHT_GROSS_PP.Value()-PHT_RESP.Value() );
			PHT_NET_PROD.Update( value );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::PHT_NUT_LIMIT_u287_exe() {
	float value;

	switch( PHT_NUT_LIMIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_NUT_LIMIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(( DIN_CONC.Value(p)/( DIN_CONC.Value(p)+P1_PHT_N_SAT.Value(p) ) ), ( PO4_SF_WT_CONC.Value(p)/( PO4_SF_WT_CONC.Value(p)+P1_PHT_P_SAT.Value(p) ) ));
			PHT_NUT_LIMIT.Update( p, value );
		}
		PHT_NUT_LIMIT.GrabMemory();
		if( PHT_NUT_LIMIT.GetF(FLinkEdges) ) { PHT_NUT_LIMIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(( DIN_CONC.Value()/( DIN_CONC.Value()+P1_PHT_N_SAT.Value() ) ), ( PO4_SF_WT_CONC.Value()/( PO4_SF_WT_CONC.Value()+P1_PHT_P_SAT.Value() ) ));
			PHT_NUT_LIMIT.Update( value );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::PHT_PROD_LIM_u288_exe() {
	float value;

	switch( PHT_PROD_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_PROD_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SF_WATER.Value(p) >  ((float)0) ) ) ? ( ( ( PHT_LIGHT_LIM.Value(p)*PHT_NUT_LIMIT.Value(p) )*PHT_TEMP_LIM.Value(p) ) ) : ( ((float)0) ) ) ;
			PHT_PROD_LIM.Update( p, value );
		}
		PHT_PROD_LIM.GrabMemory();
		if( PHT_PROD_LIM.GetF(FLinkEdges) ) { PHT_PROD_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SF_WATER.Value() >  ((float)0) ) ) ? ( ( ( PHT_LIGHT_LIM.Value()*PHT_NUT_LIMIT.Value() )*PHT_TEMP_LIM.Value() ) ) : ( ((float)0) ) ) ;
			PHT_PROD_LIM.Update( value );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::PHT_TEMP_LIM_u289_exe() {
	float value;

	switch( PHT_TEMP_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_TEMP_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( H2O_TEMP.Value(p)*P1_PHT_TEMP_COEFF.Value(p) )/40 );
			PHT_TEMP_LIM.Update( p, value );
		}
		PHT_TEMP_LIM.GrabMemory();
		if( PHT_TEMP_LIM.GetF(FLinkEdges) ) { PHT_TEMP_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( H2O_TEMP.Value()*P1_PHT_TEMP_COEFF.Value() )/40 );
			PHT_TEMP_LIM.Update( value );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::PHT_X_E_u290_exe() {
	float value;

	switch( PHT_X_E.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_X_E.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PHT_CONC.Value(p)*SF_WT_E_X.Value(p) );
			PHT_X_E.Update( p, value );
		}
		PHT_X_E.GrabMemory();
		if( PHT_X_E.GetF(FLinkEdges) ) { PHT_X_E.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PHT_CONC.Value()*SF_WT_E_X.Value() );
			PHT_X_E.Update( value );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::PHT_X_N_u291_exe() {
	float value;

	switch( PHT_X_N.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_X_N.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PHT_CONC.Value(p)*SF_WT_N_X.Value(p) );
			PHT_X_N.Update( p, value );
		}
		PHT_X_N.GrabMemory();
		if( PHT_X_N.GetF(FLinkEdges) ) { PHT_X_N.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PHT_CONC.Value()*SF_WT_N_X.Value() );
			PHT_X_N.Update( value );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::PHT_X_S_u292_exe() {
	float value;

	switch( PHT_X_S.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_X_S.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PHT_CONC.Value(p)*SF_WT_S_X.Value(p) );
			PHT_X_S.Update( p, value );
		}
		PHT_X_S.GrabMemory();
		if( PHT_X_S.GetF(FLinkEdges) ) { PHT_X_S.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PHT_CONC.Value()*SF_WT_S_X.Value() );
			PHT_X_S.Update( value );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::PHT_X_W_u293_exe() {
	float value;

	switch( PHT_X_W.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = PHT_X_W.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( PHT_CONC.Value(p)*SF_WT_W_X.Value(p) );
			PHT_X_W.Update( p, value );
		}
		PHT_X_W.GrabMemory();
		if( PHT_X_W.GetF(FLinkEdges) ) { PHT_X_W.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( PHT_CONC.Value()*SF_WT_W_X.Value() );
			PHT_X_W.Update( value );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::RIVER_PHT_u294_exe() {
	float value;

	switch( RIVER_PHT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = RIVER_PHT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0;
			RIVER_PHT.Update( p, RIVER_PHT.ParameterValue(value,p) );
		}
		RIVER_PHT.GrabMemory();
		if( RIVER_PHT.GetF(FLinkEdges) ) { RIVER_PHT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0;
			RIVER_PHT.Update( RIVER_PHT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::P1_IC_PHT_u295_exe() {
	float value;

	switch( P1_IC_PHT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_IC_PHT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  1;
			P1_IC_PHT.Update( p, P1_IC_PHT.ParameterValue(value,p) );
		}
		P1_IC_PHT.GrabMemory();
		if( P1_IC_PHT.GetF(FLinkEdges) ) { P1_IC_PHT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  1;
			P1_IC_PHT.Update( P1_IC_PHT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::P1_PHT_GROSS_PP_RT_u296_exe() {
	float value;

	switch( P1_PHT_GROSS_PP_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHT_GROSS_PP_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.008300;
			P1_PHT_GROSS_PP_RT.Update( p, P1_PHT_GROSS_PP_RT.ParameterValue(value,p) );
		}
		P1_PHT_GROSS_PP_RT.GrabMemory();
		if( P1_PHT_GROSS_PP_RT.GetF(FLinkEdges) ) { P1_PHT_GROSS_PP_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.008300;
			P1_PHT_GROSS_PP_RT.Update( P1_PHT_GROSS_PP_RT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::P1_PHT_MORTALITY_RT_u297_exe() {
	float value;

	switch( P1_PHT_MORTALITY_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHT_MORTALITY_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  2e-4;
			P1_PHT_MORTALITY_RT.Update( p, P1_PHT_MORTALITY_RT.ParameterValue(value,p) );
		}
		P1_PHT_MORTALITY_RT.GrabMemory();
		if( P1_PHT_MORTALITY_RT.GetF(FLinkEdges) ) { P1_PHT_MORTALITY_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  2e-4;
			P1_PHT_MORTALITY_RT.Update( P1_PHT_MORTALITY_RT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::P1_PHT_NC_u298_exe() {
	float value;

	switch( P1_PHT_NC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHT_NC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.010000;
			P1_PHT_NC.Update( p, P1_PHT_NC.ParameterValue(value,p) );
		}
		P1_PHT_NC.GrabMemory();
		if( P1_PHT_NC.GetF(FLinkEdges) ) { P1_PHT_NC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.010000;
			P1_PHT_NC.Update( P1_PHT_NC.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::P1_PHT_N_SAT_u299_exe() {
	float value;

	switch( P1_PHT_N_SAT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHT_N_SAT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000025;
			P1_PHT_N_SAT.Update( p, P1_PHT_N_SAT.ParameterValue(value,p) );
		}
		P1_PHT_N_SAT.GrabMemory();
		if( P1_PHT_N_SAT.GetF(FLinkEdges) ) { P1_PHT_N_SAT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000025;
			P1_PHT_N_SAT.Update( P1_PHT_N_SAT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::P1_PHT_P_SAT_u300_exe() {
	float value;

	switch( P1_PHT_P_SAT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHT_P_SAT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000002;
			P1_PHT_P_SAT.Update( p, P1_PHT_P_SAT.ParameterValue(value,p) );
		}
		P1_PHT_P_SAT.GrabMemory();
		if( P1_PHT_P_SAT.GetF(FLinkEdges) ) { P1_PHT_P_SAT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000002;
			P1_PHT_P_SAT.Update( P1_PHT_P_SAT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::P1_PHT_RESP_RT_u301_exe() {
	float value;

	switch( P1_PHT_RESP_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHT_RESP_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000140;
			P1_PHT_RESP_RT.Update( p, P1_PHT_RESP_RT.ParameterValue(value,p) );
		}
		P1_PHT_RESP_RT.GrabMemory();
		if( P1_PHT_RESP_RT.GetF(FLinkEdges) ) { P1_PHT_RESP_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000140;
			P1_PHT_RESP_RT.Update( P1_PHT_RESP_RT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::P1_PHT_TEMP_COEFF_u302_exe() {
	float value;

	switch( P1_PHT_TEMP_COEFF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHT_TEMP_COEFF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.069000;
			P1_PHT_TEMP_COEFF.Update( p, P1_PHT_TEMP_COEFF.ParameterValue(value,p) );
		}
		P1_PHT_TEMP_COEFF.GrabMemory();
		if( P1_PHT_TEMP_COEFF.GetF(FLinkEdges) ) { P1_PHT_TEMP_COEFF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.069000;
			P1_PHT_TEMP_COEFF.Update( P1_PHT_TEMP_COEFF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int PHYTOPLANKTON_module::P1_PHY_PC_u303_exe() {
	float value;

	switch( P1_PHY_PC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_PHY_PC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.005000;
			P1_PHY_PC.Update( p, P1_PHY_PC.ParameterValue(value,p) );
		}
		P1_PHY_PC.GrabMemory();
		if( P1_PHY_PC.GetF(FLinkEdges) ) { P1_PHY_PC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.005000;
			P1_PHY_PC.Update( P1_PHY_PC.ParameterValue(value) );
	  } break;
	}
	return 0;
}

PHYTOPLANKTON_module* PHYTOPLANKTON_module::fInstance = NULL;
PHYTOPLANKTON_module* PHYTOPLANKTON_module::kNullModel = (PHYTOPLANKTON_module*)0x1;
int PHYTOPLANKTON_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int PHYTOPLANKTON_module::InitVars() {
	
	TIME.SSInit(this);
	PHYTOPLANKTON.SSInit(this);
	PHT_NET_PROD.SSInit(this);
	P1_PHT_NC.SSInit(this);
	PHT_CONC.SSInit(this);
	P1_PHY_PC.SSInit(this);
	WATER_DEPTH.SSInit(this);
	P1_CELL_SIZE.SSInit(this);
	SF_WATER.SSInit(this);
	CONS_INGEST_PHT.SSInit(this);
	P1_RIVER_DATA_CF.SSInit(this);
	DIN_CONC.SSInit(this);
	PO4_SF_WT_CONC.SSInit(this);
	PHT_LIGHT_LIM.SSInit(this);
	H2O_TEMP.SSInit(this);
	SF_WT_E_X.SSInit(this);
	SF_WT_N_X.SSInit(this);
	SF_WT_S_X.SSInit(this);
	SF_WT_W_X.SSInit(this);
	PHT_GROSS_PP.SSInit(this);
	PHT_GROSS_PP.SetDestination(&PHYTOPLANKTON);
	PHT_X_IN.SSInit(this);
	PHT_X_IN.SetDestination(&PHYTOPLANKTON);
	PHT_X_OUT.SSInit(this);
	PHT_X_OUT.SetOrigin(&PHYTOPLANKTON);
	PHT_RESP.SSInit(this);
	PHT_RESP.SetOrigin(&PHYTOPLANKTON);
	PHT_CONSUMED.SSInit(this);
	PHT_CONSUMED.SetOrigin(&PHYTOPLANKTON);
	PHT_MORTALITY.SSInit(this);
	PHT_MORTALITY.SetOrigin(&PHYTOPLANKTON);
	PHT_DOWNFLOW.SSInit(this);
	PHT_DOWNFLOW.SetOrigin(&PHYTOPLANKTON);
	PHT_NUT_LIMIT.SSInit(this);
	PHT_PROD_LIM.SSInit(this);
	PHT_TEMP_LIM.SSInit(this);
	PHT_X_E.SSInit(this);
	PHT_X_E.SetLinkEdges();
	PHT_X_N.SSInit(this);
	PHT_X_N.SetLinkEdges();
	PHT_X_S.SSInit(this);
	PHT_X_S.SetLinkEdges();
	PHT_X_W.SSInit(this);
	PHT_X_W.SetLinkEdges();
	RIVER_PHT.SSInit(this);
	P1_IC_PHT.SSInit(this);
	P1_PHT_GROSS_PP_RT.SSInit(this);
	P1_PHT_MORTALITY_RT.SSInit(this);
	P1_PHT_N_SAT.SSInit(this);
	P1_PHT_P_SAT.SSInit(this);
	P1_PHT_RESP_RT.SSInit(this);
	P1_PHT_TEMP_COEFF.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int PHYTOPLANKTON_module::SetupEvents() {
	TExecuteCommand* I276 = (TExecuteCommand*) PHYTOPLANKTON.GetCommand("I276",TCommand::kIntegrate,TCommand::kCode);
	I276->SetExecutable(&PHYTOPLANKTON_I276_exe_g);
	I276->Code() = "I276 <- ( ( ( ( ( ( PHT_GROSS_PP+PHT_X_IN )-PHT_X_OUT )-PHT_RESP )-PHT_CONSUMED )-PHT_MORTALITY )-PHT_DOWNFLOW )";
	I276->AddDependency(PHT_GROSS_PP);
	I276->AddDependency(PHT_X_IN);
	I276->AddDependency(PHT_X_OUT);
	I276->AddDependency(PHT_RESP);
	I276->AddDependency(PHT_CONSUMED);
	I276->AddDependency(PHT_MORTALITY);
	I276->AddDependency(PHT_DOWNFLOW);
	I276->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i277 = (TExecuteCommand*) PHYTOPLANKTON.GetCommand("i277",TCommand::kInit,TCommand::kCode);
	i277->SetExecutable(&PHYTOPLANKTON_i277_exe_g);
	i277->Code() = "i277 <- ( ( ( WATER_DEPTH*P1_CELL_SIZE )*P1_IC_PHT )*.001 )";
	i277->AddDependency(WATER_DEPTH);
	i277->AddDependency(P1_CELL_SIZE);
	i277->AddDependency(P1_IC_PHT);
	i277->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u286 = (TExecuteCommand*) PHT_NET_PROD.GetCommand("u286",TCommand::kUpdate,TCommand::kCode);
	u286->SetExecutable(&PHT_NET_PROD_u286_exe_g);
	u286->Code() = "u286 <- ( PHT_GROSS_PP-PHT_RESP )";
	u286->AddDependency(PHT_GROSS_PP);
	u286->AddDependency(PHT_RESP);
	u286->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u298 = (TExecuteCommand*) P1_PHT_NC.GetCommand("u298",TCommand::kUpdate,TCommand::kCode);
	u298->SetExecutable(&P1_PHT_NC_u298_exe_g);
	u298->Code() = "u298 <- 0.010000";
	u298->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u285 = (TExecuteCommand*) PHT_CONC.GetCommand("u285",TCommand::kUpdate,TCommand::kCode);
	u285->SetExecutable(&PHT_CONC_u285_exe_g);
	u285->Code() = "u285 <-  ( ( ( SF_WATER <= ((float)0) ) ) ? ( ((float)0) ) : ( SL::Max(( ( RIVER_PHT*P1_RIVER_DATA_CF )+( PHYTOPLANKTON/SF_WATER ) ), ((float)0)) ) ) ";
	u285->AddDependency(SF_WATER);
	u285->AddDependency(RIVER_PHT);
	u285->AddDependency(P1_RIVER_DATA_CF);
	u285->AddDependency(PHYTOPLANKTON);
	u285->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u303 = (TExecuteCommand*) P1_PHY_PC.GetCommand("u303",TCommand::kUpdate,TCommand::kCode);
	u303->SetExecutable(&P1_PHY_PC_u303_exe_g);
	u303->Code() = "u303 <- 0.005000";
	u303->SetObjInfo(TCommand::kDepIndex, 5);
	TImportCommand* WATER_DEPTH_import = (TImportCommand*) WATER_DEPTH.GetCommand("WATER_DEPTH_import",TCommand::kUndefined,TCommand::kImport);
	WATER_DEPTH_import->Code() = "Import WATER_DEPTH from GLOBAL_module";
	WATER_DEPTH_import->AddDependency(WATER_DEPTH);
	WATER_DEPTH_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_CELL_SIZE_import = (TImportCommand*) P1_CELL_SIZE.GetCommand("P1_CELL_SIZE_import",TCommand::kUndefined,TCommand::kImport);
	P1_CELL_SIZE_import->Code() = "Import P1_CELL_SIZE from GLOBAL_module";
	P1_CELL_SIZE_import->AddDependency(P1_CELL_SIZE);
	P1_CELL_SIZE_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WATER_import = (TImportCommand*) SF_WATER.GetCommand("SF_WATER_import",TCommand::kUndefined,TCommand::kImport);
	SF_WATER_import->Code() = "Import SF_WATER from GLOBAL_module";
	SF_WATER_import->AddDependency(SF_WATER);
	SF_WATER_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* CONS_INGEST_PHT_import = (TImportCommand*) CONS_INGEST_PHT.GetCommand("CONS_INGEST_PHT_import",TCommand::kUndefined,TCommand::kImport);
	CONS_INGEST_PHT_import->Code() = "Import CONS_INGEST_PHT from CONSUMERS_module";
	CONS_INGEST_PHT_import->AddDependency(CONS_INGEST_PHT);
	CONS_INGEST_PHT_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_RIVER_DATA_CF_import = (TImportCommand*) P1_RIVER_DATA_CF.GetCommand("P1_RIVER_DATA_CF_import",TCommand::kUndefined,TCommand::kImport);
	P1_RIVER_DATA_CF_import->Code() = "Import P1_RIVER_DATA_CF from PHOSPHATE_module";
	P1_RIVER_DATA_CF_import->AddDependency(P1_RIVER_DATA_CF);
	P1_RIVER_DATA_CF_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DIN_CONC_import = (TImportCommand*) DIN_CONC.GetCommand("DIN_CONC_import",TCommand::kUndefined,TCommand::kImport);
	DIN_CONC_import->Code() = "Import DIN_CONC from DIN_module";
	DIN_CONC_import->AddDependency(DIN_CONC);
	DIN_CONC_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PO4_SF_WT_CONC_import = (TImportCommand*) PO4_SF_WT_CONC.GetCommand("PO4_SF_WT_CONC_import",TCommand::kUndefined,TCommand::kImport);
	PO4_SF_WT_CONC_import->Code() = "Import PO4_SF_WT_CONC from PHOSPHATE_module";
	PO4_SF_WT_CONC_import->AddDependency(PO4_SF_WT_CONC);
	PO4_SF_WT_CONC_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PHT_LIGHT_LIM_import = (TImportCommand*) PHT_LIGHT_LIM.GetCommand("PHT_LIGHT_LIM_import",TCommand::kUndefined,TCommand::kImport);
	PHT_LIGHT_LIM_import->Code() = "Import PHT_LIGHT_LIM from GLOBAL_module";
	PHT_LIGHT_LIM_import->AddDependency(PHT_LIGHT_LIM);
	PHT_LIGHT_LIM_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* H2O_TEMP_import = (TImportCommand*) H2O_TEMP.GetCommand("H2O_TEMP_import",TCommand::kUndefined,TCommand::kImport);
	H2O_TEMP_import->Code() = "Import H2O_TEMP from GLOBAL_module";
	H2O_TEMP_import->AddDependency(H2O_TEMP);
	H2O_TEMP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WT_E_X_import = (TImportCommand*) SF_WT_E_X.GetCommand("SF_WT_E_X_import",TCommand::kUndefined,TCommand::kImport);
	SF_WT_E_X_import->Code() = "Import SF_WT_E_X from GLOBAL_module";
	SF_WT_E_X_import->AddDependency(SF_WT_E_X);
	SF_WT_E_X_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WT_N_X_import = (TImportCommand*) SF_WT_N_X.GetCommand("SF_WT_N_X_import",TCommand::kUndefined,TCommand::kImport);
	SF_WT_N_X_import->Code() = "Import SF_WT_N_X from GLOBAL_module";
	SF_WT_N_X_import->AddDependency(SF_WT_N_X);
	SF_WT_N_X_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WT_S_X_import = (TImportCommand*) SF_WT_S_X.GetCommand("SF_WT_S_X_import",TCommand::kUndefined,TCommand::kImport);
	SF_WT_S_X_import->Code() = "Import SF_WT_S_X from GLOBAL_module";
	SF_WT_S_X_import->AddDependency(SF_WT_S_X);
	SF_WT_S_X_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WT_W_X_import = (TImportCommand*) SF_WT_W_X.GetCommand("SF_WT_W_X_import",TCommand::kUndefined,TCommand::kImport);
	SF_WT_W_X_import->Code() = "Import SF_WT_W_X from GLOBAL_module";
	SF_WT_W_X_import->AddDependency(SF_WT_W_X);
	SF_WT_W_X_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u278 = (TExecuteCommand*) PHT_GROSS_PP.GetCommand("u278",TCommand::kUpdate,TCommand::kCode);
	u278->SetExecutable(&PHT_GROSS_PP_u278_exe_g);
	u278->Code() = "u278 <-  ( ( ( SF_WATER == ((float)0) ) ) ? ( ((float)0) ) : ( ( ( ( PHT_PROD_LIM*P1_PHT_GROSS_PP_RT )*dT() )*pow((double)PHYTOPLANKTON,(double)((float)1) ) ) ) ) ";
	u278->AddDependency(SF_WATER);
	u278->AddDependency(PHT_PROD_LIM);
	u278->AddDependency(P1_PHT_GROSS_PP_RT);
	u278->AddDependency(PHYTOPLANKTON);
	u278->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u279 = (TExecuteCommand*) PHT_X_IN.GetCommand("u279",TCommand::kUpdate,TCommand::kCode);
	u279->SetExecutable(&PHT_X_IN_u279_exe_g);
	u279->Code() = "u279 <- ( ( ( PHT_X_W@(0,1,0)+PHT_X_N@(1,0,0) )+PHT_X_E@(0,-1,0) )+PHT_X_S@(-1,0,0) )";
	u279->AddDependency(PHT_X_W,"0,1,0");
	u279->AddDependency(PHT_X_N,"1,0,0");
	u279->AddDependency(PHT_X_E,"0,-1,0");
	u279->AddDependency(PHT_X_S,"-1,0,0");
	u279->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u280 = (TExecuteCommand*) PHT_X_OUT.GetCommand("u280",TCommand::kUpdate,TCommand::kCode);
	u280->SetExecutable(&PHT_X_OUT_u280_exe_g);
	u280->Code() = "u280 <- ( ( ( PHT_X_E+PHT_X_N )+PHT_X_S )+PHT_X_W )";
	if( PHT_X_OUT.GetF(FisClamped) ) { u280->AddDependency(PHYTOPLANKTON); }
	u280->AddDependency(PHT_X_E);
	u280->AddDependency(PHT_X_N);
	u280->AddDependency(PHT_X_S);
	u280->AddDependency(PHT_X_W);
	u280->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u281 = (TExecuteCommand*) PHT_RESP.GetCommand("u281",TCommand::kUpdate,TCommand::kCode);
	u281->SetExecutable(&PHT_RESP_u281_exe_g);
	u281->Code() = "u281 <-  ( ( ( SF_WATER >  ((float)0) ) ) ? ( ( ( ( P1_PHT_RESP_RT*PHT_TEMP_LIM )*PHYTOPLANKTON )*dT() ) ) : ( ((float)0) ) ) ";
	if( PHT_RESP.GetF(FisClamped) ) { u281->AddDependency(PHYTOPLANKTON); }
	u281->AddDependency(SF_WATER);
	u281->AddDependency(P1_PHT_RESP_RT);
	u281->AddDependency(PHT_TEMP_LIM);
	u281->AddDependency(PHYTOPLANKTON);
	u281->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u282 = (TExecuteCommand*) PHT_CONSUMED.GetCommand("u282",TCommand::kUpdate,TCommand::kCode);
	u282->SetExecutable(&PHT_CONSUMED_u282_exe_g);
	u282->Code() = "u282 <- CONS_INGEST_PHT";
	if( PHT_CONSUMED.GetF(FisClamped) ) { u282->AddDependency(PHYTOPLANKTON); }
	u282->AddDependency(CONS_INGEST_PHT);
	u282->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u283 = (TExecuteCommand*) PHT_MORTALITY.GetCommand("u283",TCommand::kUpdate,TCommand::kCode);
	u283->SetExecutable(&PHT_MORTALITY_u283_exe_g);
	u283->Code() = "u283 <- ( PHYTOPLANKTON*( P1_PHT_MORTALITY_RT*dT() ) )";
	if( PHT_MORTALITY.GetF(FisClamped) ) { u283->AddDependency(PHYTOPLANKTON); }
	u283->AddDependency(PHYTOPLANKTON);
	u283->AddDependency(P1_PHT_MORTALITY_RT);
	u283->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u284 = (TExecuteCommand*) PHT_DOWNFLOW.GetCommand("u284",TCommand::kUpdate,TCommand::kCode);
	u284->SetExecutable(&PHT_DOWNFLOW_u284_exe_g);
	u284->Code() = "u284 <-  ( ( ( SF_WATER == ((float)0) ) ) ? ( PHYTOPLANKTON ) : ( ((float)0) ) ) ";
	if( PHT_DOWNFLOW.GetF(FisClamped) ) { u284->AddDependency(PHYTOPLANKTON); }
	u284->AddDependency(SF_WATER);
	u284->AddDependency(PHYTOPLANKTON);
	u284->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u287 = (TExecuteCommand*) PHT_NUT_LIMIT.GetCommand("u287",TCommand::kUpdate,TCommand::kCode);
	u287->SetExecutable(&PHT_NUT_LIMIT_u287_exe_g);
	u287->Code() = "u287 <- SL::Min(( DIN_CONC/( DIN_CONC+P1_PHT_N_SAT ) ), ( PO4_SF_WT_CONC/( PO4_SF_WT_CONC+P1_PHT_P_SAT ) ))";
	u287->AddDependency(DIN_CONC);
	u287->AddDependency(P1_PHT_N_SAT);
	u287->AddDependency(PO4_SF_WT_CONC);
	u287->AddDependency(P1_PHT_P_SAT);
	u287->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u288 = (TExecuteCommand*) PHT_PROD_LIM.GetCommand("u288",TCommand::kUpdate,TCommand::kCode);
	u288->SetExecutable(&PHT_PROD_LIM_u288_exe_g);
	u288->Code() = "u288 <-  ( ( ( SF_WATER >  ((float)0) ) ) ? ( ( ( PHT_LIGHT_LIM*PHT_NUT_LIMIT )*PHT_TEMP_LIM ) ) : ( ((float)0) ) ) ";
	u288->AddDependency(SF_WATER);
	u288->AddDependency(PHT_LIGHT_LIM);
	u288->AddDependency(PHT_NUT_LIMIT);
	u288->AddDependency(PHT_TEMP_LIM);
	u288->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u289 = (TExecuteCommand*) PHT_TEMP_LIM.GetCommand("u289",TCommand::kUpdate,TCommand::kCode);
	u289->SetExecutable(&PHT_TEMP_LIM_u289_exe_g);
	u289->Code() = "u289 <- ( ( H2O_TEMP*P1_PHT_TEMP_COEFF )/40 )";
	u289->AddDependency(H2O_TEMP);
	u289->AddDependency(P1_PHT_TEMP_COEFF);
	u289->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u290 = (TExecuteCommand*) PHT_X_E.GetCommand("u290",TCommand::kUpdate,TCommand::kCode);
	u290->SetExecutable(&PHT_X_E_u290_exe_g);
	u290->Code() = "u290 <- ( PHT_CONC*SF_WT_E_X )";
	u290->AddDependency(PHT_CONC);
	u290->AddDependency(SF_WT_E_X);
	u290->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u291 = (TExecuteCommand*) PHT_X_N.GetCommand("u291",TCommand::kUpdate,TCommand::kCode);
	u291->SetExecutable(&PHT_X_N_u291_exe_g);
	u291->Code() = "u291 <- ( PHT_CONC*SF_WT_N_X )";
	u291->AddDependency(PHT_CONC);
	u291->AddDependency(SF_WT_N_X);
	u291->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u292 = (TExecuteCommand*) PHT_X_S.GetCommand("u292",TCommand::kUpdate,TCommand::kCode);
	u292->SetExecutable(&PHT_X_S_u292_exe_g);
	u292->Code() = "u292 <- ( PHT_CONC*SF_WT_S_X )";
	u292->AddDependency(PHT_CONC);
	u292->AddDependency(SF_WT_S_X);
	u292->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u293 = (TExecuteCommand*) PHT_X_W.GetCommand("u293",TCommand::kUpdate,TCommand::kCode);
	u293->SetExecutable(&PHT_X_W_u293_exe_g);
	u293->Code() = "u293 <- ( PHT_CONC*SF_WT_W_X )";
	u293->AddDependency(PHT_CONC);
	u293->AddDependency(SF_WT_W_X);
	u293->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u294 = (TExecuteCommand*) RIVER_PHT.GetCommand("u294",TCommand::kUpdate,TCommand::kCode);
	u294->SetExecutable(&RIVER_PHT_u294_exe_g);
	u294->Code() = "u294 <- 0";
	u294->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u295 = (TExecuteCommand*) P1_IC_PHT.GetCommand("u295",TCommand::kUpdate,TCommand::kCode);
	u295->SetExecutable(&P1_IC_PHT_u295_exe_g);
	u295->Code() = "u295 <- 1";
	u295->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u296 = (TExecuteCommand*) P1_PHT_GROSS_PP_RT.GetCommand("u296",TCommand::kUpdate,TCommand::kCode);
	u296->SetExecutable(&P1_PHT_GROSS_PP_RT_u296_exe_g);
	u296->Code() = "u296 <- 0.008300";
	u296->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u297 = (TExecuteCommand*) P1_PHT_MORTALITY_RT.GetCommand("u297",TCommand::kUpdate,TCommand::kCode);
	u297->SetExecutable(&P1_PHT_MORTALITY_RT_u297_exe_g);
	u297->Code() = "u297 <- 2e-4";
	u297->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u299 = (TExecuteCommand*) P1_PHT_N_SAT.GetCommand("u299",TCommand::kUpdate,TCommand::kCode);
	u299->SetExecutable(&P1_PHT_N_SAT_u299_exe_g);
	u299->Code() = "u299 <- 0.000025";
	u299->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u300 = (TExecuteCommand*) P1_PHT_P_SAT.GetCommand("u300",TCommand::kUpdate,TCommand::kCode);
	u300->SetExecutable(&P1_PHT_P_SAT_u300_exe_g);
	u300->Code() = "u300 <- 0.000002";
	u300->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u301 = (TExecuteCommand*) P1_PHT_RESP_RT.GetCommand("u301",TCommand::kUpdate,TCommand::kCode);
	u301->SetExecutable(&P1_PHT_RESP_RT_u301_exe_g);
	u301->Code() = "u301 <- 0.000140";
	u301->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u302 = (TExecuteCommand*) P1_PHT_TEMP_COEFF.GetCommand("u302",TCommand::kUpdate,TCommand::kCode);
	u302->SetExecutable(&P1_PHT_TEMP_COEFF_u302_exe_g);
	u302->Code() = "u302 <- 0.069000";
	u302->SetObjInfo(TCommand::kDepIndex, 5);
	return 0;
}

int PHYTOPLANKTON_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int PHYTOPLANKTON_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int PHYTOPLANKTON_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int PHYTOPLANKTON_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class SALT_module 
// ---------------------------------------------------------------------------
SALT_module::SALT_module(char* name) :
	TIME("TIME"),
	SF_WATER("SF_WATER"),
	SF_WT_E_X("SF_WT_E_X"),
	SF_WT_N_X("SF_WT_N_X"),
	SF_WT_S_X("SF_WT_S_X"),
	SF_WT_W_X("SF_WT_W_X"),
	SALT_SURF_WT("SALT_SURF_WT"),
	SALT_X_IN("SALT_X_IN"),
	SALT_X_OUT("SALT_X_OUT"),
	SALT_DOWNFLOW("SALT_DOWNFLOW"),
	RIVER_NACL("RIVER_NACL"),
	SALINITY("SALINITY"),
	SALT_CONC("SALT_CONC"),
	SALT_E_X("SALT_E_X"),
	SALT_N_X("SALT_N_X"),
	SALT_S_X("SALT_S_X"),
	SALT_W_X("SALT_W_X"),
	P1_IC_SALT("P1_IC_SALT"),
	TModule(name) {

	SF_WATER.SetF(FisImport,True,"CG");
	SF_WT_E_X.SetF(FisImport,True,"CG");
	SF_WT_N_X.SetF(FisImport,True,"CG");
	SF_WT_S_X.SetF(FisImport,True,"CG");
	SF_WT_W_X.SetF(FisImport,True,"CG");
}	
int SALT_module::SALT_SURF_WT_I304_exe() {
	float value;

	SALT_SURF_WT.UpdateIntegrator();
	switch( SALT_SURF_WT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SALT_SURF_WT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SALT_X_IN.Value(p)-SALT_X_OUT.Value(p) )-SALT_DOWNFLOW.Value(p) );
			SALT_SURF_WT.Update( p, value, dT() );
		}
		SALT_SURF_WT.GrabMemory();
		if( SALT_SURF_WT.GetF(FLinkEdges) ) { SALT_SURF_WT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SALT_X_IN.Value()-SALT_X_OUT.Value() )-SALT_DOWNFLOW.Value() );
			SALT_SURF_WT.Update( value, dT() );
	  } break;
	}
	return 0;
}

int SALT_module::SALT_SURF_WT_i305_exe() {
	float value;

	SALT_SURF_WT.UpdateIntegrator();
	switch( SALT_SURF_WT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SALT_SURF_WT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SF_WATER.Value(p)*P1_IC_SALT.Value(p) );
			SALT_SURF_WT.InitValue( p, value );
		}
		SALT_SURF_WT.GrabMemory();
		if( SALT_SURF_WT.GetF(FLinkEdges) ) { SALT_SURF_WT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SF_WATER.Value()*P1_IC_SALT.Value() );
			SALT_SURF_WT.InitValue( value );
	  } break;
	}
	return 0;
}

int SALT_module::SALT_X_IN_u306_exe() {
	float value;

	switch( SALT_X_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SALT_X_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( SALT_E_X.RelValue(p,0,-1,0,CVariable::kDefaultBC)+SALT_N_X.RelValue(p,1,0,0,CVariable::kDefaultBC) )+SALT_S_X.RelValue(p,-1,0,0,CVariable::kDefaultBC) )+SALT_W_X.RelValue(p,0,1,0,CVariable::kDefaultBC) );
			SALT_X_IN.Update( p, value );
		}
		SALT_X_IN.GrabMemory();
		if( SALT_X_IN.GetF(FICFlux) ) SALT_X_IN.Cov().Set(0.0); 
		if( SALT_X_IN.GetF(FLinkEdges) ) { SALT_X_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( SALT_E_X.Value()+SALT_N_X.Value() )+SALT_S_X.Value() )+SALT_W_X.Value() );
			SALT_X_IN.Update( value );
	  } break;
	}
	return 0;
}

int SALT_module::SALT_X_OUT_u307_exe() {
	float value;

	switch( SALT_X_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SALT_X_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( SALT_E_X.Value(p)+SALT_N_X.Value(p) )+SALT_S_X.Value(p) )+SALT_W_X.Value(p) );
			SALT_X_OUT.Update( p, value );
		}
		SALT_X_OUT.GrabMemory();
		if( SALT_X_OUT.GetF(FICFlux) ) SALT_X_OUT.Cov().Set(0.0); 
		if( SALT_X_OUT.GetF(FLinkEdges) ) { SALT_X_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( SALT_E_X.Value()+SALT_N_X.Value() )+SALT_S_X.Value() )+SALT_W_X.Value() );
			SALT_X_OUT.Update( value );
	  } break;
	}
	return 0;
}

int SALT_module::SALT_DOWNFLOW_u308_exe() {
	float value;

	switch( SALT_DOWNFLOW.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SALT_DOWNFLOW.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SF_WATER.Value(p) == ((float)0) ) ) ? ( SALT_SURF_WT.Value(p) ) : ( ((float)0) ) ) ;
			SALT_DOWNFLOW.Update( p, value );
		}
		SALT_DOWNFLOW.GrabMemory();
		if( SALT_DOWNFLOW.GetF(FICFlux) ) SALT_DOWNFLOW.Cov().Set(0.0); 
		if( SALT_DOWNFLOW.GetF(FLinkEdges) ) { SALT_DOWNFLOW.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SF_WATER.Value() == ((float)0) ) ) ? ( SALT_SURF_WT.Value() ) : ( ((float)0) ) ) ;
			SALT_DOWNFLOW.Update( value );
	  } break;
	}
	return 0;
}

int SALT_module::RIVER_NACL_u309_exe() {
	float value;

	switch( RIVER_NACL.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = RIVER_NACL.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0;
			RIVER_NACL.Update( p, RIVER_NACL.ParameterValue(value,p) );
		}
		RIVER_NACL.GrabMemory();
		if( RIVER_NACL.GetF(FLinkEdges) ) { RIVER_NACL.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0;
			RIVER_NACL.Update( RIVER_NACL.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int SALT_module::SALINITY_u310_exe() {
	float value;

	switch( SALINITY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SALINITY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SF_WATER.Value(p) == ((float)0) ) ) ? ( ((float)0) ) : ( ( SALT_SURF_WT.Value(p)/SF_WATER.Value(p) ) ) ) ;
			SALINITY.Update( p, value );
		}
		SALINITY.GrabMemory();
		if( SALINITY.GetF(FLinkEdges) ) { SALINITY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SF_WATER.Value() == ((float)0) ) ) ? ( ((float)0) ) : ( ( SALT_SURF_WT.Value()/SF_WATER.Value() ) ) ) ;
			SALINITY.Update( value );
	  } break;
	}
	return 0;
}

int SALT_module::SALT_CONC_u311_exe() {
	float value;

	switch( SALT_CONC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SALT_CONC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SF_WATER.Value(p) <= ((float)0) ) ) ? ( ((float)0) ) : ( SL::Max(( RIVER_NACL.Value(p)+( SALT_SURF_WT.Value(p)/SF_WATER.Value(p) ) ), ((float)0)) ) ) ;
			SALT_CONC.Update( p, value );
		}
		SALT_CONC.GrabMemory();
		if( SALT_CONC.GetF(FLinkEdges) ) { SALT_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SF_WATER.Value() <= ((float)0) ) ) ? ( ((float)0) ) : ( SL::Max(( RIVER_NACL.Value()+( SALT_SURF_WT.Value()/SF_WATER.Value() ) ), ((float)0)) ) ) ;
			SALT_CONC.Update( value );
	  } break;
	}
	return 0;
}

int SALT_module::SALT_E_X_u312_exe() {
	float value;

	switch( SALT_E_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SALT_E_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SALT_CONC.Value(p)*SF_WT_E_X.Value(p) );
			SALT_E_X.Update( p, value );
		}
		SALT_E_X.GrabMemory();
		if( SALT_E_X.GetF(FLinkEdges) ) { SALT_E_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SALT_CONC.Value()*SF_WT_E_X.Value() );
			SALT_E_X.Update( value );
	  } break;
	}
	return 0;
}

int SALT_module::SALT_N_X_u313_exe() {
	float value;

	switch( SALT_N_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SALT_N_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SALT_CONC.Value(p)*SF_WT_N_X.Value(p) );
			SALT_N_X.Update( p, value );
		}
		SALT_N_X.GrabMemory();
		if( SALT_N_X.GetF(FLinkEdges) ) { SALT_N_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SALT_CONC.Value()*SF_WT_N_X.Value() );
			SALT_N_X.Update( value );
	  } break;
	}
	return 0;
}

int SALT_module::SALT_S_X_u314_exe() {
	float value;

	switch( SALT_S_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SALT_S_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SALT_CONC.Value(p)*SF_WT_S_X.Value(p) );
			SALT_S_X.Update( p, value );
		}
		SALT_S_X.GrabMemory();
		if( SALT_S_X.GetF(FLinkEdges) ) { SALT_S_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SALT_CONC.Value()*SF_WT_S_X.Value() );
			SALT_S_X.Update( value );
	  } break;
	}
	return 0;
}

int SALT_module::SALT_W_X_u315_exe() {
	float value;

	switch( SALT_W_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SALT_W_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SF_WT_W_X.Value(p)*SALT_CONC.Value(p) );
			SALT_W_X.Update( p, value );
		}
		SALT_W_X.GrabMemory();
		if( SALT_W_X.GetF(FLinkEdges) ) { SALT_W_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SF_WT_W_X.Value()*SALT_CONC.Value() );
			SALT_W_X.Update( value );
	  } break;
	}
	return 0;
}

int SALT_module::P1_IC_SALT_u316_exe() {
	float value;

	switch( P1_IC_SALT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_IC_SALT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.020000;
			P1_IC_SALT.Update( p, P1_IC_SALT.ParameterValue(value,p) );
		}
		P1_IC_SALT.GrabMemory();
		if( P1_IC_SALT.GetF(FLinkEdges) ) { P1_IC_SALT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.020000;
			P1_IC_SALT.Update( P1_IC_SALT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

SALT_module* SALT_module::fInstance = NULL;
SALT_module* SALT_module::kNullModel = (SALT_module*)0x1;
int SALT_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int SALT_module::InitVars() {
	
	TIME.SSInit(this);
	SF_WATER.SSInit(this);
	SF_WT_E_X.SSInit(this);
	SF_WT_N_X.SSInit(this);
	SF_WT_S_X.SSInit(this);
	SF_WT_W_X.SSInit(this);
	SALT_SURF_WT.SSInit(this);
	SALT_X_IN.SSInit(this);
	SALT_X_IN.SetDestination(&SALT_SURF_WT);
	SALT_X_OUT.SSInit(this);
	SALT_X_OUT.SetOrigin(&SALT_SURF_WT);
	SALT_DOWNFLOW.SSInit(this);
	SALT_DOWNFLOW.SetOrigin(&SALT_SURF_WT);
	RIVER_NACL.SSInit(this);
	SALINITY.SSInit(this);
	SALT_CONC.SSInit(this);
	SALT_E_X.SSInit(this);
	SALT_E_X.SetLinkEdges();
	SALT_N_X.SSInit(this);
	SALT_N_X.SetLinkEdges();
	SALT_S_X.SSInit(this);
	SALT_S_X.SetLinkEdges();
	SALT_W_X.SSInit(this);
	SALT_W_X.SetLinkEdges();
	P1_IC_SALT.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int SALT_module::SetupEvents() {
	TImportCommand* SF_WATER_import = (TImportCommand*) SF_WATER.GetCommand("SF_WATER_import",TCommand::kUndefined,TCommand::kImport);
	SF_WATER_import->Code() = "Import SF_WATER from GLOBAL_module";
	SF_WATER_import->AddDependency(SF_WATER);
	SF_WATER_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WT_E_X_import = (TImportCommand*) SF_WT_E_X.GetCommand("SF_WT_E_X_import",TCommand::kUndefined,TCommand::kImport);
	SF_WT_E_X_import->Code() = "Import SF_WT_E_X from GLOBAL_module";
	SF_WT_E_X_import->AddDependency(SF_WT_E_X);
	SF_WT_E_X_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WT_N_X_import = (TImportCommand*) SF_WT_N_X.GetCommand("SF_WT_N_X_import",TCommand::kUndefined,TCommand::kImport);
	SF_WT_N_X_import->Code() = "Import SF_WT_N_X from GLOBAL_module";
	SF_WT_N_X_import->AddDependency(SF_WT_N_X);
	SF_WT_N_X_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WT_S_X_import = (TImportCommand*) SF_WT_S_X.GetCommand("SF_WT_S_X_import",TCommand::kUndefined,TCommand::kImport);
	SF_WT_S_X_import->Code() = "Import SF_WT_S_X from GLOBAL_module";
	SF_WT_S_X_import->AddDependency(SF_WT_S_X);
	SF_WT_S_X_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WT_W_X_import = (TImportCommand*) SF_WT_W_X.GetCommand("SF_WT_W_X_import",TCommand::kUndefined,TCommand::kImport);
	SF_WT_W_X_import->Code() = "Import SF_WT_W_X from GLOBAL_module";
	SF_WT_W_X_import->AddDependency(SF_WT_W_X);
	SF_WT_W_X_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I304 = (TExecuteCommand*) SALT_SURF_WT.GetCommand("I304",TCommand::kIntegrate,TCommand::kCode);
	I304->SetExecutable(&SALT_SURF_WT_I304_exe_g);
	I304->Code() = "I304 <- ( ( SALT_X_IN-SALT_X_OUT )-SALT_DOWNFLOW )";
	I304->AddDependency(SALT_X_IN);
	I304->AddDependency(SALT_X_OUT);
	I304->AddDependency(SALT_DOWNFLOW);
	I304->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i305 = (TExecuteCommand*) SALT_SURF_WT.GetCommand("i305",TCommand::kInit,TCommand::kCode);
	i305->SetExecutable(&SALT_SURF_WT_i305_exe_g);
	i305->Code() = "i305 <- ( SF_WATER*P1_IC_SALT )";
	i305->AddDependency(SF_WATER);
	i305->AddDependency(P1_IC_SALT);
	i305->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u306 = (TExecuteCommand*) SALT_X_IN.GetCommand("u306",TCommand::kUpdate,TCommand::kCode);
	u306->SetExecutable(&SALT_X_IN_u306_exe_g);
	u306->Code() = "u306 <- ( ( ( SALT_E_X@(0,-1,0)+SALT_N_X@(1,0,0) )+SALT_S_X@(-1,0,0) )+SALT_W_X@(0,1,0) )";
	u306->AddDependency(SALT_E_X,"0,-1,0");
	u306->AddDependency(SALT_N_X,"1,0,0");
	u306->AddDependency(SALT_S_X,"-1,0,0");
	u306->AddDependency(SALT_W_X,"0,1,0");
	u306->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u307 = (TExecuteCommand*) SALT_X_OUT.GetCommand("u307",TCommand::kUpdate,TCommand::kCode);
	u307->SetExecutable(&SALT_X_OUT_u307_exe_g);
	u307->Code() = "u307 <- ( ( ( SALT_E_X+SALT_N_X )+SALT_S_X )+SALT_W_X )";
	if( SALT_X_OUT.GetF(FisClamped) ) { u307->AddDependency(SALT_SURF_WT); }
	u307->AddDependency(SALT_E_X);
	u307->AddDependency(SALT_N_X);
	u307->AddDependency(SALT_S_X);
	u307->AddDependency(SALT_W_X);
	u307->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u308 = (TExecuteCommand*) SALT_DOWNFLOW.GetCommand("u308",TCommand::kUpdate,TCommand::kCode);
	u308->SetExecutable(&SALT_DOWNFLOW_u308_exe_g);
	u308->Code() = "u308 <-  ( ( ( SF_WATER == ((float)0) ) ) ? ( SALT_SURF_WT ) : ( ((float)0) ) ) ";
	if( SALT_DOWNFLOW.GetF(FisClamped) ) { u308->AddDependency(SALT_SURF_WT); }
	u308->AddDependency(SF_WATER);
	u308->AddDependency(SALT_SURF_WT);
	u308->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u309 = (TExecuteCommand*) RIVER_NACL.GetCommand("u309",TCommand::kUpdate,TCommand::kCode);
	u309->SetExecutable(&RIVER_NACL_u309_exe_g);
	u309->Code() = "u309 <- 0";
	u309->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u310 = (TExecuteCommand*) SALINITY.GetCommand("u310",TCommand::kUpdate,TCommand::kCode);
	u310->SetExecutable(&SALINITY_u310_exe_g);
	u310->Code() = "u310 <-  ( ( ( SF_WATER == ((float)0) ) ) ? ( ((float)0) ) : ( ( SALT_SURF_WT/SF_WATER ) ) ) ";
	u310->AddDependency(SF_WATER);
	u310->AddDependency(SALT_SURF_WT);
	u310->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u311 = (TExecuteCommand*) SALT_CONC.GetCommand("u311",TCommand::kUpdate,TCommand::kCode);
	u311->SetExecutable(&SALT_CONC_u311_exe_g);
	u311->Code() = "u311 <-  ( ( ( SF_WATER <= ((float)0) ) ) ? ( ((float)0) ) : ( SL::Max(( RIVER_NACL+( SALT_SURF_WT/SF_WATER ) ), ((float)0)) ) ) ";
	u311->AddDependency(SF_WATER);
	u311->AddDependency(RIVER_NACL);
	u311->AddDependency(SALT_SURF_WT);
	u311->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u312 = (TExecuteCommand*) SALT_E_X.GetCommand("u312",TCommand::kUpdate,TCommand::kCode);
	u312->SetExecutable(&SALT_E_X_u312_exe_g);
	u312->Code() = "u312 <- ( SALT_CONC*SF_WT_E_X )";
	u312->AddDependency(SALT_CONC);
	u312->AddDependency(SF_WT_E_X);
	u312->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u313 = (TExecuteCommand*) SALT_N_X.GetCommand("u313",TCommand::kUpdate,TCommand::kCode);
	u313->SetExecutable(&SALT_N_X_u313_exe_g);
	u313->Code() = "u313 <- ( SALT_CONC*SF_WT_N_X )";
	u313->AddDependency(SALT_CONC);
	u313->AddDependency(SF_WT_N_X);
	u313->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u314 = (TExecuteCommand*) SALT_S_X.GetCommand("u314",TCommand::kUpdate,TCommand::kCode);
	u314->SetExecutable(&SALT_S_X_u314_exe_g);
	u314->Code() = "u314 <- ( SALT_CONC*SF_WT_S_X )";
	u314->AddDependency(SALT_CONC);
	u314->AddDependency(SF_WT_S_X);
	u314->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u315 = (TExecuteCommand*) SALT_W_X.GetCommand("u315",TCommand::kUpdate,TCommand::kCode);
	u315->SetExecutable(&SALT_W_X_u315_exe_g);
	u315->Code() = "u315 <- ( SF_WT_W_X*SALT_CONC )";
	u315->AddDependency(SF_WT_W_X);
	u315->AddDependency(SALT_CONC);
	u315->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u316 = (TExecuteCommand*) P1_IC_SALT.GetCommand("u316",TCommand::kUpdate,TCommand::kCode);
	u316->SetExecutable(&P1_IC_SALT_u316_exe_g);
	u316->Code() = "u316 <- 0.020000";
	u316->SetObjInfo(TCommand::kDepIndex, 5);
	return 0;
}

int SALT_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int SALT_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int SALT_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int SALT_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class SEAWEED_module 
// ---------------------------------------------------------------------------
SEAWEED_module::SEAWEED_module(char* name) :
	TIME("TIME"),
	SEAWEEDS("SEAWEEDS"),
	WATER_DEPTH("WATER_DEPTH"),
	P1_CELL_SIZE("P1_CELL_SIZE"),
	SF_WATER("SF_WATER"),
	CONS_INGEST_SW("CONS_INGEST_SW"),
	P1_IC_MAC_PHBIO("P1_IC_MAC_PHBIO"),
	P1_SEPT_TO_JAN_CONV("P1_SEPT_TO_JAN_CONV"),
	SF_WT_E_X("SF_WT_E_X"),
	DIN_CONC("DIN_CONC"),
	PO4_SF_WT_CONC("PO4_SF_WT_CONC"),
	SF_WT_N_X("SF_WT_N_X"),
	SW_LIGHT_LIM("SW_LIGHT_LIM"),
	SF_WT_S_X("SF_WT_S_X"),
	H2O_TEMP("H2O_TEMP"),
	SF_WT_W_X("SF_WT_W_X"),
	DAYS("DAYS"),
	CURRENT_VELOCITY("CURRENT_VELOCITY"),
	SW_GROSS_PP("SW_GROSS_PP"),
	SW_X_IN("SW_X_IN"),
	SW_REPRODUCTION("SW_REPRODUCTION"),
	SW_X_OUT("SW_X_OUT"),
	SW_RESP("SW_RESP"),
	SW_CONSUMED("SW_CONSUMED"),
	SW_MORT("SW_MORT"),
	IC_SEAWEED("IC_SEAWEED"),
	SW_CONC("SW_CONC"),
	SW_E_X("SW_E_X"),
	SW_NET_PROD("SW_NET_PROD"),
	SW_NUT_LIMIT("SW_NUT_LIMIT"),
	SW_N_X("SW_N_X"),
	SW_PROD_LIM("SW_PROD_LIM"),
	SW_S_X("SW_S_X"),
	SW_TEMP_LIM("SW_TEMP_LIM"),
	SW_W_X("SW_W_X"),
	P1_SW_MORT_RT("P1_SW_MORT_RT"),
	P1_SW_NC("P1_SW_NC"),
	P1_SW_N_SAT("P1_SW_N_SAT"),
	P1_SW_PC("P1_SW_PC"),
	P1_SW_PP_RT("P1_SW_PP_RT"),
	P1_SW_P_SAT("P1_SW_P_SAT"),
	P1_SW_RESP_RT("P1_SW_RESP_RT"),
	P1_SW_SEEDING_RT("P1_SW_SEEDING_RT"),
	P1_SW_T_COEFF("P1_SW_T_COEFF"),
	REPRODUCTION_SEASON("REPRODUCTION_SEASON"),
	SEAWEED_RATE("SEAWEED_RATE"),
	TModule(name) {

	SEAWEEDS.SetF(FisExport,True,"CG");
	WATER_DEPTH.SetF(FisImport,True,"CG");
	P1_CELL_SIZE.SetF(FisImport,True,"CG");
	SF_WATER.SetF(FisImport,True,"CG");
	CONS_INGEST_SW.SetF(FisImport,True,"CG");
	P1_IC_MAC_PHBIO.SetF(FisImport,True,"CG");
	P1_SEPT_TO_JAN_CONV.SetF(FisImport,True,"CG");
	SF_WT_E_X.SetF(FisImport,True,"CG");
	DIN_CONC.SetF(FisImport,True,"CG");
	PO4_SF_WT_CONC.SetF(FisImport,True,"CG");
	SF_WT_N_X.SetF(FisImport,True,"CG");
	SW_LIGHT_LIM.SetF(FisImport,True,"CG");
	SF_WT_S_X.SetF(FisImport,True,"CG");
	H2O_TEMP.SetF(FisImport,True,"CG");
	SF_WT_W_X.SetF(FisImport,True,"CG");
	DAYS.SetF(FisImport,True,"CG");
	CURRENT_VELOCITY.SetF(FisImport,True,"CG");
}	
int SEAWEED_module::SEAWEEDS_I317_exe() {
	float value;

	SEAWEEDS.UpdateIntegrator();
	switch( SEAWEEDS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SEAWEEDS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( ( ( ( SW_GROSS_PP.Value(p)+SW_X_IN.Value(p) )+SW_REPRODUCTION.Value(p) )-SW_X_OUT.Value(p) )-SW_RESP.Value(p) )-SW_CONSUMED.Value(p) )-SW_MORT.Value(p) );
			SEAWEEDS.Update( p, value, dT() );
		}
		SEAWEEDS.GrabMemory();
		if( SEAWEEDS.GetF(FLinkEdges) ) { SEAWEEDS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( ( ( ( SW_GROSS_PP.Value()+SW_X_IN.Value() )+SW_REPRODUCTION.Value() )-SW_X_OUT.Value() )-SW_RESP.Value() )-SW_CONSUMED.Value() )-SW_MORT.Value() );
			SEAWEEDS.Update( value, dT() );
	  } break;
	}
	return 0;
}

int SEAWEED_module::SEAWEEDS_i318_exe() {
	float value;

	SEAWEEDS.UpdateIntegrator();
	switch( SEAWEEDS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SEAWEEDS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( WATER_DEPTH.Value(p)*P1_CELL_SIZE.Value(p) )*IC_SEAWEED.Value(p) );
			SEAWEEDS.InitValue( p, value );
		}
		SEAWEEDS.GrabMemory();
		if( SEAWEEDS.GetF(FLinkEdges) ) { SEAWEEDS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( WATER_DEPTH.Value()*P1_CELL_SIZE.Value() )*IC_SEAWEED.Value() );
			SEAWEEDS.InitValue( value );
	  } break;
	}
	return 0;
}

int SEAWEED_module::SW_GROSS_PP_u319_exe() {
	float value;

	switch( SW_GROSS_PP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_GROSS_PP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SW_PROD_LIM.Value(p)*( P1_SW_PP_RT.Value(p)/dT() ) )*SEAWEEDS.Value(p) );
			SW_GROSS_PP.Update( p, value );
		}
		SW_GROSS_PP.GrabMemory();
		if( SW_GROSS_PP.GetF(FICFlux) ) SW_GROSS_PP.Cov().Set(0.0); 
		if( SW_GROSS_PP.GetF(FLinkEdges) ) { SW_GROSS_PP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SW_PROD_LIM.Value()*( P1_SW_PP_RT.Value()/dT() ) )*SEAWEEDS.Value() );
			SW_GROSS_PP.Update( value );
	  } break;
	}
	return 0;
}

int SEAWEED_module::SW_X_IN_u320_exe() {
	float value;

	switch( SW_X_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_X_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( SW_E_X.RelValue(p,0,-1,0,CVariable::kDefaultBC)+SW_N_X.RelValue(p,1,0,0,CVariable::kDefaultBC) )+SW_W_X.RelValue(p,0,1,0,CVariable::kDefaultBC) )+SW_S_X.RelValue(p,-1,0,0,CVariable::kDefaultBC) );
			SW_X_IN.Update( p, value );
		}
		SW_X_IN.GrabMemory();
		if( SW_X_IN.GetF(FICFlux) ) SW_X_IN.Cov().Set(0.0); 
		if( SW_X_IN.GetF(FLinkEdges) ) { SW_X_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( SW_E_X.Value()+SW_N_X.Value() )+SW_W_X.Value() )+SW_S_X.Value() );
			SW_X_IN.Update( value );
	  } break;
	}
	return 0;
}

int SEAWEED_module::SW_REPRODUCTION_u321_exe() {
	float value;

	switch( SW_REPRODUCTION.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_REPRODUCTION.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( REPRODUCTION_SEASON.Value(p) <  ((float)1) ) ) ? ( ((float)0) ) : (  ( ( ( SL::Rand(((float)0), ((float)1)) <  0.1 ) ) ? ( P1_SW_SEEDING_RT.Value(p) ) : ( ((float)0) ) )  ) ) ;
			SW_REPRODUCTION.Update( p, value );
		}
		SW_REPRODUCTION.GrabMemory();
		if( SW_REPRODUCTION.GetF(FICFlux) ) SW_REPRODUCTION.Cov().Set(0.0); 
		if( SW_REPRODUCTION.GetF(FLinkEdges) ) { SW_REPRODUCTION.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( REPRODUCTION_SEASON.Value() <  ((float)1) ) ) ? ( ((float)0) ) : (  ( ( ( SL::Rand(((float)0), ((float)1)) <  0.1 ) ) ? ( P1_SW_SEEDING_RT.Value() ) : ( ((float)0) ) )  ) ) ;
			SW_REPRODUCTION.Update( value );
	  } break;
	}
	return 0;
}

int SEAWEED_module::SW_X_OUT_u322_exe() {
	float value;

	switch( SW_X_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_X_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( SW_E_X.Value(p)+SW_W_X.Value(p) )+SW_S_X.Value(p) )+SW_N_X.Value(p) );
			SW_X_OUT.Update( p, value );
		}
		SW_X_OUT.GrabMemory();
		if( SW_X_OUT.GetF(FICFlux) ) SW_X_OUT.Cov().Set(0.0); 
		if( SW_X_OUT.GetF(FLinkEdges) ) { SW_X_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( SW_E_X.Value()+SW_W_X.Value() )+SW_S_X.Value() )+SW_N_X.Value() );
			SW_X_OUT.Update( value );
	  } break;
	}
	return 0;
}

int SEAWEED_module::SW_RESP_u323_exe() {
	float value;

	switch( SW_RESP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_RESP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SF_WATER.Value(p) >  ((float)0) ) ) ? ( ( ( ( P1_SW_RESP_RT.Value(p)*dT() )*SW_TEMP_LIM.Value(p) )*SEAWEEDS.Value(p) ) ) : ( ((float)0) ) ) ;
			SW_RESP.Update( p, value );
		}
		SW_RESP.GrabMemory();
		if( SW_RESP.GetF(FICFlux) ) SW_RESP.Cov().Set(0.0); 
		if( SW_RESP.GetF(FLinkEdges) ) { SW_RESP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SF_WATER.Value() >  ((float)0) ) ) ? ( ( ( ( P1_SW_RESP_RT.Value()*dT() )*SW_TEMP_LIM.Value() )*SEAWEEDS.Value() ) ) : ( ((float)0) ) ) ;
			SW_RESP.Update( value );
	  } break;
	}
	return 0;
}

int SEAWEED_module::SW_CONSUMED_u324_exe() {
	float value;

	switch( SW_CONSUMED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_CONSUMED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  CONS_INGEST_SW.Value(p);
			SW_CONSUMED.Update( p, value );
		}
		SW_CONSUMED.GrabMemory();
		if( SW_CONSUMED.GetF(FICFlux) ) SW_CONSUMED.Cov().Set(0.0); 
		if( SW_CONSUMED.GetF(FLinkEdges) ) { SW_CONSUMED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  CONS_INGEST_SW.Value();
			SW_CONSUMED.Update( value );
	  } break;
	}
	return 0;
}

int SEAWEED_module::SW_MORT_u325_exe() {
	float value;

	switch( SW_MORT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_MORT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SEAWEEDS.Value(p)*( P1_SW_MORT_RT.Value(p)*dT() ) );
			SW_MORT.Update( p, value );
		}
		SW_MORT.GrabMemory();
		if( SW_MORT.GetF(FICFlux) ) SW_MORT.Cov().Set(0.0); 
		if( SW_MORT.GetF(FLinkEdges) ) { SW_MORT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SEAWEEDS.Value()*( P1_SW_MORT_RT.Value()*dT() ) );
			SW_MORT.Update( value );
	  } break;
	}
	return 0;
}

int SEAWEED_module::IC_SEAWEED_u326_exe() {
	float value;

	switch( IC_SEAWEED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = IC_SEAWEED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( P1_IC_MAC_PHBIO.Value(p)/P1_SEPT_TO_JAN_CONV.Value(p) )*0.05 );
			IC_SEAWEED.Update( p, value );
		}
		IC_SEAWEED.GrabMemory();
		if( IC_SEAWEED.GetF(FLinkEdges) ) { IC_SEAWEED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( P1_IC_MAC_PHBIO.Value()/P1_SEPT_TO_JAN_CONV.Value() )*0.05 );
			IC_SEAWEED.Update( value );
	  } break;
	}
	return 0;
}

int SEAWEED_module::SW_CONC_u327_exe() {
	float value;

	switch( SW_CONC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_CONC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( WATER_DEPTH.Value(p) >  0.01 ) ) ? ( ( SEAWEEDS.Value(p)/SF_WATER.Value(p) ) ) : ( ((float)0) ) ) ;
			SW_CONC.Update( p, value );
		}
		SW_CONC.GrabMemory();
		if( SW_CONC.GetF(FLinkEdges) ) { SW_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( WATER_DEPTH.Value() >  0.01 ) ) ? ( ( SEAWEEDS.Value()/SF_WATER.Value() ) ) : ( ((float)0) ) ) ;
			SW_CONC.Update( value );
	  } break;
	}
	return 0;
}

int SEAWEED_module::SW_E_X_u328_exe() {
	float value;

	switch( SW_E_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_E_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SEAWEED_RATE.Value(p)*SF_WT_E_X.Value(p) )*SW_CONC.Value(p) );
			SW_E_X.Update( p, value );
		}
		SW_E_X.GrabMemory();
		if( SW_E_X.GetF(FLinkEdges) ) { SW_E_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SEAWEED_RATE.Value()*SF_WT_E_X.Value() )*SW_CONC.Value() );
			SW_E_X.Update( value );
	  } break;
	}
	return 0;
}

int SEAWEED_module::SW_NET_PROD_u329_exe() {
	float value;

	switch( SW_NET_PROD.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_NET_PROD.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SW_GROSS_PP.Value(p)-SW_RESP.Value(p) );
			SW_NET_PROD.Update( p, value );
		}
		SW_NET_PROD.GrabMemory();
		if( SW_NET_PROD.GetF(FLinkEdges) ) { SW_NET_PROD.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SW_GROSS_PP.Value()-SW_RESP.Value() );
			SW_NET_PROD.Update( value );
	  } break;
	}
	return 0;
}

int SEAWEED_module::SW_NUT_LIMIT_u330_exe() {
	float value;

	switch( SW_NUT_LIMIT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_NUT_LIMIT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(( DIN_CONC.Value(p)/( DIN_CONC.Value(p)+P1_SW_N_SAT.Value(p) ) ), ( PO4_SF_WT_CONC.Value(p)/( PO4_SF_WT_CONC.Value(p)+P1_SW_P_SAT.Value(p) ) ));
			SW_NUT_LIMIT.Update( p, value );
		}
		SW_NUT_LIMIT.GrabMemory();
		if( SW_NUT_LIMIT.GetF(FLinkEdges) ) { SW_NUT_LIMIT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(( DIN_CONC.Value()/( DIN_CONC.Value()+P1_SW_N_SAT.Value() ) ), ( PO4_SF_WT_CONC.Value()/( PO4_SF_WT_CONC.Value()+P1_SW_P_SAT.Value() ) ));
			SW_NUT_LIMIT.Update( value );
	  } break;
	}
	return 0;
}

int SEAWEED_module::SW_N_X_u331_exe() {
	float value;

	switch( SW_N_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_N_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SEAWEED_RATE.Value(p)*SF_WT_N_X.Value(p) )*SW_CONC.Value(p) );
			SW_N_X.Update( p, value );
		}
		SW_N_X.GrabMemory();
		if( SW_N_X.GetF(FLinkEdges) ) { SW_N_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SEAWEED_RATE.Value()*SF_WT_N_X.Value() )*SW_CONC.Value() );
			SW_N_X.Update( value );
	  } break;
	}
	return 0;
}

int SEAWEED_module::SW_PROD_LIM_u332_exe() {
	float value;

	switch( SW_PROD_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_PROD_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SF_WATER.Value(p) >  ((float)0) ) ) ? ( ( ( SW_NUT_LIMIT.Value(p)*SW_TEMP_LIM.Value(p) )*SW_LIGHT_LIM.Value(p) ) ) : ( ((float)0) ) ) ;
			SW_PROD_LIM.Update( p, value );
		}
		SW_PROD_LIM.GrabMemory();
		if( SW_PROD_LIM.GetF(FLinkEdges) ) { SW_PROD_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SF_WATER.Value() >  ((float)0) ) ) ? ( ( ( SW_NUT_LIMIT.Value()*SW_TEMP_LIM.Value() )*SW_LIGHT_LIM.Value() ) ) : ( ((float)0) ) ) ;
			SW_PROD_LIM.Update( value );
	  } break;
	}
	return 0;
}

int SEAWEED_module::SW_S_X_u333_exe() {
	float value;

	switch( SW_S_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_S_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SEAWEED_RATE.Value(p)*SF_WT_S_X.Value(p) )*SW_CONC.Value(p) );
			SW_S_X.Update( p, value );
		}
		SW_S_X.GrabMemory();
		if( SW_S_X.GetF(FLinkEdges) ) { SW_S_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SEAWEED_RATE.Value()*SF_WT_S_X.Value() )*SW_CONC.Value() );
			SW_S_X.Update( value );
	  } break;
	}
	return 0;
}

int SEAWEED_module::SW_TEMP_LIM_u334_exe() {
	float value;

	switch( SW_TEMP_LIM.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_TEMP_LIM.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( H2O_TEMP.Value(p)*P1_SW_T_COEFF.Value(p) )/40 );
			SW_TEMP_LIM.Update( p, value );
		}
		SW_TEMP_LIM.GrabMemory();
		if( SW_TEMP_LIM.GetF(FLinkEdges) ) { SW_TEMP_LIM.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( H2O_TEMP.Value()*P1_SW_T_COEFF.Value() )/40 );
			SW_TEMP_LIM.Update( value );
	  } break;
	}
	return 0;
}

int SEAWEED_module::SW_W_X_u335_exe() {
	float value;

	switch( SW_W_X.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SW_W_X.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( SEAWEED_RATE.Value(p)*SF_WT_W_X.Value(p) )*SW_CONC.Value(p) );
			SW_W_X.Update( p, value );
		}
		SW_W_X.GrabMemory();
		if( SW_W_X.GetF(FLinkEdges) ) { SW_W_X.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( SEAWEED_RATE.Value()*SF_WT_W_X.Value() )*SW_CONC.Value() );
			SW_W_X.Update( value );
	  } break;
	}
	return 0;
}

int SEAWEED_module::P1_SW_MORT_RT_u336_exe() {
	float value;

	switch( P1_SW_MORT_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SW_MORT_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  2e-3;
			P1_SW_MORT_RT.Update( p, P1_SW_MORT_RT.ParameterValue(value,p) );
		}
		P1_SW_MORT_RT.GrabMemory();
		if( P1_SW_MORT_RT.GetF(FLinkEdges) ) { P1_SW_MORT_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  2e-3;
			P1_SW_MORT_RT.Update( P1_SW_MORT_RT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int SEAWEED_module::P1_SW_NC_u337_exe() {
	float value;

	switch( P1_SW_NC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SW_NC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.010000;
			P1_SW_NC.Update( p, P1_SW_NC.ParameterValue(value,p) );
		}
		P1_SW_NC.GrabMemory();
		if( P1_SW_NC.GetF(FLinkEdges) ) { P1_SW_NC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.010000;
			P1_SW_NC.Update( P1_SW_NC.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int SEAWEED_module::P1_SW_N_SAT_u338_exe() {
	float value;

	switch( P1_SW_N_SAT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SW_N_SAT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000025;
			P1_SW_N_SAT.Update( p, P1_SW_N_SAT.ParameterValue(value,p) );
		}
		P1_SW_N_SAT.GrabMemory();
		if( P1_SW_N_SAT.GetF(FLinkEdges) ) { P1_SW_N_SAT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000025;
			P1_SW_N_SAT.Update( P1_SW_N_SAT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int SEAWEED_module::P1_SW_PC_u339_exe() {
	float value;

	switch( P1_SW_PC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SW_PC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.005000;
			P1_SW_PC.Update( p, P1_SW_PC.ParameterValue(value,p) );
		}
		P1_SW_PC.GrabMemory();
		if( P1_SW_PC.GetF(FLinkEdges) ) { P1_SW_PC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.005000;
			P1_SW_PC.Update( P1_SW_PC.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int SEAWEED_module::P1_SW_PP_RT_u340_exe() {
	float value;

	switch( P1_SW_PP_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SW_PP_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.012500;
			P1_SW_PP_RT.Update( p, P1_SW_PP_RT.ParameterValue(value,p) );
		}
		P1_SW_PP_RT.GrabMemory();
		if( P1_SW_PP_RT.GetF(FLinkEdges) ) { P1_SW_PP_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.012500;
			P1_SW_PP_RT.Update( P1_SW_PP_RT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int SEAWEED_module::P1_SW_P_SAT_u341_exe() {
	float value;

	switch( P1_SW_P_SAT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SW_P_SAT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000002;
			P1_SW_P_SAT.Update( p, P1_SW_P_SAT.ParameterValue(value,p) );
		}
		P1_SW_P_SAT.GrabMemory();
		if( P1_SW_P_SAT.GetF(FLinkEdges) ) { P1_SW_P_SAT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000002;
			P1_SW_P_SAT.Update( P1_SW_P_SAT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int SEAWEED_module::P1_SW_RESP_RT_u342_exe() {
	float value;

	switch( P1_SW_RESP_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SW_RESP_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000012;
			P1_SW_RESP_RT.Update( p, P1_SW_RESP_RT.ParameterValue(value,p) );
		}
		P1_SW_RESP_RT.GrabMemory();
		if( P1_SW_RESP_RT.GetF(FLinkEdges) ) { P1_SW_RESP_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000012;
			P1_SW_RESP_RT.Update( P1_SW_RESP_RT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int SEAWEED_module::P1_SW_SEEDING_RT_u343_exe() {
	float value;

	switch( P1_SW_SEEDING_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SW_SEEDING_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.010000;
			P1_SW_SEEDING_RT.Update( p, P1_SW_SEEDING_RT.ParameterValue(value,p) );
		}
		P1_SW_SEEDING_RT.GrabMemory();
		if( P1_SW_SEEDING_RT.GetF(FLinkEdges) ) { P1_SW_SEEDING_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.010000;
			P1_SW_SEEDING_RT.Update( P1_SW_SEEDING_RT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int SEAWEED_module::P1_SW_T_COEFF_u344_exe() {
	float value;

	switch( P1_SW_T_COEFF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SW_T_COEFF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.069000;
			P1_SW_T_COEFF.Update( p, P1_SW_T_COEFF.ParameterValue(value,p) );
		}
		P1_SW_T_COEFF.GrabMemory();
		if( P1_SW_T_COEFF.GetF(FLinkEdges) ) { P1_SW_T_COEFF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.069000;
			P1_SW_T_COEFF.Update( P1_SW_T_COEFF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int SEAWEED_module::REPRODUCTION_SEASON_u345_exe() {
	float value;

	switch( REPRODUCTION_SEASON.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = REPRODUCTION_SEASON.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph13(DAYS.Value(p));
			REPRODUCTION_SEASON.Update( p, value );
		}
		REPRODUCTION_SEASON.GrabMemory();
		if( REPRODUCTION_SEASON.GetF(FLinkEdges) ) { REPRODUCTION_SEASON.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph13(DAYS.Value());
			REPRODUCTION_SEASON.Update( value );
	  } break;
	}
	return 0;
}

int SEAWEED_module::SEAWEED_RATE_u346_exe() {
	float value;

	switch( SEAWEED_RATE.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SEAWEED_RATE.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph14(CURRENT_VELOCITY.Value(p));
			SEAWEED_RATE.Update( p, value );
		}
		SEAWEED_RATE.GrabMemory();
		if( SEAWEED_RATE.GetF(FLinkEdges) ) { SEAWEED_RATE.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph14(CURRENT_VELOCITY.Value());
			SEAWEED_RATE.Update( value );
	  } break;
	}
	return 0;
}

SEAWEED_module* SEAWEED_module::fInstance = NULL;
SEAWEED_module* SEAWEED_module::kNullModel = (SEAWEED_module*)0x1;
int SEAWEED_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int SEAWEED_module::InitVars() {
	
	TIME.SSInit(this);
	SEAWEEDS.SSInit(this);
	WATER_DEPTH.SSInit(this);
	P1_CELL_SIZE.SSInit(this);
	SF_WATER.SSInit(this);
	CONS_INGEST_SW.SSInit(this);
	P1_IC_MAC_PHBIO.SSInit(this);
	P1_SEPT_TO_JAN_CONV.SSInit(this);
	SF_WT_E_X.SSInit(this);
	DIN_CONC.SSInit(this);
	PO4_SF_WT_CONC.SSInit(this);
	SF_WT_N_X.SSInit(this);
	SW_LIGHT_LIM.SSInit(this);
	SF_WT_S_X.SSInit(this);
	H2O_TEMP.SSInit(this);
	SF_WT_W_X.SSInit(this);
	DAYS.SSInit(this);
	CURRENT_VELOCITY.SSInit(this);
	SW_GROSS_PP.SSInit(this);
	SW_GROSS_PP.SetDestination(&SEAWEEDS);
	SW_X_IN.SSInit(this);
	SW_X_IN.SetDestination(&SEAWEEDS);
	SW_REPRODUCTION.SSInit(this);
	SW_REPRODUCTION.SetDestination(&SEAWEEDS);
	SW_X_OUT.SSInit(this);
	SW_X_OUT.SetOrigin(&SEAWEEDS);
	SW_RESP.SSInit(this);
	SW_RESP.SetOrigin(&SEAWEEDS);
	SW_CONSUMED.SSInit(this);
	SW_CONSUMED.SetOrigin(&SEAWEEDS);
	SW_MORT.SSInit(this);
	SW_MORT.SetOrigin(&SEAWEEDS);
	IC_SEAWEED.SSInit(this);
	SW_CONC.SSInit(this);
	SW_E_X.SSInit(this);
	SW_E_X.SetLinkEdges();
	SW_NET_PROD.SSInit(this);
	SW_NUT_LIMIT.SSInit(this);
	SW_N_X.SSInit(this);
	SW_N_X.SetLinkEdges();
	SW_PROD_LIM.SSInit(this);
	SW_S_X.SSInit(this);
	SW_S_X.SetLinkEdges();
	SW_TEMP_LIM.SSInit(this);
	SW_W_X.SSInit(this);
	SW_W_X.SetLinkEdges();
	P1_SW_MORT_RT.SSInit(this);
	P1_SW_NC.SSInit(this);
	P1_SW_N_SAT.SSInit(this);
	P1_SW_PC.SSInit(this);
	P1_SW_PP_RT.SSInit(this);
	P1_SW_P_SAT.SSInit(this);
	P1_SW_RESP_RT.SSInit(this);
	P1_SW_SEEDING_RT.SSInit(this);
	P1_SW_T_COEFF.SSInit(this);
	REPRODUCTION_SEASON.SSInit(this);
	SEAWEED_RATE.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int SEAWEED_module::SetupEvents() {
	TExecuteCommand* I317 = (TExecuteCommand*) SEAWEEDS.GetCommand("I317",TCommand::kIntegrate,TCommand::kCode);
	I317->SetExecutable(&SEAWEEDS_I317_exe_g);
	I317->Code() = "I317 <- ( ( ( ( ( ( SW_GROSS_PP+SW_X_IN )+SW_REPRODUCTION )-SW_X_OUT )-SW_RESP )-SW_CONSUMED )-SW_MORT )";
	I317->AddDependency(SW_GROSS_PP);
	I317->AddDependency(SW_X_IN);
	I317->AddDependency(SW_REPRODUCTION);
	I317->AddDependency(SW_X_OUT);
	I317->AddDependency(SW_RESP);
	I317->AddDependency(SW_CONSUMED);
	I317->AddDependency(SW_MORT);
	I317->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i318 = (TExecuteCommand*) SEAWEEDS.GetCommand("i318",TCommand::kInit,TCommand::kCode);
	i318->SetExecutable(&SEAWEEDS_i318_exe_g);
	i318->Code() = "i318 <- ( ( WATER_DEPTH*P1_CELL_SIZE )*IC_SEAWEED )";
	i318->AddDependency(WATER_DEPTH);
	i318->AddDependency(P1_CELL_SIZE);
	i318->AddDependency(IC_SEAWEED);
	i318->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* WATER_DEPTH_import = (TImportCommand*) WATER_DEPTH.GetCommand("WATER_DEPTH_import",TCommand::kUndefined,TCommand::kImport);
	WATER_DEPTH_import->Code() = "Import WATER_DEPTH from GLOBAL_module";
	WATER_DEPTH_import->AddDependency(WATER_DEPTH);
	WATER_DEPTH_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_CELL_SIZE_import = (TImportCommand*) P1_CELL_SIZE.GetCommand("P1_CELL_SIZE_import",TCommand::kUndefined,TCommand::kImport);
	P1_CELL_SIZE_import->Code() = "Import P1_CELL_SIZE from GLOBAL_module";
	P1_CELL_SIZE_import->AddDependency(P1_CELL_SIZE);
	P1_CELL_SIZE_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WATER_import = (TImportCommand*) SF_WATER.GetCommand("SF_WATER_import",TCommand::kUndefined,TCommand::kImport);
	SF_WATER_import->Code() = "Import SF_WATER from GLOBAL_module";
	SF_WATER_import->AddDependency(SF_WATER);
	SF_WATER_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* CONS_INGEST_SW_import = (TImportCommand*) CONS_INGEST_SW.GetCommand("CONS_INGEST_SW_import",TCommand::kUndefined,TCommand::kImport);
	CONS_INGEST_SW_import->Code() = "Import CONS_INGEST_SW from CONSUMERS_module";
	CONS_INGEST_SW_import->AddDependency(CONS_INGEST_SW);
	CONS_INGEST_SW_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_IC_MAC_PHBIO_import = (TImportCommand*) P1_IC_MAC_PHBIO.GetCommand("P1_IC_MAC_PHBIO_import",TCommand::kUndefined,TCommand::kImport);
	P1_IC_MAC_PHBIO_import->Code() = "Import P1_IC_MAC_PHBIO from EELGRASS_module";
	P1_IC_MAC_PHBIO_import->AddDependency(P1_IC_MAC_PHBIO);
	P1_IC_MAC_PHBIO_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_SEPT_TO_JAN_CONV_import = (TImportCommand*) P1_SEPT_TO_JAN_CONV.GetCommand("P1_SEPT_TO_JAN_CONV_import",TCommand::kUndefined,TCommand::kImport);
	P1_SEPT_TO_JAN_CONV_import->Code() = "Import P1_SEPT_TO_JAN_CONV from EELGRASS_module";
	P1_SEPT_TO_JAN_CONV_import->AddDependency(P1_SEPT_TO_JAN_CONV);
	P1_SEPT_TO_JAN_CONV_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WT_E_X_import = (TImportCommand*) SF_WT_E_X.GetCommand("SF_WT_E_X_import",TCommand::kUndefined,TCommand::kImport);
	SF_WT_E_X_import->Code() = "Import SF_WT_E_X from GLOBAL_module";
	SF_WT_E_X_import->AddDependency(SF_WT_E_X);
	SF_WT_E_X_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DIN_CONC_import = (TImportCommand*) DIN_CONC.GetCommand("DIN_CONC_import",TCommand::kUndefined,TCommand::kImport);
	DIN_CONC_import->Code() = "Import DIN_CONC from DIN_module";
	DIN_CONC_import->AddDependency(DIN_CONC);
	DIN_CONC_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* PO4_SF_WT_CONC_import = (TImportCommand*) PO4_SF_WT_CONC.GetCommand("PO4_SF_WT_CONC_import",TCommand::kUndefined,TCommand::kImport);
	PO4_SF_WT_CONC_import->Code() = "Import PO4_SF_WT_CONC from PHOSPHATE_module";
	PO4_SF_WT_CONC_import->AddDependency(PO4_SF_WT_CONC);
	PO4_SF_WT_CONC_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WT_N_X_import = (TImportCommand*) SF_WT_N_X.GetCommand("SF_WT_N_X_import",TCommand::kUndefined,TCommand::kImport);
	SF_WT_N_X_import->Code() = "Import SF_WT_N_X from GLOBAL_module";
	SF_WT_N_X_import->AddDependency(SF_WT_N_X);
	SF_WT_N_X_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SW_LIGHT_LIM_import = (TImportCommand*) SW_LIGHT_LIM.GetCommand("SW_LIGHT_LIM_import",TCommand::kUndefined,TCommand::kImport);
	SW_LIGHT_LIM_import->Code() = "Import SW_LIGHT_LIM from GLOBAL_module";
	SW_LIGHT_LIM_import->AddDependency(SW_LIGHT_LIM);
	SW_LIGHT_LIM_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WT_S_X_import = (TImportCommand*) SF_WT_S_X.GetCommand("SF_WT_S_X_import",TCommand::kUndefined,TCommand::kImport);
	SF_WT_S_X_import->Code() = "Import SF_WT_S_X from GLOBAL_module";
	SF_WT_S_X_import->AddDependency(SF_WT_S_X);
	SF_WT_S_X_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* H2O_TEMP_import = (TImportCommand*) H2O_TEMP.GetCommand("H2O_TEMP_import",TCommand::kUndefined,TCommand::kImport);
	H2O_TEMP_import->Code() = "Import H2O_TEMP from GLOBAL_module";
	H2O_TEMP_import->AddDependency(H2O_TEMP);
	H2O_TEMP_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WT_W_X_import = (TImportCommand*) SF_WT_W_X.GetCommand("SF_WT_W_X_import",TCommand::kUndefined,TCommand::kImport);
	SF_WT_W_X_import->Code() = "Import SF_WT_W_X from GLOBAL_module";
	SF_WT_W_X_import->AddDependency(SF_WT_W_X);
	SF_WT_W_X_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* DAYS_import = (TImportCommand*) DAYS.GetCommand("DAYS_import",TCommand::kUndefined,TCommand::kImport);
	DAYS_import->Code() = "Import DAYS from GLOBAL_module";
	DAYS_import->AddDependency(DAYS);
	DAYS_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* CURRENT_VELOCITY_import = (TImportCommand*) CURRENT_VELOCITY.GetCommand("CURRENT_VELOCITY_import",TCommand::kUndefined,TCommand::kImport);
	CURRENT_VELOCITY_import->Code() = "Import CURRENT_VELOCITY from GLOBAL_module";
	CURRENT_VELOCITY_import->AddDependency(CURRENT_VELOCITY);
	CURRENT_VELOCITY_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u319 = (TExecuteCommand*) SW_GROSS_PP.GetCommand("u319",TCommand::kUpdate,TCommand::kCode);
	u319->SetExecutable(&SW_GROSS_PP_u319_exe_g);
	u319->Code() = "u319 <- ( ( SW_PROD_LIM*( P1_SW_PP_RT/dT() ) )*SEAWEEDS )";
	u319->AddDependency(SW_PROD_LIM);
	u319->AddDependency(P1_SW_PP_RT);
	u319->AddDependency(SEAWEEDS);
	u319->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u320 = (TExecuteCommand*) SW_X_IN.GetCommand("u320",TCommand::kUpdate,TCommand::kCode);
	u320->SetExecutable(&SW_X_IN_u320_exe_g);
	u320->Code() = "u320 <- ( ( ( SW_E_X@(0,-1,0)+SW_N_X@(1,0,0) )+SW_W_X@(0,1,0) )+SW_S_X@(-1,0,0) )";
	u320->AddDependency(SW_E_X,"0,-1,0");
	u320->AddDependency(SW_N_X,"1,0,0");
	u320->AddDependency(SW_W_X,"0,1,0");
	u320->AddDependency(SW_S_X,"-1,0,0");
	u320->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u321 = (TExecuteCommand*) SW_REPRODUCTION.GetCommand("u321",TCommand::kUpdate,TCommand::kCode);
	u321->SetExecutable(&SW_REPRODUCTION_u321_exe_g);
	u321->Code() = "u321 <-  ( ( ( REPRODUCTION_SEASON <  ((float)1) ) ) ? ( ((float)0) ) : (  ( ( ( SL::Rand(((float)0), ((float)1)) <  0.1 ) ) ? ( P1_SW_SEEDING_RT ) : ( ((float)0) ) )  ) ) ";
	u321->AddDependency(REPRODUCTION_SEASON);
	u321->AddDependency(P1_SW_SEEDING_RT);
	u321->AddDependency(TIME);
	u321->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u322 = (TExecuteCommand*) SW_X_OUT.GetCommand("u322",TCommand::kUpdate,TCommand::kCode);
	u322->SetExecutable(&SW_X_OUT_u322_exe_g);
	u322->Code() = "u322 <- ( ( ( SW_E_X+SW_W_X )+SW_S_X )+SW_N_X )";
	if( SW_X_OUT.GetF(FisClamped) ) { u322->AddDependency(SEAWEEDS); }
	u322->AddDependency(SW_E_X);
	u322->AddDependency(SW_W_X);
	u322->AddDependency(SW_S_X);
	u322->AddDependency(SW_N_X);
	u322->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u323 = (TExecuteCommand*) SW_RESP.GetCommand("u323",TCommand::kUpdate,TCommand::kCode);
	u323->SetExecutable(&SW_RESP_u323_exe_g);
	u323->Code() = "u323 <-  ( ( ( SF_WATER >  ((float)0) ) ) ? ( ( ( ( P1_SW_RESP_RT*dT() )*SW_TEMP_LIM )*SEAWEEDS ) ) : ( ((float)0) ) ) ";
	if( SW_RESP.GetF(FisClamped) ) { u323->AddDependency(SEAWEEDS); }
	u323->AddDependency(SF_WATER);
	u323->AddDependency(P1_SW_RESP_RT);
	u323->AddDependency(SW_TEMP_LIM);
	u323->AddDependency(SEAWEEDS);
	u323->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u324 = (TExecuteCommand*) SW_CONSUMED.GetCommand("u324",TCommand::kUpdate,TCommand::kCode);
	u324->SetExecutable(&SW_CONSUMED_u324_exe_g);
	u324->Code() = "u324 <- CONS_INGEST_SW";
	if( SW_CONSUMED.GetF(FisClamped) ) { u324->AddDependency(SEAWEEDS); }
	u324->AddDependency(CONS_INGEST_SW);
	u324->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u325 = (TExecuteCommand*) SW_MORT.GetCommand("u325",TCommand::kUpdate,TCommand::kCode);
	u325->SetExecutable(&SW_MORT_u325_exe_g);
	u325->Code() = "u325 <- ( SEAWEEDS*( P1_SW_MORT_RT*dT() ) )";
	if( SW_MORT.GetF(FisClamped) ) { u325->AddDependency(SEAWEEDS); }
	u325->AddDependency(SEAWEEDS);
	u325->AddDependency(P1_SW_MORT_RT);
	u325->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u326 = (TExecuteCommand*) IC_SEAWEED.GetCommand("u326",TCommand::kUpdate,TCommand::kCode);
	u326->SetExecutable(&IC_SEAWEED_u326_exe_g);
	u326->Code() = "u326 <- ( ( P1_IC_MAC_PHBIO/P1_SEPT_TO_JAN_CONV )*0.05 )";
	u326->AddDependency(P1_IC_MAC_PHBIO);
	u326->AddDependency(P1_SEPT_TO_JAN_CONV);
	u326->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u327 = (TExecuteCommand*) SW_CONC.GetCommand("u327",TCommand::kUpdate,TCommand::kCode);
	u327->SetExecutable(&SW_CONC_u327_exe_g);
	u327->Code() = "u327 <-  ( ( ( WATER_DEPTH >  0.01 ) ) ? ( ( SEAWEEDS/SF_WATER ) ) : ( ((float)0) ) ) ";
	u327->AddDependency(WATER_DEPTH);
	u327->AddDependency(SEAWEEDS);
	u327->AddDependency(SF_WATER);
	u327->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u328 = (TExecuteCommand*) SW_E_X.GetCommand("u328",TCommand::kUpdate,TCommand::kCode);
	u328->SetExecutable(&SW_E_X_u328_exe_g);
	u328->Code() = "u328 <- ( ( SEAWEED_RATE*SF_WT_E_X )*SW_CONC )";
	u328->AddDependency(SEAWEED_RATE);
	u328->AddDependency(SF_WT_E_X);
	u328->AddDependency(SW_CONC);
	u328->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u329 = (TExecuteCommand*) SW_NET_PROD.GetCommand("u329",TCommand::kUpdate,TCommand::kCode);
	u329->SetExecutable(&SW_NET_PROD_u329_exe_g);
	u329->Code() = "u329 <- ( SW_GROSS_PP-SW_RESP )";
	u329->AddDependency(SW_GROSS_PP);
	u329->AddDependency(SW_RESP);
	u329->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u330 = (TExecuteCommand*) SW_NUT_LIMIT.GetCommand("u330",TCommand::kUpdate,TCommand::kCode);
	u330->SetExecutable(&SW_NUT_LIMIT_u330_exe_g);
	u330->Code() = "u330 <- SL::Min(( DIN_CONC/( DIN_CONC+P1_SW_N_SAT ) ), ( PO4_SF_WT_CONC/( PO4_SF_WT_CONC+P1_SW_P_SAT ) ))";
	u330->AddDependency(DIN_CONC);
	u330->AddDependency(P1_SW_N_SAT);
	u330->AddDependency(PO4_SF_WT_CONC);
	u330->AddDependency(P1_SW_P_SAT);
	u330->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u331 = (TExecuteCommand*) SW_N_X.GetCommand("u331",TCommand::kUpdate,TCommand::kCode);
	u331->SetExecutable(&SW_N_X_u331_exe_g);
	u331->Code() = "u331 <- ( ( SEAWEED_RATE*SF_WT_N_X )*SW_CONC )";
	u331->AddDependency(SEAWEED_RATE);
	u331->AddDependency(SF_WT_N_X);
	u331->AddDependency(SW_CONC);
	u331->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u332 = (TExecuteCommand*) SW_PROD_LIM.GetCommand("u332",TCommand::kUpdate,TCommand::kCode);
	u332->SetExecutable(&SW_PROD_LIM_u332_exe_g);
	u332->Code() = "u332 <-  ( ( ( SF_WATER >  ((float)0) ) ) ? ( ( ( SW_NUT_LIMIT*SW_TEMP_LIM )*SW_LIGHT_LIM ) ) : ( ((float)0) ) ) ";
	u332->AddDependency(SF_WATER);
	u332->AddDependency(SW_NUT_LIMIT);
	u332->AddDependency(SW_TEMP_LIM);
	u332->AddDependency(SW_LIGHT_LIM);
	u332->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u333 = (TExecuteCommand*) SW_S_X.GetCommand("u333",TCommand::kUpdate,TCommand::kCode);
	u333->SetExecutable(&SW_S_X_u333_exe_g);
	u333->Code() = "u333 <- ( ( SEAWEED_RATE*SF_WT_S_X )*SW_CONC )";
	u333->AddDependency(SEAWEED_RATE);
	u333->AddDependency(SF_WT_S_X);
	u333->AddDependency(SW_CONC);
	u333->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u334 = (TExecuteCommand*) SW_TEMP_LIM.GetCommand("u334",TCommand::kUpdate,TCommand::kCode);
	u334->SetExecutable(&SW_TEMP_LIM_u334_exe_g);
	u334->Code() = "u334 <- ( ( H2O_TEMP*P1_SW_T_COEFF )/40 )";
	u334->AddDependency(H2O_TEMP);
	u334->AddDependency(P1_SW_T_COEFF);
	u334->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u335 = (TExecuteCommand*) SW_W_X.GetCommand("u335",TCommand::kUpdate,TCommand::kCode);
	u335->SetExecutable(&SW_W_X_u335_exe_g);
	u335->Code() = "u335 <- ( ( SEAWEED_RATE*SF_WT_W_X )*SW_CONC )";
	u335->AddDependency(SEAWEED_RATE);
	u335->AddDependency(SF_WT_W_X);
	u335->AddDependency(SW_CONC);
	u335->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u336 = (TExecuteCommand*) P1_SW_MORT_RT.GetCommand("u336",TCommand::kUpdate,TCommand::kCode);
	u336->SetExecutable(&P1_SW_MORT_RT_u336_exe_g);
	u336->Code() = "u336 <- 2e-3";
	u336->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u337 = (TExecuteCommand*) P1_SW_NC.GetCommand("u337",TCommand::kUpdate,TCommand::kCode);
	u337->SetExecutable(&P1_SW_NC_u337_exe_g);
	u337->Code() = "u337 <- 0.010000";
	u337->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u338 = (TExecuteCommand*) P1_SW_N_SAT.GetCommand("u338",TCommand::kUpdate,TCommand::kCode);
	u338->SetExecutable(&P1_SW_N_SAT_u338_exe_g);
	u338->Code() = "u338 <- 0.000025";
	u338->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u339 = (TExecuteCommand*) P1_SW_PC.GetCommand("u339",TCommand::kUpdate,TCommand::kCode);
	u339->SetExecutable(&P1_SW_PC_u339_exe_g);
	u339->Code() = "u339 <- 0.005000";
	u339->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u340 = (TExecuteCommand*) P1_SW_PP_RT.GetCommand("u340",TCommand::kUpdate,TCommand::kCode);
	u340->SetExecutable(&P1_SW_PP_RT_u340_exe_g);
	u340->Code() = "u340 <- 0.012500";
	u340->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u341 = (TExecuteCommand*) P1_SW_P_SAT.GetCommand("u341",TCommand::kUpdate,TCommand::kCode);
	u341->SetExecutable(&P1_SW_P_SAT_u341_exe_g);
	u341->Code() = "u341 <- 0.000002";
	u341->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u342 = (TExecuteCommand*) P1_SW_RESP_RT.GetCommand("u342",TCommand::kUpdate,TCommand::kCode);
	u342->SetExecutable(&P1_SW_RESP_RT_u342_exe_g);
	u342->Code() = "u342 <- 0.000012";
	u342->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u343 = (TExecuteCommand*) P1_SW_SEEDING_RT.GetCommand("u343",TCommand::kUpdate,TCommand::kCode);
	u343->SetExecutable(&P1_SW_SEEDING_RT_u343_exe_g);
	u343->Code() = "u343 <- 0.010000";
	u343->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u344 = (TExecuteCommand*) P1_SW_T_COEFF.GetCommand("u344",TCommand::kUpdate,TCommand::kCode);
	u344->SetExecutable(&P1_SW_T_COEFF_u344_exe_g);
	u344->Code() = "u344 <- 0.069000";
	u344->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u345 = (TExecuteCommand*) REPRODUCTION_SEASON.GetCommand("u345",TCommand::kUpdate,TCommand::kCode);
	u345->SetExecutable(&REPRODUCTION_SEASON_u345_exe_g);
	u345->Code() = "u345 <- Graph13(DAYS)";
	u345->AddDependency(DAYS);
	u345->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u346 = (TExecuteCommand*) SEAWEED_RATE.GetCommand("u346",TCommand::kUpdate,TCommand::kCode);
	u346->SetExecutable(&SEAWEED_RATE_u346_exe_g);
	u346->Code() = "u346 <- Graph14(CURRENT_VELOCITY)";
	u346->AddDependency(CURRENT_VELOCITY);
	u346->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int SEAWEED_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int SEAWEED_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int SEAWEED_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int SEAWEED_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}

// ---------------------------------------------------------------------------
//                    Class TSS_module 
// ---------------------------------------------------------------------------
TSS_module::TSS_module(char* name) :
	TIME("TIME"),
	TSS_CONC("TSS_CONC"),
	SF_WATER("SF_WATER"),
	WATER_DEPTH("WATER_DEPTH"),
	VEG_STRUCTURE("VEG_STRUCTURE"),
	SHEAR_STRESS("SHEAR_STRESS"),
	P1_RIVER_DATA_CF("P1_RIVER_DATA_CF"),
	SF_WT_E_X("SF_WT_E_X"),
	SF_WT_N_X("SF_WT_N_X"),
	SF_WT_S_X("SF_WT_S_X"),
	SF_WT_W_X("SF_WT_W_X"),
	SUS_SED("SUS_SED"),
	SED_SUSP("SED_SUSP"),
	TSS_X_IN("TSS_X_IN"),
	TSS_X_OUT("TSS_X_OUT"),
	SED_DEPO("SED_DEPO"),
	RIVER_TSS("RIVER_TSS"),
	SETTLING_VELOCITY("SETTLING_VELOCITY"),
	SHEAR_RES("SHEAR_RES"),
	STRESS_EFFECT("STRESS_EFFECT"),
	TSS_X_E("TSS_X_E"),
	TSS_X_N("TSS_X_N"),
	TSS_X_S("TSS_X_S"),
	TSS_X_W("TSS_X_W"),
	P1_IC_TSS("P1_IC_TSS"),
	P1_RESISTANCE_COEFF("P1_RESISTANCE_COEFF"),
	P1_SETTLING_RT("P1_SETTLING_RT"),
	EDDY_VISCOSITY("EDDY_VISCOSITY"),
	POT_EROS("POT_EROS"),
	TModule(name) {

	TSS_CONC.SetF(FisExport,True,"CG");
	SF_WATER.SetF(FisImport,True,"CG");
	WATER_DEPTH.SetF(FisImport,True,"CG");
	VEG_STRUCTURE.SetF(FisImport,True,"CG");
	SHEAR_STRESS.SetF(FisImport,True,"CG");
	P1_RIVER_DATA_CF.SetF(FisImport,True,"CG");
	SF_WT_E_X.SetF(FisImport,True,"CG");
	SF_WT_N_X.SetF(FisImport,True,"CG");
	SF_WT_S_X.SetF(FisImport,True,"CG");
	SF_WT_W_X.SetF(FisImport,True,"CG");
}	
int TSS_module::SUS_SED_I347_exe() {
	float value;

	SUS_SED.UpdateIntegrator();
	switch( SUS_SED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SUS_SED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( SED_SUSP.Value(p)+TSS_X_IN.Value(p) )-TSS_X_OUT.Value(p) )-SED_DEPO.Value(p) );
			SUS_SED.Update( p, value, dT() );
		}
		SUS_SED.GrabMemory();
		if( SUS_SED.GetF(FLinkEdges) ) { SUS_SED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( SED_SUSP.Value()+TSS_X_IN.Value() )-TSS_X_OUT.Value() )-SED_DEPO.Value() );
			SUS_SED.Update( value, dT() );
	  } break;
	}
	return 0;
}

int TSS_module::SUS_SED_i348_exe() {
	float value;

	SUS_SED.UpdateIntegrator();
	switch( SUS_SED.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SUS_SED.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SF_WATER.Value(p)*P1_IC_TSS.Value(p) );
			SUS_SED.InitValue( p, value );
		}
		SUS_SED.GrabMemory();
		if( SUS_SED.GetF(FLinkEdges) ) { SUS_SED.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SF_WATER.Value()*P1_IC_TSS.Value() );
			SUS_SED.InitValue( value );
	  } break;
	}
	return 0;
}

int TSS_module::SED_SUSP_u349_exe() {
	float value;

	switch( SED_SUSP.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SED_SUSP.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( POT_EROS.Value(p) >  ((float)0) ) ) ? ( POT_EROS.Value(p) ) : ( ((float)0) ) ) ;
			SED_SUSP.Update( p, value );
		}
		SED_SUSP.GrabMemory();
		if( SED_SUSP.GetF(FICFlux) ) SED_SUSP.Cov().Set(0.0); 
		if( SED_SUSP.GetF(FLinkEdges) ) { SED_SUSP.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( POT_EROS.Value() >  ((float)0) ) ) ? ( POT_EROS.Value() ) : ( ((float)0) ) ) ;
			SED_SUSP.Update( value );
	  } break;
	}
	return 0;
}

int TSS_module::TSS_X_IN_u350_exe() {
	float value;

	switch( TSS_X_IN.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TSS_X_IN.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( TSS_X_E.RelValue(p,0,-1,0,CVariable::kDefaultBC)+TSS_X_N.RelValue(p,1,0,0,CVariable::kDefaultBC) )+TSS_X_S.RelValue(p,-1,0,0,CVariable::kDefaultBC) )+TSS_X_W.RelValue(p,0,1,0,CVariable::kDefaultBC) );
			TSS_X_IN.Update( p, value );
		}
		TSS_X_IN.GrabMemory();
		if( TSS_X_IN.GetF(FICFlux) ) TSS_X_IN.Cov().Set(0.0); 
		if( TSS_X_IN.GetF(FLinkEdges) ) { TSS_X_IN.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( TSS_X_E.Value()+TSS_X_N.Value() )+TSS_X_S.Value() )+TSS_X_W.Value() );
			TSS_X_IN.Update( value );
	  } break;
	}
	return 0;
}

int TSS_module::TSS_X_OUT_u351_exe() {
	float value;

	switch( TSS_X_OUT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TSS_X_OUT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( ( ( TSS_X_E.Value(p)+TSS_X_N.Value(p) )+TSS_X_W.Value(p) )+TSS_X_S.Value(p) );
			TSS_X_OUT.Update( p, value );
		}
		TSS_X_OUT.GrabMemory();
		if( TSS_X_OUT.GetF(FICFlux) ) TSS_X_OUT.Cov().Set(0.0); 
		if( TSS_X_OUT.GetF(FLinkEdges) ) { TSS_X_OUT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( ( ( TSS_X_E.Value()+TSS_X_N.Value() )+TSS_X_W.Value() )+TSS_X_S.Value() );
			TSS_X_OUT.Update( value );
	  } break;
	}
	return 0;
}

int TSS_module::SED_DEPO_u352_exe() {
	float value;

	switch( SED_DEPO.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SED_DEPO.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SETTLING_VELOCITY.Value(p) >  WATER_DEPTH.Value(p) ) ) ? ( SUS_SED.Value(p) ) : ( ( ( ( SETTLING_VELOCITY.Value(p)/WATER_DEPTH.Value(p) )/dT() )*SUS_SED.Value(p) ) ) ) ;
			SED_DEPO.Update( p, value );
		}
		SED_DEPO.GrabMemory();
		if( SED_DEPO.GetF(FICFlux) ) SED_DEPO.Cov().Set(0.0); 
		if( SED_DEPO.GetF(FLinkEdges) ) { SED_DEPO.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SETTLING_VELOCITY.Value() >  WATER_DEPTH.Value() ) ) ? ( SUS_SED.Value() ) : ( ( ( ( SETTLING_VELOCITY.Value()/WATER_DEPTH.Value() )/dT() )*SUS_SED.Value() ) ) ) ;
			SED_DEPO.Update( value );
	  } break;
	}
	return 0;
}

int TSS_module::RIVER_TSS_u353_exe() {
	float value;

	switch( RIVER_TSS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = RIVER_TSS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0;
			RIVER_TSS.Update( p, RIVER_TSS.ParameterValue(value,p) );
		}
		RIVER_TSS.GrabMemory();
		if( RIVER_TSS.GetF(FLinkEdges) ) { RIVER_TSS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0;
			RIVER_TSS.Update( RIVER_TSS.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int TSS_module::SETTLING_VELOCITY_u354_exe() {
	float value;

	switch( SETTLING_VELOCITY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SETTLING_VELOCITY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  SL::Min(P1_SETTLING_RT.Value(p), ( P1_SETTLING_RT.Value(p)/EDDY_VISCOSITY.Value(p) ));
			SETTLING_VELOCITY.Update( p, value );
		}
		SETTLING_VELOCITY.GrabMemory();
		if( SETTLING_VELOCITY.GetF(FLinkEdges) ) { SETTLING_VELOCITY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  SL::Min(P1_SETTLING_RT.Value(), ( P1_SETTLING_RT.Value()/EDDY_VISCOSITY.Value() ));
			SETTLING_VELOCITY.Update( value );
	  } break;
	}
	return 0;
}

int TSS_module::SHEAR_RES_u355_exe() {
	float value;

	switch( SHEAR_RES.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = SHEAR_RES.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( P1_RESISTANCE_COEFF.Value(p)*( ((float)1)+VEG_STRUCTURE.Value(p) ) );
			SHEAR_RES.Update( p, value );
		}
		SHEAR_RES.GrabMemory();
		if( SHEAR_RES.GetF(FLinkEdges) ) { SHEAR_RES.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( P1_RESISTANCE_COEFF.Value()*( ((float)1)+VEG_STRUCTURE.Value() ) );
			SHEAR_RES.Update( value );
	  } break;
	}
	return 0;
}

int TSS_module::STRESS_EFFECT_u356_exe() {
	float value;

	switch( STRESS_EFFECT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = STRESS_EFFECT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SHEAR_STRESS.Value(p) >  SHEAR_RES.Value(p) ) ) ? ( ( SHEAR_STRESS.Value(p)-SHEAR_RES.Value(p) ) ) : ( ((float)0) ) ) ;
			STRESS_EFFECT.Update( p, value );
		}
		STRESS_EFFECT.GrabMemory();
		if( STRESS_EFFECT.GetF(FLinkEdges) ) { STRESS_EFFECT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SHEAR_STRESS.Value() >  SHEAR_RES.Value() ) ) ? ( ( SHEAR_STRESS.Value()-SHEAR_RES.Value() ) ) : ( ((float)0) ) ) ;
			STRESS_EFFECT.Update( value );
	  } break;
	}
	return 0;
}

int TSS_module::TSS_CONC_u357_exe() {
	float value;

	switch( TSS_CONC.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TSS_CONC.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =   ( ( ( SF_WATER.Value(p) <= ((float)0) ) ) ? ( ((float)0) ) : ( SL::Max(( ( RIVER_TSS.Value(p)*P1_RIVER_DATA_CF.Value(p) )+( SUS_SED.Value(p)/SF_WATER.Value(p) ) ), ((float)0)) ) ) ;
			TSS_CONC.Update( p, value );
		}
		TSS_CONC.GrabMemory();
		if( TSS_CONC.GetF(FLinkEdges) ) { TSS_CONC.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =   ( ( ( SF_WATER.Value() <= ((float)0) ) ) ? ( ((float)0) ) : ( SL::Max(( ( RIVER_TSS.Value()*P1_RIVER_DATA_CF.Value() )+( SUS_SED.Value()/SF_WATER.Value() ) ), ((float)0)) ) ) ;
			TSS_CONC.Update( value );
	  } break;
	}
	return 0;
}

int TSS_module::TSS_X_E_u358_exe() {
	float value;

	switch( TSS_X_E.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TSS_X_E.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SF_WT_E_X.Value(p)*TSS_CONC.Value(p) );
			TSS_X_E.Update( p, value );
		}
		TSS_X_E.GrabMemory();
		if( TSS_X_E.GetF(FLinkEdges) ) { TSS_X_E.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SF_WT_E_X.Value()*TSS_CONC.Value() );
			TSS_X_E.Update( value );
	  } break;
	}
	return 0;
}

int TSS_module::TSS_X_N_u359_exe() {
	float value;

	switch( TSS_X_N.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TSS_X_N.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SF_WT_N_X.Value(p)*TSS_CONC.Value(p) );
			TSS_X_N.Update( p, value );
		}
		TSS_X_N.GrabMemory();
		if( TSS_X_N.GetF(FLinkEdges) ) { TSS_X_N.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SF_WT_N_X.Value()*TSS_CONC.Value() );
			TSS_X_N.Update( value );
	  } break;
	}
	return 0;
}

int TSS_module::TSS_X_S_u360_exe() {
	float value;

	switch( TSS_X_S.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TSS_X_S.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SF_WT_S_X.Value(p)*TSS_CONC.Value(p) );
			TSS_X_S.Update( p, value );
		}
		TSS_X_S.GrabMemory();
		if( TSS_X_S.GetF(FLinkEdges) ) { TSS_X_S.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SF_WT_S_X.Value()*TSS_CONC.Value() );
			TSS_X_S.Update( value );
	  } break;
	}
	return 0;
}

int TSS_module::TSS_X_W_u361_exe() {
	float value;

	switch( TSS_X_W.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = TSS_X_W.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  ( SF_WT_W_X.Value(p)*TSS_CONC.Value(p) );
			TSS_X_W.Update( p, value );
		}
		TSS_X_W.GrabMemory();
		if( TSS_X_W.GetF(FLinkEdges) ) { TSS_X_W.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  ( SF_WT_W_X.Value()*TSS_CONC.Value() );
			TSS_X_W.Update( value );
	  } break;
	}
	return 0;
}

int TSS_module::P1_IC_TSS_u362_exe() {
	float value;

	switch( P1_IC_TSS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_IC_TSS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.008000;
			P1_IC_TSS.Update( p, P1_IC_TSS.ParameterValue(value,p) );
		}
		P1_IC_TSS.GrabMemory();
		if( P1_IC_TSS.GetF(FLinkEdges) ) { P1_IC_TSS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.008000;
			P1_IC_TSS.Update( P1_IC_TSS.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int TSS_module::P1_RESISTANCE_COEFF_u363_exe() {
	float value;

	switch( P1_RESISTANCE_COEFF.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_RESISTANCE_COEFF.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.000100;
			P1_RESISTANCE_COEFF.Update( p, P1_RESISTANCE_COEFF.ParameterValue(value,p) );
		}
		P1_RESISTANCE_COEFF.GrabMemory();
		if( P1_RESISTANCE_COEFF.GetF(FLinkEdges) ) { P1_RESISTANCE_COEFF.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.000100;
			P1_RESISTANCE_COEFF.Update( P1_RESISTANCE_COEFF.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int TSS_module::P1_SETTLING_RT_u364_exe() {
	float value;

	switch( P1_SETTLING_RT.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = P1_SETTLING_RT.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  0.046800;
			P1_SETTLING_RT.Update( p, P1_SETTLING_RT.ParameterValue(value,p) );
		}
		P1_SETTLING_RT.GrabMemory();
		if( P1_SETTLING_RT.GetF(FLinkEdges) ) { P1_SETTLING_RT.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  0.046800;
			P1_SETTLING_RT.Update( P1_SETTLING_RT.ParameterValue(value) );
	  } break;
	}
	return 0;
}

int TSS_module::EDDY_VISCOSITY_u365_exe() {
	float value;

	switch( EDDY_VISCOSITY.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = EDDY_VISCOSITY.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph15(SHEAR_STRESS.Value(p));
			EDDY_VISCOSITY.Update( p, value );
		}
		EDDY_VISCOSITY.GrabMemory();
		if( EDDY_VISCOSITY.GetF(FLinkEdges) ) { EDDY_VISCOSITY.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph15(SHEAR_STRESS.Value());
			EDDY_VISCOSITY.Update( value );
	  } break;
	}
	return 0;
}

int TSS_module::POT_EROS_u366_exe() {
	float value;

	switch( POT_EROS.UpdateMode() ) {
	  case CVariable::kFastSpatial: 
	  case CVariable::kSpatial: {
		DistributedGrid& g = POT_EROS.Grid();
		for( TCell* p = (TCell*)g.first(); g.onGrid(p); g.next(p) ) {
			 value =  Graph16(STRESS_EFFECT.Value(p));
			POT_EROS.Update( p, value );
		}
		POT_EROS.GrabMemory();
		if( POT_EROS.GetF(FLinkEdges) ) { POT_EROS.LinkEdges(); }
	  } break;
	  case CVariable::kTemporal: {
			 value =  Graph16(STRESS_EFFECT.Value());
			POT_EROS.Update( value );
	  } break;
	}
	return 0;
}

TSS_module* TSS_module::fInstance = NULL;
TSS_module* TSS_module::kNullModel = (TSS_module*)0x1;
int TSS_module::InitArrays() {
	int index, is_dimension_name;
	
	return 0;
}

int TSS_module::InitVars() {
	
	TIME.SSInit(this);
	TSS_CONC.SSInit(this);
	SF_WATER.SSInit(this);
	WATER_DEPTH.SSInit(this);
	VEG_STRUCTURE.SSInit(this);
	SHEAR_STRESS.SSInit(this);
	P1_RIVER_DATA_CF.SSInit(this);
	SF_WT_E_X.SSInit(this);
	SF_WT_N_X.SSInit(this);
	SF_WT_S_X.SSInit(this);
	SF_WT_W_X.SSInit(this);
	SUS_SED.SSInit(this);
	SED_SUSP.SSInit(this);
	SED_SUSP.SetDestination(&SUS_SED);
	TSS_X_IN.SSInit(this);
	TSS_X_IN.SetDestination(&SUS_SED);
	TSS_X_OUT.SSInit(this);
	TSS_X_OUT.SetOrigin(&SUS_SED);
	SED_DEPO.SSInit(this);
	SED_DEPO.SetOrigin(&SUS_SED);
	RIVER_TSS.SSInit(this);
	SETTLING_VELOCITY.SSInit(this);
	SHEAR_RES.SSInit(this);
	STRESS_EFFECT.SSInit(this);
	TSS_X_E.SSInit(this);
	TSS_X_E.SetLinkEdges();
	TSS_X_N.SSInit(this);
	TSS_X_N.SetLinkEdges();
	TSS_X_S.SSInit(this);
	TSS_X_S.SetLinkEdges();
	TSS_X_W.SSInit(this);
	TSS_X_W.SetLinkEdges();
	P1_IC_TSS.SSInit(this);
	P1_RESISTANCE_COEFF.SSInit(this);
	P1_SETTLING_RT.SSInit(this);
	EDDY_VISCOSITY.SSInit(this);
	POT_EROS.SSInit(this);
	fVarList.Alphabetize();
	return 0;
}

int TSS_module::SetupEvents() {
	TExecuteCommand* u357 = (TExecuteCommand*) TSS_CONC.GetCommand("u357",TCommand::kUpdate,TCommand::kCode);
	u357->SetExecutable(&TSS_CONC_u357_exe_g);
	u357->Code() = "u357 <-  ( ( ( SF_WATER <= ((float)0) ) ) ? ( ((float)0) ) : ( SL::Max(( ( RIVER_TSS*P1_RIVER_DATA_CF )+( SUS_SED/SF_WATER ) ), ((float)0)) ) ) ";
	u357->AddDependency(SF_WATER);
	u357->AddDependency(RIVER_TSS);
	u357->AddDependency(P1_RIVER_DATA_CF);
	u357->AddDependency(SUS_SED);
	u357->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WATER_import = (TImportCommand*) SF_WATER.GetCommand("SF_WATER_import",TCommand::kUndefined,TCommand::kImport);
	SF_WATER_import->Code() = "Import SF_WATER from GLOBAL_module";
	SF_WATER_import->AddDependency(SF_WATER);
	SF_WATER_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* WATER_DEPTH_import = (TImportCommand*) WATER_DEPTH.GetCommand("WATER_DEPTH_import",TCommand::kUndefined,TCommand::kImport);
	WATER_DEPTH_import->Code() = "Import WATER_DEPTH from GLOBAL_module";
	WATER_DEPTH_import->AddDependency(WATER_DEPTH);
	WATER_DEPTH_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* VEG_STRUCTURE_import = (TImportCommand*) VEG_STRUCTURE.GetCommand("VEG_STRUCTURE_import",TCommand::kUndefined,TCommand::kImport);
	VEG_STRUCTURE_import->Code() = "Import VEG_STRUCTURE from CONSUMERS_module";
	VEG_STRUCTURE_import->AddDependency(VEG_STRUCTURE);
	VEG_STRUCTURE_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SHEAR_STRESS_import = (TImportCommand*) SHEAR_STRESS.GetCommand("SHEAR_STRESS_import",TCommand::kUndefined,TCommand::kImport);
	SHEAR_STRESS_import->Code() = "Import SHEAR_STRESS from GLOBAL_module";
	SHEAR_STRESS_import->AddDependency(SHEAR_STRESS);
	SHEAR_STRESS_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* P1_RIVER_DATA_CF_import = (TImportCommand*) P1_RIVER_DATA_CF.GetCommand("P1_RIVER_DATA_CF_import",TCommand::kUndefined,TCommand::kImport);
	P1_RIVER_DATA_CF_import->Code() = "Import P1_RIVER_DATA_CF from PHOSPHATE_module";
	P1_RIVER_DATA_CF_import->AddDependency(P1_RIVER_DATA_CF);
	P1_RIVER_DATA_CF_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WT_E_X_import = (TImportCommand*) SF_WT_E_X.GetCommand("SF_WT_E_X_import",TCommand::kUndefined,TCommand::kImport);
	SF_WT_E_X_import->Code() = "Import SF_WT_E_X from GLOBAL_module";
	SF_WT_E_X_import->AddDependency(SF_WT_E_X);
	SF_WT_E_X_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WT_N_X_import = (TImportCommand*) SF_WT_N_X.GetCommand("SF_WT_N_X_import",TCommand::kUndefined,TCommand::kImport);
	SF_WT_N_X_import->Code() = "Import SF_WT_N_X from GLOBAL_module";
	SF_WT_N_X_import->AddDependency(SF_WT_N_X);
	SF_WT_N_X_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WT_S_X_import = (TImportCommand*) SF_WT_S_X.GetCommand("SF_WT_S_X_import",TCommand::kUndefined,TCommand::kImport);
	SF_WT_S_X_import->Code() = "Import SF_WT_S_X from GLOBAL_module";
	SF_WT_S_X_import->AddDependency(SF_WT_S_X);
	SF_WT_S_X_import->SetObjInfo(TCommand::kDepIndex, 0);
	TImportCommand* SF_WT_W_X_import = (TImportCommand*) SF_WT_W_X.GetCommand("SF_WT_W_X_import",TCommand::kUndefined,TCommand::kImport);
	SF_WT_W_X_import->Code() = "Import SF_WT_W_X from GLOBAL_module";
	SF_WT_W_X_import->AddDependency(SF_WT_W_X);
	SF_WT_W_X_import->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* I347 = (TExecuteCommand*) SUS_SED.GetCommand("I347",TCommand::kIntegrate,TCommand::kCode);
	I347->SetExecutable(&SUS_SED_I347_exe_g);
	I347->Code() = "I347 <- ( ( ( SED_SUSP+TSS_X_IN )-TSS_X_OUT )-SED_DEPO )";
	I347->AddDependency(SED_SUSP);
	I347->AddDependency(TSS_X_IN);
	I347->AddDependency(TSS_X_OUT);
	I347->AddDependency(SED_DEPO);
	I347->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* i348 = (TExecuteCommand*) SUS_SED.GetCommand("i348",TCommand::kInit,TCommand::kCode);
	i348->SetExecutable(&SUS_SED_i348_exe_g);
	i348->Code() = "i348 <- ( SF_WATER*P1_IC_TSS )";
	i348->AddDependency(SF_WATER);
	i348->AddDependency(P1_IC_TSS);
	i348->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u349 = (TExecuteCommand*) SED_SUSP.GetCommand("u349",TCommand::kUpdate,TCommand::kCode);
	u349->SetExecutable(&SED_SUSP_u349_exe_g);
	u349->Code() = "u349 <-  ( ( ( POT_EROS >  ((float)0) ) ) ? ( POT_EROS ) : ( ((float)0) ) ) ";
	u349->AddDependency(POT_EROS);
	u349->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u350 = (TExecuteCommand*) TSS_X_IN.GetCommand("u350",TCommand::kUpdate,TCommand::kCode);
	u350->SetExecutable(&TSS_X_IN_u350_exe_g);
	u350->Code() = "u350 <- ( ( ( TSS_X_E@(0,-1,0)+TSS_X_N@(1,0,0) )+TSS_X_S@(-1,0,0) )+TSS_X_W@(0,1,0) )";
	u350->AddDependency(TSS_X_E,"0,-1,0");
	u350->AddDependency(TSS_X_N,"1,0,0");
	u350->AddDependency(TSS_X_S,"-1,0,0");
	u350->AddDependency(TSS_X_W,"0,1,0");
	u350->SetObjInfo(TCommand::kDepIndex, 3);
	TExecuteCommand* u351 = (TExecuteCommand*) TSS_X_OUT.GetCommand("u351",TCommand::kUpdate,TCommand::kCode);
	u351->SetExecutable(&TSS_X_OUT_u351_exe_g);
	u351->Code() = "u351 <- ( ( ( TSS_X_E+TSS_X_N )+TSS_X_W )+TSS_X_S )";
	if( TSS_X_OUT.GetF(FisClamped) ) { u351->AddDependency(SUS_SED); }
	u351->AddDependency(TSS_X_E);
	u351->AddDependency(TSS_X_N);
	u351->AddDependency(TSS_X_W);
	u351->AddDependency(TSS_X_S);
	u351->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u352 = (TExecuteCommand*) SED_DEPO.GetCommand("u352",TCommand::kUpdate,TCommand::kCode);
	u352->SetExecutable(&SED_DEPO_u352_exe_g);
	u352->Code() = "u352 <-  ( ( ( SETTLING_VELOCITY >  WATER_DEPTH ) ) ? ( SUS_SED ) : ( ( ( ( SETTLING_VELOCITY/WATER_DEPTH )/dT() )*SUS_SED ) ) ) ";
	if( SED_DEPO.GetF(FisClamped) ) { u352->AddDependency(SUS_SED); }
	u352->AddDependency(SETTLING_VELOCITY);
	u352->AddDependency(WATER_DEPTH);
	u352->AddDependency(SUS_SED);
	u352->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u353 = (TExecuteCommand*) RIVER_TSS.GetCommand("u353",TCommand::kUpdate,TCommand::kCode);
	u353->SetExecutable(&RIVER_TSS_u353_exe_g);
	u353->Code() = "u353 <- 0";
	u353->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u354 = (TExecuteCommand*) SETTLING_VELOCITY.GetCommand("u354",TCommand::kUpdate,TCommand::kCode);
	u354->SetExecutable(&SETTLING_VELOCITY_u354_exe_g);
	u354->Code() = "u354 <- SL::Min(P1_SETTLING_RT, ( P1_SETTLING_RT/EDDY_VISCOSITY ))";
	u354->AddDependency(P1_SETTLING_RT);
	u354->AddDependency(EDDY_VISCOSITY);
	u354->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u355 = (TExecuteCommand*) SHEAR_RES.GetCommand("u355",TCommand::kUpdate,TCommand::kCode);
	u355->SetExecutable(&SHEAR_RES_u355_exe_g);
	u355->Code() = "u355 <- ( P1_RESISTANCE_COEFF*( ((float)1)+VEG_STRUCTURE ) )";
	u355->AddDependency(P1_RESISTANCE_COEFF);
	u355->AddDependency(VEG_STRUCTURE);
	u355->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u356 = (TExecuteCommand*) STRESS_EFFECT.GetCommand("u356",TCommand::kUpdate,TCommand::kCode);
	u356->SetExecutable(&STRESS_EFFECT_u356_exe_g);
	u356->Code() = "u356 <-  ( ( ( SHEAR_STRESS >  SHEAR_RES ) ) ? ( ( SHEAR_STRESS-SHEAR_RES ) ) : ( ((float)0) ) ) ";
	u356->AddDependency(SHEAR_STRESS);
	u356->AddDependency(SHEAR_RES);
	u356->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u358 = (TExecuteCommand*) TSS_X_E.GetCommand("u358",TCommand::kUpdate,TCommand::kCode);
	u358->SetExecutable(&TSS_X_E_u358_exe_g);
	u358->Code() = "u358 <- ( SF_WT_E_X*TSS_CONC )";
	u358->AddDependency(SF_WT_E_X);
	u358->AddDependency(TSS_CONC);
	u358->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u359 = (TExecuteCommand*) TSS_X_N.GetCommand("u359",TCommand::kUpdate,TCommand::kCode);
	u359->SetExecutable(&TSS_X_N_u359_exe_g);
	u359->Code() = "u359 <- ( SF_WT_N_X*TSS_CONC )";
	u359->AddDependency(SF_WT_N_X);
	u359->AddDependency(TSS_CONC);
	u359->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u360 = (TExecuteCommand*) TSS_X_S.GetCommand("u360",TCommand::kUpdate,TCommand::kCode);
	u360->SetExecutable(&TSS_X_S_u360_exe_g);
	u360->Code() = "u360 <- ( SF_WT_S_X*TSS_CONC )";
	u360->AddDependency(SF_WT_S_X);
	u360->AddDependency(TSS_CONC);
	u360->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u361 = (TExecuteCommand*) TSS_X_W.GetCommand("u361",TCommand::kUpdate,TCommand::kCode);
	u361->SetExecutable(&TSS_X_W_u361_exe_g);
	u361->Code() = "u361 <- ( SF_WT_W_X*TSS_CONC )";
	u361->AddDependency(SF_WT_W_X);
	u361->AddDependency(TSS_CONC);
	u361->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u362 = (TExecuteCommand*) P1_IC_TSS.GetCommand("u362",TCommand::kUpdate,TCommand::kCode);
	u362->SetExecutable(&P1_IC_TSS_u362_exe_g);
	u362->Code() = "u362 <- 0.008000";
	u362->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u363 = (TExecuteCommand*) P1_RESISTANCE_COEFF.GetCommand("u363",TCommand::kUpdate,TCommand::kCode);
	u363->SetExecutable(&P1_RESISTANCE_COEFF_u363_exe_g);
	u363->Code() = "u363 <- 0.000100";
	u363->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u364 = (TExecuteCommand*) P1_SETTLING_RT.GetCommand("u364",TCommand::kUpdate,TCommand::kCode);
	u364->SetExecutable(&P1_SETTLING_RT_u364_exe_g);
	u364->Code() = "u364 <- 0.046800";
	u364->SetObjInfo(TCommand::kDepIndex, 5);
	TExecuteCommand* u365 = (TExecuteCommand*) EDDY_VISCOSITY.GetCommand("u365",TCommand::kUpdate,TCommand::kCode);
	u365->SetExecutable(&EDDY_VISCOSITY_u365_exe_g);
	u365->Code() = "u365 <- Graph15(SHEAR_STRESS)";
	u365->AddDependency(SHEAR_STRESS);
	u365->SetObjInfo(TCommand::kDepIndex, 0);
	TExecuteCommand* u366 = (TExecuteCommand*) POT_EROS.GetCommand("u366",TCommand::kUpdate,TCommand::kCode);
	u366->SetExecutable(&POT_EROS_u366_exe_g);
	u366->Code() = "u366 <- Graph16(STRESS_EFFECT)";
	u366->AddDependency(STRESS_EFFECT);
	u366->SetObjInfo(TCommand::kDepIndex, 0);
	return 0;
}

int TSS_module::PostFirstUpdate() {
	PostEventsByType(TEvent::kFirstUpdate);
	return 0;
}

int TSS_module::PostFinalUpdate() {
	PostEventsByType(TEvent::kFinalUpdate);
	return 0;
}

int TSS_module::PostImport() {
	PostEventsByType(TEvent::kImport);
	return 0;
}

int TSS_module::PostIntegrate() {
	PostEventsByType(TEvent::kIntegrate);
	return 0;
}
