#include "BitString.h"


void BitString::resize( int size ) {
    int newsize = size/BITSTRBITS + 16;
    _BS_word* new_data = new _BS_word[newsize];
    memset(new_data, 0, newsize*sizeof(_BS_word) );
    memcpy( new_data, _data, _length/_BS_CHAR_BIT );
    _length = newsize * BITSTRBITS;
    if( _data ) delete[] _data;
    _data = new_data;
}

void BitString::set(int p) {
    if (p < 0) gPrintErr("Illegal bit index");
    if ((unsigned)(p) >= _length) resize( p + 1 );
    _data[ BitStr_index(p) ] |= _BS_BITMASK( BitStr_pos(p) );
}

void BitString::clear() {
    memset( _data, 0, _length*sizeof(_BS_word) );
}
