//----------------------------------------------------------------------------------------;
//	ByteBuffer.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------

#ifndef __ByteBuffer__
#define __ByteBuffer__

#include <stdlib.h>
static const int kBuffIncrement = 512;

#ifndef byte
typedef unsigned char byte;
#endif

class ByteBuffer {

  byte* fBuff;
  int fSize;

public:

  ByteBuffer() { fBuff = NULL; fSize = 0; }
  ByteBuffer(int size) { fBuff = new byte[size]; fSize = size; }
  ~ByteBuffer() { if(fBuff) delete[] fBuff; }
  void resize(int size) { 
    if(size <= fSize) return ;
		int new_sixe = size+kBuffIncrement;
		byte* new_buff  = new byte[new_sixe];  
    memcpy(new_buff,fBuff,fSize); 
		if(fBuff) delete[] fBuff;
		fBuff = new_buff;
		fSize = new_sixe;
  }

  byte* buff() { return fBuff; }
  int size() { return fSize; }
  int length() { 
    int i=0; 
    while( i< fSize ) { if(fBuff[i++] == '\0') break;} 
    return i-1; 
  }
};

#endif


  
