//----------------------------------------------------------------------------------------
//	UCStream.cp
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------
  
#include "CStream.h"
   
//========================================================================================
// 								class CStream 
//========================================================================================
  
  //----------------------------------------------------------------------------------------
  //				CStream::CStream:
  //----------------------------------------------------------------------------------------

CStream::CStream(const char* path, const char* ioMode)
{
  fFile = fopen(path,ioMode);
  fData = NULL; sindex=0;
  if (fFile == NULL) { sprintf(gMsgStr,"Can't open %s file",path); gPrintErr(); }
}

CStream::CStream(CString* data)
{
  fFile = NULL; 
  fData= data;
  data->clear(); sindex=0;
}
  
CStream::CStream()
{
  fFile = NULL; 
  fData = NULL; sindex=0;
}

int CStream::Open(const char* path, const char* ioMode)
{
  fFile = fopen(path,ioMode);
  if (fFile == NULL) { sprintf(gMsgStr,"Can't open file:\n%s\n\n",path); gPrintErr(); return 0; }
  else if( ioMode[0] == 'r' ) { sprintf(gMsgStr,">>>>>Incorporating Data from file:\n  %s\n",path); gPrintScreen(); }
  return 1;
}

void CStream::Close()
{
  if(fFile != NULL)  fclose(fFile);
  fFile = NULL;
}

int CStream::scanForward ( char tchar, int upto, int line_break  ) 
{	int test, rv=1, incomment = 0;
		
while( ( test = get() ) != tchar) {
  if( test == EOF ) { rv= -2; break; }
  if( test == '|' ) { incomment = 1; }
  if( line_break && test == '\n' ) { rv= -1; break; }
  if( incomment && test == '\n' ) { incomment = 0; }
}
if(upto && rv > 0) unget(test);
return(rv);
}

void CStream::processEnvVars(CString& str) {
  TAssoc_array& env_vars = Env::LocalEnvVars();
  THash_object* hobj = NULL;
  while( (hobj = env_vars.get_hashobj()) != NULL ) {
	TString& obj = (TString&)hobj->obj();
	if( str.contains( obj ) ) {
	  TString& key = hobj->key();
	  TString repl_str( "${" + key + "}" );
	  str.gsub(obj,repl_str);
	}
  }
}


int CStream::skipWhite ( char& nextChar ) 
{
  int test = 0, rv=1;
		
  while( isspace(test) ) {
    test = get();
    if( test == EOF ) { rv = 0; break; }
  }
  unget(test);
  nextChar = test;
  return(rv);
}

//----------------------------------------------------------------------------------------
//				GLOBALS::operator>>:
//----------------------------------------------------------------------------------------
  
CStream& CStream::operator>>( int& i ) { 
   if( fData ) { ; } else {  fscanf(fFile,"%d",&i); } return *this;
}    

CStream& CStream::operator>>( float& f ) { 
  if( fData ) { ; } else { fscanf(fFile,"%f",&f); } return *this;
}     

CStream& CStream::operator>>( char* str ) { 
  if( fData ) { ; } else {   fscanf(fFile,"%s",str); } return *this;
}    

CStream& CStream::operator>>( char& ch ) { 
  char c = ' ';	
  while( isspace(c) ) { c = get(); }
  ch = c;
  return *this;
}      
 
//----------------------------------------------------------------------------------------
//				GLOBALS::operator<<:
//----------------------------------------------------------------------------------------
  

CStream& CStream::operator<<( int i ) { 
   if( fData ) { fData->appendIndex(i); } else {  fprintf(fFile,"%d", i); } return *this;
}           

CStream& CStream::operator<<( unsigned long i ) { 
   if( fData ) { fData->appendIndex(i); } else {  fprintf(fFile,"%lu", i); } return *this;
}           

CStream& CStream::operator<<( float f ) { 
   if( fData ) { (*fData)+=f; } else {  fprintf(fFile,"%f", f); } return *this;
}     

CStream& CStream::operator<<( double f ) { 
   if( fData ) { (*fData)+=f; } else {  fprintf(fFile,"%.3e", f); } return *this;
}     

CStream& CStream::operator<<( const char* str ) { 
   CString data(str);
   return CStream::operator<<( data );
}     

CStream& CStream::operator<<( CString& str ) { 
  processEnvVars(str);
   if( fData ) { (*fData)+=str; } else {  fprintf(fFile,"%s", str.chars() ); } return *this;
}     

CStream& CStream::operator<<( char c ) { 
   if( fData ) { (*fData)+=c; } else {  fprintf(fFile,"%c", c); } return *this;
}       

CStream& CStream::operator<<( byte c ) { 
   if( fData ) { (*fData)+=c; } else {  fprintf(fFile,"%x", c); } return *this;
}       


 
